/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.reportversion;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.report.context.ReportListContext;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.report.reportversion.ReportVersionDataHandle;

public class ReportVersionBaseDataPlugin
extends AbstractBaseFormPlugin {
    private boolean isSingle = false;
    private boolean isFromListView = false;
    ReportListContext context;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getContext() != null) {
            this.isSingle = this.getContext().getTemplates() != null && this.getContext().getTemplates().length == 1;
            boolean bl = this.isFromListView = this.getFormCustomParam("reportlistcontext") != null;
        }
        if (this.getContext() == null || this.isSingle || !this.isFromListView) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
        }
        this.initVersionNumber();
        if (this.isFromListView) {
            return;
        }
        Object tmpid = this.getView().getFormShowParameter().getCustomParam("tmpid");
        Object cyId = this.getView().getFormShowParameter().getCustomParam("cyId");
        Object yearId = this.getView().getFormShowParameter().getCustomParam("yearId");
        Object periodId = this.getView().getFormShowParameter().getCustomParam("periodId");
        Object reportOrgId = this.getView().getFormShowParameter().getCustomParam("reportOrgId");
        Object sceneId = this.getView().getFormShowParameter().getCustomParam("sceneId");
        DynamicObject cy = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)((Long)reportOrgId), (Long)((Long)yearId), (Long)((Long)periodId));
        IDNumberTreeNode cyNode = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)((Long)cyId));
        String cyNumber = cyNode.getNumber();
        long viewCyId = "DC".equals(cyNumber) || "EC".equals(cyNumber) ? cy.getLong("id") : ((Long)cyId).longValue();
        this.getModel().setValue("modelid", (Object)this.getModelId());
        this.getModel().setValue("templateid", tmpid);
        String orgNum = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)reportOrgId)).getNumber();
        reportOrgId = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)orgNum).getId();
        this.getModel().setValue("entityid", reportOrgId);
        this.getModel().setValue("sceneid", sceneId);
        this.getModel().setValue("yearid", yearId);
        this.getModel().setValue("periodid", periodId);
        this.getModel().setValue("currencyid", (Object)viewCyId);
        this.getModel().setValue("data", this.getView().getFormShowParameter().getCustomParam("sm"));
        this.getModel().setValue("spreadjson", this.getView().getFormShowParameter().getCustomParam("json"));
        this.bindVerRptData();
    }

    private void initVersionNumber() {
        ComboEdit combo = (ComboEdit)this.getView().getControl("versionnumber");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(32);
        int versionNumSize = ConfigServiceHelper.getIntegerParam((Long)this.getModelId(), (String)ConfigEnum.VERSIONNUMSIZE.getNumber(), (String)"params", (Integer)3);
        for (int i = 1; i <= versionNumSize; ++i) {
            ComboItem comboItem = new ComboItem(new LocaleString(i + ".0"), i + "");
            comboItems.add(comboItem);
        }
        combo.setComboItems(comboItems);
        this.getView().updateView("versionnumber");
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void bindVerRptData() {
        DynamicObject verrpt = null;
        try {
            Object tmpid = this.getView().getFormShowParameter().getCustomParam("tmpid");
            Object cyId = this.getView().getFormShowParameter().getCustomParam("cyId");
            Object yearId = this.getView().getFormShowParameter().getCustomParam("yearId");
            Object periodId = this.getView().getFormShowParameter().getCustomParam("periodId");
            Object reportOrgId = this.getView().getFormShowParameter().getCustomParam("reportOrgId");
            String orgNum = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)reportOrgId)).getNumber();
            reportOrgId = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)orgNum).getId();
            Object sceneId = this.getView().getFormShowParameter().getCustomParam("sceneId");
            DynamicObject cy = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)((Long)reportOrgId), (Long)((Long)yearId), (Long)((Long)periodId));
            IDNumberTreeNode cyNode = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)((Long)cyId));
            String cyNumber = cyNode.getNumber();
            long viewCyId = "DC".equals(cyNumber) || "EC".equals(cyNumber) ? cy.getLong("id") : ((Long)cyId).longValue();
            DynamicObject temp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,number,group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)tmpid))});
            String versionnumber = (String)this.getModel().getValue("versionnumber");
            verrpt = ReportVersionDataHandle.getReportVersion((Long)reportOrgId, (Long)sceneId, (Long)yearId, (Long)periodId, viewCyId, temp.getString("number"), versionnumber);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (verrpt != null) {
            this.getModel().setValue("versionnumber", verrpt.get("versionnumber"));
            this.getModel().setValue("versionname", verrpt.get("versionname"));
            this.getModel().setValue("createrid", verrpt.get("createrid"));
            this.getModel().setValue("createdate", verrpt.get("createdate"));
        } else {
            this.getModel().setValue("versionname", null);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        boolean bl = this.isFromListView = this.getFormCustomParam("reportlistcontext") != null;
        if (this.isFromListView) {
            return;
        }
        super.propertyChanged(e);
        if ("versionnumber".equals(e.getProperty().getName())) {
            this.bindVerRptData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean bl = this.isFromListView = this.getFormCustomParam("reportlistcontext") != null;
        if (this.isFromListView) {
            return;
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        boolean bl = this.isFromListView = this.getFormCustomParam("reportlistcontext") != null;
        if (this.isFromListView) {
            Object value = this.getModel().getValue("versionname");
            ReportVersionDataHandle.saveReportVersions(this.getContext(), (String)this.getModel().getValue("versionnumber"), value);
        }
        if (eventArgs.getOperationResult().isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportVersionBaseDataPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            try {
                this.saveOpLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58\u4e3a\u7248\u672c", "ReportVersionBaseDataPlugin_2", "fi-bcm-formplugin", "saveVersion"), new MultiLangEnumBridge("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s \u4fdd\u5b58\u4e3a\u7248\u672c:%8$s", "ReportVersionBaseDataPlugin_3", "fi-bcm-formplugin"));
            }
            catch (Exception e) {
                log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
            this.getView().close();
        }
    }

    private void saveOpLog(OpNameMultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge) {
        if (this.isFromListView) {
            Object scenceDy = this.getView().getParentView().getModel().getValue("scenario");
            Object yearDy = this.getView().getParentView().getModel().getValue("year");
            Object periodDy = this.getView().getParentView().getModel().getValue("period");
            Object cyDy = this.getView().getParentView().getModel().getValue("currency");
            if (scenceDy == null || yearDy == null || periodDy == null || cyDy == null) {
                return;
            }
            String scenceNum = ((DynamicObject)scenceDy).getString("number");
            String yearNum = ((DynamicObject)yearDy).getString("number");
            String periodNum = ((DynamicObject)periodDy).getString("number");
            String cyNum = ((DynamicObject)cyDy).getString("number");
            Object[] pkids = ((BillList)this.getView().getParentView().getControl("billlistap")).getSelectedRows().getPrimaryKeyValues();
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_reportlistentity", (String)"entity.number,template.number,template.name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
            Set entityNumbers = doc.stream().map(m -> m.getString("entity.number")).collect(Collectors.toSet());
            List tempNumbers = doc.stream().map(m -> m.getString("template.number") + m.getString("template.name")).collect(Collectors.toList());
            this.writeMultiLangLog(opNameBridge, new OPDescMultiLangEnumBridge(opDescBridge, new String[]{scenceNum, yearNum, periodNum, String.join((CharSequence)",", entityNumbers), cyNum, String.join((CharSequence)",", tempNumbers), "", String.valueOf(this.getModel().getValue("versionname"))}));
            return;
        }
        Object tmpid = this.getView().getFormShowParameter().getCustomParam("tmpid");
        Object yearId = this.getView().getFormShowParameter().getCustomParam("yearId");
        Object periodId = this.getView().getFormShowParameter().getCustomParam("periodId");
        Object reportOrgId = this.getView().getFormShowParameter().getCustomParam("reportOrgId");
        Object sceneId = this.getView().getFormShowParameter().getCustomParam("sceneId");
        Object cyId = this.getView().getFormShowParameter().getCustomParam("cyId");
        DynamicObject cy = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)((Long)reportOrgId), (Long)((Long)yearId), (Long)((Long)periodId));
        IDNumberTreeNode cyNode = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)((Long)cyId));
        String cyNumber = cyNode.getNumber();
        long viewCyId = "DC".equals(cyNumber) || "EC".equals(cyNumber) ? cy.getLong("id") : ((Long)cyId).longValue();
        String scenceNum = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_scenemembertree", (Long)((Long)sceneId)).getNumber();
        String yearNum = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_fymembertree", (Long)((Long)yearId)).getNumber();
        String periodNum = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_periodmembertree", (Long)((Long)periodId)).getNumber();
        String orgNum = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)((Long)reportOrgId)).getNumber();
        String cyNum = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_currencymembertree", (Long)viewCyId).getNumber();
        String tempName = ModelDataProvider.getTemplateModel(tmpid).getName();
        String tempNum = ModelDataProvider.getTemplateModel(tmpid).getNumber();
        this.writeMultiLangLog(opNameBridge, new OPDescMultiLangEnumBridge(opDescBridge, new String[]{scenceNum, yearNum, periodNum, orgNum, cyNum, tempNum, tempName, String.valueOf(this.getModel().getValue("versionname"))}));
    }

    @Override
    public void afterBindData(EventObject e) {
        if (this.isFromListView) {
            return;
        }
        super.afterBindData(e);
    }

    public ReportListContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        String param = (String)this.getFormCustomParam("reportlistcontext");
        if (param == null) {
            return null;
        }
        this.context = (ReportListContext)ObjectSerialUtil.deSerializedBytes((String)param);
        return this.context;
    }
}

