/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.reportversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.report.context.ReportListContext;
import kd.fi.bcm.formplugin.report.workBench.WorkBenchContext;
import org.apache.commons.collections4.CollectionUtils;

public class ReportVersionDataHandle {
    public static final String RPTVERID = "rptverid";
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MemberReader.class);

    public static DynamicObject getRptReportVersion(long entityId, long sceneId, long yearId, long periodId, long viewCyId, String tempNum) {
        DynamicObjectCollection verRpts = ReportVersionDataHandle.getReportVersions(entityId, sceneId, yearId, periodId, viewCyId, tempNum);
        DynamicObject verrpt = verRpts.stream().findFirst().orElse(null);
        return verrpt;
    }

    private static DynamicObjectCollection getReportVersions(long entityId, long sceneId, long yearId, long periodId, long viewCyId, String tempNum) {
        QFilter filter = new QFilter("entityid", "=", (Object)entityId);
        filter.and(new QFilter("sceneid", "=", (Object)sceneId));
        filter.and(new QFilter("yearid", "=", (Object)yearId));
        filter.and(new QFilter("periodid", "=", (Object)periodId));
        filter.and(new QFilter("currencyid", "=", (Object)viewCyId));
        filter.and(new QFilter("templateid.number", "=", (Object)tempNum));
        DynamicObjectCollection verRpts = QueryServiceHelper.query((String)"bcm_reportversion", (String)"id,versionnumber,versionname,createrid,createdate,data,spreadjson", (QFilter[])new QFilter[]{filter}, (String)"versionnumber");
        return verRpts;
    }

    private static DynamicObjectCollection getReportVersions(long modelId) {
        QFilter filter = new QFilter("modelid", "=", (Object)modelId);
        DynamicObjectCollection verRpts = QueryServiceHelper.query((String)"bcm_reportversion", (String)"id,versionnumber,versionname,createrid,createdate,data,spreadjson", (QFilter[])new QFilter[]{filter}, (String)"versionnumber desc");
        return verRpts;
    }

    public static DynamicObject getLargestReportVersion(long modelId) {
        DynamicObjectCollection verRpts = ReportVersionDataHandle.getReportVersions(modelId);
        DynamicObject verrpt = verRpts.stream().findFirst().orElse(null);
        return verrpt;
    }

    public static int deleteRptReportVersion(long entityId, long sceneId, long yearId, long periodId, long viewCyId, String tempNum, String versionnumber) {
        QFilter filter = new QFilter("entityid", "=", (Object)entityId);
        filter.and(new QFilter("sceneid", "=", (Object)sceneId));
        filter.and(new QFilter("yearid", "=", (Object)yearId));
        filter.and(new QFilter("periodid", "=", (Object)periodId));
        filter.and(new QFilter("currencyid", "=", (Object)viewCyId));
        filter.and(new QFilter("templateid.number", "=", (Object)tempNum));
        filter.and(new QFilter("versionnumber", "=", (Object)versionnumber));
        return DeleteServiceHelper.delete((String)"bcm_reportversion", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getReportVersion(long entityId, long sceneId, long yearId, long periodId, long viewCyId, String tempNum, String versionnumber) {
        QFilter filter = new QFilter("entityid", "=", (Object)entityId);
        filter.and(new QFilter("sceneid", "=", (Object)sceneId));
        filter.and(new QFilter("yearid", "=", (Object)yearId));
        filter.and(new QFilter("periodid", "=", (Object)periodId));
        filter.and(new QFilter("currencyid", "=", (Object)viewCyId));
        filter.and(new QFilter("templateid.number", "=", (Object)tempNum));
        filter.and(new QFilter("versionnumber", "=", (Object)versionnumber));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_reportversion", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dy == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)dy.getLong("id"), (String)"bcm_reportversion");
    }

    public static DynamicObjectCollection getReportVersions(Set<Long> entityIds, long sceneId, long yearId, long periodId, long viewCyId, Set<String> tempNums, String versionnumber) {
        QFilter filter = new QFilter("entityid", "in", entityIds);
        filter.and(new QFilter("sceneid", "=", (Object)sceneId));
        filter.and(new QFilter("yearid", "=", (Object)yearId));
        filter.and(new QFilter("periodid", "=", (Object)periodId));
        if (viewCyId != 0L) {
            filter.and(new QFilter("currencyid", "=", (Object)viewCyId));
        }
        filter.and(new QFilter("templateid.number", "in", tempNums));
        filter.and(new QFilter("versionnumber", "=", (Object)versionnumber));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_reportversion", (String)"id,entityid,currencyid,templateid.id,templateid.number,versionnumber", (QFilter[])new QFilter[]{filter});
        if (doc == null) {
            return null;
        }
        return doc;
    }

    public static Set<String> saveReportVersions(WorkBenchContext context, String verNum, Object verName) {
        Set<Long> reportIds = context.getReports();
        HashSet<String> temNums = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty(reportIds)) {
            List<DynamicObject> objects = ReportVersionDataHandle.queryReports(reportIds);
            HashSet<Long> entityIds = new HashSet<Long>(16);
            ReportVersionDataHandle.collectEntityAndTemplates(objects, entityIds, temNums);
            ReportVersionDataHandle.updateVersionData(ReportVersionDataHandle.getReportVersions(entityIds, context.getScenarioId(), context.getFyId(), context.getPeriodId(), 0L, temNums, verNum), objects, verNum, verName, context.getModelId(), context.getScenarioId(), context.getFyId(), context.getPeriodId(), context.getRealCurrencyId(), false);
        }
        return temNums;
    }

    private static void collectEntityAndTemplates(List<DynamicObject> reports, Set<Long> entityIds, Set<String> temNums) {
        if (CollectionUtils.isNotEmpty(reports)) {
            reports.forEach(r -> {
                long org = r.getLong("entity.id");
                entityIds.add(org);
                temNums.add(r.getString("template.number"));
            });
        }
    }

    private static List<DynamicObject> queryReports(Set<Long> reports) {
        ArrayList<DynamicObject> dyos = new ArrayList<DynamicObject>(16);
        QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,entity.id,template.id,template.number,spreadjson,data", (QFilter[])new QFilter[]{new QFilter("id", "in", reports)}).forEach(d -> dyos.add((DynamicObject)d));
        return dyos;
    }

    private static List<DynamicObject> updateVersionData(DynamicObjectCollection rptVerDoc, List<DynamicObject> reports, String verNum, Object verName, long modelId, long scenceId, long fyId, long periodId, long currencyId, boolean isEc) {
        ArrayList<DynamicObject> verRpts = new ArrayList<DynamicObject>(16);
        if (CollectionUtils.isEmpty(reports)) {
            return verRpts;
        }
        Map<Object, Object> verKey2Dy = new HashMap(16);
        Set<Object> ids = new HashSet(16);
        if (rptVerDoc != null && !rptVerDoc.isEmpty()) {
            verKey2Dy = rptVerDoc.stream().collect(Collectors.toMap(k -> ReportVersionDataHandle.getVerKey(k.getString("entityid.id"), k.getString("currencyid.id"), k.getString("templateid.number")), v -> v, (o1, o2) -> o2));
            ids = rptVerDoc.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        }
        ORM orm = ORM.create();
        for (DynamicObject report : reports) {
            DynamicObject cy;
            DynamicObject dy = orm.newDynamicObject("bcm_reportversion");
            dy.set("modelid", (Object)modelId);
            dy.set("templateid", (Object)report.getLong("template.id"));
            long orgID = report.getLong("entity.id");
            dy.set("entityid", (Object)orgID);
            dy.set("sceneid", (Object)scenceId);
            dy.set("yearid", (Object)fyId);
            dy.set("periodid", (Object)periodId);
            long realCuId = currencyId;
            if (isEc && (cy = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgID, (Long)fyId, (Long)periodId)) != null) {
                realCuId = cy.getLong("id");
            }
            dy.set("currencyid", (Object)realCuId);
            dy.set("spreadjson", (Object)report.getString("spreadjson"));
            dy.set("data", (Object)report.getString("data"));
            String verKey = ReportVersionDataHandle.getVerKey(String.valueOf(orgID), String.valueOf(currencyId), report.getString("template.number"));
            if (verKey2Dy.containsKey(verKey)) {
                dy.set("createrid", (Object)((DynamicObject)verKey2Dy.get(verKey)).getLong("createrid"));
                dy.set("createdate", (Object)((DynamicObject)verKey2Dy.get(verKey)).getDate("createdate"));
            } else {
                dy.set("createrid", (Object)RequestContext.get().getCurrUserId());
                dy.set("createdate", (Object)TimeServiceHelper.now());
            }
            dy.set("modifierid", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifydate", (Object)TimeServiceHelper.now());
            dy.set("versionnumber", (Object)verNum);
            dy.set("versionname", verName);
            verRpts.add(dy);
        }
        try {
            if (CollectionUtils.isNotEmpty(ids)) {
                QFilter filter = new QFilter("id", "in", ids);
                DeleteServiceHelper.delete((String)"bcm_reportversion", (QFilter[])new QFilter[]{filter});
            }
            SaveServiceHelper.save((DynamicObject[])verRpts.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return verRpts;
    }

    public static List<DynamicObject> saveReportVersions(ReportListContext context, String verNum, Object verName) {
        List reportlists = Arrays.stream(context.getTemplates()).filter(t -> !ReportStatusEnum.UNWEAVE.status().equals(t.getString("reportstatus"))).collect(Collectors.toList());
        Set<Long> reports = reportlists.stream().map(t -> t.getLong("report.id")).collect(Collectors.toSet());
        List<DynamicObject> objects = ReportVersionDataHandle.queryReports(reports);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        HashSet<String> temNums = new HashSet<String>(16);
        ReportVersionDataHandle.collectEntityAndTemplates(objects, entityIds, temNums);
        IDNumberTreeNode cyNode = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)context.modelId), (Long)context.cyId);
        String cyNumber = cyNode.getNumber();
        return ReportVersionDataHandle.updateVersionData(ReportVersionDataHandle.getReportVersions(entityIds, context.scenceId, context.yearId, context.periodId, 0L, temNums, verNum), objects, verNum, verName, context.modelId, context.scenceId, context.yearId, context.periodId, context.cyId, "DC".equals(cyNumber) || "EC".equals(cyNumber));
    }

    private static String getVerKey(String orgId, String cyID, String tempNum) {
        return orgId + cyID + tempNum;
    }

    public static DynamicObject getRptReportVersion(FormShowParameter param) {
        DynamicObjectCollection verRpts = ReportVersionDataHandle.getRptReportVersions(param);
        DynamicObject verrpt = verRpts.stream().findFirst().orElse(null);
        return verrpt;
    }

    public static DynamicObjectCollection getRptReportVersions(FormShowParameter param) {
        try {
            Object tmpid = param.getCustomParam("tmpid");
            Object modelId = param.getCustomParam("KEY_MODEL_ID");
            Object cyId = param.getCustomParam("cyId");
            Object yearId = param.getCustomParam("yearId");
            Object periodId = param.getCustomParam("periodId");
            Object reportOrgId = param.getCustomParam("reportOrgId");
            String orgNum = MemberReader.findEntityMemberById((Long)((Long)modelId), (Long)((Long)reportOrgId)).getNumber();
            reportOrgId = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)orgNum).getId();
            Object sceneId = param.getCustomParam("sceneId");
            DynamicObject cy = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)((Long)reportOrgId), (Long)((Long)yearId), (Long)((Long)periodId));
            IDNumberTreeNode cyNode = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)((Long)cyId));
            String cyNumber = cyNode.getNumber();
            long viewCyId = "DC".equals(cyNumber) || "EC".equals(cyNumber) ? cy.getLong("id") : ((Long)cyId).longValue();
            DynamicObject temp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,number,group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)tmpid))});
            DynamicObjectCollection verrpts = ReportVersionDataHandle.getReportVersions((Long)reportOrgId, (Long)sceneId, (Long)yearId, (Long)periodId, viewCyId, temp.getString("number"));
            return verrpts;
        }
        catch (Exception e) {
            return new DynamicObjectCollection();
        }
    }
}

