/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.reportversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.formplugin.report.reportversion.ReportVersionDataHandle;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;

public class ReportVersionDataViewPlugin
extends AbstractTemplateBasePlugin {
    private static final String SPREADKEY = "template_spread";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initVersionNumber();
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("rptverid");
        DynamicObject rptVerDy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bcm_reportversion");
        this.setViewParam(rptVerDy);
    }

    private void initVersionNumber() {
        ComboEdit combo = (ComboEdit)this.getView().getControl("versionnumber");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(32);
        int versionNumSize = ConfigServiceHelper.getIntegerParam((Long)this.getModelId(), (String)ConfigEnum.VERSIONNUMSIZE.getNumber(), (String)"params", (Integer)3);
        for (int i = 1; i <= versionNumSize; ++i) {
            ComboItem comboItem = new ComboItem(new LocaleString(i + ".0"), i + "");
            comboItems.add(comboItem);
        }
        combo.setComboItems(comboItems);
        this.getView().updateView("versionnumber");
    }

    private void setViewParam(DynamicObject rptVerDy) {
        String spreadjson = rptVerDy.getString("spreadjson");
        String versionnumber = rptVerDy.getString("versionnumber");
        String versionname = rptVerDy.getString("versionname");
        this.getModel().beginInit();
        this.getModel().setValue("versionnumber", (Object)versionnumber);
        this.getModel().setValue("versionname", (Object)versionname);
        this.getModel().endInit();
        this.getView().updateView("versionname");
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), SPREADKEY, spreadjson);
        String sheetname = (String)this.getView().getFormShowParameter().getCustomParam("sheetname");
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), SPREADKEY, Collections.singletonList(sheetname));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("versionnumber".equals(e.getProperty().getName())) {
            Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("rptverid");
            DynamicObject rptVerDy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bcm_reportversion");
            if ((rptVerDy = ReportVersionDataHandle.getReportVersion(rptVerDy.getLong("entityid.id"), rptVerDy.getLong("sceneid.id"), rptVerDy.getLong("yearid.id"), rptVerDy.getLong("periodid.id"), rptVerDy.getLong("currencyid.id"), rptVerDy.getString("templateid.number"), newValue.toString())) == null) {
                this.getModel().beginInit();
                this.getModel().setValue("versionnumber", oldValue);
                this.getModel().endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u65e0\u8be5\u7248\u672c\u6570\u636e\u3002", (String)"ReportVersionDataViewPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setViewParam(rptVerDy);
        }
    }
}

