/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.chkcheck.model.DimensionCombination;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.util.SpreadMemberUtil;
import org.apache.commons.collections.MapUtils;

public class CellControlerByAttachment {
    private AbstractMultiReportPlugin plugin;
    private RangeModel rangeModel;

    public CellControlerByAttachment(AbstractMultiReportPlugin plugin) {
        this.plugin = plugin;
    }

    public RangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(RangeModel rangeModel) {
        this.rangeModel = rangeModel;
    }

    public static void setAttachmentMark(IClientViewProxy view, List<Map<String, Object>> rangedetails, String text, boolean vi) {
        if (!rangedetails.isEmpty()) {
            ArrayList parameters = new ArrayList(10);
            HashMap<String, Object> parameter = new HashMap<String, Object>(16);
            parameter.put("range", rangedetails.toArray());
            parameter.put("vi", vi);
            parameter.put("text", text);
            parameter.put("bc", "#5582f3");
            parameter.put("fc", "white");
            parameter.put("pos", new int[]{0});
            parameters.add(parameter);
            if (!parameters.isEmpty()) {
                SpreadClientInvoker.invokeMethod(view, "setCornerMark", "report", parameters.toArray());
            }
        }
    }

    public void controlStyle() {
        this.clearAttachmentMark();
        long modelId = this.plugin.getModelId();
        QFilter filter = new QFilter("noteinfo.model", "=", (Object)modelId);
        QFilter typeFilter = new QFilter("noteinfo.attachmenttype", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter, typeFilter};
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_chkattachment", (String)"noteinfo.dimensionstr", (QFilter[])filters);
        if (dys == null || dys.isEmpty()) {
            return;
        }
        HashSet<String> strSet = new HashSet<String>(16);
        for (DynamicObject dy : dys) {
            strSet.add(dy.getString("noteinfo.dimensionstr"));
        }
        SpreadManager sm = this.plugin.getSpreadModel();
        HashMap pageMemberMap = new HashMap(16);
        String orgNum = SpreadMemberUtil.fillPageDimMembers((long)modelId, (SpreadManager)sm, pageMemberMap);
        Map<DimTypesEnum, Object> commonParam = this.plugin.getCurrentReportCommonParam("number", true);
        DimensionCombination dimCombination = new DimensionCombination(modelId);
        ArrayList<Map<String, Object>> rangedetails = new ArrayList<Map<String, Object>>(16);
        sm.getBook().getSheet(0).iteratorRangeCells(this.rangeModel, cell -> {
            Map cellDimMemberMap = SpreadMemberUtil.getCellDimMemberMap((Map)pageMemberMap, (String)orgNum, (Map)commonParam, (Cell)cell, (long)modelId, (boolean)false);
            if (MapUtils.isNotEmpty((Map)cellDimMemberMap)) {
                SpreadMemberUtil.dealCellOrgDimMemMap((Map)cellDimMemberMap);
                dimCombination.putAll(cellDimMemberMap);
                if (strSet.contains(dimCombination.getDimensionCombineStr())) {
                    HashMap<String, Integer> rangedetail = new HashMap<String, Integer>(16);
                    rangedetail.put("r", cell.getRow());
                    rangedetail.put("c", cell.getCol());
                    rangedetail.put("rc", 1);
                    rangedetail.put("cc", 1);
                    cell.setUserObject("setCornerMark", (Object)true);
                    rangedetails.add(rangedetail);
                }
            }
        });
        CellControlerByAttachment.setAttachmentMark(this.plugin.getClientViewProxy(), rangedetails, "A", true);
        this.plugin.cacheSpreadModel(sm);
    }

    private void clearAttachmentMark() {
        ArrayList<Map<String, Object>> clearRangedetails = new ArrayList<Map<String, Object>>(16);
        SpreadManager spreadManager = this.plugin.getSpreadModel();
        spreadManager.getBook().getSheet(0).iteratorCells(cell -> {
            if (!cell.isMdDataDomain()) {
                return;
            }
            if (((Boolean)cell.getUserObject("setCornerMark", (Object)false)).booleanValue()) {
                HashMap<String, Integer> rangedetail = new HashMap<String, Integer>(16);
                rangedetail.put("r", cell.getRow());
                rangedetail.put("c", cell.getCol());
                rangedetail.put("rc", 1);
                rangedetail.put("cc", 1);
                cell.removeUserObject("setCornerMark");
                clearRangedetails.add(rangedetail);
            }
        });
        CellControlerByAttachment.setAttachmentMark(this.plugin.getClientViewProxy(), clearRangedetails, "", false);
        this.plugin.cacheSpreadModel(spreadManager);
    }
}

