/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.style;

import java.util.List;
import java.util.Set;
import kd.fi.bcm.business.permission.cache.MemPermClassCacheManager;
import kd.fi.bcm.business.permission.cache.MembPermCacheManager;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.formplugin.report.style.PermTypePack;
import kd.fi.bcm.spread.model.IDimMember;

public class DataPermService {
    private MembPermCacheManager permMng;
    private MemPermClassCacheManager permClass;

    public DataPermService() {
    }

    public DataPermService(long modelId) {
        this.initService(modelId);
    }

    public final void initService(long modelId) {
        if (this.permMng == null && this.permClass == null) {
            this.permMng = new MembPermCacheManager((Object)modelId);
            this.permClass = new MemPermClassCacheManager((Object)modelId);
        }
    }

    protected void cycleComparedPermType(List<IDimMember> membs, PermTypePack remainPack) {
        membs.iterator().forEachRemaining(m -> {
            if (PermEnum.NOPERM != remainPack.permType) {
                PermEnum memPerm = this.permMng.getMemPermControlTypeAllowNull(m.getDimension().getNumber(), m.getNumber());
                if (PermEnum.NOPERM == memPerm) {
                    remainPack.permType = PermEnum.NOPERM;
                } else {
                    PermEnum classPerm = this.permClass.getMemPermClassType(m.getDimension().getNumber(), m.getNumber());
                    remainPack.permType = memPerm == null && classPerm == null ? this.comparedPerm(remainPack.permType, this.permMng.getMemDefaultPermType(m.getDimension().getNumber(), m.getNumber())) : (classPerm == null ? this.comparedPerm(remainPack.permType, memPerm) : (memPerm == null ? this.comparedPerm(remainPack.permType, classPerm) : this.comparedPerm(remainPack.permType, this.comparedPerm(memPerm, classPerm))));
                }
            }
        });
    }

    private PermEnum comparedPerm(PermEnum srcPermType, PermEnum targPermType) {
        return srcPermType.getValue() - targPermType.getValue() > 0 ? srcPermType : targPermType;
    }

    public Set<String> filterNoPermData(String dimNum, Set<String> membs, Long modelid) {
        return DataCollectUtil.getReadOrWritePermMembersByNums((Long)modelid, (String)dimNum, membs);
    }
}

