/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.style;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.extreport.ExtReportViewHandle;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.IDimMember;

public class EXTReportStyleHandle {
    private AbstractMultiReportPlugin plugin;
    public static final List<Integer> types = new ArrayList<Integer>(16);
    private Set<String> cwpAt;
    private RangeModel rangeModel;
    private static Set<String> inputATs;

    public EXTReportStyleHandle(AbstractMultiReportPlugin plugin) {
        this.plugin = plugin;
    }

    public void statusControl() {
        boolean hasExt = false;
        for (PositionInfo positionInfo : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getExtendInfo() == null) continue;
            hasExt = true;
        }
        if (!hasExt) {
            return;
        }
        Sheet sheet = this.plugin.getSpreadModel().getBook().getSheet(0);
        Map<String, Map<String, Object>> cellsMap = this.lockCellByTemplateStyle(sheet, null);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        for (Object positionInfo : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getExtendInfo() == null) continue;
            RangeModel areaRangeModel = new RangeModel(positionInfo.getAreaRange());
            if (this.rangeModel != null) {
                areaRangeModel = this.rangeModel;
            }
            invoker.unlockCell(areaRangeModel.getY_start(), areaRangeModel.getX_start(), areaRangeModel.getRowSize(), areaRangeModel.getColSize());
        }
        invoker.lockCell(cellsMap.values().stream().collect(Collectors.toList()));
        HashMap<String, StatusResult> re = new HashMap<String, StatusResult>(16);
        for (PositionInfo positionInfo : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            QueryStatusCommandInfo extComm = this.getQueryStatusExtCommandInfo(positionInfo);
            BizStatusContext extCT = new BizStatusContext(extComm);
            re.putAll(BizStatusServer.queryStatus((BizStatusContext)extCT));
        }
        for (PositionInfo positionInfo : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getExtendInfo() == null) continue;
            RangeModel curPosRangeModel = new RangeModel(positionInfo.getAreaRange());
            if (this.rangeModel != null && (this.rangeModel == null || this.rangeModel.getY_start() < curPosRangeModel.getY_start() || this.rangeModel.getY_end() > curPosRangeModel.getY_end())) continue;
            for (String floatDimNum : positionInfo.getExtendInfo().getFloatDimNums()) {
                QueryStatusCommandInfo mddComm = this.getQueryStatusMddCommandInfo(floatDimNum, positionInfo);
                BizStatusContext mddCT = new BizStatusContext(mddComm);
                Map mddRE = BizStatusServer.queryStatus((BizStatusContext)mddCT);
                re.putAll(mddRE);
            }
        }
        this.lockCell(sheet, re);
        ExtReportViewHandle viewHandle = new ExtReportViewHandle(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.plugin.getView());
        viewHandle.lockExtSourceCols(this.plugin.getSpreadModel());
        viewHandle.setPlugin(this.plugin);
        viewHandle.lockStageLockCols(this.plugin.getSpreadModel(), true);
        if (this.plugin.getTemplateModel().getIsOnlyRead()) {
            invoker.lockCell(0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
        }
        this.invisibleCell(sheet, re);
    }

    private QueryStatusCommandInfo getQueryStatusExtCommandInfo(PositionInfo positionInfo) {
        ReportTabInfo reportTabInfo;
        Object reportId;
        QueryStatusCommandInfo comm = this.getQueryStatusCommonCommandInfo();
        if (positionInfo.getExtendInfo() != null) {
            ArrayList extCols = new ArrayList(positionInfo.getExtendInfo().getCols());
            extCols.removeAll(positionInfo.getExtendInfo().getFloatDimNums());
            for (String extCol : extCols) {
                comm.addCrossMembers((List)Lists.newArrayList((Object[])new String[]{extCol}));
            }
            String extGroup = positionInfo.getExtendInfo().getExtGroup();
            QFilter modelQF = new QFilter("model.id", "=", (Object)this.plugin.getModelId());
            QFilter numQF = new QFilter("number", "=", (Object)extGroup);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"isparticipmerge", (QFilter[])new QFilter[]{modelQF, numQF});
            comm.setBizGroupInMerge(dy.getBoolean("isparticipmerge"));
            comm.setKeyPacker(membs -> {
                ArrayList list = new ArrayList(10);
                comm.getCrossDimensions().forEach(dim -> {
                    if (membs.get(dim) != null) {
                        list.add(extGroup + (String)membs.get(dim));
                    }
                });
                return Joiner.on((char)',').join(list);
            });
        }
        if ((reportId = (reportTabInfo = this.plugin.getCurrentReportTabInfo()).getReportId()) == null) {
            reportId = 0L;
        }
        comm.setReportId(LongUtil.toLong((Object)reportId).longValue());
        return comm;
    }

    private Map<String, Map<String, Object>> lockCellByTemplateStyle(Sheet sheet, RangeModel rangeModel) {
        HashMap<String, Map<String, Object>> cellsMap = new HashMap<String, Map<String, Object>>(16);
        sheet.iteratorRangeCells(rangeModel, cell -> {
            if (cell.getUserObject() != null && ((Boolean)cell.getUserObject("locked", (Object)false)).booleanValue()) {
                cellsMap.putAll(this.createLockMap((Cell)cell));
            }
        });
        return cellsMap;
    }

    private Map<String, Map<String, Object>> createLockMap(Cell cell) {
        HashMap<String, Map<String, Object>> maps = new HashMap<String, Map<String, Object>>(16);
        String keyMap = "row:" + cell.getRow() + "col:" + cell.getCol();
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        map.put(SpreadProperties.UnlockCellMethod.R.k(), cell.getRow());
        map.put(SpreadProperties.UnlockCellMethod.C.k(), cell.getCol());
        map.put(SpreadProperties.UnlockCellMethod.RC.k(), 1);
        map.put(SpreadProperties.UnlockCellMethod.CC.k(), 1);
        maps.put(keyMap, map);
        return maps;
    }

    private QueryStatusCommandInfo getQueryStatusCommonCommandInfo() {
        QueryStatusCommandInfo comm = new QueryStatusCommandInfo(this.plugin.getModelNumber());
        HashMap<String, Object> dim2Membs = new HashMap<String, Object>(16);
        for (IDimMember member : this.plugin.getSpreadModel().getFilter().getViewPointDomain().getAllMembers()) {
            dim2Membs.put(member.getDimension().getNumber(), member.getNumber());
        }
        for (IDimMember member : this.plugin.getSpreadModel().getFilter().getPageDomain().getAllMembers()) {
            dim2Membs.put(member.getDimension().getNumber(), member.getNumber());
        }
        String cyNum = (String)dim2Membs.get(DimTypesEnum.CURRENCY.getNumber());
        String bpNum = (String)dim2Membs.get(DimTypesEnum.PROCESS.getNumber());
        if (cyNum.equals("DC") || cyNum.equals("EC")) {
            Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.plugin.getModelId(), (long)this.plugin.getCurrentOrgId(), (String)bpNum, (String)cyNum, (long)0L, (long)0L);
            dim2Membs.put(DimTypesEnum.CURRENCY.getNumber(), pair.p2);
        }
        for (Map.Entry entry : dim2Membs.entrySet()) {
            comm.addFixDimension((String)entry.getKey(), (String)entry.getValue());
        }
        comm.setBizStatusQueryTypes(types);
        comm.setCrossDimensions(Collections.singletonList("Extends"));
        return comm;
    }

    public QueryStatusCommandInfo getQueryStatusMddCommandInfo(String dim, PositionInfo positionInfo) {
        QueryStatusCommandInfo comm = this.getQueryStatusCommonCommandInfo();
        Sheet sheet = this.plugin.getSpreadModel().getBook().getSheet(0);
        if (positionInfo.getExtendInfo() != null) {
            HashMultimap mddDim2Membsets = HashMultimap.create();
            String[] range = positionInfo.getAreaRange().split(":");
            Point start = ExcelUtils.pos2Point((String)range[0]);
            Point end = ExcelUtils.pos2Point((String)range[1]);
            sheet.iteratorRangeCells(start.y, end.y, start.x, end.x, cell -> {
                if (cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty() && dim.equals(((IDimMember)cell.getMemberFromUserObject().get(0)).getDimension().getNumber())) {
                    mddDim2Membsets.put((Object)((IDimMember)cell.getMemberFromUserObject().get(0)).getDimension().getNumber(), (Object)((IDimMember)cell.getMemberFromUserObject().get(0)).getNumber());
                }
            });
            ArrayList dims = Lists.newArrayList((Iterable)mddDim2Membsets.keySet());
            comm.setCrossDimensions((List)dims);
            for (String mddDim : dims) {
                for (String s : mddDim2Membsets.get((Object)mddDim)) {
                    comm.addCrossMembers((List)Lists.newArrayList((Object[])new String[]{s}));
                }
            }
        }
        return comm;
    }

    private void lockCell(Sheet sheet, Map<String, StatusResult> re) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        invoker.setBatch(true);
        for (PositionInfo positionInfo : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getExtendInfo() == null) continue;
            int headRow = positionInfo.getFirstRow() - 1;
            boolean isLockCol = false;
            for (Cell cell : sheet.getRow(headRow, true)) {
                if (cell.getEXTColNumber().isEmpty() || !re.containsKey(positionInfo.getExtendInfo().getExtGroup() + cell.getEXTColNumber())) continue;
                isLockCol = true;
            }
            if (!isLockCol) continue;
            RangeModel posRangeModel = new RangeModel(positionInfo.getAreaRange());
            if (this.rangeModel != null) {
                posRangeModel = this.rangeModel;
            }
            invoker.lockCell(posRangeModel.getY_start(), posRangeModel.getX_start(), posRangeModel.getRowSize(), posRangeModel.getColSize());
        }
        invoker.startToInvoke();
    }

    private void invisibleCell(Sheet sheet, Map<String, StatusResult> re) {
        Point end;
        Point start;
        String[] range;
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        invoker.setBatch(true);
        if (!re.isEmpty()) {
            for (PositionInfo positionInfo : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
                if (positionInfo.getExtendInfo() != null) {
                    int headRow = positionInfo.getFirstRow() - 1;
                    for (Cell cell2 : sheet.getRow(headRow, true)) {
                        if (cell2.getEXTColNumber().isEmpty() || !re.containsKey(cell2.getEXTColNumber())) continue;
                        int code = re.get(cell2.getEXTColNumber()).getStatusCode();
                        if (BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode() != code) continue;
                        for (int i = 0; i < positionInfo.getRowSize(); ++i) {
                            invoker.updataValue(cell2.getRow() + 1 + i, cell2.getCol(), "******");
                        }
                    }
                    range = positionInfo.getAreaRange().split(":");
                    start = ExcelUtils.pos2Point((String)range[0]);
                    end = ExcelUtils.pos2Point((String)range[1]);
                    sheet.iteratorRangeCells(start.y, end.y, start.x, end.x, cell -> {
                        String number;
                        StatusResult statusResult;
                        if (cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty() && (statusResult = (StatusResult)re.get(number = ((IDimMember)cell.getMemberFromUserObject().get(0)).getNumber())) != null) {
                            int code = statusResult.getStatusCode();
                            if (BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode() == code) {
                                for (int i = 0; i < positionInfo.getColSize(); ++i) {
                                    invoker.updataValue(cell.getRow(), cell.getCol() + i, "******");
                                }
                            }
                        }
                    });
                }
                invoker.startToInvoke();
            }
        }
        boolean isNoPerm = (Boolean)ThreadCache.get((Object)("checkMGStatus_noperm_" + RequestContext.get().getCurrUserId() + this.plugin.getModelId()), () -> {
            boolean checkMGStatus = (Boolean)ThreadCache.get((Object)("checkMGStatus_" + RequestContext.get().getCurrUserId() + this.plugin.getModelId()), () -> BcmFunPermissionHelper.needCheckMGStatus((long)RequestContext.get().getCurrUserId(), (long)this.plugin.getModelId()));
            if (checkMGStatus) {
                return !this.plugin.checkECSubmitStatus_allCY();
            }
            return false;
        });
        for (PositionInfo positionInfo : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getExtendInfo() == null) continue;
            range = positionInfo.getAreaRange().split(":");
            start = ExcelUtils.pos2Point((String)range[0]);
            end = ExcelUtils.pos2Point((String)range[1]);
            if (!isNoPerm) continue;
            sheet.iteratorRangeCells(start.y, end.y, start.x, end.x, cell -> invoker.updataValue(cell.getRow(), cell.getCol(), "******"));
        }
        invoker.startToInvoke();
    }

    public boolean isAreaLock(PositionInfo positionInfo) {
        if (positionInfo != null && positionInfo.getExtendInfo() != null) {
            QueryStatusCommandInfo extComm;
            BizStatusContext extCT;
            Map fixDimension;
            if (this.cwpAt == null) {
                DynamicObjectCollection atDoc = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"number,datasource", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.plugin.getModelId())});
                this.cwpAt = atDoc.stream().filter(d -> d.getString("datasource").equals(DataSourceEnum.TABLEADJUSTMENT.getOIndex())).map(m -> m.getString("number")).collect(Collectors.toSet());
            }
            if (!((fixDimension = (extCT = new BizStatusContext(extComm = this.getQueryStatusExtCommandInfo(positionInfo))).getQueryCommandInfo().getFixDimension()).containsKey(DimTypesEnum.ENTITY.getNumber()) && fixDimension.containsKey(DimTypesEnum.SCENARIO.getNumber()) && fixDimension.containsKey(DimTypesEnum.YEAR.getNumber()) && fixDimension.containsKey(DimTypesEnum.PERIOD.getNumber()) && fixDimension.containsKey(DimTypesEnum.CURRENCY.getNumber()) && fixDimension.containsKey(DimTypesEnum.PROCESS.getNumber()) && fixDimension.containsKey(DimTypesEnum.AUDITTRIAL.getNumber()))) {
                return false;
            }
            String processNumber = "";
            String at = "";
            for (IDimMember member : this.plugin.getSpreadModel().getFilter().getPageDomain().getAllMembers()) {
                if (member.getDimension().getNumber().equals(DimTypesEnum.PROCESS.getNumber())) {
                    processNumber = member.getNumber();
                }
                if (!member.getDimension().getNumber().equals(DimTypesEnum.AUDITTRIAL.getNumber())) continue;
                at = member.getNumber();
            }
            for (IDimMember member : this.plugin.getSpreadModel().getFilter().getViewPointDomain().getAllMembers()) {
                if (member.getDimension().getNumber().equals(DimTypesEnum.PROCESS.getNumber())) {
                    processNumber = member.getNumber();
                }
                if (!member.getDimension().getNumber().equals(DimTypesEnum.AUDITTRIAL.getNumber())) continue;
                at = member.getNumber();
            }
            Map<DimTypesEnum, Object> reportParamIds = this.plugin.getCurrentReportCommonParam("id");
            Map<DimTypesEnum, Object> reportParamNums = this.plugin.getCurrentReportCommonParam("number");
            Long orgId = (Long)reportParamIds.get(DimTypesEnum.ENTITY);
            Long sceneId = (Long)reportParamIds.get(DimTypesEnum.SCENARIO);
            Long yearId = (Long)reportParamIds.get(DimTypesEnum.YEAR);
            Long periodId = (Long)reportParamIds.get(DimTypesEnum.PERIOD);
            String currencyNum = (String)reportParamNums.get(DimTypesEnum.CURRENCY);
            if (currencyNum.equals("DC") || currencyNum.equals("EC")) {
                Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.plugin.getModelId(), (long)orgId, (String)processNumber, (String)currencyNum, (long)0L, (long)0L);
                currencyNum = (String)pair.p2;
            }
            String entityNum = (String)reportParamNums.get(DimTypesEnum.ENTITY);
            boolean isAutoConvert = ExchangeQueryHelper.getAutoConvert((Long)this.plugin.getModelId(), (Long)sceneId, (Long)yearId, (Long)periodId, (SimpleVo)SimpleVo.newOne((String)entityNum, (Long)orgId));
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)extCT.getQueryCommandInfo().getModelNumber(), (String)entityNum);
            boolean isEC = currencyNum.equals(orgNode.getCurrency());
            Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.plugin.getModelId(), (long)orgId, (String)processNumber, (String)currencyNum, (long)0L, (long)0L);
            boolean isPOrg = !orgNode.isLeaf();
            boolean isInMerge = extCT.getQueryCommandInfo().isBizGroupInMerge();
            if (!isPOrg && "EIRpt".equals(processNumber) && isEC && inputATs.contains(at)) {
                return false;
            }
            if (isPOrg && "EIRpt".equals(processNumber) && isEC && inputATs.contains(at) && !isInMerge) {
                return false;
            }
            if (!isPOrg && "IRpt".equals(processNumber) && !isEC && inputATs.contains(at) && !isAutoConvert) {
                return false;
            }
            if (isPOrg && "IRpt".equals(processNumber) && !isEC && inputATs.contains(at) && !isAutoConvert && !isInMerge) {
                return false;
            }
            if ("ERAdj".equals(processNumber) && this.cwpAt.contains(at)) {
                return false;
            }
            Map mdsMap = MergeControlHelper.geAllMergeDs((Object)this.plugin.getModelId(), (Object)sceneId, (Object)yearId, (Object)periodId);
            String mdSource = (String)mdsMap.get(orgNode.getId());
            if (isPOrg && MergeDataSourceEnum.CSTE.getIndex().equals(mdSource) && isInMerge && "EIRpt".equals(processNumber) && "EntityInput".equals(at) && isEC) {
                return false;
            }
            return !"RAdj".equals(processNumber) || !this.cwpAt.contains(at);
        }
        return false;
    }

    public RangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(RangeModel rangeModel) {
        this.rangeModel = rangeModel;
    }

    static {
        types.add(BizStatusAccessFactory.StatusCodeEnum.ReportStatusControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.LockInTemplateStyle.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.RootEntity.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.PCControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.PeriodManageControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.DataFlowControl.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.DataStageArchiveAccess.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.DataStageStatusAccess.getCode());
        types.add(BizStatusAccessFactory.StatusCodeEnum.ExtBizControl.getCode());
        inputATs = Sets.newHashSet((Object[])new String[]{"EntityInput", "DataCollection"});
    }
}

