/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.style;

import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.report.ReportContextProvider;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.EffectCombChecker;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class LockSheetLogic {
    public static final String LOCKSHEET = "locksheet";
    private AbstractMultiReportPlugin plugin;
    private Map<DimTypesEnum, Object> map;
    private DynamicObject orgCurrency;
    private boolean isLeaf;
    private boolean isView;
    private boolean isCSTE;

    public LockSheetLogic(AbstractMultiReportPlugin plugin, Map<DimTypesEnum, Object> map, DynamicObject orgCurrency, boolean isLeaf, boolean isCSTE, boolean isCWP, boolean isView) {
        this.plugin = plugin;
        this.map = map;
        this.orgCurrency = orgCurrency;
        this.isLeaf = isLeaf;
        this.isCSTE = isCSTE;
        this.isView = isView;
    }

    public boolean checkIsOnlyRead() {
        boolean quoteLocked;
        if (this.orgCurrency == null) {
            return true;
        }
        if (this.isView) {
            return true;
        }
        if (this.plugin.getTemplateModel().getIsOnlyRead()) {
            return true;
        }
        if (this.map.containsKey(DimTypesEnum.SCENARIO) && this.map.containsKey(DimTypesEnum.YEAR) && this.map.containsKey(DimTypesEnum.PERIOD) && this.map.containsKey(DimTypesEnum.ENTITY) && (quoteLocked = MergeControlHelper.isQuoteLocked((Long)this.plugin.getModelId(), (Long)Long.valueOf(this.map.get(DimTypesEnum.SCENARIO).toString()), (Long)Long.valueOf(this.map.get(DimTypesEnum.YEAR).toString()), (Long)Long.valueOf(this.map.get(DimTypesEnum.PERIOD).toString()), (Long)Long.valueOf(this.map.get(DimTypesEnum.ENTITY).toString())))) {
            return true;
        }
        boolean existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)this.plugin.getModelId());
        String bpNum = SpreadMemUtil.getMemFromFilter((SpreadManager)this.plugin.getSpreadModel(), (String)DimTypesEnum.PROCESS.getNumber());
        String atNum = SpreadMemUtil.getMemFromFilter((SpreadManager)this.plugin.getSpreadModel(), (String)DimTypesEnum.AUDITTRIAL.getNumber());
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers((long)this.plugin.getModelId()));
        if (assoMembs.contains((Object)DimTypesEnum.PROCESS.getNumber(), (Object)bpNum)) {
            bpNum = (String)assoMembs.get((Object)DimTypesEnum.PROCESS.getNumber(), (Object)bpNum);
        }
        if (assoMembs.contains((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)atNum)) {
            atNum = (String)assoMembs.get((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)atNum);
        }
        DynamicObjectCollection atdoc = ReportContextProvider.getDataSourceAT((long)this.plugin.getModelId());
        List inputaATNums = atdoc.stream().filter(d -> d.getString("datasource").contains("1")).map(m -> m.getString("number")).collect(Collectors.toList());
        List adjATNums = atdoc.stream().filter(d -> d.getString("datasource").contains(DataSourceEnum.TABLEADJUSTMENT.getOIndex())).map(m -> m.getString("number")).collect(Collectors.toList());
        DynamicObjectCollection bpdoc = ReportContextProvider.getDataSourceBp((long)this.plugin.getModelId());
        List inputBPNums = bpdoc.stream().filter(d -> d.getString("datasource").contains("1")).map(m -> m.getString("number")).collect(Collectors.toList());
        if (this.isCSTE) {
            return !inputBPNums.contains(bpNum) || !inputaATNums.contains(atNum) && existAuditTrailDimension;
        }
        if (bpNum != null && bpNum.equals("RAdj") && (adjATNums.contains(atNum) || !existAuditTrailDimension)) {
            return false;
        }
        EffectCombChecker ecc = new EffectCombChecker(this.plugin.getModelId());
        if (ecc.checkCWP(bpNum, atNum)) {
            return false;
        }
        if ("rpt".equalsIgnoreCase(this.plugin.getBizAppId()) && ecc.checkWPforRpt(bpNum, atNum)) {
            return false;
        }
        if (bpNum != null && !"ERAdj".equals(bpNum) && existAuditTrailDimension && ecc.getAtCWPNums().contains(atNum)) {
            return true;
        }
        if (bpNum != null && ecc.checkBpCanWrite(this.isLeaf, bpNum) && (!existAuditTrailDimension || ecc.checkAtCanWrite(atNum))) {
            return false;
        }
        return !StringUtils.isEmpty((String)bpNum) && !StringUtils.isEmpty((String)atNum);
    }

    public static boolean checkCWP(long modelId, String pbNum, String atNum, String org) {
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg((String)MemberReader.findModelNumberById((Object)modelId), (String)org));
        if (assoMembs.contains((Object)DimTypesEnum.PROCESS.getNumber(), (Object)pbNum)) {
            pbNum = (String)assoMembs.get((Object)DimTypesEnum.PROCESS.getNumber(), (Object)pbNum);
        }
        if (assoMembs.contains((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)atNum)) {
            atNum = (String)assoMembs.get((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)atNum);
        }
        return new EffectCombChecker(modelId).checkCWP(pbNum, atNum);
    }
}

