/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.style;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.SamePeriodLastYearVo;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.extreport.ExtReportViewHandle;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.style.CellControlerByAttachment;
import kd.fi.bcm.formplugin.report.style.DimMoveRCModel;
import kd.fi.bcm.formplugin.report.style.EXTReportStyleHandle;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.MultiAreaPositionsManager;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;

public class ReportStyleHandle {
    private AbstractMultiReportPlugin plugin;
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ReportStyleHandle.class);
    protected static final List<Integer> inUseType = new ArrayList<Integer>(16);
    protected static final List<Integer> inUseType_area = new ArrayList<Integer>(16);
    public static final List<Integer> hasRedirectMember = new ArrayList<Integer>(16);
    public static final List<Integer> adjustCheckType = new ArrayList<Integer>(16);
    protected static final List<Integer> typeNoPerm = new ArrayList<Integer>(16);
    private RangeModel rangeModel;
    private DimMoveRCModel dimMoveRCModel;

    public ReportStyleHandle(AbstractMultiReportPlugin plugin) {
        this.plugin = plugin;
    }

    public RangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(RangeModel rangeModel) {
        this.rangeModel = rangeModel;
    }

    public void statusAdjustControl() {
        HashMap<String, Map<String, Object>> cellsMap;
        LOG.startWatch();
        Sheet sheet = this.plugin.getSpreadModel().getBook().getSheet(0);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        invoker.setBatch(true);
        boolean isLockCellBySheet = ConfigServiceHelper.getBoolChildParam((Long)this.plugin.getModelId(), (String)"CM045", (String)ChildConfigEnum.LOCKCELL.getBusinesstypevalue());
        Map<Object, Object> map = cellsMap = isLockCellBySheet ? this.lockCellByTemplateStyle(sheet) : new HashMap(16);
        if (this.rangeModel != null || this.plugin.getTemplateModel().isSaveByDim() && this.plugin.getSpreadModel().getCommonPositionInfo() != null) {
            QueryStatusCommandInfo commandInfo = this.initQueryStatusCommandInfo(true, true);
            commandInfo.setBizStatusQueryTypes(typeNoPerm);
            this.markRedirectFixMember(commandInfo);
            this.invisibleCell(sheet, BizStatusServer.queryStatus((BizStatusContext)new BizStatusContext(commandInfo)), invoker, commandInfo.getCrossDimensions());
            if (this.rangeModel != null) {
                invoker.unlockCell(this.rangeModel.getY_start(), this.rangeModel.getX_start(), this.rangeModel.getY_end() - this.rangeModel.getY_start() + 1, this.rangeModel.getX_end() - this.rangeModel.getX_start() + 1);
            } else {
                invoker.unlockCell(0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
            }
            commandInfo.setBizStatusQueryTypes(adjustCheckType);
            Map statusMap = BizStatusServer.queryStatus((BizStatusContext)new BizStatusContext(commandInfo));
            List<Map<String, Object>> cells = this.lockCell(statusMap, sheet, cellsMap, commandInfo.getCrossDimensions(), false);
            if (!cells.isEmpty()) {
                invoker.lockCell(cells);
            }
            this.markRedirectMember(commandInfo);
        }
        invoker.startToInvoke();
        if (this.rangeModel == null) {
            EXTReportStyleHandle handle = new EXTReportStyleHandle(this.plugin);
            handle.statusControl();
        }
        LOG.info(String.format("\u62a5\u8868\u9501\u5b9aReportStyleHandle[%s]\u6267\u884c\u8017\u65f6", "statusAdjustControl"));
    }

    public Map<String, Map<String, Object>> statusControl(boolean isNoPerm) {
        LOG.startWatch();
        Sheet sheet = this.plugin.getSpreadModel().getBook().getSheet(0);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        invoker.setBatch(true);
        Map<String, Map<String, Object>> cellsMap = this.lockCellByTemplateStyle(sheet);
        if (this.rangeModel != null || this.plugin.getTemplateModel().isSaveByDim() && this.plugin.getSpreadModel().getCommonPositionInfo() != null) {
            QueryStatusCommandInfo commandInfo = this.initQueryStatusCommandInfo(isNoPerm, false);
            if (commandInfo.hasCrossDims()) {
                BizStatusContext statusContext = new BizStatusContext(commandInfo);
                this.markRedirectFixMember(commandInfo);
                Map statusMap = BizStatusServer.queryStatus((BizStatusContext)statusContext);
                Map<String, StatusResult> areaStatusMap = this.queryAreaStatus(isNoPerm, this.rangeModel);
                List crossDimensions = commandInfo.getCrossDimensions();
                this.invisibleCell(sheet, statusMap, invoker, crossDimensions);
                if (!sheet.getUserObject().containsKey("issource")) {
                    CellControlerByAttachment attchController = new CellControlerByAttachment(this.plugin);
                    attchController.setRangeModel(this.rangeModel);
                    attchController.controlStyle();
                }
                sheet.getUserObject().remove("issource");
                if (!isNoPerm) {
                    if (this.rangeModel != null) {
                        invoker.unlockCell(this.rangeModel.getY_start(), this.rangeModel.getX_start(), this.rangeModel.getY_end() - this.rangeModel.getY_start() + 1, this.rangeModel.getX_end() - this.rangeModel.getX_start() + 1);
                    } else {
                        invoker.unlockCell(0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
                    }
                    List<Map<String, Object>> cells = this.lockCell(statusMap, sheet, cellsMap, crossDimensions, false);
                    List<Map<String, Object>> areCells = this.lockCell(areaStatusMap, sheet, cellsMap, crossDimensions, false);
                    if (!cells.isEmpty()) {
                        invoker.lockCell(cells);
                    }
                    if (!areCells.isEmpty()) {
                        invoker.lockCell(areCells);
                    }
                    this.markRedirectMember(commandInfo);
                }
            }
        } else {
            invoker.lockCell(cellsMap.values().stream().collect(Collectors.toList()));
        }
        invoker.startToInvoke();
        if (this.rangeModel == null) {
            EXTReportStyleHandle handle = new EXTReportStyleHandle(this.plugin);
            handle.statusControl();
        }
        LOG.info(String.format("\u62a5\u8868\u9501\u5b9aReportStyleHandle[%s]\u6267\u884c\u8017\u65f6", "statusControl"));
        return cellsMap;
    }

    private Map<String, StatusResult> queryAreaStatus(boolean isNoPerm, RangeModel rangeModel) {
        HashMap<String, StatusResult> areaStatusMap = new HashMap<String, StatusResult>(16);
        if (rangeModel != null) {
            int index = 1 == this.plugin.getSpreadModel().isHorizon() ? rangeModel.getX_start() : rangeModel.getY_start();
            BasePointInfo basePoint = this.plugin.getSpreadModel().getInAreaBasePosInfo(index);
            if (basePoint != null) {
                for (BasePointInnerLineInfo lineInfo : basePoint.getBasePointInnerLineInfo()) {
                    if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(lineInfo.getDimension().getNumber())) continue;
                    this.setRangeModel(rangeModel);
                    QueryStatusCommandInfo areaCommandInfo = this.initQueryStatusCommandInfo(isNoPerm, false);
                    BizStatusContext areaStatusContext = new BizStatusContext(areaCommandInfo);
                    areaStatusContext.setPointInfo(basePoint);
                    areaStatusContext.getQueryCommandInfo().setBizStatusQueryTypes(inUseType_area);
                    areaStatusMap.putAll(BizStatusServer.queryStatus((BizStatusContext)areaStatusContext));
                }
            }
        } else {
            for (PositionInfo pos : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
                for (BasePointInfo basePoint : pos.getBasePoints()) {
                    for (BasePointInnerLineInfo lineInfo : basePoint.getBasePointInnerLineInfo()) {
                        if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(lineInfo.getDimension().getNumber())) continue;
                        rangeModel = new RangeModel(basePoint.getDynaRange());
                        this.setRangeModel(rangeModel);
                        QueryStatusCommandInfo areaCommandInfo = this.initQueryStatusCommandInfo(isNoPerm, false);
                        BizStatusContext areaStatusContext = new BizStatusContext(areaCommandInfo);
                        areaStatusContext.setPointInfo(basePoint);
                        areaStatusContext.getQueryCommandInfo().setBizStatusQueryTypes(inUseType_area);
                        areaStatusMap.putAll(BizStatusServer.queryStatus((BizStatusContext)areaStatusContext));
                    }
                }
            }
            this.setRangeModel(null);
        }
        return areaStatusMap;
    }

    public List<Map<String, Object>> statusControlRedirect(boolean isNoPerm, boolean isNeedRedirect) {
        if (!ConfigServiceHelper.getBoolParam((Long)this.plugin.getModelId(), (String)"CM043")) {
            return new ArrayList<Map<String, Object>>();
        }
        LOG.startWatch();
        Sheet sheet = this.plugin.getSpreadModel().getBook().getSheet(0);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        invoker.setBatch(true);
        Map<String, Map<String, Object>> cellsMap = this.lockCellByTemplateStyle(sheet);
        List<Map<String, Object>> cells = new ArrayList<Map<String, Object>>(16);
        if (this.rangeModel != null || this.plugin.getTemplateModel().isSaveByDim() && this.plugin.getSpreadModel().getCommonPositionInfo() != null) {
            QueryStatusCommandInfo commandInfo = this.initQueryStatusCommandInfo(isNoPerm, isNeedRedirect);
            commandInfo.setBizStatusQueryTypes(hasRedirectMember);
            BizStatusContext statusContext = new BizStatusContext(commandInfo);
            this.markRedirectFixMember(commandInfo);
            Map statusMap = BizStatusServer.queryStatus((BizStatusContext)statusContext);
            List crossDimensions = commandInfo.getCrossDimensions();
            this.invisibleCell(sheet, statusMap, invoker, crossDimensions);
            if (!isNoPerm) {
                if (this.rangeModel != null) {
                    invoker.unlockCell(this.rangeModel.getY_start(), this.rangeModel.getX_start(), this.rangeModel.getY_end() - this.rangeModel.getY_start() + 1, this.rangeModel.getX_end() - this.rangeModel.getX_start() + 1);
                } else {
                    invoker.unlockCell(0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
                }
                cells = this.lockCell(statusMap, sheet, cellsMap, crossDimensions, true);
                if (!cells.isEmpty()) {
                    invoker.lockCell(cells);
                }
                this.markRedirectMember(commandInfo);
            }
        } else {
            invoker.lockCell(cellsMap.values().stream().collect(Collectors.toList()));
        }
        invoker.startToInvoke();
        LOG.info(String.format("\u62a5\u8868\u91cd\u5b9a\u5411\u9501\u5b9aReportStyleHandle[%s]\u6267\u884c\u8017\u65f6", "statusControl"));
        return cells;
    }

    public boolean statusControlWithRedirect(Cell cell, boolean isNoPerm) {
        LOG.startWatch();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        invoker.setBatch(true);
        QueryStatusCommandInfo commandInfo = this.initQueryStatusCommandInfo(cell, isNoPerm, true);
        commandInfo.setBizStatusQueryTypes(hasRedirectMember);
        BizStatusContext statusContext = new BizStatusContext(commandInfo);
        Map statusMap = BizStatusServer.queryStatus((BizStatusContext)statusContext);
        if (!isNoPerm) {
            return !statusMap.isEmpty();
        }
        return false;
    }

    private void markRedirectFixMember(QueryStatusCommandInfo commandInfo) {
        HashBasedTable assoMembs;
        Map fixDimension = commandInfo.getFixDimension();
        if (this.isCommonDimsIncludeDim(commandInfo, DimTypesEnum.ENTITY.getNumber())) {
            if (this.plugin.isAdjust()) {
                assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel_adjust", () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg((String)commandInfo.getModelNumber(), null));
            } else {
                String par_sonNum = (String)((Object[])commandInfo.getCommonDims().get(DimTypesEnum.ENTITY.getNumber()))[1];
                String orgRealNum = (String)ThreadCache.get((Object)("on" + par_sonNum), () -> MemberReader.findMemberByNumber((String)commandInfo.getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)par_sonNum).getNumber());
                assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg((String)commandInfo.getModelNumber(), (String)orgRealNum));
            }
        } else {
            assoMembs = HashBasedTable.create();
        }
        for (Map.Entry dim2Memb : fixDimension.entrySet()) {
            if (!assoMembs.contains(dim2Memb.getKey(), dim2Memb.getValue())) continue;
            this.plugin.getSpreadModel().getFilter().setHasReactFixMember(true);
        }
    }

    public boolean isCommonDimsIncludeDim(QueryStatusCommandInfo commandInfo, String dimNum) {
        Map commonDims;
        return commandInfo != null && (commonDims = commandInfo.getCommonDims()) != null && commonDims.get(dimNum) != null;
    }

    private void markRedirectMember(QueryStatusCommandInfo commandInfo) {
        this.markRedirectFixMember(commandInfo);
        Recorder org = new Recorder((Object)"");
        if (this.isCommonDimsIncludeDim(commandInfo, DimTypesEnum.ENTITY.getNumber())) {
            org.setRecord((Object)((String)((Object[])commandInfo.getCommonDims().get(DimTypesEnum.ENTITY.getNumber()))[1]));
        }
        Table assoMembs = this.plugin.isAdjust() ? (Table)ThreadCache.get((Object)"assoMembInModel_adjust", () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg((String)commandInfo.getModelNumber(), null)) : (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg((String)commandInfo.getModelNumber(), (String)((String)org.getRecord())));
        WatchLoggerUtil.debug((WatchLogger)LOG, (String)("assoMembs_" + assoMembs));
        this.plugin.getSpreadModel().getBook().getSheet(0).iteratorCells(cell -> {
            List memberFromUserObject;
            if (cell.isMdDataDomain() && !(memberFromUserObject = cell.getMemberFromUserObject()).isEmpty()) {
                for (IDimMember member : memberFromUserObject) {
                    boolean redirectMem = assoMembs.contains((Object)member.getDimension().getNumber(), (Object)member.getNumber());
                    cell.setHasReactMember(redirectMem);
                }
            }
        });
        this.plugin.cacheSpreadModel();
    }

    private String getCrossMemberKey(List<IDimMember> memberFromUserObject, List<String> crossDimNumber) {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>(16);
        memberFromUserObject.forEach(iDimMember -> map.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber()));
        Predicate<DimMember> testLastYear = c -> DimTypesEnum.YEAR.getNumber().equals(c.getDimension().getNumber()) && "LastYear".equals(c.getOriNumber());
        if (this.dimMoveRCModel != null && this.dimMoveRCModel.isNeedPutPeriodInRC()) {
            Recorder isLastYear = new Recorder((Object)false);
            memberFromUserObject.forEach(iDimMember -> {
                map.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber());
                if (testLastYear.test((DimMember)iDimMember)) {
                    isLastYear.setRecord((Object)true);
                }
            });
            if (!map.containsKey(DimTypesEnum.PERIOD.getNumber())) {
                map.put(DimTypesEnum.PERIOD.getNumber(), this.dimMoveRCModel.getAllDim2Membs().get(DimTypesEnum.PERIOD.getNumber()));
            }
            if (this.dimMoveRCModel.isNeedPutPeriodInRC() && ((Boolean)isLastYear.getRecord()).booleanValue()) {
                List pyVos = ConfigServiceHelper.getCM056Config((long)this.plugin.getModelId());
                for (SamePeriodLastYearVo pyVo : pyVos) {
                    if (!pyVo.getSceario().equals(this.dimMoveRCModel.getDim2Membs().get(DimTypesEnum.SCENARIO.getNumber())) || !pyVo.getCurrentPeriod().equals(map.get(DimTypesEnum.PERIOD.getNumber()))) continue;
                    map.put(DimTypesEnum.PERIOD.getNumber(), pyVo.getExchangePeriod());
                    break;
                }
            }
        }
        crossDimNumber.forEach(dimNumber -> stringBuilder.append((String)dimNumber).append('|').append((String)map.get(dimNumber)).append(";"));
        return stringBuilder.toString();
    }

    private void invisibleCell(Sheet sheet, Map<String, StatusResult> re, SpreadEasyInvoker invoker, List<String> crossDimNumber) {
        HashMap<String, StatusResult> noPermMap = new HashMap<String, StatusResult>(16);
        HashMap<String, StatusResult> onlyReadPermMap = new HashMap<String, StatusResult>(16);
        for (Map.Entry<String, StatusResult> entry : re.entrySet()) {
            if (entry.getValue().getStatusCode() == BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode()) {
                noPermMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue().getStatusCode() != BizStatusAccessFactory.StatusCodeEnum.PermissionControl.getCode()) continue;
            onlyReadPermMap.put(entry.getKey(), entry.getValue());
        }
        sheet.iteratorRangeCells(this.rangeModel, cell -> {
            if (cell.isMdDataDomain()) {
                String crossMemberKey = this.getCrossMemberKey(cell.getMemberFromUserObject(), crossDimNumber);
                if (noPermMap.containsKey(crossMemberKey)) {
                    invoker.updataValue(cell.getRow(), cell.getCol(), "******");
                    cell.setUserObject("p", (Object)1);
                    cell.removeUserObject("r");
                } else if (onlyReadPermMap.containsKey(crossMemberKey)) {
                    cell.setUserObject("r", (Object)1);
                    cell.removeUserObject("p");
                } else {
                    cell.removeUserObject("r");
                    cell.removeUserObject("p");
                }
            }
        });
    }

    private Map<String, Map<String, Object>> lockCellByTemplateStyle(Sheet sheet) {
        HashMap<String, Map<String, Object>> cellsMap = new HashMap<String, Map<String, Object>>(16);
        Map<String, Pair<Long, String>> pageViewMember = this.plugin.getPageViewMember();
        boolean isNeedCheck = !pageViewMember.containsKey(DimTypesEnum.YEAR.getNumber()) || !pageViewMember.containsKey(DimTypesEnum.PERIOD.getNumber());
        sheet.iteratorRangeCells(this.rangeModel, cell -> {
            if (cell.isLock()) {
                cellsMap.putAll(this.createLockMap((Cell)cell));
            } else if (cell.isMdDataDomain() && isNeedCheck && this.hasSpecialMember((Cell)cell)) {
                cellsMap.putAll(this.createLockMap((Cell)cell));
            }
        });
        return cellsMap;
    }

    private boolean hasSpecialMember(Cell cell) {
        boolean hasSpecialMember = false;
        for (IDimMember m : cell.getMemberFromUserObject()) {
            String dNumber = m.getDimension().getNumber();
            if ((!PresetConstant.FY_DIM.equals(dNumber) || !Arrays.asList(m.getNumber(), ((DimMember)m).getOriNumber()).contains("LastYear")) && (!PresetConstant.PERIOD_DIM.equals(dNumber) || !Arrays.asList(m.getNumber(), ((DimMember)m).getOriNumber()).contains("LastPeriod"))) continue;
            hasSpecialMember = true;
        }
        return hasSpecialMember;
    }

    private Map<String, Map<String, Object>> createLockMap(Cell cell) {
        HashMap<String, Map<String, Object>> maps = new HashMap<String, Map<String, Object>>(16);
        String keyMap = "row:" + cell.getRow() + "col:" + cell.getCol();
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        map.put(SpreadProperties.UnlockCellMethod.R.k(), cell.getRow());
        map.put(SpreadProperties.UnlockCellMethod.C.k(), cell.getCol());
        map.put(SpreadProperties.UnlockCellMethod.RC.k(), 1);
        map.put(SpreadProperties.UnlockCellMethod.CC.k(), 1);
        maps.put(keyMap, map);
        return maps;
    }

    private QueryStatusCommandInfo initQueryStatusCommandInfo(boolean isNoPerm, boolean isNeedRedirect) {
        return this.initQueryStatusCommandInfo(null, isNoPerm, isNeedRedirect);
    }

    private QueryStatusCommandInfo initQueryStatusCommandInfo(Cell cell, boolean isNoPerm, boolean isNeedRedirect) {
        QueryStatusCommandInfo queryStatusCommandInfo = new QueryStatusCommandInfo(this.plugin.getModelNumber());
        HashMap<String, String> dim2Membs = new HashMap<String, String>(16);
        HashMap<String, String> fixDim2RCMembs = new HashMap<String, String>(16);
        FilterView filterView = this.plugin.getSpreadModel().getFilter();
        for (IDimMember member : filterView.getViewPointDomain().getAllMembers()) {
            dim2Membs.put(member.getDimension().getNumber(), TemplateUtil.getMemberNumber((IDimMember)member));
        }
        for (IDimMember member : filterView.getPageDomain().getAllMembers()) {
            dim2Membs.put(member.getDimension().getNumber(), TemplateUtil.getMemberNumber((IDimMember)member));
        }
        String cyNum = (String)dim2Membs.get(DimTypesEnum.CURRENCY.getNumber());
        String bpNum = (String)dim2Membs.get(DimTypesEnum.PROCESS.getNumber());
        String orgNum = (String)dim2Membs.get(DimTypesEnum.ENTITY.getNumber());
        if (cyNum != null && bpNum != null && (cyNum.equals("DC") || cyNum.equals("EC")) && StringUtils.isNotEmpty((String)orgNum)) {
            Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.plugin.getModelId(), (long)this.plugin.getCurrentOrgId(), (String)bpNum, (String)cyNum, (long)0L, (long)0L);
            dim2Membs.put(DimTypesEnum.CURRENCY.getNumber(), (String)pair.p2);
        }
        this.dimMoveRCModel = this.getDimMoveRCModel(dim2Membs);
        this.moveCommonDim2RC(dim2Membs, fixDim2RCMembs, this.dimMoveRCModel);
        for (Map.Entry entry : dim2Membs.entrySet()) {
            if (isNeedRedirect || filterView.isHasReactFixMember()) {
                Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg((String)this.plugin.getModelNumber(), (String)((String)dim2Membs.get(DimTypesEnum.ENTITY.getNumber()))));
                if (assoMembs.get(entry.getKey(), entry.getValue()) != null) {
                    queryStatusCommandInfo.addFixDimension((String)entry.getKey(), (String)assoMembs.get(entry.getKey(), entry.getValue()));
                    continue;
                }
                queryStatusCommandInfo.addFixDimension((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            queryStatusCommandInfo.addFixDimension((String)entry.getKey(), (String)entry.getValue());
        }
        List<String> crossDimensions = this.getcrossDimensionNumber(this.dimMoveRCModel);
        queryStatusCommandInfo.setCrossDimensions(crossDimensions);
        if (cell != null) {
            if (cell.isMdDataDomain()) {
                queryStatusCommandInfo.addCrossMembers(this.getCrossMembersByCell(cell, crossDimensions, isNeedRedirect, this.dimMoveRCModel));
            }
        } else {
            this.plugin.getSpreadModel().getBook().getSheet(0).iteratorRangeCells(this.rangeModel, singeleCell -> {
                if (singeleCell.isMdDataDomain()) {
                    queryStatusCommandInfo.addCrossMembers(this.getCrossMembersByCell((Cell)singeleCell, crossDimensions, isNeedRedirect, this.dimMoveRCModel));
                }
            });
        }
        if (this.plugin.isAdjust()) {
            queryStatusCommandInfo.setBizStatusQueryTypes(adjustCheckType);
        } else {
            queryStatusCommandInfo.setBizStatusQueryTypes(isNoPerm ? typeNoPerm : inUseType);
        }
        queryStatusCommandInfo.setKeyPacker(membs -> {
            StringBuilder sb = new StringBuilder();
            crossDimensions.forEach(dim -> {
                if (membs.get(dim) != null) {
                    sb.append((String)dim).append('|').append((String)membs.get(dim)).append(";");
                }
            });
            return sb.toString();
        });
        if (Sets.newHashSet((Object[])new Integer[]{TemplateTypeEnum.DYNA.getType(), TemplateTypeEnum.FIX.getType()}).contains(this.plugin.getTemplateModel().getTemplateType())) {
            ReportTabInfo reportTabInfo = this.plugin.getCurrentReportTabInfo();
            Object reportId = reportTabInfo.getReportId();
            if (reportId == null) {
                reportId = 0L;
            }
            queryStatusCommandInfo.setReportId(LongUtil.toLong((Object)reportId).longValue());
            queryStatusCommandInfo.setTemplateId(LongUtil.toLong((Object)reportTabInfo.getTemplateId()).longValue());
            this.addCommonDimensions(queryStatusCommandInfo);
        }
        return queryStatusCommandInfo;
    }

    private void moveCommonDim2RC(Map<String, String> dim2Membs, Map<String, String> fixDim2RCMembs, DimMoveRCModel dimMoveRCModel) {
        dimMoveRCModel.putAllDim2Membs(dim2Membs);
        if (dimMoveRCModel.isNeedPutPeriodInRC()) {
            fixDim2RCMembs.put(DimTypesEnum.PERIOD.getNumber(), dim2Membs.remove(DimTypesEnum.PERIOD.getNumber()));
        }
        dimMoveRCModel.putDim2Membs(dim2Membs);
        dimMoveRCModel.putFixDim2RCMembs(fixDim2RCMembs);
    }

    private DimMoveRCModel getDimMoveRCModel(Map<String, String> dim2Membs) {
        DimMoveRCModel dimMoveRCModel = new DimMoveRCModel();
        boolean isPeriodInPV = false;
        boolean isfyInPV = false;
        for (Map.Entry<String, String> entry : dim2Membs.entrySet()) {
            if (DimTypesEnum.YEAR.getNumber().equals(entry.getKey())) {
                isfyInPV = true;
                continue;
            }
            if (!DimTypesEnum.PERIOD.getNumber().equals(entry.getKey())) continue;
            isPeriodInPV = true;
        }
        List pyVos = ConfigServiceHelper.getCM056Config((long)this.plugin.getModelId());
        MultiAreaPositionsManager spreadmanager = this.plugin.getSpreadModel().getAreaManager();
        boolean isLastYearInRC = false;
        if (!pyVos.isEmpty()) {
            for (PositionInfo pos : spreadmanager.getPostionInfoSet()) {
                if (isfyInPV || !isPeriodInPV) continue;
                if (spreadmanager.getRowDimDoman(pos).containsDimension(DimTypesEnum.YEAR.getNumber())) {
                    for (IDimMember member : spreadmanager.getRowDimDoman(pos).getAllMembers()) {
                        if (!"LastYear".equals(((DimMember)member).getOriNumber())) continue;
                        isLastYearInRC = true;
                        break;
                    }
                    if (isLastYearInRC) break;
                }
                if (!spreadmanager.getColDimDomain(pos).containsDimension(DimTypesEnum.YEAR.getNumber())) continue;
                for (IDimMember member : spreadmanager.getColDimDomain(pos).getAllMembers()) {
                    if (!"LastYear".equals(((DimMember)member).getOriNumber())) continue;
                    isLastYearInRC = true;
                    break;
                }
                if (!isLastYearInRC) continue;
                break;
            }
        }
        dimMoveRCModel.setNeedPutPeriodInRC(isLastYearInRC);
        return dimMoveRCModel;
    }

    public void addCommonDimensions(QueryStatusCommandInfo queryStatusCommandInfo) {
        String commonFilterDimensionInfo = this.plugin.getCommonFilterDimensionInfo();
        JSONObject dims = new JSONObject();
        if (StringUtils.isNotEmpty((String)commonFilterDimensionInfo)) {
            dims = JSONObject.parseObject((String)commonFilterDimensionInfo);
        }
        for (Map.Entry entry : dims.entrySet()) {
            String dimNumber = "";
            JSONObject item = (JSONObject)entry.getValue();
            String key = (String)entry.getKey();
            String memNumber = item.getString("number");
            Long id = item.getLong("id");
            switch (key) {
                case "bcm_entitymembertree": {
                    IDNumberTreeNode numberTreeNode = MemberReader.findEntityMemberById((String)this.plugin.getModelNumber(), (Long)id);
                    if (numberTreeNode.getParent() != null) {
                        memNumber = numberTreeNode.getParent().getNumber() + "_" + numberTreeNode.getNumber();
                    }
                    dimNumber = DimTypesEnum.ENTITY.getNumber();
                    break;
                }
                case "bcm_scenemembertree": {
                    dimNumber = DimTypesEnum.SCENARIO.getNumber();
                    break;
                }
                case "bcm_fymembertree": {
                    dimNumber = DimTypesEnum.YEAR.getNumber();
                    break;
                }
                case "bcm_periodmembertree": {
                    dimNumber = DimTypesEnum.PERIOD.getNumber();
                    break;
                }
                case "bcm_currencymembertree": {
                    dimNumber = DimTypesEnum.CURRENCY.getNumber();
                    break;
                }
            }
            queryStatusCommandInfo.addCommonDims(dimNumber, id, memNumber);
        }
    }

    private List<String> getcrossDimensionNumber(DimMoveRCModel dimMoveRCModel) {
        Pair<AreaRangeEntry, List<String>> pair = kd.fi.bcm.formplugin.util.TemplateUtil.getCommonAreaRangeEntry(this.plugin.getTemplateModel());
        if (dimMoveRCModel.isNeedPutPeriodInRC()) {
            ((List)pair.p2).add(DimTypesEnum.PERIOD.getNumber());
        }
        return pair == null ? new ArrayList(16) : (List)pair.p2;
    }

    private List<String> getCrossMembersByCell(Cell cell, List<String> crossDimensions, boolean isNeedRedirect, DimMoveRCModel dimMoveRCModel) {
        ArrayList<String> rowOrColDimNumber = new ArrayList<String>(16);
        if (cell.isMdDataDomain()) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            Recorder isLastYear = new Recorder((Object)false);
            Predicate<DimMember> testLastYear = c -> DimTypesEnum.YEAR.getNumber().equals(c.getDimension().getNumber()) && "LastYear".equals(c.getOriNumber());
            if (isNeedRedirect && cell.hasReactMember()) {
                Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers((String)this.plugin.getModelNumber()));
                cell.getMemberFromUserObject().forEach(iDimMember -> {
                    if (assoMembs.get((Object)iDimMember.getDimension().getNumber(), (Object)iDimMember.getNumber()) == null) {
                        map.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber());
                    } else {
                        map.put(iDimMember.getDimension().getNumber(), (String)assoMembs.get((Object)iDimMember.getDimension().getNumber(), (Object)iDimMember.getNumber()));
                    }
                    if (testLastYear.test((DimMember)iDimMember)) {
                        isLastYear.setRecord((Object)true);
                    }
                });
            } else {
                cell.getMemberFromUserObject().forEach(iDimMember -> {
                    map.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber());
                    if (testLastYear.test((DimMember)iDimMember)) {
                        isLastYear.setRecord((Object)true);
                    }
                });
            }
            if (!map.containsKey(DimTypesEnum.PERIOD.getNumber()) && dimMoveRCModel.isNeedPutPeriodInRC()) {
                map.put(DimTypesEnum.PERIOD.getNumber(), dimMoveRCModel.getAllDim2Membs().get(DimTypesEnum.PERIOD.getNumber()));
            }
            if (dimMoveRCModel.isNeedPutPeriodInRC() && ((Boolean)isLastYear.getRecord()).booleanValue()) {
                List pyVos = ConfigServiceHelper.getCM056Config((long)this.plugin.getModelId());
                for (SamePeriodLastYearVo pyVo : pyVos) {
                    if (!pyVo.getSceario().equals(dimMoveRCModel.getDim2Membs().get(DimTypesEnum.SCENARIO.getNumber())) || !pyVo.getCurrentPeriod().equals(map.get(DimTypesEnum.PERIOD.getNumber()))) continue;
                    map.put(DimTypesEnum.PERIOD.getNumber(), pyVo.getExchangePeriod());
                    break;
                }
            }
            crossDimensions.forEach(dimNumber -> rowOrColDimNumber.add((String)map.get(dimNumber)));
        }
        return rowOrColDimNumber;
    }

    private List<Map<String, Object>> lockCell(Map<String, StatusResult> statusMap, Sheet sheet, Map<String, Map<String, Object>> cellsMap, List<String> crossDimensions, boolean isNeedRedirect) {
        if (!statusMap.isEmpty()) {
            sheet.iteratorRangeCells(this.rangeModel, cell -> {
                List memberFromUserObject;
                if (cell.isMdDataDomain() && !(memberFromUserObject = cell.getMemberFromUserObject()).isEmpty()) {
                    String keyMap = "row:" + cell.getRow() + "col:" + cell.getCol();
                    if (isNeedRedirect && cell.hasReactMember()) {
                        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers((String)this.plugin.getModelNumber()));
                        StringBuilder stringBuilder = new StringBuilder();
                        HashMap map = new HashMap(16);
                        memberFromUserObject.forEach(iDimMember -> {
                            if (assoMembs.get((Object)iDimMember.getDimension().getNumber(), (Object)iDimMember.getNumber()) == null) {
                                map.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber());
                            } else {
                                map.put(iDimMember.getDimension().getNumber(), assoMembs.get((Object)iDimMember.getDimension().getNumber(), (Object)iDimMember.getNumber()));
                            }
                        });
                        crossDimensions.forEach(dimNumber -> stringBuilder.append((String)dimNumber).append('|').append((String)map.get(dimNumber)).append(";"));
                        String crossMemberKey = stringBuilder.toString();
                        if (statusMap.containsKey(crossMemberKey) && !cellsMap.containsKey(keyMap)) {
                            cellsMap.putAll(this.createLockMap((Cell)cell));
                        }
                    } else {
                        String crossMemberKey = this.getCrossMemberKey(memberFromUserObject, crossDimensions);
                        if (statusMap.containsKey(crossMemberKey) && !cellsMap.containsKey(keyMap)) {
                            cellsMap.putAll(this.createLockMap((Cell)cell));
                        }
                    }
                }
            });
        }
        if (cellsMap.values().isEmpty()) {
            return new ArrayList<Map<String, Object>>(16);
        }
        return cellsMap.values().stream().collect(Collectors.toList());
    }

    public String getLockMsg(Cell cell, boolean isNoPerm, boolean isDoubleClick, List<Integer> lockTypes) {
        PositionInfo pos;
        String lockMsg = "";
        if (((Boolean)cell.getUserObject("locked", (Object)false)).booleanValue() || isDoubleClick && !this.plugin.getTemplateModel().isSaveByDim()) {
            return ResManager.loadKDString((String)"\u6a21\u677f\u5185\u8bbe\u7f6e\u9501\u5b9a\u3002", (String)"ReportStyleHandle_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (this.isOnlyReadTempStatus()) {
            return ResManager.loadKDString((String)"\u53ea\u8bfb\u72b6\u6001\u5df2\u9501\u5b9a\u3002", (String)"ReportStyleHandle_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (cell.isMdDataDomain()) {
            boolean isNeedCheck;
            Map<String, Pair<Long, String>> pageViewMember = this.plugin.getPageViewMember();
            boolean bl = isNeedCheck = !pageViewMember.containsKey(DimTypesEnum.YEAR.getNumber()) || !pageViewMember.containsKey(DimTypesEnum.PERIOD.getNumber());
            if (isNeedCheck && this.hasSpecialMember(cell)) {
                lockMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u8d22\u5e74\u671f\u95f4\u4e0a\u5e74\u4e0a\u671f\u9501\u5b9a\u3002", (String)"ReportStyleHandle_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isEmpty((String)lockMsg)) {
                QueryStatusCommandInfo commandInfo = this.initQueryStatusCommandInfo(cell, isNoPerm, false);
                if (lockTypes != null) {
                    commandInfo.setBizStatusQueryTypes(lockTypes);
                }
                BizStatusContext statusContext = new BizStatusContext(commandInfo);
                Map statusMap = BizStatusServer.queryStatus((BizStatusContext)statusContext);
                Map<String, StatusResult> areaStatusMap = this.queryAreaStatus(isNoPerm, new RangeModel(cell.getCol(), cell.getCol(), cell.getRow(), cell.getRow()));
                statusMap.putAll(areaStatusMap);
                if (!statusMap.isEmpty()) {
                    int statusCode = ((StatusResult)statusMap.values().iterator().next()).getStatusCode();
                    lockMsg = BizStatusServer.getLockMsg((BizStatusContext)statusContext, (int)statusCode);
                }
            }
        }
        if ((pos = this.plugin.getSpreadModel().getInAreaPositionByRow(cell.getRow(), cell.getCol())) != null && pos.getExtendInfo() != null && StringUtils.isEmpty((String)lockMsg)) {
            QueryStatusCommandInfo commandInfo = this.initQueryStatusCommandInfo(cell, isNoPerm, false);
            commandInfo.setBizStatusQueryTypes(EXTReportStyleHandle.types);
            BizStatusContext statusContext = new BizStatusContext(commandInfo);
            Map statusMap = BizStatusServer.queryExtStatus((BizStatusContext)statusContext);
            if (!statusMap.isEmpty()) {
                int statusCode = ((StatusResult)statusMap.values().iterator().next()).getStatusCode();
                lockMsg = BizStatusServer.getLockMsg((BizStatusContext)statusContext, (int)statusCode);
            }
            if (StringUtils.isEmpty((String)lockMsg)) {
                ExtReportViewHandle viewHandle = new ExtReportViewHandle(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.plugin.getView());
                viewHandle.setPlugin(this.plugin);
                Pair<String, List<Integer>> lockRow = viewHandle.lockStageLockCols(this.plugin.getSpreadModel(), false);
                if (((List)lockRow.p2).contains(cell.getRow())) {
                    lockMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b%s\u9636\u6bb5\u5df2\u9501\u5b9a\uff0c\u6570\u636e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizStatusServer_22", (String)"fi-bcm-business", (Object[])new Object[0]), lockRow.p1);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)lockMsg)) {
            return lockMsg;
        }
        if (this.isCommitOrCompleteForReport()) {
            return ResManager.loadKDString((String)"\u62a5\u8868\u72b6\u6001\u63a7\u5236\u9501\u5b9a\u3002", (String)"ReportStyleHandle_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        int unit = this.plugin.getReportUnitInfo();
        if (ConfigServiceHelper.getBoolParam((Long)this.plugin.getModelId(), (String)"CM059") && unit != 0) {
            return ResManager.loadKDString((String)"\u975e\u5143\u8868\u5355\u4f4d\u4e0b\u6570\u636e\u4e0d\u53ef\u5f55\u5165\u3002", (String)"ReportStyleHandle_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return lockMsg;
    }

    private boolean isOnlyReadTempStatus() {
        ReportTabInfo reportTabInfo = this.plugin.getCurrentReportTabInfo();
        Long templateId = LongUtil.toLong((Object)reportTabInfo.getTemplateId());
        QFilter templateFilter = new QFilter("id", "=", (Object)templateId);
        templateFilter.and("isonlyread", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"bcm_templateentity", (QFilter[])templateFilter.toArray());
    }

    public boolean isCommitOrCompleteForReport() {
        ReportTabInfo reportTabInfo = this.plugin.getCurrentReportTabInfo();
        Object reportId = reportTabInfo.getReportId();
        if (reportId != null && !reportId.equals(0L)) {
            QFilter filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)reportId));
            filter.and("reportstatus", "in", Arrays.asList(ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()));
            return QueryServiceHelper.exists((String)"bcm_reportentity", (QFilter[])filter.toArray());
        }
        return false;
    }

    static {
        typeNoPerm.add(BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.PeriodManageControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.AdjustPeriodControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.ValidCrossControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.MemberSelfControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.ValidCalAccControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.InnerLogicGenerate.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.PCControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.InputMemberControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.RedirectMemberAccess.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.OnlyReadTemplate.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.PeriodManageControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.AdjustPeriodControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.DataFlowControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.DataStageArchiveAccess.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.DataStageStatusAccess.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.ReportStatusControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.RootEntity.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.RedirectMemberAccess.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.ValidCrossControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.MemberSelfControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.ValidCalAccControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.InnerLogicGenerate.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.PCControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.BLFYControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.InitPeriodControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.InputMemberControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.PermissionControl.getCode());
        inUseType.add(BizStatusAccessFactory.StatusCodeEnum.ICVersionControlAccess.getCode());
        inUseType_area.add(BizStatusAccessFactory.StatusCodeEnum.ICVersionControlAccess.getCode());
        adjustCheckType.add(BizStatusAccessFactory.StatusCodeEnum.RootEntity.getCode());
        adjustCheckType.add(BizStatusAccessFactory.StatusCodeEnum.AdjustMemberSelfControl.getCode());
        adjustCheckType.add(BizStatusAccessFactory.StatusCodeEnum.ValidCalAccControl.getCode());
    }
}

