/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.style.adjust;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.sql.ISqlLazyFilter;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MemberGroupKey;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.sql.util.TypeConversionUtils;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.CurrencyTool;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.business.util.ProcessUtils;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.report.style.DataPermService;
import kd.fi.bcm.formplugin.report.style.adjust.SortMedal;
import kd.fi.bcm.formplugin.report.util.ReportPeriodUtil;
import kd.fi.bcm.formplugin.template.util.TemplateFloatUtil;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.MDDataHandleService;
import kd.fi.bcm.spread.model.dao.Tuple;
import net.sourceforge.pinyin4j.PinyinHelper;

public class FloatDataProvider {
    public static final String unleafsign = "unleaf";
    public static Map<String, String> bps = new HashMap<String, String>(16);

    public static List<Row> getResultRowByArea(Map<String, MDResultSet> setmap, String area) {
        Object value;
        Row row;
        MDResultSet set = setmap.get(area);
        ArrayList<Row> rows = new ArrayList<Row>(10);
        if (set != null) {
            while (set.next()) {
                row = set.getRow();
                value = row.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (value == null) continue;
                rows.add(set.getRow());
            }
        }
        if ((set = setmap.get(area + unleafsign)) != null) {
            while (set.next()) {
                row = set.getRow();
                value = row.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (value == null) continue;
                rows.add(set.getRow());
            }
        }
        return rows;
    }

    public static List<Row> getResultRowByArea(TemplateModel template, SpreadManager spread, Map<String, MDResultSet> setmap, PositionInfo positionInfo, BasePointInfo basePointInfo, HashMap<String, DataTypeAcctCacheInfo> dataTypeMap) {
        Set floatDims;
        MDResultSet set = setmap.get(basePointInfo.getOriginalDynaRange());
        ArrayList<Row> rows = new ArrayList<Row>(10);
        if (set != null) {
            while (set.next()) {
                rows.add(set.getRow());
            }
        }
        if ((set = setmap.get(basePointInfo.getOriginalDynaRange() + unleafsign)) != null) {
            while (set.next()) {
                rows.add(set.getRow());
            }
        }
        if (rows.isEmpty()) {
            return rows;
        }
        if (!basePointInfo.getShowFloatMember(positionInfo).booleanValue()) {
            FloatDataProvider.filterRowsByRowOrCol(rows, basePointInfo, spread);
        }
        ArrayList<Row> newrows = new ArrayList<Row>(10);
        if (positionInfo.isFloatPosition() && positionInfo.getBasePoints() != null && !positionInfo.getBasePoints().isEmpty() && !(floatDims = (Set)SpreadMemUtil.getFixAndFloatDimByPositionInfo((PositionInfo)positionInfo).p2).isEmpty()) {
            Map<String, List<Row>> groupRows = rows.parallelStream().collect(Collectors.groupingBy(d -> {
                StringBuilder sb = new StringBuilder();
                for (String dim : floatDims) {
                    sb.append(d.getString(dim)).append(';');
                }
                return sb.deleteCharAt(sb.length() - 1).toString();
            }));
            groupRows.forEach((k, v) -> {
                boolean isNotAllZero = v.stream().anyMatch(e -> {
                    try {
                        BigDecimal vv = TypeConversionUtils.objToBigDecimal((Object)e.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                        if (vv != null && vv.compareTo(BigDecimal.ZERO) != 0) {
                            for (Map.Entry dt : dataTypeMap.entrySet()) {
                                if (DataTypeEnum.TXT != ((DataTypeAcctCacheInfo)dt.getValue()).getMemberDataTypeEnum((String)dt.getKey(), e.getString((String)dt.getKey()))) continue;
                                return basePointInfo.getShowFloatText(positionInfo, true);
                            }
                            return true;
                        }
                    }
                    catch (Throwable t) {
                        return basePointInfo.getShowFloatText(positionInfo, true);
                    }
                    for (Map.Entry dt : dataTypeMap.entrySet()) {
                        if (DataTypeEnum.TXT != ((DataTypeAcctCacheInfo)dt.getValue()).getMemberDataTypeEnum((String)dt.getKey(), e.getString((String)dt.getKey()))) continue;
                        return basePointInfo.getShowFloatText(positionInfo, true);
                    }
                    return basePointInfo.getShowFloatNullOrZero(positionInfo, true);
                });
                if (isNotAllZero) {
                    newrows.addAll((Collection<Row>)v);
                }
            });
        }
        return newrows;
    }

    private static void filterRowsByRowOrCol(List<Row> rows, BasePointInfo basePointInfo, SpreadManager spread) {
        StringBuilder sb;
        if (basePointInfo.getFixMemberPosition().size() == 0) {
            return;
        }
        ArrayList dims = new ArrayList(10);
        ((List)basePointInfo.getFixMemberPosition().values().iterator().next()).forEach(d -> dims.add(d.getDimension().getNumber()));
        HashSet<String> exitmemkey = new HashSet<String>(10);
        IRelaMembSupplier periodSupplier = ReportSpecialVariableUtil.getPeriodSupplierFromSm((SpreadManager)spread);
        boolean fyIsPV = ReportSpecialVariableUtil.isPageAndViewFilterForFp((SpreadManager)spread, (String)PresetConstant.FY_DIM);
        for (List fix : basePointInfo.getFixMemberPosition().values()) {
            sb = new StringBuilder();
            for (IDimMember mem : fix) {
                String memNumber = mem.getNumber();
                if (DimTypesEnum.CURRENCY.getNumber().equals(mem.getDimension().getNumber()) && CurrencyTool.isTransCurrency((String)memNumber)) {
                    return;
                }
                if (Arrays.asList(PresetConstant.PERIOD_DIM, PresetConstant.FY_DIM).contains(mem.getDimension().getNumber()) && "LastPeriod".equals(memNumber = ReportSpecialVariableUtil.getRealMemNumber((String)mem.getDimension().getNumber(), (String)memNumber, (boolean)fyIsPV, (IRelaMembSupplier)periodSupplier))) {
                    return;
                }
                sb.append(memNumber).append('|');
            }
            exitmemkey.add(sb.toString());
        }
        for (int i = 0; i < rows.size(); ++i) {
            Row r = rows.get(i);
            sb = new StringBuilder();
            for (String dim : dims) {
                sb.append(r.getString(dim)).append('|');
            }
            if (exitmemkey.contains(sb.toString())) continue;
            rows.remove(i);
            --i;
        }
    }

    public static List<Row> sortRowByDim(List<Row> rows, String ... dimnum) {
        Collections.sort(rows, (o1, o2) -> {
            for (String num : dimnum) {
                String mem02;
                String mem01 = o1.getString(num);
                if (mem01.compareTo(mem02 = o2.getString(num)) == 0) continue;
                return mem01.compareTo(mem02);
            }
            return 0;
        });
        return rows;
    }

    public static List<Row> sortRowByConsumer(List<Row> rows, Consumer<Row> sorter, final String ... dimnum) {
        Collections.sort(rows, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                for (String num : dimnum) {
                    String mem02;
                    String mem01 = o1.getString(num);
                    if (mem01.compareTo(mem02 = o2.getString(num)) == 0) continue;
                    return mem01.compareTo(mem02);
                }
                return 0;
            }
        });
        return rows;
    }

    public static Map<String, MDResultSet> queryMDResultSetMapByPageAndView(SpreadManager spread, long modelId, boolean isDirectHoriz, IRelaMembSupplier<String, String> relaMembSupplier, IRelaMembSupplier<String, String> periodSupplier) {
        ReportSpecialVariableUtil.dealSpecialPeriodOrFyForSm((SpreadManager)spread, periodSupplier, null);
        ViewPointDimDomain viewPointDomain = spread.getFilter().getViewPointDomain();
        PageDimDomain pageDomain = spread.getFilter().getPageDomain();
        boolean isViewCurrency = MDDataHandleService.isViewDim((Domain)viewPointDomain, (Domain)pageDomain, (String)"Currency");
        boolean isViewEntity = MDDataHandleService.isViewDim((Domain)viewPointDomain, (Domain)pageDomain, (String)"Entity");
        boolean isViewProcess = MDDataHandleService.isViewDim((Domain)viewPointDomain, (Domain)pageDomain, (String)"Process");
        boolean isView = isViewCurrency && isViewEntity && isViewProcess;
        List viewTuples = MDDataHandleService.genTuples((Domain)viewPointDomain);
        List pageTuples = MDDataHandleService.genTuples((Domain)pageDomain);
        Tuple pv_currencyTuple = MDDataHandleService.getTupleDim((List)viewTuples, (List)pageTuples, (String)DimTypesEnum.CURRENCY.getNumber());
        Tuple pv_entityTuple = MDDataHandleService.getTupleDim((List)viewTuples, (List)pageTuples, (String)DimTypesEnum.ENTITY.getNumber());
        Tuple pv_processTuple = MDDataHandleService.getTupleDim((List)viewTuples, (List)pageTuples, (String)DimTypesEnum.PROCESS.getNumber());
        ArrayList<IDimension> pageAndViewDim = new ArrayList<IDimension>(spread.getFilter().getPageDomain().getDimensions());
        pageAndViewDim.addAll(spread.getFilter().getViewPointDomain().getDimensions());
        HashMap<String, MDResultSet> mdResultSetMap = new HashMap<String, MDResultSet>(16);
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelId);
        boolean isCS = FloatDataProvider.isCS(pageAndViewDim);
        String[] dimNumList = FloatDataProvider.getDimensionNums(modelId);
        for (PositionInfo positionInfo : FloatLogicImpl.sortPositionInfo(spread.getAreaManager().getPostionInfoSet(), isDirectHoriz)) {
            if (positionInfo.getBasePoints() != null && positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo bp : FloatLogicImpl.sortBasePoint(positionInfo.getBasePoints())) {
                MDResultSet set;
                if (isCS && positionInfo.getFloatSummaryWay() == PositionInfo.FloatSummaryWay.NONSUPPORT) continue;
                SQLBuilder sql = new SQLBuilder(modelNumber);
                sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                for (IDimension dim : pageAndViewDim) {
                    String[] values = new String[dim.getMembers().size()];
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        String memnum = ((IDimMember)dim.getMembers().get(i2)).getNumber();
                        if (DimTypesEnum.ENTITY.getNumber().equals(dim.getNumber()) && ((IDimMember)dim.getMembers().get(i2)).getPar_SonNum() != null) {
                            memnum = ((IDimMember)dim.getMembers().get(i2)).getPar_SonNum();
                        }
                        values[i2] = memnum;
                    }
                    if (isView) {
                        if (dim.getNumber().equals("Currency")) {
                            String currencyNumber = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)((OrgRelaMembSupplier)relaMembSupplier).get_mainOrgId().longValue(), (String)((String)pv_processTuple.v), (String)((String)pv_currencyTuple.v), (long)0L, (long)0L).p2;
                            sql.addFilter(dim.getNumber(), new String[]{currencyNumber});
                            continue;
                        }
                        if (dim.getNumber().equals("Entity")) {
                            if (OrgRelaProcessMembPool.isRelaProcess((String)((String)pv_processTuple.v))) {
                                sql.addFilter(dim.getNumber(), new String[]{(String)relaMembSupplier.access(pv_entityTuple.v)});
                                continue;
                            }
                            sql.addFilter(dim.getNumber(), values);
                            continue;
                        }
                        if (dim.getNumber().equals("Process")) {
                            sql.addFilter(dim.getNumber(), new String[]{ProcessUtils.getRealProcess((String)((String)pv_processTuple.v))});
                            continue;
                        }
                        sql.addFilter(dim.getNumber(), values);
                        continue;
                    }
                    sql.addFilter(dim.getNumber(), values);
                }
                if (bp.getShowFloatMember(positionInfo).booleanValue()) {
                    ThreadCache.put((Object)"isShowAllMember", (Object)true);
                }
                FloatDataProvider.addFixMemberFilter(spread, bp, sql, modelId);
                ThreadCache.remove((Object)"isShowAllMember");
                ReportPeriodUtil.addSingleDimSpecialSqlFilter(spread, sql, modelNumber, periodSupplier);
                sql.addSelectField(dimNumList);
                FloatDataProvider.appendOrgRelaMemb(sql, relaMembSupplier);
                FloatDataProvider.rebuildSqlFilter(sql, modelId, relaMembSupplier);
                FloatDataProvider.removePeriod(spread, modelNumber, sql, periodSupplier);
                Pair bpFilter = sql.getFilter(DimTypesEnum.PROCESS.getNumber());
                if (bp.getShowFloatNullOrZero(positionInfo, true).booleanValue() && isViewProcess && bpFilter != null && bpFilter.p2 != null) {
                    for (int i3 = 0; i3 < ((String[])bpFilter.p2).length; ++i3) {
                        if (!bps.containsKey(((String[])bpFilter.p2)[i3])) continue;
                        ((String[])bpFilter.p2)[i3] = bps.get(((String[])bpFilter.p2)[i3]);
                    }
                }
                if (bp.getShowFloatMember(positionInfo).booleanValue()) {
                    ArrayList carsdim = new ArrayList();
                    bp.getBasePointInnerLineInfo().forEach(i -> carsdim.add(i.getDimension().getNumber()));
                    set = OlapServiceHelper.madeUpData((SQLBuilder)sql, carsdim);
                } else {
                    set = OlapServiceHelper.queryData((SQLBuilder)sql);
                }
                mdResultSetMap.put(bp.getOriginalDynaRange(), set);
            }
        }
        return mdResultSetMap;
    }

    private static void removePeriod(SpreadManager spreadManager, String cube, SQLBuilder sql, IRelaMembSupplier<String, String> s) {
        if (s != null && ConfigServiceHelper.getBoolParam((String)cube, (String)"isOnlyShowBefCurPeriod")) {
            boolean isOnlyShowBefCurPeriod;
            boolean bl = isOnlyShowBefCurPeriod = spreadManager.getBook().getSheet(0).getUserObject("isonlyshowbefcurperiod") == null ? false : (Boolean)spreadManager.getBook().getSheet(0).getUserObject("isonlyshowbefcurperiod");
            if (isOnlyShowBefCurPeriod) {
                for (Pair pair : sql.getFilters()) {
                    if (!DimTypesEnum.PERIOD.getNumber().equals(pair.p1)) continue;
                    Set<String> periods = Stream.of((Object[])pair.p2).collect(Collectors.toSet());
                    PeriodUtils.getAfterPeriod((String)cube, (String)((String)s.access((Object)"CurrentPeriod"))).forEach(periods::remove);
                    if (periods.isEmpty()) {
                        sql.setCancel(true);
                    }
                    sql.replaceOrAddFilter(DimTypesEnum.PERIOD.getNumber(), periods.toArray(new String[0]));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void rebuildSqlFilter(SQLBuilder sql, long modelId, IRelaMembSupplier<String, String> relaMembSupplier) {
        Set<Object> oriCurrencyNum = new HashSet(16);
        Set<Object> oriEntityNum = new HashSet(16);
        Set<Object> oriProcessNum = new HashSet(16);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (Pair pair : sql.getFilters()) {
            if ("Currency".equals(pair.p1)) {
                oriCurrencyNum = Stream.of((Object[])pair.p2).collect(Collectors.toSet());
            }
            if ("Entity".equals(pair.p1)) {
                oriEntityNum = Stream.of((Object[])pair.p2).collect(Collectors.toSet());
            }
            if (!"Process".equals(pair.p1)) continue;
            oriProcessNum = Stream.of((Object[])pair.p2).collect(Collectors.toSet());
        }
        sql.setCheckPar_Son(false);
        oriEntityNum.remove("Entity");
        HashSet<String> newCurrencyNums = new HashSet<String>(16);
        HashSet<Object> newEntityNums = new HashSet<Object>(16);
        for (String string : oriCurrencyNum) {
            for (String string2 : oriProcessNum) {
                for (String string3 : oriEntityNum) {
                    String child_parent = (String)relaMembSupplier.access((Object)string3);
                    IDNumberTreeNode entityMemberNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)child_parent);
                    Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)entityMemberNode.getId(), (String)string2, (String)string, (long)0L, (long)0L);
                    String currencyNumber = (String)pair.p2;
                    if (currencyNumber != null) {
                        newCurrencyNums.add(currencyNumber);
                    }
                    if (!((String)pair.p1).contains("_")) continue;
                    newEntityNums.add(pair.p1);
                }
            }
        }
        for (String string : oriEntityNum) {
            void var13_18;
            boolean hasInCP;
            String[] strs = string.split("_");
            if (strs.length == 2) {
                String string4 = strs[1];
            } else {
                String string5 = string;
            }
            if (hasInCP = newEntityNums.stream().anyMatch(arg_0 -> FloatDataProvider.lambda$rebuildSqlFilter$6((String)var13_18, arg_0))) continue;
            newEntityNums.add(var13_18);
        }
        if (!newCurrencyNums.isEmpty()) {
            sql.replaceOrAddFilter("Currency", (String[])newCurrencyNums.stream().toArray(String[]::new));
        }
        sql.replaceOrAddFilter("Entity", (String[])newEntityNums.stream().toArray(String[]::new));
    }

    private static void appendOrgRelaMemb(SQLBuilder sql, IRelaMembSupplier<String, String> relaMembSupplier) {
        AtomicBoolean existRelaProcess = new AtomicBoolean(false);
        ArrayList allProcess = new ArrayList(2);
        sql.getFilters().forEach(e -> {
            if (DimTypesEnum.PROCESS.getNumber().equals(e.p1)) {
                for (String s : (String[])e.p2) {
                    existRelaProcess.set(OrgRelaProcessMembPool.isRelaProcess((String)s));
                    allProcess.add(s);
                }
            }
        });
        if (existRelaProcess.get()) {
            List filters = sql.getFilters();
            boolean isOnlyRelaEntityFilter = allProcess.stream().allMatch(p -> OrgRelaProcessMembPool.isRelaProcess((String)p));
            for (int i = 0; i < filters.size(); ++i) {
                if (!DimTypesEnum.ENTITY.getNumber().equals(((Pair)filters.get((int)i)).p1)) continue;
                String[] p2Array = (String[])((Pair)filters.get((int)i)).p2;
                HashSet orgs = Sets.newHashSetWithExpectedSize((int)p2Array.length);
                for (String s : p2Array) {
                    orgs.add(relaMembSupplier.access((Object)s));
                    if (isOnlyRelaEntityFilter) continue;
                    orgs.add(s);
                }
                Pair filter = Pair.onePair((Object)((Pair)filters.get((int)i)).p1, (Object)orgs.toArray(new String[0]));
                filters.set(i, filter);
            }
        }
    }

    private static boolean isCS(List<IDimension> pageAndViewDim) {
        String processNumber = DimTypesEnum.PROCESS.getNumber();
        for (IDimension dim : pageAndViewDim) {
            if (!processNumber.equals(dim.getNumber())) continue;
            for (IDimMember mem : dim.getMembers()) {
                if (!"EIRpt".equals(mem.getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, String> getBasePointInlineFixMemberFilter(BasePointInfo bp, SQLBuilder sql) {
        HashMap<String, String> dim2MembMap = new HashMap<String, String>(16);
        bp.getBasePointInnerLineInfo().forEach(l -> {
            if (!l.isFloated() && !l.getDynaMembScopes().isEmpty()) {
                dim2MembMap.put(l.getDimension().getNumber(), ((DynaMembScopeInfo)l.getDynaMembScopes().get(0)).getMember().getNumber());
            }
        });
        return dim2MembMap;
    }

    public static String[] getDimensionNums(long modelId) {
        QFilter qf = new QFilter("model.id", "=", (Object)modelId);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"number", (QFilter[])qfs);
        ArrayList list = new ArrayList(10);
        dcs.forEach(p -> list.add(p.getString("number")));
        return list.toArray(new String[0]);
    }

    public static List<Row> filterRow(List<Row> rows, String colname, boolean isInclude, Set<String> valsSet) {
        ArrayList<Row> rs = new ArrayList<Row>(10);
        if (rows.isEmpty()) {
            return rs;
        }
        int colIndex = rows.get(0).getColIndex(colname);
        for (Row row : rows) {
            if (isInclude) {
                if (!valsSet.contains(row.getValue(colIndex))) continue;
                rs.add(row);
                continue;
            }
            if (valsSet.contains(row.getValue(colIndex))) continue;
            rs.add(row);
        }
        return rs;
    }

    public static void dealRowByPack(Map<MemberGroupKey, List<Row>> rowMap, MemberGroupKey key, Cell cell, int moneyColIndex) {
        List<Row> rows = rowMap.get(key);
        if (rows != null && !rows.isEmpty()) {
            Row row = rows.get(0);
            Object value = row.getValue(moneyColIndex);
            Object oldvalue = cell.getValue();
            if (value == null) {
                if (oldvalue != null) {
                    cell.setValue(value);
                }
            } else if (oldvalue == null || !value.toString().equals(oldvalue.toString())) {
                cell.setValue(value);
            }
            cell.setUserObject("floatmd", (Object)true);
            rowMap.remove(key);
        }
    }

    public static Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    public static void setValByPack(List<Row> rows, List<Pair<String, String>> filter, Cell cell) {
        for (Row row : rows) {
            boolean is = true;
            for (Pair<String, String> f : filter) {
                if (row.getString((String)f.p1).equals(f.p2)) continue;
                is = false;
                break;
            }
            if (!is) continue;
            cell.setValue(row.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
            cell.setUserObject("notupdata", (Object)true);
            break;
        }
    }

    public static void addFixMemberFilter(SpreadManager sm, BasePointInfo bs, SQLBuilder sql, long modelId) {
        String[] mcs;
        Map<String, Set<String>> dim2mem = FloatDataProvider.getFixMembers(bs);
        if (dim2mem.isEmpty()) {
            sql.setCancel(true);
            return;
        }
        for (Map.Entry<String, Set<String>> entry : dim2mem.entrySet()) {
            Set<String> value = entry.getValue();
            if ("Currency".equals(entry.getKey()) && "Process".equals(entry.getKey()) || value == null) continue;
            if (value.isEmpty()) {
                sql.setCancel(true);
            }
            sql.addFilter(entry.getKey(), value.toArray(new String[0]));
        }
        Map<String, String> dim2MembMap = FloatDataProvider.getBasePointInlineFixMemberFilter(bs, sql);
        dim2MembMap.entrySet().forEach(e -> sql.addFilter((String)e.getKey(), new String[]{(String)e.getValue()}));
        Map<String, String[]> membScope = FloatDataProvider.getFloatDimMemberFilter(sm, bs, sql, modelId);
        boolean hasCur = bs.getBasePointInnerLineInfo().stream().anyMatch(l -> {
            if (DimTypesEnum.MYCOMPANY.getNumber().equals(l.getDimension().getNumber())) {
                return ThreadCache.get((Object)("hasCur" + l.toScopeString())) != null;
            }
            return false;
        });
        if (membScope.get(DimTypesEnum.MYCOMPANY.getNumber()) != null && (mcs = membScope.get(DimTypesEnum.MYCOMPANY.getNumber())).length == 1 && (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(mcs[0]) || SystemVarsEnum.CURRENT.getNumber().equals(mcs[0]))) {
            membScope.remove(DimTypesEnum.MYCOMPANY.getNumber());
        }
        if (hasCur) {
            membScope.remove(DimTypesEnum.MYCOMPANY.getNumber());
        }
        membScope.entrySet().forEach(e -> {
            if (((String[])e.getValue()).length != 0) {
                sql.addFilter((String)e.getKey(), (String[])e.getValue());
            } else {
                sql.setCancel(true);
            }
        });
    }

    private static Map<String, String[]> getFloatDimMemberFilter(SpreadManager sm, BasePointInfo bs, SQLBuilder sql, long modelId) {
        HashMap<String, String[]> membScope = new HashMap<String, String[]>(16);
        boolean cm033 = ConfigServiceHelper.getBoolParam((Long)modelId, (String)ConfigEnum.CM033.getNumber()) || MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)String.valueOf(modelId));
        DataPermService service = (DataPermService)ThreadCache.get((Object)("DataPermService" + modelId), () -> new DataPermService(modelId));
        if (!cm033) {
            for (Pair filter : sql.getFilters()) {
                HashSet members = Sets.newHashSet((Object[])((Object[])filter.p2));
                Set membs = (Set)ThreadCache.get((Object)("getFloatDimMemberFilter-" + modelId + (String)filter.p1), () -> service.filterNoPermData((String)filter.p1, members, modelId));
                if (!membs.isEmpty()) continue;
                sql.setCancel(true);
            }
        }
        String sceneNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.YEAR.getNumber());
        String periodNum = sm.getFilter().getCommonFilterNum(DimTypesEnum.PERIOD.getNumber());
        long sceneId = sm.getFilter().getCommonFilterId(DimTypesEnum.SCENARIO.getNumber());
        long yearId = sm.getFilter().getCommonFilterId(DimTypesEnum.YEAR.getNumber());
        long periodId = sm.getFilter().getCommonFilterId(DimTypesEnum.PERIOD.getNumber());
        if (0L == sceneId) {
            sceneId = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)sceneNum).getId();
        }
        if (0L == yearId) {
            yearId = MemberReader.findFyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)yearNum).getId();
        }
        if (0L == periodId) {
            periodId = MemberReader.findPeriodMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)periodNum).getId();
        }
        boolean isYPNotInPV = StringUtils.isEmpty((CharSequence)yearNum) || StringUtils.isEmpty((CharSequence)periodNum);
        VersionParam param = new VersionParam(modelId, sceneId, yearId, periodId);
        for (BasePointInnerLineInfo l : bs.getBasePointInnerLineInfo()) {
            if (l.isFloated()) {
                String dimNum = l.getDimension().getNumber();
                if ("InternalCompany".equals(dimNum) && !ThreadCache.exists((Object)"isShowAllMember")) {
                    sql.addLazyFilter(dimNum, (ISqlLazyFilter & Serializable)member -> {
                        Set numbers = (Set)ThreadCache.get((Object)("float-lazy-filter" + l.toScopeString()), () -> {
                            Set<String> members = isYPNotInPV ? TemplateFloatUtil.getNumbersByInnerInfo(l, modelId) : TemplateFloatUtil.getNumbersByInnerInfo_All(param, l, modelId);
                            if (!cm033 && service != null) {
                                members = service.filterNoPermData(dimNum, members, modelId);
                            }
                            return members;
                        });
                        return numbers != null && numbers.contains(member);
                    });
                    continue;
                }
                String[] ns = (String[])ThreadCache.get((Object)("fdp.gfdf" + l.toScopeString()), () -> {
                    Set<String> numbers = isYPNotInPV ? TemplateFloatUtil.getNumbersByInnerInfo(l, modelId) : TemplateFloatUtil.getNumbersByInnerInfo_All(param, l, modelId);
                    if (numbers != null) {
                        if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                            Set<Long> orgIds = TemplateFloatUtil.getIdsByInnerInfo(l, modelId);
                            numbers = FloatDataProvider.filterOrgMergeStruct(sql, modelId, orgIds, numbers);
                        }
                        if (!numbers.isEmpty()) {
                            if ("Entity".equals(dimNum)) {
                                List<String> rateEntityNums = FloatDataProvider.getRateEntityNums(modelId);
                                Iterator<String> iterator = numbers.iterator();
                                while (iterator.hasNext()) {
                                    if (!rateEntityNums.contains(iterator.next())) continue;
                                    iterator.remove();
                                }
                            }
                            if (!cm033 && service != null) {
                                numbers = service.filterNoPermData(dimNum, numbers, modelId);
                            }
                            if (DimTypesEnum.MYCOMPANY.getNumber().equals(dimNum) && numbers.contains(SystemVarsEnum.RELATE_ENTITY.getNumber())) {
                                ThreadCache.put((Object)("hasCur" + l.toScopeString()), (Object)true);
                            }
                        }
                        return numbers.toArray(new String[0]);
                    }
                    return null;
                });
                if (ns != null && ns.length != 0) {
                    membScope.put(dimNum, ns);
                    continue;
                }
                sql.setCancel(true);
                continue;
            }
            if (cm033) continue;
            List membScopes = l.getDynaMembScopes();
            if (cm033 || membScopes.isEmpty()) continue;
            String dimNum = l.getDimension().getNumber();
            HashSet<String> members = new HashSet<String>(16);
            members.add(((DynaMembScopeInfo)membScopes.get(0)).getMember().getNumber());
            Set<Object> membs = new HashSet(1);
            if (service != null) {
                membs = service.filterNoPermData(dimNum, members, modelId);
            }
            if (!membs.isEmpty()) continue;
            sql.setCancel(true);
        }
        return membScope;
    }

    private static Set<String> filterOrgMergeStruct(SQLBuilder sql, long modelId, Set<Long> orgIds, Set<String> numbers) {
        Predicate<Pair> isInCommonDomain = pair -> pair != null && pair.p2 != null && ((String[])pair.p2).length == 1;
        if (!(isInCommonDomain.test(sql.getFilter(DimTypesEnum.SCENARIO.getNumber())) && isInCommonDomain.test(sql.getFilter(DimTypesEnum.YEAR.getNumber())) && isInCommonDomain.test(sql.getFilter(DimTypesEnum.PERIOD.getNumber())))) {
            return numbers;
        }
        Collection allOrgs = MemberReader.getAllNodeByDimNum((String)DimTypesEnum.ENTITY.getNumber(), (String)sql.getCubecatalog());
        Recorder recorder = new Recorder(orgIds);
        Collection areaOrgs = allOrgs.stream().filter(o -> ((Set)recorder.getRecord()).contains(o.getId())).collect(Collectors.toSet());
        DynamicObjectCollection orgTrees = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_entitymembertree"), null);
        for (IDNumberTreeNode areaOrg : areaOrgs) {
            DynamicObject dy = orgTrees.addNew();
            dy.set("id", (Object)areaOrg.getId());
            dy.set("number", (Object)areaOrg.getNumber());
        }
        long scenario = MemberReader.findMemberByNumber((String)sql.getCubecatalog(), (String)DimTypesEnum.SCENARIO.getNumber(), (String)((String[])sql.getFilter((String)DimTypesEnum.SCENARIO.getNumber()).p2)[0]).getId();
        long year = MemberReader.findMemberByNumber((String)sql.getCubecatalog(), (String)DimTypesEnum.YEAR.getNumber(), (String)((String[])sql.getFilter((String)DimTypesEnum.YEAR.getNumber()).p2)[0]).getId();
        long period = MemberReader.findMemberByNumber((String)sql.getCubecatalog(), (String)DimTypesEnum.PERIOD.getNumber(), (String)((String[])sql.getFilter((String)DimTypesEnum.PERIOD.getNumber()).p2)[0]).getId();
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, scenario, year, period);
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)orgTrees);
        OrgServiceHelper.dealNoMergeOrgList((DynamicObjectCollection)orgTrees, (Long)param.getModelId(), (Long)scenario, (Long)year, (Long)period);
        return orgTrees.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
    }

    private static List<String> getRateEntityNums(long modelId) {
        QFilter qFilter2;
        ArrayList<String> rateEntityNums = new ArrayList<String>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection eneitys = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number", (QFilter[])new QFilter[]{qFilter, qFilter2 = new QFilter("ISEXCHANGERATE", "=", (Object)Character.valueOf('1'))});
        if (eneitys != null && !eneitys.isEmpty()) {
            for (DynamicObject obj : eneitys) {
                rateEntityNums.add(obj.getString("number"));
            }
        }
        return rateEntityNums;
    }

    private static String getModelNumberById(long cubeId) {
        QFilter qfilter = new QFilter("id", "=", (Object)cubeId);
        DynamicObject md = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter[]{qfilter});
        return md.getString("number");
    }

    public static boolean isIncludeFilterDim(String dimNum) {
        return !PresetConstant.MYCOMPANY_DIM.equals(dimNum) && !PresetConstant.INTERNALCOMPANY_DIM.equals(dimNum);
    }

    private static Map<String, Set<String>> getFixMembers(BasePointInfo bp) {
        Map map = bp.getFixMemberPosition();
        HashMap<String, Set<String>> dimMap = new HashMap<String, Set<String>>(16);
        for (List mems : map.values()) {
            for (IDimMember mem : mems) {
                String oriNumber;
                String dim = mem.getDimension().getNumber();
                HashSet<String> memnums = (HashSet<String>)dimMap.get(dim);
                if (memnums == null) {
                    memnums = new HashSet<String>(16);
                    dimMap.put(dim, memnums);
                }
                memnums.add(mem.getNumber());
                if (!PresetConstant.FY_DIM.equals(dim) || !"LastYear".equals(oriNumber = ((DimMember)mem).getOriNumber())) continue;
                memnums.add(oriNumber);
            }
        }
        return dimMap;
    }

    static {
        bps.put("ERpt", "Rpt");
        bps.put("EIRpt", "IRpt");
        bps.put("ERAdj", "RAdj");
    }

    public static class Sorter {
        protected List<SortSetting> sortSettings;
        protected List<Row> rows;
        protected int floatSize;
        protected BasePointInfo baseInfo;
        protected PositionInfo posInfo;
        protected long modelId;
        protected long schemeId;
        protected SortSetting currentsort;
        Supplier<Integer> sortByer;
        Map<String, Map<String, String>> dim_Num2SimpleNames = new HashMap<String, Map<String, String>>(16);
        Map<String, Map<String, Integer>> dim_Num2Sequences = new HashMap<String, Map<String, Integer>>(16);
        Map<String, Set<String>> baseInfoFloatScope;
        List<String> flineDims = new ArrayList<String>(16);
        List<String> floatAllDim = new ArrayList<String>(16);

        public Sorter(List<SortSetting> dims, List<Row> rows, BasePointInfo baseInfo, long modelNum, Supplier<Integer> sortByer, PositionInfo posInfo) {
            this.sortSettings = dims;
            this.rows = rows;
            int floatSize = 0;
            this.baseInfo = baseInfo;
            this.posInfo = posInfo;
            this.modelId = modelNum;
            this.sortByer = sortByer;
            for (BasePointInnerLineInfo lineInfo : baseInfo.getBasePointInnerLineInfo()) {
                if (lineInfo.isFloated() && !lineInfo.isIshide()) {
                    ++floatSize;
                }
                this.floatAllDim.add(lineInfo.getDimension().getNumber());
                if (!lineInfo.isFloated()) continue;
                this.flineDims.add(lineInfo.getDimension().getNumber());
            }
            this.baseInfoFloatScope = this.getFloatScope();
            this.floatSize = floatSize;
        }

        public final Map<String, Set<String>> getFloatScope() {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
            for (BasePointInnerLineInfo info : this.baseInfo.getBasePointInnerLineInfo()) {
                ArrayList numbers = new ArrayList();
                List scope = info.getDynaMembScopes();
                if (scope.isEmpty()) {
                    if (!info.isFloated()) continue;
                    String modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
                    IDNumberTreeNode memberNode = MemberReader.findMemberByNumber((String)modelNumber, (String)info.getDimension().getNumber(), (String)info.getDimension().getNumber());
                    Set numberSet = memberNode.getAllChildren().stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
                    numbers.addAll(numberSet);
                    HashSet li = (HashSet)map.get(info.getDimension().getNumber());
                    if (li == null) {
                        li = new HashSet();
                    }
                    li.addAll(numbers);
                    map.put(info.getDimension().getNumber(), li);
                    continue;
                }
                for (DynaMembScopeInfo scinfo : scope) {
                    if (scinfo.isCustom()) {
                        if (SystemVarsEnum.PR_NONE.getNumber().equals(scinfo.getMember().getNumber())) {
                            QFBuilder qb = new QFBuilder("model", "=", (Object)this.modelId);
                            qb.and("dimension.number", "=", (Object)scinfo.getMember().getDimension().getNumber()).and("dpropertyid1", "=", (Object)0).and("dpropertyid2", "=", (Object)0).and("dpropertyid3", "=", (Object)0).and("dpropertyid4", "=", (Object)0).and("dpropertyid5", "=", (Object)0).and("dpropertyid6", "=", (Object)0).and("dpropertyid7", "=", (Object)0).and("dpropertyid8", "=", (Object)0).and("dpropertyid9", "=", (Object)0).and("dpropertyid10", "=", (Object)0);
                            DynamicObjectCollection doc = QueryServiceHelper.query((String)scinfo.getMember().getDimension().getUqCode(), (String)"number", (QFilter[])qb.toArray(), null, (int)-1);
                            numbers.addAll(doc.stream().map(d -> d.getString("number")).collect(Collectors.toSet()));
                            continue;
                        }
                        numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)scinfo.getMember().getNumber(), (int)scinfo.getRangeId(), (String)String.valueOf(this.modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                        continue;
                    }
                    numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)scinfo.getMember().getNumber(), (int)scinfo.getRangeId(), (String)String.valueOf(this.modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                }
                HashSet li = (HashSet)map.get(info.getDimension().getNumber());
                if (li == null) {
                    li = new HashSet();
                }
                li.addAll(numbers);
                map.put(info.getDimension().getNumber(), li);
            }
            return map;
        }

        public List<Row> getRows() {
            return this.rows;
        }

        public void sortByStream() {
            if (this.sortSettings.isEmpty()) {
                return;
            }
            if (!this.sortSettings.isEmpty()) {
                Object sortMedal;
                if (this.sortByer.get().intValue() == PositionInfo.FloatMemDisplayPattern.SIMPLENAME.getIndex()) {
                    for (SortSetting sort : this.sortSettings) {
                        if (sort.dimNum == null) continue;
                        this.dim_Num2SimpleNames.put(sort.dimNum, MemberReader.getMemberNumber2SimpleNameMap((long)this.modelId, (String)sort.dimNum));
                    }
                }
                for (SortSetting sort : this.sortSettings) {
                    if (sort.dimNum == null || sort.sortder != 2) continue;
                    this.dim_Num2Sequences.put(sort.dimNum, DimMemberSortUtil.getMemberNumber2SequenceMap((Long)this.modelId, (String)sort.dimNum, (long)this.schemeId, (Collection)this.baseInfoFloatScope.get(sort.getDimNum())));
                }
                Map<String, List<Row>> groupRows = this.rows.stream().collect(Collectors.groupingBy(r -> {
                    StringBuilder sb = new StringBuilder();
                    for (String dim : this.floatAllDim) {
                        sb.append(r.getString(dim));
                    }
                    return sb.toString();
                }));
                List<SortMedal> groups = new ArrayList<SortMedal>(16);
                for (Map.Entry<String, List<Row>> groupEntry : groupRows.entrySet()) {
                    HashMap<String, String> map = new HashMap<String, String>(this.floatAllDim.size());
                    for (String dim : this.floatAllDim) {
                        map.put(dim, groupEntry.getValue().get(0).getString(dim));
                    }
                    sortMedal = new SortMedal(map, groupEntry.getKey(), groupEntry.getValue());
                    groups.add((SortMedal)sortMedal);
                }
                this.buildFixGroup(groups);
                PinYinComparator pyComparator = new PinYinComparator();
                Comparator<SortMedal> rowComparator = null;
                String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
                sortMedal = this.sortSettings.iterator();
                while (sortMedal.hasNext()) {
                    Comparator keyComparator;
                    List dims;
                    SortSetting sort;
                    this.currentsort = sort = sortMedal.next();
                    if (StringUtils.isNotEmpty((CharSequence)sort.dimNum)) {
                        if (sort.sortder == 2 && !sort.dimNum.equals(DimTypesEnum.AUDITTRIAL.getNumber())) {
                            Function<SortMedal, Integer> function1 = s -> this.dim_Num2Sequences.get(sort.dimNum).get(s.getModalDim2Mem().get(sort.dimNum));
                            Comparator keyComparator2 = (m1, m2) -> {
                                if (m1 == null) {
                                    if (m2 == null) {
                                        return 0;
                                    }
                                    return -1;
                                }
                                if (m2 == null) {
                                    return 1;
                                }
                                return m1.compareTo((Integer)m2);
                            };
                            rowComparator = rowComparator != null ? rowComparator.thenComparing(function1, keyComparator2) : Comparator.comparing(function1, keyComparator2);
                            continue;
                        }
                        Function<SortMedal, String> function = s -> {
                            String name;
                            IDNumberTreeNode member = BcmThreadCache.findMemberByNum((String)modelNum, (String)sort.dimNum, (String)s.getModalDim2Mem().get(sort.dimNum));
                            String string = name = member != null ? member.getName() : "";
                            return this.sortByer.get().intValue() == PositionInfo.FloatMemDisplayPattern.NAME.getIndex() ? name : (this.sortByer.get().intValue() == PositionInfo.FloatMemDisplayPattern.SIMPLENAME.getIndex() ? this.dim_Num2SimpleNames.get(sort.dimNum).get(s.getModalDim2Mem().get(sort.dimNum)) : s.getModalDim2Mem().get(sort.dimNum));
                        };
                        Comparator keyComparator3 = (m1, m2) -> sort.sortder == 0 ? pyComparator.compare((String)m1, (String)m2) : -pyComparator.compare((String)m1, (String)m2);
                        rowComparator = rowComparator != null ? rowComparator.thenComparing(function, keyComparator3) : Comparator.comparing(function, keyComparator3);
                        continue;
                    }
                    this.currentsort = sort;
                    String[] points = this.baseInfo.getDynaRange().split(":");
                    int index = this.baseInfo.getDirect() == 1 ? sort.orderLevel - (ExcelUtils.pos2Y((String)points[1]) - ExcelUtils.pos2Y((String)points[0]) + 1) : sort.orderLevel - (ExcelUtils.pos2X((String)points[1]) - ExcelUtils.pos2X((String)points[0]) + 1);
                    if (index < 0 || (dims = (List)this.baseInfo.getFixMemberPosition().get(index)) == null) continue;
                    StringBuilder fixKey = new StringBuilder();
                    for (IDimMember dimMember : dims) {
                        fixKey.append(dimMember.getNumber());
                    }
                    Function<SortMedal, Variant> function = s -> {
                        if (s.getDim2Row().get(fixKey.toString()) == null) {
                            return Variant.zeroVariant;
                        }
                        Object originalValue = s.getDim2Row().get(fixKey.toString()).getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
                        if (originalValue == null || Variant.zeroVariant.equals(new Variant(originalValue))) {
                            return Variant.zeroVariant;
                        }
                        return new Variant(originalValue);
                    };
                    Comparator dataComparator = (o1, o2) -> this.currentsort.sortder == 0 ? o1.compareTo(o2) : -o1.compareTo(o2);
                    Comparator comparator = keyComparator = sort.sortder == 0 ? (o1, o2) -> dataComparator.compare(o1, o2) : Comparator.reverseOrder();
                    if (rowComparator != null) {
                        rowComparator = rowComparator.thenComparing(function, keyComparator);
                        continue;
                    }
                    rowComparator = Comparator.comparing(function, keyComparator);
                }
                if (rowComparator != null) {
                    groups.sort(rowComparator);
                }
                if (!"0".equals(ThreadCache.get((Object)"isTop"))) {
                    groups = this.topsort(groups);
                }
                ArrayList<Row> endRows = new ArrayList<Row>(16);
                for (SortMedal group : groups) {
                    endRows.addAll(group.getGroup());
                }
                this.rows = endRows;
            }
        }

        private void buildFixGroup(List<SortMedal> groups) {
            for (SortMedal sortMedal : groups) {
                sortMedal.buildDim2Group(this.baseInfo);
            }
        }

        private List<SortMedal> topsort(List<SortMedal> groups) {
            for (SortSetting sort : this.sortSettings) {
                if (sort.top == 0) continue;
                return groups.stream().limit(Math.abs(sort.top)).collect(Collectors.toList());
            }
            return groups;
        }

        public long getSchemeId() {
            return this.schemeId;
        }

        public void setSchemeId(long schemeId) {
            this.schemeId = schemeId;
        }
    }

    public static class PinYinComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return PinYinComparator.ToPinYinString(o1).compareTo(PinYinComparator.ToPinYinString(o2));
        }

        protected static String ToPinYinString(String str) {
            StringBuilder sb = new StringBuilder();
            String[] arr = null;
            for (int i = 0; i < str.length(); ++i) {
                arr = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i));
                if (arr != null && arr.length > 0) {
                    for (String string : arr) {
                        sb.append(string);
                    }
                    continue;
                }
                if (arr != null) continue;
                sb.append(str.charAt(i));
            }
            return sb.toString();
        }
    }

    public static class SortSetting {
        protected int top;
        protected int orderLevel;
        protected int sortder;
        protected String dimNum;

        public SortSetting(int top, int orderLevel, int sortder, String dim) {
            this.top = top;
            this.orderLevel = orderLevel;
            this.sortder = sortder;
            this.dimNum = dim;
        }

        public SortSetting(int top, int sortder, String dim) {
            this.top = top;
            this.sortder = sortder;
            this.dimNum = dim;
        }

        public int getSortder() {
            return this.sortder;
        }

        public int getTop() {
            return this.top;
        }

        public String getDimNum() {
            return this.dimNum;
        }

        public int getOrderLevel() {
            return this.orderLevel;
        }
    }
}

