/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.excel.ApiResponseModel;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.DefaultPageDimSettingUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.report.util.DataCollectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.util.DataCollectUtils;
import org.apache.commons.collections.CollectionUtils;

public class DataCollectCheckUtils {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DataCollectCheckUtils.class);
    private static Set<String> excludeDims = Sets.newHashSet((Object[])new String[]{"bcm_entitymembertree", "bcm_fymembertree", "bcm_periodmembertree", "bcm_scenemembertree"});

    public static ApiResponseModel checkOrgVersion(Long modelId, Long scenarioId, Long yearId, Long periodId, Multimap<Long, Long> dataCollectRowsByOrg) {
        ApiResponseModel result = DataCollectCheckUtils.isEmptySelect(dataCollectRowsByOrg);
        if (!result.isSuccess()) {
            return result;
        }
        if (!MergeControlHelper.isQuoteScene((Long)modelId, (Long)scenarioId)) {
            return new ApiResponseModel();
        }
        Set versionOrgs = MergeControlHelper.getAllVersionedOrgs((Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId);
        ArrayList<String> cantOrgs = new ArrayList<String>(16);
        ArrayList orgIds = new ArrayList(dataCollectRowsByOrg.keySet());
        for (Long orgId : orgIds) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String orgNum = entity.getNumber();
            if (versionOrgs.contains(orgNum)) continue;
            cantOrgs.add(orgNum);
            dataCollectRowsByOrg.removeAll((Object)orgId);
        }
        if (cantOrgs.size() > 0) {
            result.setBackData((Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\u5316\u60c5\u666f\u4e0b, \u672a\u6267\u884c\u7248\u672c\u5316\u7684\u7ec4\u7ec7 %s \u4e0d\u53ef\u516c\u5f0f\u53d6\u6570\u3002", (String)"DataCollectCheckUtils_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", cantOrgs)));
        }
        if (dataCollectRowsByOrg.size() == 0) {
            result.setSuccess(false);
        }
        return result;
    }

    public static ApiResponseModel checkBookClose(String modelNum, String scenarioNum, String yearNum, String perionNum, Multimap<Long, Long> dataCollectRowsByOrg) {
        ApiResponseModel result = DataCollectCheckUtils.isEmptySelect(dataCollectRowsByOrg);
        if (!result.isSuccess()) {
            return result;
        }
        HashMap<String, Long> orgNum2Id = new HashMap<String, Long>(16);
        Set orgSet = dataCollectRowsByOrg.keySet();
        for (Long orgId : orgSet) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId);
            orgNum2Id.put(entity.getNumber(), orgId);
        }
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Map dimMemMapByNum = DataCollectUtils.getDimMemMapByNum((Long)modelId, orgNum2Id.keySet(), (String)"Entity");
        HashMultimap asstmember2bcms = HashMultimap.create();
        dimMemMapByNum.forEach((k, v) -> asstmember2bcms.put(v, k));
        List<String> cantOrgs = null;
        try {
            cantOrgs = DataCollectCheckUtils.filterGlBookClosingOrg(modelId, scenarioNum, yearNum, perionNum, dimMemMapByNum.values());
        }
        catch (KDBizException e) {
            result.setBackData((Object)e);
        }
        if (!CollectionUtils.isEmpty(cantOrgs)) {
            for (String org : cantOrgs) {
                if (!asstmember2bcms.containsKey((Object)org)) continue;
                for (String asstOrg : asstmember2bcms.get((Object)org)) {
                    dataCollectRowsByOrg.removeAll(orgNum2Id.get(asstOrg));
                }
            }
            result.setBackData((Object)String.format(ResManager.loadKDString((String)"%s \u7ec4\u7ec7\u603b\u8d26\u672a\u7ed3\u8d26, \u4e0d\u6267\u884c\u53d6\u6570\u3002", (String)"DataCollectCheckUtils_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", cantOrgs)));
            if (dataCollectRowsByOrg.size() == 0) {
                result.setSuccess(false);
            }
        }
        return result;
    }

    public static ApiResponseModel check(String modelNum, Long modelId, Long scenarioId, Long yearId, Long periodId, Multimap<Long, Long> dataCollectRowsByOrg, boolean isReCet, Multimap<Long, Long> realSelectRow) {
        log.startWatch();
        ApiResponseModel result = DataCollectCheckUtils.isEmptySelect(dataCollectRowsByOrg);
        if (!result.isSuccess()) {
            return result;
        }
        HashMap<Long, Long> baseOrgIds = new HashMap<Long, Long>(16);
        HashMap<Long, String> orgIdAndNameMap = new HashMap<Long, String>(16);
        HashMap<Long, String> orgIdAndNum = new HashMap<Long, String>(16);
        HashMap<Long, Map<Long, Map<String, String>>> comMemMapsMaps = new HashMap<Long, Map<Long, Map<String, String>>>(16);
        Set orgSet = dataCollectRowsByOrg.keySet();
        ArrayList orgIds = new ArrayList(orgSet);
        for (Long orgId : orgIds) {
            DataCollectCheckUtils.initOrgParams(orgId, modelNum, baseOrgIds, orgIdAndNameMap, orgIdAndNum);
            DataCollectCheckUtils.initTemplateParam(modelNum, modelId, dataCollectRowsByOrg, orgIdAndNum, comMemMapsMaps, orgId);
        }
        try {
            DataCollectCheckUtils.checkPeriodStatus(modelId, scenarioId, yearId, periodId, orgIdAndNum.values());
            DataCollectCheckUtils.checkMcStatus(modelNum, modelId, scenarioId, yearId, periodId, orgIdAndNameMap, baseOrgIds.values());
            DataCollectCheckUtils.checkCollectStatus(modelId, scenarioId, yearId, periodId, dataCollectRowsByOrg);
            DataCollectCheckUtils.checkByReportStatus(modelNum, modelId, scenarioId, yearId, periodId, baseOrgIds, dataCollectRowsByOrg, comMemMapsMaps, isReCet, realSelectRow);
            DataCollectCheckUtils.checkCurrency(modelNum, modelId, scenarioId, yearId, periodId, dataCollectRowsByOrg, baseOrgIds.values(), orgIdAndNameMap);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setBackData((Object)e);
            log.error("datacollect check error :" + e);
        }
        log.info("datacollect check-->spantime");
        return result;
    }

    private static void initTemplateParam(String modelNum, Long modelId, Multimap<Long, Long> dataCollectRowsByOrg, Map<Long, String> orgIdAndNum, Map<Long, Map<Long, Map<String, String>>> comMemMapsMaps, Long orgId) {
        ArrayList<Long> templateIds = new ArrayList<Long>(dataCollectRowsByOrg.get((Object)orgId));
        DataCollectCheckUtils.removeTemplateWithNllDim(templateIds, orgId, modelId, modelNum, dataCollectRowsByOrg);
        Map comMemMaps = kd.fi.bcm.business.util.DataCollectUtil.collectPageSelect((String)modelNum, (String)orgIdAndNum.get(orgId), templateIds);
        comMemMapsMaps.put(orgId, comMemMaps);
    }

    private static ApiResponseModel isEmptySelect(Multimap<Long, Long> dataCollectRowsByOrg) {
        ApiResponseModel reslut = new ApiResponseModel();
        if (dataCollectRowsByOrg.size() == 0) {
            reslut.setSuccess(false);
            reslut.setBackData((Object)ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u7ec4\u7ec7\u6a21\u677f,\u4e0d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\u3002", (String)"DataCollectCheckUtils_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return reslut;
    }

    private static Map<Long, Long> getRightTemplateId(Long modelId, Long yearId, Long periodId, Multimap<Long, Long> dataCollectRowsByOrg) {
        Set templates = dataCollectRowsByOrg.values().stream().distinct().collect(Collectors.toSet());
        return TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, templates);
    }

    private static void initOrgParams(Long orgId, String modelNum, Map<Long, Long> baseOrgIds, Map<Long, String> orgIdAndNameMap, Map<Long, String> orgIdAndNum) {
        IDNumberTreeNode entity = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId);
        Long copyfromId = entity.getCopyfromId();
        Long baseId = copyfromId == 0L ? entity.getId() : copyfromId;
        baseOrgIds.put(orgId, baseId);
        orgIdAndNameMap.put(baseId, entity.getName());
        orgIdAndNum.put(orgId, entity.getNumber());
    }

    private static void checkMcStatus(String modelNum, Long modelId, Long scenarioId, Long yearId, Long periodId, Map<Long, String> orgIdAndNameMap, Collection<Long> baseOrgIds) {
        Map mcStatusMap = McStatus.batchGetMcStatus((Object)modelId, baseOrgIds, (Object)scenarioId, (Object)yearId, (Object)periodId);
        ArrayList<String> orgNameList = new ArrayList<String>(16);
        for (Map.Entry entry : mcStatusMap.entrySet()) {
            if (!((McStatus)entry.getValue()).getFlow().isSubmit()) continue;
            orgNameList.add(orgIdAndNameMap.get(entry.getKey()));
        }
        if (orgNameList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u63d0\u4ea4\u6216\u8005\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u201c\u516c\u5f0f\u53d6\u6570\u201d\u3002", (String)"DataCollectCheckUtils_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", orgNameList)));
        }
    }

    private static void checkPeriodStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<String> orgNums) {
        boolean isEnable = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012");
        if (isEnable) {
            HashSet<String> orgNumSet = new HashSet<String>(orgNums);
            Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)modelId, orgNumSet, (Long)scenarioId, (Long)yearId, (Long)periodId, (String)"datastatus");
            orgNumSet.removeAll(periodOpenOrgSet);
            if (orgNumSet.size() > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u671f\u95f4\u7684\u6570\u636e\u671f\u95f4\u72b6\u6001\u4e3a\u201c\u5df2\u5173\u95ed\u201d\u6216\u201c\u672a\u5f00\u542f\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DataCollectCheckUtils_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", orgNumSet)));
            }
        }
    }

    public static List<String> filterGlBookClosingOrg(Long modelId, String scenario, String year, String period, Collection<String> orgNums) {
        boolean beforeClosingConfig = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM042");
        boolean isMonth = "MRpt".equals(scenario) && year != null && year.startsWith("FY") && period != null && period.startsWith("M_M");
        ArrayList<String> cantOrgNums = new ArrayList<String>();
        if (!beforeClosingConfig && isMonth) {
            String yearNum = year.substring(2);
            String periodNum = period.substring(3);
            Map result = null;
            try {
                result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"GLAccountBookService", (String)"isAccountBookCloseBatch", (Object[])new Object[]{new ArrayList<String>(orgNums), null, yearNum, periodNum});
            }
            catch (Exception e) {
                String mes = ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)10);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u8d26\u63a5\u53e3\u5f02\u5e38, \u8df3\u8fc7\u7ed3\u8d26\u6821\u9a8c : %s", (String)"DataCollectCheckUtils_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), mes));
            }
            for (Map.Entry entry : result.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                cantOrgNums.add((String)entry.getKey());
            }
        }
        return cantOrgNums;
    }

    private static void checkCurrency(String modelNum, Long modelId, Long scenarioId, Long yearId, Long periodId, Multimap<Long, Long> dataCollectRowsByOrg, Collection<Long> baseOrgIds, Map<Long, String> orgIdAndNameMap) {
        Set templateIds = dataCollectRowsByOrg.values().stream().distinct().collect(Collectors.toSet());
        Map orgAndTemplates = DefaultPageDimSettingUtil.getOrgIdAndNotEc((String)modelNum, baseOrgIds, templateIds);
        ArrayList orgNameList = new ArrayList(16);
        HashSet<SimpleVo> orgs = new HashSet<SimpleVo>(orgAndTemplates.size());
        for (Long orgId : orgAndTemplates.keySet()) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            orgs.add(SimpleVo.newOne((IDNumberTreeNode)orgNode));
        }
        Map dataMap = ExchangeQueryHelper.queryOrgRate((Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId, orgs);
        dataMap.forEach((k, v) -> {
            if (((Boolean)v.p1).booleanValue()) {
                orgNameList.add(orgIdAndNameMap.get(k));
            }
        });
        if (orgNameList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u6298\u7b97\u5e01\u4e0d\u80fd\u6267\u884c\u201c\u516c\u5f0f\u53d6\u6570\u201d\u3002", (String)"DataCollectCheckUtils_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", orgNameList)));
        }
    }

    private static void checkByReportStatus(String modelNum, Long modelId, Long scenarioId, Long yearId, Long periodId, Map<Long, Long> baseOrgIds, Multimap<Long, Long> dataCollectRowsByOrg, Map<Long, Map<Long, Map<String, String>>> comMemMapsMaps, boolean isReCet, Multimap<Long, Long> realSelectRow) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("scene", "=", (Object)scenarioId));
        builder.add(new QFilter("fyear", "=", (Object)yearId));
        builder.add(new QFilter("period", "=", (Object)periodId));
        HashSet<Long> orgs = new HashSet<Long>(10);
        HashSet<Long> templates = new HashSet<Long>(10);
        HashMap<String, String> orgAndTem2Cur = new HashMap<String, String>(16);
        for (Long entityId : dataCollectRowsByOrg.keySet()) {
            Collection templateIds = dataCollectRowsByOrg.get((Object)entityId);
            Long baseId = baseOrgIds.get(entityId);
            for (Long templateId : templateIds) {
                orgs.add(baseId);
                templates.add(templateId);
                Map<String, String> orgTempMap = comMemMapsMaps.get(entityId).get(templateId);
                String curNum = "EC";
                if (StringUtil.isEmptyString((String)orgTempMap.get(DimTypesEnum.CURRENCY.getNumber()))) {
                    curNum = orgTempMap.get(DimTypesEnum.CURRENCY.getNumber());
                }
                if ("EC".equals(curNum) || "DC".equals(curNum) || "PC".equals(curNum)) {
                    Pair msg = TransMemberUtil.transOrgAndCurbyOrgId((String)modelNum, (long)entityId, (String)"EIRpt", (String)curNum, (long)0L, (long)0L);
                    curNum = (String)msg.p2;
                }
                orgAndTem2Cur.put(baseId + "|" + templateId, curNum);
            }
        }
        builder.add(new QFilter("entity", "in", orgs));
        builder.add(new QFilter("template", "in", templates));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_reportentity", (String)"entity,template,reportstatus,currency.number", (QFilter[])builder.toArray());
        for (DynamicObject dot : col) {
            String currency;
            String reportstatus = dot.getString("reportstatus");
            if (reportstatus.equals("C") || reportstatus.equals("D")) {
                currency = DataCollectCheckUtils.getCurrencyFromMap(orgAndTem2Cur, dot);
                if (StringUtil.equals((String)dot.getString("currency.number"), (String)currency)) {
                    dataCollectRowsByOrg.remove((Object)baseOrgIds.get(dot.getLong("entity")), (Object)dot.getLong("template"));
                }
            }
            if (isReCet || !reportstatus.equals("B") || realSelectRow.containsEntry((Object)dot.getLong("entity"), (Object)dot.getLong("template"))) continue;
            currency = DataCollectCheckUtils.getCurrencyFromMap(orgAndTem2Cur, dot);
            if (!StringUtil.equals((String)dot.getString("currency.number"), (String)currency)) continue;
            dataCollectRowsByOrg.remove((Object)baseOrgIds.get(dot.getLong("entity")), (Object)dot.getLong("template"));
        }
    }

    private static String getCurrencyFromMap(Map<String, String> orgAndTem2Cur, DynamicObject dot) {
        long entity = dot.getLong("entity");
        long template = dot.getLong("template");
        String currency = orgAndTem2Cur.get(entity + "|" + template);
        return currency;
    }

    private static void removeTemplateWithNllDim(List<Long> templateIds, Long orgid, Long modelId, String modelNum, Multimap<Long, Long> dataCollectRowsByOrg) {
        Iterator<Long> iterator = templateIds.iterator();
        while (iterator.hasNext()) {
            Long next = iterator.next();
            if (!DataCollectCheckUtils.isExistNullDimMemb(next, orgid, modelId, modelNum)) continue;
            dataCollectRowsByOrg.remove((Object)orgid, (Object)next);
            iterator.remove();
        }
    }

    private static boolean isExistNullDimMemb(Long tmpId, Long orgid, Long modelId, String modelNum) {
        int pageselect = DataCollectUtil.getPageSelectNum(modelId, tmpId, orgid);
        Pair pair = (Pair)ThreadCache.get((Object)("pagedimcount" + tmpId), () -> DataCollectCheckUtils.getPageViewCount(tmpId, modelNum));
        if ((Integer)pair.p1 == 0) {
            return false;
        }
        if (pageselect > 0) {
            return (Integer)pair.p1 != pageselect;
        }
        return pair.p2 != pair.p1;
    }

    private static Pair<Integer, Integer> getPageViewCount(Long tmpId, String modelNum) {
        TemplateModel t = ModelDataProvider.getTemplateModel(tmpId);
        if (!t.isSaveByDim()) {
            return Pair.onePair((Object)0, (Object)0);
        }
        String pagedimStr = DataCollectUtil.getTemplatePageDimDefaultMembInfo(t, excludeDims, Maps.newHashMap(), modelNum);
        AtomicInteger count = new AtomicInteger();
        t.getPageDimensionEntries().forEach(p -> {
            if (!excludeDims.contains(p.getDimension().getMemberEntityNumber())) {
                count.getAndIncrement();
            }
        });
        t.getPagePropEntries().forEach(p -> {
            if (!excludeDims.contains(p.getDimension().getMemberEntityNumber())) {
                count.getAndIncrement();
            }
        });
        return Pair.onePair((Object)count.get(), (Object)pagedimStr.split(",").length);
    }

    private static void checkCollectStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, Multimap<Long, Long> dataCollectRowsByOrg) {
        DynamicObject[] dys;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("scenario", "=", (Object)scenarioId);
        qfBuilder.add("fy", "=", (Object)yearId);
        qfBuilder.add("period", "=", (Object)periodId);
        qfBuilder.add("org.id", "in", (Object)dataCollectRowsByOrg.keySet());
        qfBuilder.add("template.id", "in", (Object)dataCollectRowsByOrg.values());
        qfBuilder.add("collectstatus", "in", Arrays.asList(Character.valueOf(DataCollectRecordEnum.EXCUTING.index), Character.valueOf(DataCollectRecordEnum.READY.index)));
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"bcm_datacollect", (String)"org,template,collectstatus", (QFilter[])qfBuilder.toArray())) {
            dataCollectRowsByOrg.remove((Object)dy.getLong("org.id"), (Object)dy.getLong("template.id"));
        }
    }
}

