/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.exception.EDSaveException;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.report.ExtMergeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.ExtDataHandleService;

public class ExtDataMergeUtil {
    private static Map<PositionInfo, EDResultSet> queryExtData(SpreadManager sm, String cube, IRelaMembSupplier<String, String> orgSupplier, boolean keepEntity) {
        List list = ExtDataHandleService.queryExtDataByDataSet((boolean)false, (SpreadManager)sm, (String)cube, (OrgRelaMembSupplier)((OrgRelaMembSupplier)orgSupplier), (boolean)false, (ExtMergeEnum)(keepEntity ? ExtMergeEnum.KEEPENTITY : ExtMergeEnum.UNKEEPENTITY), (int)ExtDataHandleService.getPageSizeSetting((long)MemberReader.findModelIdByNum((String)cube)), (boolean)false);
        HashMap<PositionInfo, EDResultSet> pos2EDResult = new HashMap<PositionInfo, EDResultSet>(16);
        for (ExtDataHandleService.DataModelDataSetInfo ds : list) {
            pos2EDResult.put(ds.positionInfo, ds.edResultSet);
        }
        return pos2EDResult;
    }

    public static void mergeExtData(SpreadManager sm, String showNumber, IRelaMembSupplier<String, String> orgSupplier, boolean keepEntity) {
        Map<PositionInfo, EDResultSet> data = ExtDataMergeUtil.queryExtData(sm, showNumber, orgSupplier, keepEntity);
        HashSet<String> dataModelNumbers = new HashSet<String>(16);
        for (Map.Entry<PositionInfo, EDResultSet> res : data.entrySet()) {
            EDResultSet re = res.getValue();
            if (re.getFetchSize() == 0) continue;
            Map disableExtModels = ExtDataUtil.getAllDisableEXTModel((long)((OrgRelaMembSupplier)orgSupplier).get_modelId());
            PositionInfo posInfo = res.getKey();
            ExtendInfo extendInfo = posInfo.getExtendInfo();
            if (extendInfo == null || disableExtModels.containsKey(extendInfo.getExtModelNumber()) || !dataModelNumbers.add(extendInfo.getExtModelNumber())) continue;
            EDSaveComInfo edSaveComInfo = new EDSaveComInfo(showNumber, extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
            ExtDataMergeUtil.buildSaveInfo(sm, (OrgRelaMembSupplier)orgSupplier, edSaveComInfo, posInfo, re, keepEntity);
            boolean canSave = ExtDataHandleService.checkMergeOrgSave((OrgRelaMembSupplier)((OrgRelaMembSupplier)orgSupplier), (PositionInfo)posInfo);
            if (!canSave) continue;
            edSaveComInfo.setKeepEntity(keepEntity);
            TXHandle th = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    ExtDataServiceHelper.saveData((EDSaveComInfo)edSaveComInfo);
                }
                catch (Exception e) {
                    th.markRollback();
                    throw new EDSaveException((Throwable)e, new ErrorCode("", "Extend Data Error."), new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (th == null) continue;
                if (throwable != null) {
                    try {
                        th.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                th.close();
            }
        }
    }

    private static void buildSaveInfo(SpreadManager sm, OrgRelaMembSupplier orgSupplier, EDSaveComInfo edSaveComInfo, PositionInfo posInfo, EDResultSet re, boolean keepEntity) {
        Map<String, String> mddPVDim = ExtDataMergeUtil.buildSaveFilter((Domain)sm.getFilter().getPageDomain(), edSaveComInfo);
        mddPVDim.putAll(ExtDataMergeUtil.buildSaveFilter((Domain)sm.getFilter().getViewPointDomain(), edSaveComInfo));
        ExtDataHandleService.correctFilter((OrgRelaMembSupplier)orgSupplier, (EDSaveComInfo)edSaveComInfo);
        List mddColDims = posInfo.getExtendInfo().getFloatdims().stream().map(f -> f.getDimension().getNumber()).collect(Collectors.toList());
        List extCols = posInfo.getExtendInfo().getCols().stream().filter(c -> !mddColDims.contains(c)).collect(Collectors.toList());
        int startRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[0]);
        int headerCol = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
        ArrayList<String> headSeqMddCols = new ArrayList<String>(16);
        ArrayList<String> headSeqExtCols = new ArrayList<String>(16);
        for (Cell cell : sm.getBook().getSheet(0).getRow(headerCol)) {
            if (cell.getEXTColNumber().isEmpty()) continue;
            if (mddColDims.contains(cell.getEXTColNumber())) {
                headSeqMddCols.add(cell.getEXTColNumber());
                continue;
            }
            if (!extCols.contains(cell.getEXTColNumber())) continue;
            headSeqExtCols.add(cell.getEXTColNumber());
        }
        if (keepEntity && !headSeqMddCols.contains("Entity")) {
            headSeqMddCols.add("Entity");
        }
        edSaveComInfo.setCols(headSeqExtCols.toArray(new String[0]));
        edSaveComInfo.setDims(headSeqMddCols.toArray(new String[0]));
        re.iteratorRows(r -> {
            Object[] valueRow = new Object[edSaveComInfo.getCols().length];
            int i = 0;
            for (String c : edSaveComInfo.getCols()) {
                valueRow[i] = r.getOriginalValue(c);
                ++i;
            }
            i = 0;
            String[] dimValueRow = new String[edSaveComInfo.getDims().length];
            for (String c : edSaveComInfo.getDims()) {
                dimValueRow[i] = r.getString(c);
                ++i;
            }
            edSaveComInfo.addValue(valueRow, dimValueRow);
        });
    }

    private static Map<String, String> buildSaveFilter(Domain domain, EDSaveComInfo edSaveComInfo) {
        LinkedHashMap<String, String> mddDim = new LinkedHashMap<String, String>(16);
        for (IDimension d : domain.getDimensions()) {
            for (IDimMember m : d.getMembers()) {
                if (ExtDataUtil.fixDims.contains(m.getDimension().getNumber())) {
                    ExtDataMergeUtil.buildFilter(edSaveComInfo, d.getNumber(), m.getNumber());
                    continue;
                }
                mddDim.put(d.getNumber(), m.getNumber());
            }
        }
        return mddDim;
    }

    private static void buildFilter(EDSaveComInfo edSaveComInfo, String dim, String value) {
        if (DimTypesEnum.PROCESS.getNumber().equals(dim)) {
            value = "EIRpt";
        }
        if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dim)) {
            value = "EntityInput";
        }
        edSaveComInfo.addfixedDimension(dim, value);
    }

    public static void clearExtData(SpreadManager sm, String showNumber, IRelaMembSupplier<String, String> orgSupplier) {
        Map disableExtModels = ExtDataUtil.getAllDisableEXTModel((long)((OrgRelaMembSupplier)orgSupplier).get_modelId());
        List extInMergeGroups = ExtDataUtil.getExtInMergeGroups((long)((OrgRelaMembSupplier)orgSupplier).get_modelId());
        for (Map.Entry entry : sm.getAreaManager()) {
            IDNumberTreeNode member;
            PositionInfo posInfo = (PositionInfo)entry.getKey();
            ExtendInfo extendInfo = posInfo.getExtendInfo();
            if (extendInfo == null || disableExtModels.containsKey(extendInfo.getExtModelNumber()) || !(member = MemberReader.findMemberById((long)((OrgRelaMembSupplier)orgSupplier).get_modelId(), (String)"bcm_entitymembertree", (Long)((OrgRelaMembSupplier)orgSupplier).get_mainOrgId())).isLeaf() && extInMergeGroups.contains(extendInfo.getExtGroup())) continue;
            EDSaveComInfo edclearComInfo = new EDSaveComInfo(showNumber, extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
            Map<String, String> mddPVDim = ExtDataMergeUtil.buildSaveFilter((Domain)sm.getFilter().getPageDomain(), edclearComInfo);
            mddPVDim.putAll(ExtDataMergeUtil.buildSaveFilter((Domain)sm.getFilter().getViewPointDomain(), edclearComInfo));
            ExtDataHandleService.correctFilter((OrgRelaMembSupplier)((OrgRelaMembSupplier)orgSupplier), (EDSaveComInfo)edclearComInfo);
            boolean canSave = ExtDataHandleService.checkMergeOrgSave((OrgRelaMembSupplier)((OrgRelaMembSupplier)orgSupplier), (PositionInfo)posInfo);
            if (!canSave) {
                return;
            }
            TXHandle th = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    ExtDataServiceHelper.deleteDataBySaveInfo((EDSaveComInfo)edclearComInfo);
                }
                catch (Exception e) {
                    th.markRollback();
                    throw new EDSaveException((Throwable)e, new ErrorCode("", "Extend Data Error."), new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (th == null) continue;
                if (throwable != null) {
                    try {
                        th.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                th.close();
            }
        }
    }
}

