/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.ReportDataScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.scheme.SimpleIDNumberTreeNode;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.linkreport.LinkReportUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;

public class ReportDataSchemeUtil {
    private static final String REPORTDATASELECTSCHEMECACHE = "rdsscache";

    public static ReportDataSelectScheme getReportDataSelectScheme(SchemeContext schemeContext, String type) {
        long templateId = schemeContext.getTemplateId();
        QFilter filter = new QFilter("model", "=", (Object)schemeContext.getModel()).and("applymenu", "=", (Object)type);
        QFilter tempFilter = new QFilter("template", "=", (Object)templateId);
        String key = String.join((CharSequence)"_", ReportDataSchemeUtil.getPrefix(schemeContext.getModel()), type);
        if (templateId != 0L && QueryServiceHelper.exists((String)"bcm_reportdata_custseting", (QFilter[])new QFilter[]{filter, tempFilter})) {
            key = String.join((CharSequence)"_", ReportDataSchemeUtil.getPrefix(schemeContext.getModel(), templateId), type);
        }
        return ReportDataSchemeUtil.copyReportDataSelectScheme((ReportDataSelectScheme)GlobalCacheServiceHelper.getCommonCache().getOrLoad(key, () -> new ReportDataSelectScheme(schemeContext, type)), schemeContext);
    }

    private static ReportDataSelectScheme copyReportDataSelectScheme(ReportDataSelectScheme cache, SchemeContext schemeContext) {
        ReportDataSelectScheme rdss = new ReportDataSelectScheme();
        rdss.setType(cache.getType());
        rdss.setSchemeContext(schemeContext);
        List dimNums = TemplateUtil.getReportDataDimNums((long)schemeContext.getModel());
        schemeContext.removeIf(dimension -> dimension.isIssys() && !dimNums.contains(dimension.getNumber()));
        rdss.setNames(cache.getNames());
        rdss.setSchemetype(cache.getSchemetype());
        HashMap<String, List<AbstractScheme>> map = new HashMap<String, List<AbstractScheme>>(16);
        cache.getRDataSelectSchemes().forEach((k, v) -> map.put((String)k, new ArrayList(v)));
        rdss.setRDataSelectSchemes(map);
        rdss.setCm(cache.isCm());
        return rdss;
    }

    private static String getPrefix(long modelId) {
        return String.join((CharSequence)"_", REPORTDATASELECTSCHEMECACHE, modelId + "");
    }

    private static String getPrefix(long modelId, long templateId) {
        return String.join((CharSequence)"_", REPORTDATASELECTSCHEMECACHE, templateId + "", modelId + "");
    }

    public static void removeCache(long modelId, long templateId) {
        String key = ReportDataSchemeUtil.getPrefix(modelId);
        if (templateId != 0L) {
            key = ReportDataSchemeUtil.getPrefix(modelId, templateId);
        }
        GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey(key);
    }

    public static void setIDNumberTreeNodeFilter2SpreadFilter(SpreadManager sm, SimpleIDNumberTreeNode member, DynamicObject periodDyo) {
        IDimension dim = ObjectConvertUtils.toIDimension(member);
        IDimMember m = ObjectConvertUtils.toDimMember(member, dim);
        dim.addMember(m);
        if (sm.getFilter().getPageDomain().containsDimension(dim)) {
            if (dim.getNumber().equals(DimTypesEnum.SCENARIO.getNumber()) && periodDyo != null) {
                IDimension pdim = ObjectConvertUtils.toIDimension(periodDyo.getDynamicObject("dimension"));
                IDimMember pm = ObjectConvertUtils.toDimMember(periodDyo, pdim);
                pdim.addMember(pm);
                sm.getFilter().changePageDim(pdim);
            }
            sm.getFilter().changePageDim(dim);
        } else if (sm.getFilter().getFilterDomain().containsDimension(dim)) {
            ((DimMember)m).setId(member.getId().longValue());
            if (member.getParent() != null) {
                ((DimMember)m).setPar_SonNum(member.getParent().getNumber() + "_" + member.getNumber());
            }
            sm.getFilter().changeFilterDim(dim, sm);
            LinkReportUtil.changeRCSysValue(dim, sm);
        }
    }

    public static Map<String, Object> convertDyna2Map(SimpleIDNumberTreeNode member) {
        HashMap<String, Object> cacheItem = new HashMap<String, Object>(16);
        cacheItem.put("id", member.getId());
        cacheItem.put("name", member.getName());
        cacheItem.put("number", member.getNumber());
        cacheItem.put("isleaf", member.isLeaf());
        if (member.getParent() != null) {
            cacheItem.put("parent", ReportDataScheme.queryDynamicObjectById((SimpleIDNumberTreeNode)member.getParent()));
        }
        return cacheItem;
    }
}

