/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.PeriodRelaMembSupplier;
import kd.fi.bcm.business.olap.verify.VerifyResult;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.report.floatreport.AutoFloatWithoutViewHandle;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.ReportDataRefleshService;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.MDDataHandleService;

public class ReportDataUtil {
    public static VerifyResult cleanAllData(long tmpId, Map<String, Pair<Long, String>> commonDIm, Map<String, String> dimMap, OlapSourceEnum type) {
        ReportDataUtil.checkCommonDim(commonDIm);
        long orgId = (Long)commonDIm.get((Object)DimTypesEnum.ENTITY.getNumber()).p1;
        TemplateModel temp = ModelDataProvider.getTemplateModel(tmpId);
        String cube = MemberReader.findModelNumberById((Object)temp.getModelId());
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)temp.getModelId(), (Long)orgId);
        DynamicObject[] records = ReportDataUtil.getReportRecord(commonDIm, cube, orgNode, tmpId);
        VerifyResult error = ReportDataUtil.checkCanDel(records, temp);
        if (!error.isEmpty()) {
            return error;
        }
        SpreadManager spreadModel = ReportDataUtil.getSpreadManager(temp, records);
        OrgRelaMembSupplier orgsup = new OrgRelaMembSupplier(Long.valueOf(orgId), orgNode.getNumber(), Long.valueOf(temp.getModelId()));
        PeriodRelaMembSupplier periodSupplier = new PeriodRelaMembSupplier(cube, (String)commonDIm.get((Object)DimTypesEnum.YEAR.getNumber()).p2, (String)commonDIm.get((Object)DimTypesEnum.PERIOD.getNumber()).p2, (String)commonDIm.get((Object)DimTypesEnum.SCENARIO.getNumber()).p2);
        ReportDataUtil.fixFilterMembers(dimMap, temp, spreadModel, orgNode);
        ReportDataUtil.fixDataToModel(temp, spreadModel, orgNode, cube, (IRelaMembSupplier<String, String>)orgsup, (IRelaMembSupplier<String, String>)periodSupplier);
        ReportDataUtil.clearModelData(spreadModel);
        ThreadCache.put((Object)"mdsave.ose", (Object)type);
        VerifyResult vr = MDDataHandleService.save((SpreadManager)spreadModel, (String)cube, (IRelaMembSupplier)orgsup, null, (IRelaMembSupplier)periodSupplier);
        ThreadCache.remove((Object)"mdsave.ose");
        return vr;
    }

    private static SpreadManager getSpreadManager(TemplateModel temp, DynamicObject[] records) {
        DynamicObject record;
        String data;
        SpreadManager spreadModel = records == null || records.length == 0 ? JsonSerializerUtil.toSpreadManager((String)temp.getRptData()) : (StringUtils.isEmpty((String)(data = (record = records[0]).getString("data"))) ? JsonSerializerUtil.toSpreadManager((String)temp.getRptData()) : JsonSerializerUtil.toSpreadManager((String)data));
        return spreadModel;
    }

    private static void checkCommonDim(Map<String, Pair<Long, String>> commonDIm) {
        if (!(commonDIm.containsKey(DimTypesEnum.ENTITY.getNumber()) && commonDIm.containsKey(DimTypesEnum.SCENARIO.getNumber()) && commonDIm.containsKey(DimTypesEnum.YEAR.getNumber()) && commonDIm.containsKey(DimTypesEnum.PERIOD.getNumber()) && commonDIm.containsKey(DimTypesEnum.CURRENCY.getNumber()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5168\u7ec4\u7ec7\uff0c\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\uff0c\u5e01\u79cd \u53c2\u6570\u3002", (String)"ReportDataUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private static VerifyResult checkCanDel(DynamicObject[] doc, TemplateModel temp) {
        VerifyResult error = new VerifyResult();
        if (temp.getIsOnlyRead()) {
            error.addVerifyMsg(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u4e3a\u53ea\u8bfb\u6216\u67e5\u8be2\u7528\u9014\u7684\u62a5\u8868\uff0c\u4e0d\u53ef\u4fee\u6539\u5f53\u524d\u62a5\u8868\u4efb\u4f55\u5355\u5143\u683c\u7684\u5185\u5bb9\u3002", (String)"ReportDataUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (doc == null || doc.length == 0) {
            return error;
        }
        if (doc.length > 1) {
            error.addVerifyMsg(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u7b14\u62a5\u8868\u7f16\u5236\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ReportDataUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return error;
        }
        DynamicObject record = doc[0];
        if (record != null && !ReportStatusEnum.WEAVING.status().equals(record.getString("reportstatus")) && !ReportStatusEnum.BACK.status().equals(record.getString("reportstatus"))) {
            error.addVerifyMsg(ResManager.loadKDString((String)"\u62a5\u8868\u4e0d\u662f\u7f16\u5236\u4e2d\u6216\u6253\u56de\u72b6\u6001\u4e0d\u5141\u8bb8\u6e05\u9664\u3002", (String)"ReportDataUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return error;
    }

    private static DynamicObject[] getReportRecord(Map<String, Pair<Long, String>> commonDIm, String cube, IDNumberTreeNode orgNode, long tmpId) {
        long curid = (Long)commonDIm.get((Object)DimTypesEnum.CURRENCY.getNumber()).p1;
        String curNum = (String)commonDIm.get((Object)DimTypesEnum.CURRENCY.getNumber()).p2;
        if ("EC".equals(curNum) || "DC".equals(curNum)) {
            curNum = orgNode.getCurrency();
            curid = MemberReader.findCurrencyMemberByNum((String)cube, (String)curNum).getId();
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)MemberReader.findModelIdByNum((String)cube));
        qfBuilder.add("scene", "=", commonDIm.get((Object)DimTypesEnum.SCENARIO.getNumber()).p1);
        qfBuilder.add("fyear", "=", commonDIm.get((Object)DimTypesEnum.YEAR.getNumber()).p1);
        qfBuilder.add("period", "=", commonDIm.get((Object)DimTypesEnum.PERIOD.getNumber()).p1);
        qfBuilder.add("currency", "=", (Object)curid);
        qfBuilder.add("entity", "=", (Object)orgNode.getBaseTreeNode().getId());
        qfBuilder.add("template", "=", (Object)tmpId);
        return BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)"data,reportstatus", (QFilter[])qfBuilder.toArray());
    }

    private static void fixFilterMembers(Map<String, String> dimMap, TemplateModel temp, SpreadManager spreadModel, IDNumberTreeNode orgNode) {
        if (!dimMap.containsKey(DimTypesEnum.ENTITY.getNumber())) {
            dimMap.put(DimTypesEnum.ENTITY.getNumber(), orgNode.getNumber());
        }
        ReportDataUtil.setSpreadFilter(spreadModel, temp, dimMap);
    }

    private static void clearModelData(SpreadManager spreadModel) {
        spreadModel.getBook().getSheet(0).iteratorCells(cell -> {
            if (ReportSpecialVariableUtil.isAllowClearCellVaue((Cell)cell)) {
                cell.setValue(null);
            }
        });
    }

    private static void fixDataToModel(TemplateModel temp, SpreadManager spreadModel, IDNumberTreeNode orgNode, String cube, IRelaMembSupplier<String, String> orgsup, IRelaMembSupplier<String, String> periodSupplier) {
        AutoFloatWithoutViewHandle impl = new AutoFloatWithoutViewHandle(spreadModel, temp);
        impl.setModelId(temp.getModelId());
        impl.setRelaMembSupplier(orgsup);
        AutoFloatWithoutViewHandle.cacheFloatType(spreadModel.isHorizon() == 1);
        impl.autoFloat(true, orgNode.getNumber());
        impl.clearEffectiveThreadCache();
        ThreadCache.remove((Object)"floattype");
        ThreadCache.remove((Object)"floatarea");
        new ReportDataRefleshService().reflesh(spreadModel, cube, orgsup, periodSupplier);
    }

    public static void setSpreadFilter(SpreadManager spm, TemplateModel template, Map<String, String> dimMap) {
        long modelID = template.getModelId();
        String cube = MemberReader.findModelNumberById((Object)modelID);
        FilterView spmFilter = spm.getFilter();
        if (spmFilter == null) {
            Member m;
            String memnum;
            Member m2;
            ViewPointDimDomain view = new ViewPointDimDomain();
            PageDimDomain page = new PageDimDomain();
            IDimension dim = null;
            IDimMember member = null;
            for (ViewPointDimensionEntry v : template.getViewPointDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                if (dimMap.containsKey(v.getDimension().getNumber())) {
                    m2 = new Member();
                    memnum = dimMap.get(v.getDimension().getNumber());
                    m2.setName(MemberReader.findMemberByNumber((String)cube, (String)v.getDimension().getNumber(), (String)memnum).getName());
                    m2.setNumber(memnum);
                    member = ObjectConvertUtils.toDimMember(m2, dim);
                } else {
                    member = ObjectConvertUtils.toDimMember(v.getMember(), dim);
                }
                dim.addMember(member);
                view.addDimension(dim);
            }
            for (ViewPointDimensionEntry v : template.getPageDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                String entityNumber = v.getDimension().getMemberEntityNumber();
                if (dimMap.containsKey(v.getDimension().getNumber())) {
                    m = new Member();
                    String memnum2 = dimMap.get(v.getDimension().getNumber());
                    m.setName(MemberReader.findMemberByNumber((String)cube, (String)v.getDimension().getNumber(), (String)memnum2).getName());
                    m.setNumber(memnum2);
                    member = ObjectConvertUtils.toDimMember(m, dim);
                } else {
                    if (v.getMembers().isEmpty() && "bcm_entitymembertree".equals(entityNumber)) {
                        throw new KDBizException("not find fefind entity number");
                    }
                    m = (Member)v.getMembers().get(0);
                    Object[] obj = ReportDataUtil.getMember(modelID, m, dim);
                    member = (IDimMember)obj[0];
                }
                dim.addMember(member);
                page.addDimension(dim);
            }
            for (ViewPointDimensionEntry v : template.getPagePropEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                if (dimMap.containsKey(v.getDimension().getNumber())) {
                    m2 = new Member();
                    memnum = dimMap.get(v.getDimension().getNumber());
                    m2.setName(MemberReader.findMemberByNumber((String)cube, (String)v.getDimension().getNumber(), (String)memnum).getName());
                    m2.setNumber(memnum);
                    member = ObjectConvertUtils.toDimMember(m2, dim);
                    dim.addMember(member);
                } else {
                    DynamicObjectCollection members = SpreadUtils.queryMemberByMembProperty(v.getCustomProperties(), (List<MembProperty>)v.getAllMembProperties(), v.getDimension());
                    if (members != null && !members.isEmpty()) {
                        m = new Member();
                        m.setName(((DynamicObject)members.get(0)).getString("name"));
                        m.setNumber(((DynamicObject)members.get(0)).getString("number"));
                        member = ObjectConvertUtils.toDimMember(m, dim);
                        dim.addMember(member);
                    }
                }
                page.addDimension(dim);
            }
            spm.setFilter(new FilterView(view, page));
        }
    }

    private static Object[] getMember(long modelId, Member m, IDimension dim) {
        int scope = m.getScope();
        long memberid = m.getId();
        DimMember member = null;
        if (scope == RangeEnum.VALUE_20.getValue() || scope == RangeEnum.VALUE_40.getValue()) {
            QFilter qf = new QFilter("parent", "=", (Object)memberid);
            DynamicObject dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{qf});
            member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("name"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        if (scope == RangeEnum.VALUE_60.getValue()) {
            QFilter qf = new QFilter("id", "=", (Object)memberid);
            DynamicObject dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"parent", (QFilter[])new QFilter[]{qf});
            long parentid = dot.getLong("parent");
            QFilter qf1 = new QFilter("parent", "=", (Object)parentid);
            QFilter qf2 = new QFilter("id", "!=", (Object)memberid);
            dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{qf1, qf2});
            member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        if (scope == RangeEnum.VALUE_90.getValue() || scope == RangeEnum.VALUE_110.getValue()) {
            String pLongNum = BusinessDataServiceHelper.loadSingle((Object)m.getId(), (String)m.getDataEntityNumber(), (String)"longnumber").getString("longnumber");
            DynamicObject dot = QueryServiceHelper.queryOne((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(pLongNum + '!' + "%")).or("longnumber", "=", (Object)pLongNum), new QFilter("model", "=", (Object)modelId), new QFilter("isleaf", "=", (Object)(scope == RangeEnum.VALUE_90.getValue() ? 1 : 0))});
            ArrayList items = new ArrayList();
            new MembRangeItem(m.getDataEntityNumber(), Long.valueOf(m.getId()), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, (Object)modelId).matchItems(c -> items.add(c.number));
            member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
            return new Object[]{member, dot.getLong("id")};
        }
        member = new DimMember(m.getName(), m.getNumber(), m.getName(), dim);
        return new Object[]{member, memberid};
    }
}

