/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class ReportPeriodUtil {
    private static boolean isPageAndViewFilter(String dimNum, TemplateModel tm) {
        return tm.getViewPointDimensionEntries().stream().anyMatch(v -> v.getDimension().getNumber().equals(dimNum)) || tm.getPageDimensionEntries().stream().anyMatch(v -> v.getDimension().getNumber().equals(dimNum)) || tm.getPagePropEntries().stream().anyMatch(v -> v.getDimension().getNumber().equals(dimNum));
    }

    public static void addSingleDimSpecialSqlFilter(SpreadManager sm, SQLBuilder sql, String modelNumber, IRelaMembSupplier<String, String> periodSupplier) {
        boolean hasFy = ReportSpecialVariableUtil.isPageAndViewFilterForFp((SpreadManager)sm, (String)PresetConstant.FY_DIM);
        boolean hasPeriod = ReportSpecialVariableUtil.isPageAndViewFilterForFp((SpreadManager)sm, (String)PresetConstant.PERIOD_DIM);
        if (hasFy && hasPeriod) {
            return;
        }
        HashSet<String> specialFys = new HashSet<String>(16);
        HashSet<Object> specialPeriods = new HashSet<Object>(16);
        if (periodSupplier == null) {
            return;
        }
        String currentYear = periodSupplier.getCurrentYear();
        String currentPeriod = periodSupplier.getCurrentPeriod();
        String currentScenario = periodSupplier.getCurrentScenario();
        AtomicBoolean exitLastPeriod = new AtomicBoolean(false);
        AtomicBoolean exitLastYear = new AtomicBoolean(false);
        HashSet scenarios = new HashSet(16);
        sql.getFilters().stream().forEach(e -> {
            if (PresetConstant.FY_DIM.equals(e.p1)) {
                Arrays.stream((Object[])e.p2).forEach(memNum -> {
                    if ("CurrentYear".equals(memNum)) {
                        specialFys.add(currentYear);
                    } else if ("LastYear".equals(memNum)) {
                        Optional lastYear = PeriodUtils.getLastYear((String)modelNumber, (String)currentYear);
                        if (lastYear.isPresent()) {
                            specialFys.add((String)lastYear.get());
                            exitLastYear.set(true);
                        }
                    } else if (!Arrays.asList("AllYear", "Year").contains(memNum)) {
                        specialFys.add((String)memNum);
                    }
                });
            } else if (PresetConstant.PERIOD_DIM.equals(e.p1)) {
                Arrays.stream((Object[])e.p2).forEach(memNum -> {
                    if ("CurrentPeriod".equals(memNum)) {
                        specialPeriods.add(currentPeriod);
                    } else if ("LastPeriod".equals(memNum)) {
                        exitLastPeriod.set(true);
                    } else {
                        specialPeriods.add(memNum);
                    }
                });
            } else if (PresetConstant.SCENE_DIM.equals(e.p1)) {
                scenarios.addAll(Arrays.asList((Object[])e.p2));
            }
        });
        if (exitLastYear.get() && hasPeriod) {
            List vos = ConfigServiceHelper.getCM056Config((long)MemberReader.findModelIdByNum((String)modelNumber));
            specialPeriods.addAll(vos.stream().filter(e -> e.getCurrentPeriod().equals(currentPeriod) && (scenarios.contains(e.getSceario()) || scenarios.isEmpty())).map(v -> v.getExchangePeriod()).collect(Collectors.toList()));
        }
        if (exitLastPeriod.get()) {
            if (hasFy) {
                specialFys.add(currentYear);
            }
            HashSet<Object> tempFys = new HashSet<Object>(16);
            for (String specialFy : specialFys) {
                Pair yearAndPeriod = PeriodUtils.trans2SpecificPeriodForReport((String)modelNumber, (String)currentScenario, (String)currentPeriod, (String)specialFy, (String)"LastPeriod");
                if (yearAndPeriod.p1 != null && !specialFys.contains(yearAndPeriod.p1)) {
                    tempFys.add(yearAndPeriod.p1);
                }
                if (yearAndPeriod.p2 == null) continue;
                specialPeriods.add(yearAndPeriod.p2);
            }
            if (!tempFys.isEmpty()) {
                specialFys.addAll(tempFys);
            }
        }
        if (!specialFys.isEmpty()) {
            sql.mergeOrAddFilter(PresetConstant.FY_DIM, specialFys);
        }
        if (!specialPeriods.isEmpty()) {
            sql.mergeOrAddFilter(PresetConstant.PERIOD_DIM, specialPeriods);
        }
    }
}

