/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.BcmDLockUtil;
import kd.fi.bcm.business.util.MyTemplateUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKReportType;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.common.enums.report.CheckResultEnum;
import kd.fi.bcm.common.enums.report.ReportType;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import org.apache.commons.collections.CollectionUtils;

public class ReportRecordUtil {
    public static final String STATUS = "Status";
    public static final String MODEL_ID = "ModelId";
    public static final String ENTITY_ID = "EntityId";
    public static final String SCENARIO_ID = "ScenarioId";
    public static final String YEAR_ID = "YearId";
    public static final String PERIOD_ID = "PeriodId";
    public static final String CURRENCY_ID = "CurrencyId";
    public static final String SCHEME_ID = "SchemeId";
    public static final String TEMPLATEREPORTS = "TemplateReports";
    public static final String SKIPCHK = "skipChk";
    public static final String SUCCESS = "success";
    public static final String FAIL = "fail";
    public static final String MESSAGE = "message";
    public static final String TOTALMESSAGE = "totalMessage";
    public static final String SUCCESSREPORTS = "successReports";
    public static final String FAILREPORTS = "failReports";
    public static final String CHECKCHKFAILREPORTS = "checkCHKFailReports";
    public static final String OPNAME = "opName";
    public static final String OPDESCRIPTIONS = "opDescriptions";

    public static Map<String, Object> getReportParamForEPM(long modelId, long fyId, long scenarId, long periodId, long currencyId, long orgId, long schemeId, Map<String, Long> templateReports, boolean skipChk) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put(MODEL_ID, modelId);
        paramMap.put(ENTITY_ID, orgId);
        paramMap.put(SCENARIO_ID, scenarId);
        paramMap.put(YEAR_ID, fyId);
        paramMap.put(PERIOD_ID, periodId);
        paramMap.put(CURRENCY_ID, currencyId);
        paramMap.put(SCHEME_ID, schemeId);
        paramMap.put(TEMPLATEREPORTS, templateReports);
        paramMap.put(SKIPCHK, skipChk);
        return paramMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateCtReportStatus(ReportStatusEnum status, Object[] pks, String result, Map<Pair<Object, Object>, List<DynamicObject>> orgCtReportList) {
        String selectFields = "id,model,cycletabstatus,cycletable, completer,completetime, commitor,committime,firstcommittime,committimes, sendbacker,sendbacktime,sendbacktimes,fyear,period,scene,currency,currency.number,entity,report_entry,report_entry.report,report_entry.template";
        QFilter filter = new QFilter("id", "in", (Object)pks);
        Object[] reports = BusinessDataServiceHelper.load((String)"bcm_cycletablereport", (String)selectFields, (QFilter[])new QFilter[]{filter});
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        for (DynamicObject dynamicObject : reports) {
            boolean flag = false;
            if (ReportStatusEnum.COMPLETE == status) {
                if (CheckResultEnum.SUCCESS.index.equals(result)) {
                    dynamicObject.set("completer", (Object)userId);
                    dynamicObject.set("completetime", (Object)new Date());
                    dynamicObject.set("cycletabstatus", (Object)ReportStatusEnum.COMPLETE.status());
                    flag = true;
                } else if (CheckResultEnum.OTHER.index.equals(result)) {
                    dynamicObject.set("cycletabstatus", (Object)ReportStatusEnum.WEAVING.status());
                }
            } else if (ReportStatusEnum.WEAVING == status) {
                if (!CheckResultEnum.SUCCESS.index.equals(result) && !CheckResultEnum.OTHER.index.equals(result)) return;
                dynamicObject.set("completer", null);
                dynamicObject.set("completetime", null);
                dynamicObject.set("cycletabstatus", (Object)ReportStatusEnum.WEAVING.status());
            } else if (ReportStatusEnum.COMMIT == status) {
                flag = true;
                if (CheckResultEnum.SUCCESS.index.equals(result)) {
                    dynamicObject.set("commitor", (Object)userId);
                    dynamicObject.set("committime", (Object)new Date());
                    if (dynamicObject.get("firstcommittime") == null) {
                        dynamicObject.set("firstcommittime", (Object)new Date());
                    }
                    dynamicObject.set("committimes", (Object)(dynamicObject.getInt("committimes") + 1));
                    dynamicObject.set("cycletabstatus", (Object)status.status());
                }
            } else {
                if (ReportStatusEnum.BACK != status) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5c06\u62a5\u8868\u72b6\u6001\u66f4\u65b0\u4e3a\u201c%s\u201d\u3002", (String)"ReportRecordUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), status.status()));
                if (CheckResultEnum.SUCCESS.index.equals(result)) {
                    dynamicObject.set("sendbacker", (Object)userId);
                    dynamicObject.set("sendbacktime", (Object)new Date());
                    dynamicObject.set("sendbacktimes", (Object)(dynamicObject.getInt("sendbacktimes") + 1));
                    dynamicObject.set("cycletabstatus", (Object)ReportStatusEnum.BACK.status());
                    dynamicObject.set("completer", null);
                    dynamicObject.set("completetime", null);
                } else {
                    if (!CheckResultEnum.OTHER.index.equals(result)) return;
                    dynamicObject.set("completer", null);
                    dynamicObject.set("completetime", null);
                    dynamicObject.set("cycletabstatus", (Object)ReportStatusEnum.WEAVING.status());
                }
            }
            Pair pair = Pair.onePair((Object)dynamicObject.getLong("entity.id"), (Object)dynamicObject.getLong("cycletable.id"));
            if (flag) {
                if (orgCtReportList.isEmpty() || !orgCtReportList.containsKey(pair)) continue;
                ReportRecordUtil.creatReportEntry(dynamicObject, orgCtReportList.get(pair));
                continue;
            }
            if (dynamicObject.getDynamicObjectCollection("report_entry") == null) continue;
            dynamicObject.getDynamicObjectCollection("report_entry").clear();
        }
        if (reports.length <= 0) return;
        BusinessDataServiceHelper.save((IDataEntityType)reports[0].getDynamicObjectType(), (Object[])reports);
    }

    public static List<Long> batchSaveNewCtReportRecords(Map<Pair<Long, Long>, DynamicObject> orgCtDyoMap) {
        ArrayList<Long> reportIds = new ArrayList<Long>(16);
        ArrayList records = new ArrayList(orgCtDyoMap.size());
        Date now = TimeServiceHelper.now();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        orgCtDyoMap.entrySet().forEach(entry -> {
            Pair pair = (Pair)entry.getKey();
            DynamicObject dyo = (DynamicObject)entry.getValue();
            DynamicObject reportObject = ORM.create().newDynamicObject("bcm_cycletablereport");
            reportObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            reportObject.set("modifier", (Object)userId);
            reportObject.set("modifytime", (Object)now);
            reportObject.set("cycletable", pair.p2);
            reportObject.set("model", (Object)dyo.getLong("model"));
            reportObject.set("creator", (Object)userId);
            reportObject.set("createtime", (Object)now);
            reportObject.set("scene", (Object)dyo.getLong("scene"));
            reportObject.set("fyear", (Object)dyo.getLong("fyear"));
            reportObject.set("period", (Object)dyo.getLong("period"));
            reportObject.set("currency", (Object)dyo.getLong("currency"));
            reportObject.set("entity", pair.p1);
            reportObject.set("completer", null);
            reportObject.set("completetime", null);
            reportObject.set("cycletabstatus", (Object)ReportStatusEnum.WEAVING.status());
            records.add(reportObject);
            reportIds.add(reportObject.getLong("id"));
        });
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)records.get(0)).getDataEntityType(), (Object[])records.toArray());
        return reportIds;
    }

    public static List<Long> batchSaveNewCtReportRecords(List<DynamicObject> ctReportDyos, ReportStatusEnum status, Map<Pair<Object, Object>, List<DynamicObject>> orgCtReportList) {
        ArrayList<Long> reportIds = new ArrayList<Long>(16);
        ArrayList records = new ArrayList(ctReportDyos.size());
        Date now = TimeServiceHelper.now();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        ctReportDyos.forEach(dyo -> {
            DynamicObject reportObject = ORM.create().newDynamicObject("bcm_cycletablereport");
            reportObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            reportObject.set("modifier", (Object)userId);
            reportObject.set("modifytime", (Object)now);
            reportObject.set("cycletable", (Object)dyo.getLong("cycletable"));
            reportObject.set("model", (Object)dyo.getLong("model.id"));
            reportObject.set("creator", (Object)userId);
            reportObject.set("createtime", (Object)now);
            reportObject.set("scene", (Object)dyo.getLong("scene.id"));
            reportObject.set("fyear", (Object)dyo.getLong("fyear.id"));
            reportObject.set("period", (Object)dyo.getLong("period.id"));
            reportObject.set("currency", (Object)dyo.getLong("currency.id"));
            Long entityId = QueryMemberDetailsHelper.getBaseMemberId((Long)dyo.getLong("entity.id"), (String)"bcm_entitymembertree");
            reportObject.set("entity", (Object)entityId);
            if (ReportStatusEnum.COMPLETE == status) {
                reportObject.set("completer", (Object)userId);
                reportObject.set("completetime", (Object)new Date());
                Pair pair = Pair.onePair((Object)entityId, (Object)dyo.get("cycletable.id"));
                if (orgCtReportList.containsKey(pair)) {
                    ReportRecordUtil.creatReportEntry(reportObject, (List)orgCtReportList.get(pair));
                }
            } else if (ReportStatusEnum.WEAVING == status) {
                reportObject.set("completer", null);
                reportObject.set("completetime", null);
            } else if (ReportStatusEnum.COMMIT == status) {
                reportObject.set("commitor", (Object)userId);
                reportObject.set("committime", (Object)new Date());
                if (reportObject.get("firstcommittime") == null) {
                    reportObject.set("firstcommittime", (Object)new Date());
                }
                reportObject.set("committimes", (Object)(reportObject.getInt("committimes") + 1));
            } else if (ReportStatusEnum.BACK == status) {
                reportObject.set("sendbacker", (Object)userId);
                reportObject.set("sendbacktime", (Object)new Date());
                reportObject.set("sendbacktimes", (Object)1);
            }
            reportObject.set("cycletabstatus", (Object)status.status());
            records.add(reportObject);
            reportIds.add(reportObject.getLong("id"));
        });
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)records.get(0)).getDataEntityType(), (Object[])records.toArray());
        return reportIds;
    }

    public static void creatReportEntry(DynamicObject reportObject, List<DynamicObject> dynamicObjectList) {
        if (dynamicObjectList.isEmpty()) {
            return;
        }
        DynamicObjectCollection reportEntry = reportObject.getDynamicObjectCollection("report_entry");
        reportEntry.clear();
        dynamicObjectList.forEach(dynamicObject -> {
            DynamicObject dyo = reportEntry.addNew();
            dyo.set("report", (Object)dynamicObject.getLong("id"));
            dyo.set("template", (Object)dynamicObject.getLong("template.id"));
        });
    }

    public static List<Long> batchSaveNewReportRecords(List<Long> templateIds, Object modelId, Object currencyId, Object entityId, Object sceneId, Object yearId, Object periodId, ReportStatusEnum status, boolean isCsl, Object userId) {
        ArrayList<Long> reportIds = new ArrayList<Long>();
        Date now = TimeServiceHelper.now();
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        HashMap preRecords = new HashMap(templateIds.size());
        templateIds.forEach(tmpId -> {
            DynamicObject record = ORM.create().newDynamicObject("bcm_reportentity");
            record.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            record.set("modifier", userId);
            record.set("modifytime", (Object)now);
            record.set("template", tmpId);
            record.set("model", modelId);
            record.set("creator", userId);
            record.set("createtime", (Object)now);
            record.set("scene", sceneId);
            record.set("fyear", yearId);
            record.set("period", periodId);
            record.set("currency", currencyId);
            record.set("entity", entityId);
            record.set("reporttype", (Object)ReportType.NORMAL.index);
            if (ReportStatusEnum.COMPLETE == status) {
                record.set("completer", userId);
                record.set("completetime", (Object)new Date());
            } else if (ReportStatusEnum.WEAVING == status) {
                record.set("completer", null);
                record.set("completetime", null);
            }
            record.set("reportstatus", (Object)status.status());
            TemplateModel templateModel = ModelDataProvider.getTemplateModel(tmpId);
            String spreadJson = templateModel.getRptSpreadJson();
            String spreadSerial = templateModel.getRptData();
            DynamicObject orgTmp = MyTemplateUtil.getOwnOrgTemplate((TemplateModel)templateModel, (long)Long.parseLong(entityId.toString()));
            SpreadManager sm = null;
            if (orgTmp != null) {
                if (!ConfigServiceHelper.getBoolParam((Long)LongUtil.toLong((Object)modelId), (String)"isSupportNewMytemplate")) {
                    spreadJson = orgTmp.getString("spreadjson");
                    spreadSerial = orgTmp.getString("data");
                    if (StringUtils.isEmpty((String)spreadJson) || StringUtils.isEmpty((String)spreadSerial)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u540e\u53f0\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ReportRecordUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
                } else {
                    sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
                    List cells = SpecialCalLogic.loadMyTemplateFormulasAndLocks((SpreadManager)sm, (long)LongUtil.toLong((Object)modelId), (long)tmpId, (long)Long.parseLong(entityId.toString()), (boolean)true);
                    spreadJson = TempFormulaUtil.dealSpreadJson(cells, sm.getBook().getSheet(0).getSheetName(), spreadJson);
                }
                spreadJson = TempFormulaUtil.removeAccFormula(sm, spreadJson);
                spreadSerial = JsonSerializerUtil.toJson((SpreadManager)sm);
            }
            record.set("spreadjson", (Object)spreadJson);
            record.set("data", (Object)spreadSerial);
            if (TemplateServiceHelper.isNotFinTemplate((Object)tmpId)) {
                long id = GlobalIdUtil.genGlobalLongId();
                record.set("nofin", (Object)id);
                ReportServiceHelper.saveNewNofinancialRecords((Object)id, (Object)modelId, (Object)currencyId, (Object)entityId, (Object)yearId, (Object)periodId, (Object)tmpId);
            }
            reportIds.add(record.getLong("id"));
            preRecords.put(tmpId, record);
        });
        BcmDLockUtil.lockReportEntity((Object)modelId, (Object)sceneId, (Object)yearId, (Object)periodId, (Object)currencyId, (Object)entityId, lock -> {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template", (QFilter[])new QFilter[]{QFilter.of((String)"model = ? and scene = ? and fyear = ? and period = ? and currency = ? and entity = ?", (Object[])new Object[]{modelId, sceneId, yearId, periodId, currencyId, entityId}), ReportType.getFilter()});
            if (!doc.isEmpty()) {
                for (DynamicObject obj : doc) {
                    long tid = obj.getLong("template");
                    if (!templateIds.contains(tid)) continue;
                    DynamicObject remove = (DynamicObject)preRecords.remove(tid);
                    if (remove != null) {
                        reportIds.remove(remove.getLong("id"));
                    }
                    reportIds.add(obj.getLong("id"));
                }
            }
            if (!preRecords.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)preRecords.values().iterator().next()).getDataEntityType(), (Object[])preRecords.values().toArray(), (OperateOption)op);
                preRecords.clear();
            }
        });
        if (!preRecords.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u7528\u6237\u5728\u540c\u65f6\u64cd\u4f5c\u7f16\u5236\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ReportRecordUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return reportIds;
    }

    public static List<Long> batchSaveNewReportRecords(List<Long> templateIds, Object modelId, Object currencyId, Object entityId, Object sceneId, Object yearId, Object periodId, ReportStatusEnum status, boolean isCsl) {
        return ReportRecordUtil.batchSaveNewReportRecords(templateIds, modelId, currencyId, entityId, sceneId, yearId, periodId, status, isCsl, RequestContext.get().getUserId());
    }

    public static Map<String, Object> executeReportStatusToEPM(Map<String, Object> param) {
        String srcItemKey = param.get(STATUS).toString();
        long modelId = (Long)param.get(MODEL_ID);
        long entityId = (Long)param.get(ENTITY_ID);
        long scenarioId = (Long)param.get(SCENARIO_ID);
        long yearId = (Long)param.get(YEAR_ID);
        long periodId = (Long)param.get(PERIOD_ID);
        long currencyId = (Long)param.get(CURRENCY_ID);
        long schemeId = (Long)param.get(SCHEME_ID);
        Map templateReports = (Map)param.get(TEMPLATEREPORTS);
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelId);
        DynamicObject scenarioDy = BusinessDataServiceHelper.loadSingle((Object)scenarioId, (String)"bcm_scenemembertree");
        DynamicObject yearDy = BusinessDataServiceHelper.loadSingle((Object)yearId, (String)"bcm_fymembertree");
        DynamicObject periodDy = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"bcm_periodmembertree");
        DynamicObject currencyDy = BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bcm_currencymembertree");
        boolean isEcCurrency = CurrencyEnum.EC.number.equals(currencyDy.getString("number")) || CurrencyEnum.DC.number.equals(currencyDy.getString("number"));
        DynamicObject trueCurrency = OrgCurrencyServiceHelper.getOrgDefaultCurrency((long)modelId, (long)entityId, (String)"DC");
        IDNumberTreeNode treeNode = BcmThreadCache.findNodeById((String)modelNumber, (String)DimTypesEnum.ENTITY.getNumber(), (long)entityId);
        long entity = treeNode.getCopyfromId();
        long orgId = entity == 0L ? entityId : entity;
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        ArrayList<Object> messages = new ArrayList<Object>(templateReports.size());
        ArrayList<Long> successId = new ArrayList<Long>(templateReports.size());
        ArrayList failId = new ArrayList(templateReports.size());
        ReportStatusEnum reportStatus = null;
        Map statusMap = new HashMap();
        ArrayList<Long> reportList = new ArrayList<Long>(templateReports.size());
        ArrayList<Long> templateList = new ArrayList<Long>(templateReports.size());
        ArrayList<Long> notSaveTemplateList = new ArrayList<Long>(templateReports.size());
        List<Long> templateIdList = templateReports.keySet().stream().map(LongUtil::toLong).collect(Collectors.toList());
        if (isEcCurrency) {
            currencyId = trueCurrency.getLong("id");
            currencyDy = trueCurrency;
        } else if (currencyId == trueCurrency.getLong("id")) {
            isEcCurrency = true;
        }
        Map<Long, Long> existReport = ReportRecordUtil.QueryReportRecordByDim(modelId, scenarioId, yearId, periodId, currencyId, orgId, templateIdList);
        HashSet<String> successReports = new HashSet<String>(16);
        HashSet<String> failReports = new HashSet<String>(16);
        HashSet<String> checkCHKFailReports = new HashSet<String>(16);
        for (Map.Entry temp : templateReports.entrySet()) {
            if (!existReport.containsKey(LongUtil.toLong(temp.getKey()))) {
                notSaveTemplateList.add(LongUtil.toLong(temp.getKey()));
                continue;
            }
            reportList.add(existReport.get(LongUtil.toLong(temp.getKey())));
            templateList.add(LongUtil.toLong(temp.getKey()));
        }
        DynamicObjectCollection temps = ReportRecordUtil.getTemplateDyos(modelId, templateIdList);
        ReportStatusEnum statusEnum = ReportStatusEnum.getStatusEnumBy((String)srcItemKey);
        if (!PeriodSettingHelper.checkPeriodStatus((long)modelId, (String)treeNode.getNumber(), (long)scenarioId, (long)yearId, (long)periodId, (String)"datastatus")) {
            messages.add(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportRecordUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            failId.addAll(notSaveTemplateList);
            failId.addAll(templateList);
            failReports.addAll(temps.stream().map(d -> d.getString("number")).collect(Collectors.toSet()));
        } else {
            QFilter filter = new QFilter("id", "in", reportList);
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_reportentity", (String)ReportRecordUtil.getSelector(), (QFilter[])new QFilter[]{filter});
            boolean skipCHK = (Boolean)param.getOrDefault(SKIPCHK, false);
            if (statusEnum == ReportStatusEnum.COMPLETE) {
                if (!skipCHK) {
                    CalContext ctx = new CalContext(modelNumber, treeNode.getNumber(), yearDy.getString("number"), periodDy.getString("number"), scenarioDy.getString("number"), currencyDy.getString("number"));
                    ctx.setProperty("originalOrgId", (Object)entityId);
                    ctx.setProperty("reporttype", (Object)CHKReportType.NORMALREPORT.getSign());
                    if (templates.size() == 1) {
                        String tempNumber = ((DynamicObject)temps.get(0)).getString("number");
                        ctx.setProperty("temp", (Object)tempNumber);
                        ChkCheckServiceHelper.check((ICalContext)ctx);
                    } else {
                        String templateNumbers = temps.stream().map(r -> r.getString("number")).collect(Collectors.joining(","));
                        ctx.setProperty("batchChkTmp", (Object)templateNumbers);
                        ctx.setProperty("selecttemplatelist", (Object)templates);
                        ctx.setProperty("clickCheck", (Object)false);
                        ChkCheckServiceHelper.check((ICalContext)ctx, (boolean)true);
                    }
                }
                HashSet orgIds = new HashSet(10);
                orgIds.add(orgId);
                HashMap<Long, Long> orgCurr = new HashMap<Long, Long>();
                orgCurr.put(orgId, currencyId);
                statusMap = ChkCheckStatusHelper.getChkStatusMap((long)modelId, (Set)orgIds, (long)yearId, (long)scenarioId, (long)periodId, orgCurr, (long)schemeId);
                DynamicObjectCollection excutingRds = ReportServiceHelper.getExcutingRecords(new HashSet<Long>(templateIdList), (Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId, Collections.singleton(orgId));
                Map<String, DynamicObject> excuting2Dys = excutingRds.stream().collect(Collectors.toMap(k -> k.getString("org") + k.getString("template.id"), v -> v));
                ThreadCache.put((Object)"ReportListPlugin.checkIsExcute", excuting2Dys);
                ThreadCache.put((Object)"ReportListPlugin.checkIsExcute_org2_sorgs", (Object)MapInitHelper.ofMap((Object)orgId, (Object)orgId));
            }
            for (DynamicObject template : templates) {
                String status = template.getString("reportstatus");
                Object message = null;
                Map temp = ReportServiceHelper.getMap((DynamicObject)template);
                Long reportId = template.getLong("id");
                switch (statusEnum) {
                    case COMPLETE: {
                        Pair checkresult = ChkCheckStatusHelper.getStatus((String)String.valueOf(schemeId), (String)String.valueOf(orgId), (Long)template.getLong("template.id"), (String)String.valueOf(currencyId), statusMap, (boolean)isEcCurrency);
                        if (((Integer)checkresult.p1).intValue() == CheckResultenum.FAIL.getIndex()) {
                            message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6821\u9a8c\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u6267\u884c\u7f16\u5236\u5b8c\u6210\u64cd\u4f5c\u3002", (String)"ReportRecordUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.getString("template.name"));
                            checkCHKFailReports.add(template.getString("template.number"));
                        } else {
                            message = ReportServiceHelper.verifyCompeteStatus((Map)temp, (String)status, (long)modelId, (String)modelNumber, (DynamicObject)scenarioDy, (DynamicObject)yearDy, (DynamicObject)periodDy, (boolean)true, null);
                        }
                        reportStatus = ReportStatusEnum.COMPLETE;
                        break;
                    }
                    case UNWEAVE: 
                    case WEAVING: {
                        message = ReportServiceHelper.verifyCancelStatus((Map)temp, (String)status, (long)modelId, (String)modelNumber, (DynamicObject)scenarioDy, (DynamicObject)yearDy, (DynamicObject)periodDy, (DynamicObject)currencyDy, (boolean)true, null);
                        reportStatus = ReportStatusEnum.WEAVING;
                        break;
                    }
                    case COMMIT: {
                        message = ReportServiceHelper.verifySubmitStatus((Map)temp, (String)status, (long)modelId, (String)modelNumber, (DynamicObject)scenarioDy, (DynamicObject)yearDy, (DynamicObject)periodDy, (DynamicObject)currencyDy, null, (boolean)true, null);
                        reportStatus = ReportStatusEnum.COMMIT;
                        break;
                    }
                    case BACK: {
                        message = ReportServiceHelper.verifyBackStatus((Map)temp, (String)status, (long)modelId, (String)modelNumber, (DynamicObject)scenarioDy, (DynamicObject)yearDy, (DynamicObject)periodDy, (DynamicObject)currencyDy, (boolean)true, null);
                        reportStatus = ReportStatusEnum.BACK;
                        break;
                    }
                }
                if (!StringUtil.isEmptyString(message)) {
                    messages.add(message);
                    failId.add(reportId);
                    failReports.add(template.getString("template.number"));
                    continue;
                }
                successId.add(reportId);
                successReports.add(template.getString("template.number"));
            }
            try (TXHandle tx = TX.required();){
                try {
                    HashMap<Long, DynamicObject> idDyoMap = new HashMap<Long, DynamicObject>(16);
                    if (CollectionUtils.isNotEmpty(notSaveTemplateList) && CollectionUtils.isNotEmpty((Collection)temps)) {
                        idDyoMap.putAll(temps.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (k1, k2) -> k1)));
                    }
                    for (Long templateId : notSaveTemplateList) {
                        ArrayList<Long> templateIds = new ArrayList<Long>();
                        templateIds.add(templateId);
                        DynamicObject template = (DynamicObject)idDyoMap.get(templateId);
                        if (template == null) continue;
                        if (statusEnum == ReportStatusEnum.COMPLETE) {
                            Pair checkresult = ChkCheckStatusHelper.getStatus((String)String.valueOf(schemeId), (String)String.valueOf(orgId), (Long)templateId, (String)String.valueOf(currencyId), statusMap, (boolean)isEcCurrency);
                            if (((Integer)checkresult.p1).intValue() == CheckResultenum.FAIL.getIndex()) {
                                messages.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6821\u9a8c\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u6267\u884c\u7f16\u5236\u5b8c\u6210\u64cd\u4f5c\u3002", (String)"ReportRecordUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.getString("name")));
                                failId.add(templateId);
                                failReports.add(template.getString("number"));
                                checkCHKFailReports.add(template.getString("number"));
                                continue;
                            }
                            List<Long> savereports = ReportRecordUtil.batchSaveNewReportRecords(templateIds, modelId, currencyId, orgId, scenarioDy.get("id"), yearId, periodId, ReportStatusEnum.WEAVING, false);
                            successId.add(savereports.get(0));
                            reportStatus = ReportStatusEnum.COMPLETE;
                            messages.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d:\u62a5\u8868\u672a\u7f16\u5236\uff0c\u5df2\u81ea\u52a8\u751f\u6210\u62a5\u8868\u5e76\u6267\u884c\u5bf9\u5e94\u64cd\u4f5c\u3002", (String)"ReportRecordUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.get("name")));
                            successReports.add(template.getString("number"));
                            continue;
                        }
                        String message = null;
                        String status = ReportStatusEnum.UNWEAVE.status();
                        HashMap<String, String> temp = new HashMap<String, String>(1);
                        temp.put("template.name", template.getString("name"));
                        switch (statusEnum) {
                            case UNWEAVE: 
                            case WEAVING: {
                                message = ReportServiceHelper.verifyCancelStatus(temp, (String)status, (long)modelId, (String)modelNumber, (DynamicObject)scenarioDy, (DynamicObject)yearDy, (DynamicObject)periodDy, (DynamicObject)currencyDy, (boolean)true, null);
                                reportStatus = ReportStatusEnum.WEAVING;
                                break;
                            }
                            case COMMIT: {
                                message = ReportServiceHelper.verifySubmitStatus(temp, (String)status, (long)modelId, (String)modelNumber, (DynamicObject)scenarioDy, (DynamicObject)yearDy, (DynamicObject)periodDy, (DynamicObject)currencyDy, null, (boolean)true, null);
                                reportStatus = ReportStatusEnum.COMMIT;
                                break;
                            }
                            case BACK: {
                                message = ReportServiceHelper.verifyBackStatus(temp, (String)status, (long)modelId, (String)modelNumber, (DynamicObject)scenarioDy, (DynamicObject)yearDy, (DynamicObject)periodDy, (DynamicObject)currencyDy, (boolean)true, null);
                                reportStatus = ReportStatusEnum.BACK;
                                break;
                            }
                        }
                        if (StringUtil.isEmptyString(message)) continue;
                        messages.add(message);
                        failId.add(templateId);
                        failReports.add(template.getString("number"));
                    }
                    if (!successId.isEmpty()) {
                        ReportServiceHelper.updateReportStatus(reportStatus, (Object[])successId.toArray());
                        DynamicObject[] successRec = new DynamicObject[successId.size()];
                        for (int i = 0; i < successId.size(); ++i) {
                            DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportentity");
                            report.set("id", successId.get(i));
                            successRec[i] = report;
                        }
                        MyTaskStatusHelper.synchronizeTaskStatus((DynamicObject[])successRec, (boolean)false);
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
                }
            }
        }
        ReportRecordUtil.collectOpLogs(statusEnum, temps, yearDy.getString("number"), periodDy.getString("number"), treeNode.getName(), successReports, result);
        result.put(SUCCESS, successId);
        result.put(FAIL, failId);
        result.put(MESSAGE, messages);
        result.put(TOTALMESSAGE, String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u5176\u4e2d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"ReportRecordUtil_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), templateReports.size(), successId.size(), failId.size()));
        result.put(SUCCESSREPORTS, successReports);
        result.put(FAILREPORTS, failReports);
        result.put(CHECKCHKFAILREPORTS, checkCHKFailReports);
        return result;
    }

    public static void collectOpLogs(ReportStatusEnum statusEnum, DynamicObjectCollection temps, String yearNum, String periodNum, String org, Set<String> successReports, Map<String, Object> result) {
        Tuple tuple = ReportStatusEnum.getOperateMessage((ReportStatusEnum)statusEnum);
        if (StringUtils.isEmpty((String)((String)tuple.p1)) || StringUtils.isEmpty((String)((String)tuple.p2)) || StringUtils.isEmpty((String)((String)tuple.p3))) {
            return;
        }
        ArrayList<String> opDescriptions = new ArrayList<String>(16);
        for (DynamicObject temp : temps) {
            String number = temp.getString("number");
            String name = temp.getString("name");
            opDescriptions.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s %5$s\uff0c%6$s", (String)"ReportRecordUtil_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), yearNum, periodNum, org, number, name, successReports.contains(number) ? tuple.p2 : tuple.p3));
        }
        result.put(OPNAME, tuple.p1);
        result.put(OPDESCRIPTIONS, opDescriptions);
    }

    public static void batchWriteLogs(long modelId, Map<String, Object> result, boolean isEPM) {
        try {
            OperationLogUtil.batchWriteOperationLog((String)((String)result.get(OPNAME)), (List)((List)result.get(OPDESCRIPTIONS)), (Long)modelId, (String)"bcm_report_list", (boolean)isEPM);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static DynamicObjectCollection getTemplateDyos(long modelId, List<Long> ids) {
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        filter2.and(new QFilter("id", "in", ids));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name,number,ischeckstatus,uncheckentity", (QFilter[])new QFilter[]{filter2});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            Map<Long, DynamicObject> id2Tmps = query.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            ThreadCache.put((Object)"ReportServiceHelper.verifySubmitStatusAboutLedger", id2Tmps);
        }
        return query;
    }

    private static Map<Long, Long> QueryReportRecordByDim(Long modelId, Long scenarioId, Long yearId, Long periodId, Long currencyId, Long entityId, List<Long> tempIds) {
        QFBuilder qfByDim = new QFBuilder();
        qfByDim.add("model_id", "=", (Object)modelId);
        qfByDim.add("scene_id", "=", (Object)scenarioId);
        qfByDim.add("fyear_id", "=", (Object)yearId);
        qfByDim.add("period_id", "=", (Object)periodId);
        qfByDim.add("currency_id", "=", (Object)currencyId);
        qfByDim.add("entity_id", "=", (Object)entityId);
        qfByDim.add("template_id", "in", tempIds);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template_id", (QFilter[])qfByDim.toArray());
        return result.stream().collect(Collectors.toMap(x -> x.getLong("template_id"), x -> x.getLong("id"), (v1, v2) -> v1));
    }

    public static String getSelector() {
        return "id,template.id,template.number,template.name,model.number,model.id,reportstatus,entity.id,entity.name,entity.number,entity.isleaf,entity.copyfrom,entity,template";
    }

    public static DynamicObject getReportRecordDyo(long templateId, Object modelId, Map<String, Long> filterMap, boolean isCsl) {
        long currencyId = filterMap.get("bcm_currencymembertree");
        long entityId = filterMap.get("bcm_entitymembertree");
        long sceneId = filterMap.get("bcm_scenemembertree");
        long yearId = filterMap.get("bcm_fymembertree");
        long periodId = filterMap.get("bcm_periodmembertree");
        List<Long> ids = ReportRecordUtil.batchSaveNewReportRecords(Collections.singletonList(templateId), modelId, currencyId, entityId, sceneId, yearId, periodId, ReportStatusEnum.WEAVING, isCsl, RequestContext.get().getUserId());
        if (!ids.isEmpty()) {
            return BusinessDataServiceHelper.loadSingle((Object)ids.get(0), (String)"bcm_reportentity");
        }
        return null;
    }
}

