/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.report.ReportType;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.util.GZIPUtils;

public class ReportToVoucherUtil {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportToVoucherUtil.class);

    public Map<String, Object> queryrpt(Map<String, Object> map) {
        this.checkParams(map);
        String orgnumber = (String)map.get("orgnumber");
        String yearnumber = (String)map.get("yearnumber");
        String periodnumber = (String)map.get("periodnumber");
        List entryparams = (List)map.get("entryparams");
        Long modelid = Long.valueOf((String)((Map)((Map)entryparams.get(0)).get("param")).get("modelid"));
        DynamicObject org = this.getOrg(modelid, orgnumber);
        long orgId = org.getLong("id");
        DynamicObject year = this.getYear(modelid, yearnumber);
        long yearId = year.getLong("id");
        HashMap<String, String> dimensionFilter = new HashMap<String, String>(16);
        dimensionFilter.put(DimEntityNumEnum.ENTITY.getNumber(), org.getString("number"));
        dimensionFilter.put(DimEntityNumEnum.YEAR.getNumber(), year.getString("number"));
        Map<Long, String> scenariosMap = this.getScenarios(modelid);
        Map sceneperiods = DimensionServiceHelper.getScenePeriodMap((Long)modelid);
        dimensionFilter.put(DimEntityNumEnum.PROCESS.getNumber(), org.getBoolean("isleaf") ? "IRpt" : "CS");
        dimensionFilter.put(DimEntityNumEnum.AUDITTRIAL.getNumber(), "ATTotal");
        HashSet<Long> tmplids = new HashSet<Long>(entryparams.size());
        for (Map entrymap : entryparams) {
            tmplids.add(Long.valueOf((String)((Map)entrymap.get("param")).get("templateid")));
        }
        List tmpllist = TemplateRangeService.getCompleteTemplateModels(tmplids);
        HashMap tmplMap = new HashMap();
        tmpllist.forEach(tmpl -> tmplMap.put(tmpl.getId(), tmpl));
        HashMap<String, Set<String>> datafilter = new HashMap<String, Set<String>>();
        Map dims = this.getDimensionListByModel(modelid);
        HashMap<String, Map<String, Set<String>>> entrysFilterMap = new HashMap<String, Map<String, Set<String>>>(16);
        HashMap<String, Object> fixEntrysMap = new HashMap<String, Object>();
        HashMap<String, Object> floatEntrysMap = new HashMap<String, Object>();
        List dimensions = DimensionServiceHelper.getDimensionNumListByModel((Object)modelid);
        List<String> allCurrencyNumbers = this.getAllCurrencyNumber(modelid);
        HashMap<String, String> rowAndColfilter = new HashMap<String, String>();
        boolean isSaveByDim = true;
        for (Map entry : entryparams) {
            Map param = (Map)entry.get("param");
            String rownumber = (String)entry.get("rownumber");
            long scenarioId = Long.parseLong((String)param.get("scenarioid"));
            String scenarioNumber = scenariosMap.get(scenarioId);
            String periodnum = this.getCorrectPeriod(modelid, (List)sceneperiods.get(scenarioNumber), periodnumber);
            if (periodnum == null) {
                fixEntrysMap.put(rownumber, null);
                continue;
            }
            String currencynum = (String)entry.get("currencynumber");
            if (!allCurrencyNumbers.contains(currencynum)) {
                fixEntrysMap.put(rownumber, null);
                continue;
            }
            dimensionFilter.put(DimEntityNumEnum.SCENARIO.getNumber(), scenarioNumber);
            dimensionFilter.put(DimEntityNumEnum.PERIOD.getNumber(), periodnum);
            dimensionFilter.put(DimEntityNumEnum.CURRENCY.getNumber(), currencynum);
            Long currentTmpl = Long.valueOf((String)param.get("templateid"));
            TemplateModel currentModel = (TemplateModel)tmplMap.get(currentTmpl);
            String position = (String)param.get("position");
            if (currentModel.isSaveByDim()) {
                Map<String, Object> rowAndColMap = this.getRowAndColDim(currentModel, position, fixEntrysMap, rownumber);
                if (fixEntrysMap.containsKey(rownumber)) {
                    this.setSheetCellValue(currentModel, position, fixEntrysMap, rownumber);
                    continue;
                }
                if (rowAndColMap.get("wantfloatmembersFrom") != null) {
                    this.setFloatMembersRow(currentModel, rowAndColMap, dimensionFilter, dimensions, rownumber, floatEntrysMap);
                    continue;
                }
                Map unwantedDim = (Map)rowAndColMap.get("floatDimension");
                for (String dimension : dimensions) {
                    if (rowAndColMap.get(dimension) == null) continue;
                    rowAndColfilter.put(dimension, (String)rowAndColMap.get(dimension));
                }
                HashMap<String, Set<String>> allfilter = new HashMap<String, Set<String>>();
                dimensionFilter.forEach((k, v) -> {
                    HashSet<String> set = new HashSet<String>();
                    set.add((String)v);
                    allfilter.put((String)k, (Set<String>)set);
                });
                rowAndColfilter.forEach((k, v) -> {
                    HashSet<String> set = new HashSet<String>();
                    set.add((String)v);
                    allfilter.put((String)k, (Set<String>)set);
                });
                this.setOtherNeedDimFilter(currentModel, allfilter, unwantedDim);
                entrysFilterMap.put(rownumber, allfilter);
                this.setDataFilter(allfilter, datafilter, dims);
                rowAndColfilter.clear();
                continue;
            }
            isSaveByDim = false;
            this.queryCellValueFormReportRecord(modelid, orgId, yearId, scenarioId, periodnum, currencynum, currentModel, position, fixEntrysMap, rownumber);
        }
        Map<List<String>, BigDecimal> olapresult = this.queryOlap(modelid, datafilter, dimensions);
        Map<String, Object> entryrows = this.setReturnOlapData(olapresult, entrysFilterMap, dimensions);
        QFBuilder builder = new QFBuilder("model", "=", (Object)modelid);
        builder.add("isfloat", "=", (Object)Character.valueOf('1'));
        Map<String, String> dimMap = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"dimension.name,dimensionmap.name", (QFilter[])builder.toArray()).stream().collect(Collectors.toMap(di -> di.getString("dimension.name"), di -> di.getString("dimensionmap.name"), (e1, e2) -> e2));
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("dimensions", isSaveByDim ? dims : Collections.EMPTY_MAP);
        result.put("entryrows", entryrows);
        result.put("entryfixrows", fixEntrysMap);
        result.put("entryfloatrows", floatEntrysMap);
        result.put("dimMap", dimMap);
        WatchLoggerUtil.debug((WatchLogger)logger, (String)String.format("DebugInfo-queryrpt:\n%s", ((Object)result).toString()));
        return result;
    }

    private void checkParams(Map<String, Object> map) {
        if (map.get("orgnumber") == null || map.get("yearnumber") == null || map.get("periodnumber") == null || map.get("entryparams") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6309\u62a5\u8868\u751f\u6210\u51ed\u8bc1\u65f6\uff0c\u7f3a\u5c11\u5fc5\u987b\u7684\u53c2\u6570\u3002", (String)"ReportToVoucherUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setFloatMembersRow(TemplateModel currentModel, Map<String, Object> rowAndColMap, Map<String, String> dimensionFilter, List<String> dimensions, String rownumber, Map<String, Object> floatEntrysMap) {
        Map unwantedDim = (Map)rowAndColMap.get("floatDimension");
        HashMap<String, Set> rowAndColfilter = new HashMap<String, Set>();
        for (String dimension : dimensions) {
            if (rowAndColMap.get(dimension) == null) continue;
            rowAndColfilter.put(dimension, (Set)rowAndColMap.get(dimension));
        }
        HashMap<String, Set<String>> allfilter = new HashMap<String, Set<String>>();
        dimensionFilter.forEach((k, v) -> {
            HashSet<String> memberset = new HashSet<String>();
            memberset.add((String)v);
            allfilter.put((String)k, (Set<String>)memberset);
        });
        rowAndColfilter.forEach((k, v) -> allfilter.put((String)k, (Set<String>)v));
        this.setOtherDimFilter(currentModel, allfilter, unwantedDim);
        Map<String, Set<String>> olapresult = this.queryOlapMembers(currentModel.getModelId(), allfilter, (String)rowAndColMap.get("wantfloatmembersFrom"));
        floatEntrysMap.put(rownumber, olapresult);
    }

    private Map<String, Set<String>> queryOlapMembers(Long modelid, Map<String, Set<String>> datafilter, String floatdimension) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        if (datafilter.size() == 0) {
            return result;
        }
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelid);
        SQLBuilder sql = new SQLBuilder(modelNumber);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        String[] selectfield = new String[]{floatdimension};
        sql.addSelectField(selectfield);
        datafilter.forEach((k, v) -> sql.addFilter(k, v.toArray(new String[0])));
        MDResultSet resultset = OlapServiceHelper.queryData((SQLBuilder)sql);
        if (resultset != null) {
            while (resultset.next()) {
                Set<String> members = result.get(floatdimension) == null ? new HashSet() : (Set)result.get(floatdimension);
                members.add(resultset.getString(floatdimension));
                result.put(floatdimension, members);
            }
        }
        return result;
    }

    private void setOtherDimFilter(TemplateModel currentModel, Map<String, Set<String>> allfilter, Map<String, Set<String>> unwantedDim) {
        List listpage = currentModel.getPageDimensionEntries();
        List viewpage = currentModel.getViewPointDimensionEntries();
        HashMap pageAndViewDim = new HashMap();
        listpage.forEach(dimension -> {
            if (dimension.getMembers().size() > 0) {
                pageAndViewDim.put(dimension.getDimension().getNumber(), ((Member)dimension.getMembers().get(0)).getNumber());
            }
        });
        viewpage.forEach(dimension -> pageAndViewDim.put(dimension.getDimension().getNumber(), dimension.getMember().getNumber()));
        for (Map.Entry entry : pageAndViewDim.entrySet()) {
            String dim = (String)entry.getKey();
            if (allfilter.containsKey(dim) || unwantedDim != null && unwantedDim.containsKey(dim)) continue;
            HashSet memberset = new HashSet();
            memberset.add(entry.getValue());
            allfilter.put(dim, memberset);
        }
        if (unwantedDim != null) {
            for (Map.Entry<Object, Object> entry : unwantedDim.entrySet()) {
                if (entry.getValue() == null || ((Set)entry.getValue()).size() <= 0) continue;
                allfilter.put((String)entry.getKey(), (Set<String>)entry.getValue());
            }
        }
    }

    private void setSheetCellValue(TemplateModel currentModel, String position, Map<String, Object> fixEntrysMap, String rownumber) {
        String spreadJson = currentModel.getSpreadJson();
        spreadJson = spreadJson.substring(6);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadJson)));
        JSONObject object = JSONObject.parseObject((String)ssjson);
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject sheet = (JSONObject)sheets.get((Object)currentModel.getName());
        JSONObject data = (JSONObject)sheet.get((Object)"data");
        JSONObject dataTable = (JSONObject)data.get((Object)"dataTable");
        Point cellpoint = ExcelUtils.pos2Point((String)position);
        Object cellValue = ((JSONObject)((JSONObject)dataTable.get((Object)(cellpoint.y + ""))).get((Object)(cellpoint.x + ""))).get((Object)"value");
        fixEntrysMap.put(rownumber, cellValue);
    }

    private Map<String, Object> setReturnOlapData(Map<List<String>, BigDecimal> result, Map<String, Map<String, Set<String>>> entrysFilterMap, List<String> dimensions) {
        HashMap<String, Object> entryrows = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, Set<String>>> mapEntry : entrysFilterMap.entrySet()) {
            String entryrownumber = mapEntry.getKey();
            for (Map.Entry<List<String>, BigDecimal> entry : result.entrySet()) {
                List<String> list = entry.getKey();
                boolean hit = true;
                for (int i = 0; i < dimensions.size(); ++i) {
                    String dim = dimensions.get(i);
                    String dimMember = list.get(i);
                    if (mapEntry.getValue().get(dim) == null || mapEntry.getValue().get(dim).contains(dimMember)) continue;
                    hit = false;
                    break;
                }
                if (!hit) continue;
                HashMap newmap = entryrows.get(entryrownumber) == null ? new HashMap() : (HashMap)entryrows.get(entryrownumber);
                newmap.put(list, entry.getValue());
                entryrows.put(entryrownumber, newmap);
            }
            entryrows.putIfAbsent(entryrownumber, null);
        }
        return entryrows;
    }

    private Map<List<String>, BigDecimal> queryOlap(Long modelid, Map<String, Set<String>> datafilter, List<String> dimensions) {
        HashMap<List<String>, BigDecimal> result = new HashMap<List<String>, BigDecimal>(16);
        if (datafilter.size() == 0) {
            return result;
        }
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelid);
        SQLBuilder sql = new SQLBuilder(modelNumber);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addSelectField(dimensions.toArray(new String[0]));
        datafilter.forEach((k, v) -> sql.addFilter(k, v.toArray(new String[0])));
        MDResultSet resultset = OlapServiceHelper.queryData((SQLBuilder)sql);
        while (resultset.next()) {
            ArrayList key = new ArrayList();
            dimensions.forEach(e -> key.add(resultset.getString(e)));
            result.put(key, resultset.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField()));
        }
        return result;
    }

    private void setDataFilter(Map<String, Set<String>> allfilter, Map<String, Set<String>> datafilter, Map<String, String> dims) {
        if (datafilter.size() == 0) {
            dims.keySet().forEach(k -> datafilter.put((String)k, new HashSet()));
        }
        HashSet needdeletedim = new HashSet();
        datafilter.forEach((k, v) -> {
            Set str = (Set)allfilter.get(k);
            if (str != null && str.size() > 0) {
                ((Set)datafilter.get(k)).addAll(str);
            } else {
                needdeletedim.add(k);
            }
        });
        needdeletedim.forEach(dim -> datafilter.remove(dim));
    }

    private void setOtherNeedDimFilter(TemplateModel currentModel, Map<String, Set<String>> allfilter, Map<String, Set<String>> unwantedDim) {
        List listpage = currentModel.getPageDimensionEntries();
        List viewpage = currentModel.getViewPointDimensionEntries();
        HashMap pageAndViewDim = new HashMap();
        listpage.forEach(dimension -> {
            if (dimension.getMembers().size() > 0) {
                pageAndViewDim.put(dimension.getDimension().getNumber(), ((Member)dimension.getMembers().get(0)).getNumber());
            }
        });
        viewpage.forEach(dimension -> pageAndViewDim.put(dimension.getDimension().getNumber(), dimension.getMember().getNumber()));
        for (Map.Entry entry : pageAndViewDim.entrySet()) {
            String dim = (String)entry.getKey();
            if (allfilter.containsKey(dim) || unwantedDim != null && unwantedDim.containsKey(dim)) continue;
            HashSet set = new HashSet();
            set.add(entry.getValue());
            allfilter.put(dim, set);
        }
        if (unwantedDim != null) {
            for (Map.Entry<Object, Object> entry : unwantedDim.entrySet()) {
                if (entry.getValue() == null || ((Set)entry.getValue()).size() <= 0) continue;
                allfilter.put((String)entry.getKey(), (Set<String>)entry.getValue());
            }
        }
    }

    private Map<String, Object> getRowAndColDim(TemplateModel currentModel, String position, Map<String, Object> fixEntrysMap, String rownumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isfloat = TemplateTypeEnum.DYNA.getType() == currentModel.getTemplateType().intValue();
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)currentModel.getRptData());
        Point cellpoint = ExcelUtils.pos2Point((String)position.split(":")[0]);
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            if (cellpoint.x == cell.getCol() && cellpoint.y == cell.getRow()) {
                if (!isfloat) {
                    if (cell.getUserObject("KEY_DIM_FLAG") == null) {
                        fixEntrysMap.put(rownumber, null);
                        return;
                    }
                    List members = (List)cell.getUserObject("KEY_DIM_FLAG");
                    for (DimMember mem : members) {
                        map.put(mem.getDimension().getNumber(), mem.getNumber());
                    }
                } else {
                    HashMap<String, Set<String>> floatDimension;
                    List lines;
                    int direct = 0;
                    int fixindex = 0;
                    int offset = 0;
                    boolean isdataArea = false;
                    BasePointInfo hitBasepoint = null;
                    for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
                        List basepoints = e.getBasePoints();
                        if (direct == 0 && basepoints != null && basepoints.size() > 0) {
                            direct = ((BasePointInfo)basepoints.get(0)).getDirect();
                        }
                        if (ExcelUtils.isWithInScope((String)e.getAreaRange(), (String)cellpoint.toString())) {
                            isdataArea = true;
                        }
                        for (BasePointInfo basepoint : basepoints) {
                            RangeModel b = new RangeModel(basepoint.getDynaRange());
                            if (direct == 2) {
                                if (b.getY_start() > cellpoint.y || cellpoint.y > b.getY_end()) continue;
                                hitBasepoint = basepoint;
                                fixindex = cell.getCol() - ExcelUtils.pos2X((String)e.getAreaRange().split(":")[0]);
                                if (fixindex >= 0) continue;
                                offset = cell.getCol() - b.getX_start();
                                continue;
                            }
                            if (b.getX_start() > cellpoint.x || cellpoint.x > b.getX_end()) continue;
                            hitBasepoint = basepoint;
                            fixindex = cell.getRow() - ExcelUtils.pos2Y((String)e.getAreaRange().split(":")[0]);
                            if (fixindex >= 0) continue;
                            offset = cell.getRow() - b.getY_start();
                        }
                    }
                    if (isdataArea && hitBasepoint != null) {
                        ((List)hitBasepoint.getFixMemberPosition().get(fixindex)).forEach(dim -> map.put(dim.getDimension().getNumber(), dim.getNumber()));
                        lines = hitBasepoint.getBasePointInnerLineInfo();
                        floatDimension = new HashMap();
                        lines.forEach(line -> {
                            if (line.isFloated()) {
                                Set<String> numbers = this.getDynaMembScopesMembers(line.getDynaMembScopes(), currentModel.getModelId());
                                floatDimension.put(line.getDimension().getNumber(), numbers);
                            } else {
                                line.getDynaMembScopes().forEach(scope -> map.put(line.getDimension().getNumber(), scope.getMember().getNumber()));
                            }
                        });
                        map.put("floatDimension", floatDimension);
                    } else if (isdataArea && hitBasepoint == null) {
                        if (cell.getUserObject("KEY_DIM_FLAG") == null) {
                            fixEntrysMap.put(rownumber, null);
                            return;
                        }
                        List members = (List)cell.getUserObject("KEY_DIM_FLAG");
                        for (DimMember mem : members) {
                            map.put(mem.getDimension().getNumber(), mem.getNumber());
                        }
                    } else if (!isdataArea && hitBasepoint != null) {
                        hitBasepoint.getFixMemberPosition().forEach((index, value) -> value.forEach(dim -> {
                            HashSet<String> dimmembers = map.get(dim.getDimension().getNumber()) == null ? new HashSet<String>() : (Set)map.get(dim.getDimension().getNumber());
                            dimmembers.add(dim.getNumber());
                            map.put(dim.getDimension().getNumber(), dimmembers);
                        }));
                        lines = hitBasepoint.getBasePointInnerLineInfo();
                        floatDimension = new HashMap<String, Set<String>>();
                        for (BasePointInnerLineInfo line2 : lines) {
                            Set<String> numbers;
                            if (line2.isFloated() && line2.getOffset() == offset) {
                                map.put("wantfloatmembersFrom", line2.getDimension().getNumber());
                                numbers = this.getDynaMembScopesMembers(line2.getDynaMembScopes(), currentModel.getModelId());
                                floatDimension.put(line2.getDimension().getNumber(), numbers);
                                continue;
                            }
                            if (line2.isFloated() && line2.getOffset() != offset) {
                                numbers = this.getDynaMembScopesMembers(line2.getDynaMembScopes(), currentModel.getModelId());
                                floatDimension.put(line2.getDimension().getNumber(), numbers);
                                continue;
                            }
                            line2.getDynaMembScopes().forEach(scope -> {
                                HashSet<String> memberset = new HashSet<String>();
                                memberset.add(scope.getMember().getNumber());
                                map.put(line2.getDimension().getNumber(), memberset);
                            });
                        }
                        map.put("floatDimension", floatDimension);
                    } else {
                        fixEntrysMap.put(rownumber, null);
                    }
                }
            }
        });
        return map;
    }

    private Set<String> getDynaMembScopesMembers(List<DynaMembScopeInfo> list, Object modelid) {
        HashSet<String> numbers = new HashSet<String>();
        for (DynaMembScopeInfo scinfo : list) {
            new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), Long.valueOf(((DimMember)scinfo.getMember()).getId()), scinfo.getMember().getNumber(), scinfo.getRangeId(), scinfo.isCustom(), modelid).matchItems(c -> numbers.add(c.number));
        }
        return numbers;
    }

    private List<String> getAllCurrencyNumber(Long modelid) {
        Collection currencies = MemberReader.getAllNodeByDimNum((String)PresetConstant.CURRENCY_DIM, (String)MemberReader.findModelNumberById((Object)modelid));
        return currencies.stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toList());
    }

    private Map<Long, String> getScenarios(Long modelid) {
        Collection scenarios = MemberReader.getAllNodeByDimNum((String)PresetConstant.SCENE_DIM, (String)MemberReader.findModelNumberById((Object)modelid));
        return scenarios.stream().collect(Collectors.toMap(IDNumberTreeNode::getId, IDNumberTreeNode::getNumber));
    }

    private DynamicObject getOrg(Long modelid, String orgnumber) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        qf.add("number", "=", (Object)orgnumber);
        qf.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id, number, name, isleaf, dimension.number, dimension.name", (QFilter[])qf.toArray());
        if (org == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u4f53\u7cfb\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u7ec4\u7ec7\u3002", (String)"ReportToVoucherUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgnumber));
        }
        return org;
    }

    private DynamicObject getYear(Long modelid, String yearnumber) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        qf.add("number", "like", (Object)("%" + yearnumber + "%"));
        DynamicObject year = BusinessDataServiceHelper.loadSingle((String)"bcm_fymembertree", (String)"id, number, name, dimension.number, dimension.name", (QFilter[])qf.toArray());
        if (year == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u4f53\u7cfb\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8d22\u5e74\u3002", (String)"ReportToVoucherUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), yearnumber));
        }
        return year;
    }

    private String getCorrectPeriod(Long modelid, List<String> scenePeriodList, String periodnumber) {
        if (scenePeriodList.size() > 0 && scenePeriodList.size() > 10) {
            for (String string : scenePeriodList) {
                if (!string.contains(periodnumber)) continue;
                return string;
            }
        } else if (scenePeriodList.size() > 0 && scenePeriodList.size() < 10) {
            int periodNum = (int)Math.ceil((double)Integer.parseInt(periodnumber) / 3.0);
            for (String col : scenePeriodList) {
                if (!col.contains(String.valueOf(periodNum))) continue;
                return col;
            }
        }
        QFBuilder periodqf = new QFBuilder("model", "=", (Object)modelid);
        periodqf.add("number", "like", (Object)("M_M%" + periodnumber));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmembertree", (String)"id, number", (QFilter[])periodqf.toArray());
        return dynamicObject == null ? null : dynamicObject.getString("number");
    }

    private Map<String, String> getDimensionListByModel(Object modelId) {
        LinkedHashMap<String, String> dims = new LinkedHashMap<String, String>();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_dimension", (String)"number, name", (QFilter[])new QFBuilder().add("model", "=", modelId).toArray(), (String)"dseq");
        dyns.forEach(e -> dims.put(e.getString("number"), e.getString("name")));
        return dims;
    }

    private void queryCellValueFormReportRecord(long modelId, long orgId, long yearId, long scenarioId, String periodNumber, String currencyNumber, TemplateModel templateModel, String position, Map<String, Object> fixEntrysMap, String rowNumber) {
        String key = String.format("%s_%s_%s_%s_%s_%s_%s", modelId, yearId, scenarioId, periodNumber, currencyNumber, templateModel.getId(), orgId);
        SpreadManager spreadManager = (SpreadManager)ThreadCache.get((Object)key, () -> {
            String data;
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.and("entity", "=", (Object)orgId);
            qfBuilder.and("scene", "=", (Object)scenarioId);
            qfBuilder.and("fyear", "=", (Object)yearId);
            Long periodId = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNumber).getId();
            qfBuilder.and("period", "=", (Object)periodId);
            Long currencyId = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)currencyNumber).getId();
            qfBuilder.and("currency", "=", (Object)currencyId);
            qfBuilder.and("template.number", "=", (Object)templateModel.getNumber());
            qfBuilder.and(new QFilter("reporttype", "=", (Object)ReportType.NORMAL.index).or(new QFilter("reporttype", "=", (Object)"")));
            logger.info(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u8f6c\u8d26\u62a5\u8868\u67e5\u8be2\u6761\u4ef6:", (String)"ReportToVoucherUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]) + "modelId=%s,orgId=%s,scenarioId=%s,yearId=%s,periodId=%s,currencyId=%s,templateNumber=%s", modelId, orgId, scenarioId, yearId, periodId, currencyId, templateModel.getNumber()));
            DataSet reportDataSet = QueryServiceHelper.queryDataSet((String)"ReportToVoucher", (String)"bcm_reportentity", (String)"data", (QFilter[])qfBuilder.toArray(), null);
            if (reportDataSet.hasNext()) {
                Row record = reportDataSet.next();
                data = record.getString("data");
            } else {
                TemplateModel template = ModelDataProvider.getTemplateModel(templateModel.getId());
                data = template.getRptData();
            }
            return JsonSerializerUtil.toSpreadManager((String)data);
        });
        if (spreadManager != null) {
            Sheet sheet = spreadManager.getBook().getSheet(0);
            Point cellPoint = ExcelUtils.pos2Point((String)position);
            Cell cell = sheet.getCell(cellPoint.y, cellPoint.x);
            fixEntrysMap.put(rowNumber, cell.getValue());
        }
    }
}

