/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.report.ReportMultiExportTask;
import kd.fi.bcm.formplugin.util.POIUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;

public class SXSSFUtil {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReportMultiExportTask.class);

    public static void setCellValue(XSSFCell cell, Object value) {
        block29: {
            try {
                if (value instanceof Date) {
                    try {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            cell.setCellValue((Date)value);
                            break block29;
                        }
                        String format = DateTimeUtils.format((Date)((Date)value), (String)cell.getCellStyle().getDataFormatString());
                        cell.setCellValue(format);
                    }
                    catch (Exception e) {
                        try {
                            String format = DateTimeUtils.format((Date)((Date)value));
                            cell.setCellValue(format);
                            break block29;
                        }
                        catch (Exception e1) {
                            cell.setCellValue((Date)value);
                        }
                    }
                    break block29;
                }
                if (value instanceof Double) {
                    cell.setCellValue(((Double)value).doubleValue());
                } else if (value instanceof String) {
                    if (!value.equals(cell.toString().trim())) {
                        cell.setCellValue((String)value);
                    }
                } else if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                } else if (value instanceof Calendar) {
                    cell.setCellValue((Calendar)value);
                } else if (value instanceof LocalDate) {
                    cell.setCellValue((LocalDate)value);
                } else if (value instanceof LocalDateTime) {
                    cell.setCellValue((LocalDateTime)value);
                } else if (value instanceof RichTextString) {
                    cell.setCellValue((RichTextString)value);
                } else if (value instanceof Number) {
                    cell.setCellValue(((Number)value).doubleValue());
                } else if (value == null) {
                    try {
                        cell.setBlank();
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
            }
            catch (FormulaParseException f) {
                if (cell.getCellType() == CellType.FORMULA) {
                    String fval = cell.getCTCell().getF().getStringValue();
                    cell.getCTCell().unsetF();
                    cell.setCellValue(fval);
                }
                log.error("FormulaParseException:" + cell.getRowIndex() + "@" + cell.getColumnIndex());
            }
        }
    }

    public static String toString(Cell cell, CellType cellType) {
        switch (cellType) {
            case BLANK: {
                return "";
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", LocaleUtil.getUserLocale());
                    sdf.setTimeZone(LocaleUtil.getUserTimeZone());
                    return sdf.format(cell.getDateCellValue());
                }
                return Double.toString(cell.getNumericCellValue());
            }
            case STRING: {
                return cell.getRichStringCellValue().toString();
            }
            case ERROR: {
                return ErrorEval.getText((int)cell.getErrorCellValue());
            }
        }
        return "Unknown Cell Type: " + cell.getCellType();
    }

    public static void insertCol(XSSFSheet currentSheet, int inertColIndex, int counts, int maxRow, int maxCol, Map<Object, Short> styles) {
        int i;
        int sourceCol = inertColIndex;
        if (sourceCol == -1 || counts == 0) {
            return;
        }
        HashMap<Integer, CellRangeAddress> changeRegions = new HashMap<Integer, CellRangeAddress>(16);
        CellRangeAddress newRegion = null;
        for (i = 0; i < currentSheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = currentSheet.getMergedRegion(i);
            int firstColumn = region.getFirstColumn();
            int lastColumn = region.getLastColumn();
            if (inertColIndex > lastColumn) continue;
            if (inertColIndex <= firstColumn) {
                firstColumn += counts;
                lastColumn += counts;
            } else {
                lastColumn += counts;
            }
            newRegion = new CellRangeAddress(region.getFirstRow(), region.getLastRow(), firstColumn, lastColumn);
            changeRegions.put(i, newRegion);
        }
        if (!changeRegions.isEmpty()) {
            currentSheet.removeMergedRegions(changeRegions.keySet());
            changeRegions.values().forEach(changeRegion -> currentSheet.addMergedRegionUnsafe(changeRegion));
        }
        ArrayList<Integer> columnWidthList = new ArrayList<Integer>(maxCol);
        for (i = 0; i <= maxCol; ++i) {
            columnWidthList.add(currentSheet.getColumnWidth(i));
        }
        for (i = 0; i < maxRow; ++i) {
            XSSFRow sourceRow = currentSheet.getRow(i);
            if (sourceRow == null) {
                sourceRow = currentSheet.createRow(i);
            }
            int lastCellInex = sourceRow.getLastCellNum() - 1;
            for (int j = lastCellInex + counts; j > sourceCol; --j) {
                XSSFCell templateCell = j <= sourceCol + counts ? sourceRow.getCell(sourceCol) : sourceRow.getCell(j - counts);
                if (i == 0) {
                    if (j > sourceCol && j <= sourceCol + counts) {
                        if (columnWidthList.size() > sourceCol) {
                            currentSheet.setColumnWidth(j, ((Integer)columnWidthList.get(sourceCol)).intValue());
                        }
                    } else if (columnWidthList.size() > j - counts) {
                        currentSheet.setColumnWidth(j, ((Integer)columnWidthList.get(j - counts)).intValue());
                    }
                }
                if (templateCell == null) continue;
                templateCell.setBlank();
                templateCell.removeFormula();
                XSSFCell newCell = sourceRow.getCell(j);
                if (newCell == null) {
                    newCell = sourceRow.createCell(j);
                }
                POIUtil.copyCell(currentSheet.getWorkbook(), templateCell, newCell, styles, false);
            }
        }
    }

    public static void insertRows(XSSFSheet currentSheet, int insertRowIndex, int rows, int maxRow, int maxCol, Map<Object, Short> styles) {
        if (insertRowIndex == -1 || rows == 0) {
            return;
        }
        for (int j = 1; j <= rows; ++j) {
            int lastRowNum = currentSheet.getLastRowNum();
            currentSheet.shiftRows(insertRowIndex, lastRowNum, 1, true, false);
            XSSFRow rowSource = currentSheet.getRow(insertRowIndex + 1);
            if (rowSource == null) {
                rowSource = currentSheet.createRow(insertRowIndex + 1);
            }
            XSSFCellStyle rowStyle = rowSource.getRowStyle();
            XSSFRow rowInsert = currentSheet.createRow(insertRowIndex);
            if (rowStyle != null) {
                rowInsert.setRowStyle((CellStyle)rowStyle);
                rowInsert.setHeight(rowSource.getHeight());
            }
            int lastColIndex = rowSource.getLastCellNum() - 1;
            for (int col = 0; col <= lastColIndex; ++col) {
                XSSFCell cellSource = rowSource.getCell(col);
                if (cellSource == null) {
                    cellSource = rowSource.createCell(col);
                }
                cellSource.setBlank();
                cellSource.removeFormula();
                XSSFCell cellInsert = rowInsert.getCell(col);
                if (cellInsert == null) {
                    cellInsert = rowInsert.createCell(col);
                }
                if (cellInsert == null || cellSource == null) continue;
                POIUtil.copyCell(currentSheet.getWorkbook(), cellSource, cellInsert, styles, false);
            }
        }
    }

    public static void insertRows(XSSFSheet currentSheet, int insertRowIndex, int rows, int maxRow, int maxCol) {
        if (insertRowIndex == -1 || rows == 0) {
            return;
        }
        CellRangeAddress region = null;
        for (int i = 0; i < currentSheet.getNumMergedRegions(); ++i) {
            region = currentSheet.getMergedRegion(i);
            if (!region.containsRow(insertRowIndex)) continue;
            int firstRow = region.getFirstRow();
            int lastRow = region.getLastRow();
            if (firstRow >= insertRowIndex) {
                firstRow += rows;
                lastRow += rows;
            } else if (firstRow < insertRowIndex && insertRowIndex <= lastRow) {
                lastRow += rows;
            }
            region.setFirstColumn(firstRow);
            region.setLastColumn(lastRow);
        }
        for (int j = 1; j <= rows; ++j) {
            int lastRowNum = currentSheet.getLastRowNum();
            currentSheet.shiftRows(insertRowIndex, lastRowNum, 1, true, false);
            XSSFRow rowSource = currentSheet.getRow(insertRowIndex + 1);
            if (rowSource == null) {
                rowSource = currentSheet.createRow(insertRowIndex + 1);
            }
            XSSFCellStyle rowStyle = rowSource.getRowStyle();
            XSSFRow rowInsert = currentSheet.createRow(insertRowIndex);
            if (rowStyle != null) {
                rowInsert.setRowStyle((CellStyle)rowStyle);
                rowInsert.setHeight(rowSource.getHeight());
            }
            for (int col = 0; col < maxCol; ++col) {
                XSSFCell cellSource = rowSource.getCell(col);
                XSSFCell cellInsert = rowInsert.createCell(col);
                if (cellInsert == null || cellSource == null) continue;
                XSSFCellStyle cellStyle = cellSource.getCellStyle();
                if (CellType.FORMULA == cellSource.getCellType()) {
                    cellInsert.setCellFormula(cellSource.getCellFormula());
                } else {
                    cellInsert.setCellType(cellSource.getCellType());
                }
                if (cellStyle == null) continue;
                XSSFCellStyle insertCellStyle = cellInsert.getCellStyle();
                SXSSFUtil.copyCellStyle(cellStyle, insertCellStyle);
            }
        }
    }

    public static void addMergedRegion(XSSFSheet sheet, Map<Integer, Integer> mergeRegions, Integer row) {
        if (!mergeRegions.isEmpty()) {
            int index = 0;
            List list = mergeRegions.keySet().stream().sorted().collect(Collectors.toList());
            for (int i = 0; i < list.size(); ++i) {
                int lastCol;
                int firstCol;
                Integer key = (Integer)list.get(i);
                Integer value = mergeRegions.get(key);
                if (index == 0) {
                    firstCol = key;
                    lastCol = value + key;
                    sheet.addMergedRegionUnsafe(new CellRangeAddress(row.intValue(), row.intValue(), firstCol, lastCol));
                } else {
                    firstCol = key + index;
                    lastCol = value + key + index;
                    sheet.addMergedRegionUnsafe(new CellRangeAddress(row.intValue(), row.intValue(), firstCol, lastCol));
                }
                index = value + index;
            }
        }
    }

    public static void updateFormula(List<Map<String, Object>> p1, XSSFSheet sheet) {
        if (!p1.isEmpty()) {
            for (Map<String, Object> map : p1) {
                XSSFCell cell;
                int row = (Integer)map.get("r");
                int col = (Integer)map.get("c");
                String formula = (String)map.get("f");
                XSSFRow row1 = sheet.getRow(row);
                if (row1 == null) {
                    row1 = sheet.createRow(row);
                }
                XSSFCellStyle style = null;
                for (int i = row1.getFirstCellNum(); i < row1.getLastCellNum(); ++i) {
                    if (row1.getCell(i) == null) continue;
                    style = row1.getCell(i).getCellStyle();
                    break;
                }
                if ((cell = row1.getCell(col)) == null) {
                    cell = row1.createCell(col);
                }
                cell.setCellStyle((CellStyle)style);
                cell.setCellFormula(formula);
            }
        }
    }

    public static void setOrgRowStyle(XSSFWorkbook xssfWorkbook, int startRow) {
        double stringNeedsHeight;
        XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
        XSSFRow row = sheet.getRow(startRow);
        CTRow ctRow = row.getCTRow();
        ctRow.setCustomHeight(false);
        String maxStr = "";
        XSSFFont xssfFont = new XSSFFont();
        XSSFCell cell = null;
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            XSSFCell xssfCell = row.getCell(i);
            if (xssfCell == null) continue;
            XSSFCellStyle style = xssfCell.getCellStyle();
            style.setWrapText(true);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setVerticalAlignment(VerticalAlignment.TOP);
            String cellContent = SXSSFUtil.getCellContent(xssfCell);
            if (cellContent == null || cellContent.length() <= maxStr.length()) continue;
            xssfFont = style.getFont();
            maxStr = cellContent;
            cell = xssfCell;
        }
        if (cell == null) {
            return;
        }
        int cellWidth = sheet.getColumnWidth(cell.getColumnIndex());
        double maxHeight = row.getHeight();
        short fontHeight = xssfFont.getFontHeight();
        double cellContentWidth = maxStr.getBytes().length * 2 * 256;
        double stringNeedsRows = cellContentWidth / (double)cellWidth;
        if (stringNeedsRows < 1.0) {
            stringNeedsRows = 1.0;
        }
        if ((stringNeedsHeight = (double)fontHeight * stringNeedsRows) > maxHeight) {
            maxHeight = stringNeedsHeight;
            maxHeight = Math.ceil(maxHeight);
            row.setHeight((short)maxHeight);
        }
    }

    public static String getCellContent(XSSFCell xssfCell) {
        if (xssfCell == null) {
            return "";
        }
        String result = "";
        CellType cellType = xssfCell.getCellType();
        switch (cellType) {
            case STRING: {
                result = xssfCell.getStringCellValue().trim();
                break;
            }
            case NUMERIC: {
                String s = String.valueOf(xssfCell.getNumericCellValue());
                if (s != null && s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                result = s;
                break;
            }
            case FORMULA: {
                break;
            }
            case BOOLEAN: {
                result = String.valueOf(xssfCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                break;
            }
        }
        return result;
    }

    public static void copyCellStyle(XSSFCellStyle fromStyle, XSSFCellStyle toStyle) {
        toStyle.setAlignment(fromStyle.getAlignment());
        toStyle.setBorderBottom(fromStyle.getBorderBottom());
        toStyle.setBorderLeft(fromStyle.getBorderLeft());
        toStyle.setBorderRight(fromStyle.getBorderRight());
        toStyle.setBorderTop(fromStyle.getBorderTop());
        toStyle.setTopBorderColor(fromStyle.getTopBorderColor());
        toStyle.setBottomBorderColor(fromStyle.getBottomBorderColor());
        toStyle.setRightBorderColor(fromStyle.getRightBorderColor());
        toStyle.setLeftBorderColor(fromStyle.getLeftBorderColor());
        toStyle.setFillBackgroundColor(fromStyle.getFillBackgroundColor());
        toStyle.setDataFormat(fromStyle.getDataFormat());
        toStyle.setFillPattern(fromStyle.getFillPattern());
        toStyle.setHidden(fromStyle.getHidden());
        toStyle.setIndention(fromStyle.getIndention());
        toStyle.setLocked(fromStyle.getLocked());
        toStyle.setRotation(fromStyle.getRotation());
        toStyle.setVerticalAlignment(fromStyle.getVerticalAlignment());
        toStyle.setWrapText(fromStyle.getWrapText());
    }

    public static void close(Workbook workbook, FileOutputStream fileOutputStream) {
        try {
            if (workbook != null) {
                workbook.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException ex) {
            throw new KDBizException(ex.getMessage());
        }
    }
}

