/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.workBench;

import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.bizstatus.access.DataFlowControlStatusAccess;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.report.WorkBenchButtonEnum;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.workBench.WorkBenchContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckBeforeItemClickService {
    private WorkBenchButtonEnum buttonEnum;
    private WorkBenchContext context;
    private ApplicationTypeEnum applicationTypeEnum;

    public CheckBeforeItemClickService(WorkBenchButtonEnum buttonEnum, WorkBenchContext context, ApplicationTypeEnum applicationTypeEnum) {
        this.buttonEnum = buttonEnum;
        this.context = context;
        this.applicationTypeEnum = applicationTypeEnum;
    }

    public void doInternalCheck(boolean isWorkBench) {
        if (!isWorkBench) {
            this.doExternalCheck();
        }
        if (this.buttonEnum == null) {
            return;
        }
        if (this.buttonEnum.isModifyData()) {
            this.doCheckECSubmitStatus();
            this.doCheckReportStatusController();
            this.doCheckTemplate();
        }
    }

    public void doExternalCheck() {
        if (this.checkOrgMemberIsNoPerm()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"CheckBeforeItemClickService_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.buttonEnum == null) {
            return;
        }
        this.doCheckAppType();
        this.doCheckBlackWhiteList();
        this.doCheckParamController();
        this.doCheckOrgMergeNode();
        if (this.buttonEnum.isModifyData()) {
            if (!this.checkOrgMemberIsReadAndWrite()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u7ec4\u7ec7\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"CheckBeforeItemClickService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.doCheckPeriodManangerStatus();
            if (WorkBenchButtonEnum.BTN_STAGEBACK != this.buttonEnum) {
                this.doCheckECSubmitStatus();
            }
            this.doCheckEffectiveOrg();
        }
    }

    public void doCheckAppType() {
        if (this.buttonEnum == null) {
            return;
        }
        switch (this.buttonEnum) {
            case BTN_STAGECOMMIT: 
            case BTN_STAGEBACK: 
            case BTN_RPADATAIMPORT: 
            case BTN_START_RPA: 
            case BTN_RPA_LOG: {
                if (ApplicationTypeEnum.RPT != this.applicationTypeEnum) break;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u8d22\u52a1\u62a5\u8868\u4e0d\u53ef\u4f7f\u7528\u3002", (String)"CheckBeforeItemClickService_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
            }
        }
    }

    public void doCheckBlackWhiteList() {
        boolean isBreak = false;
        switch (this.buttonEnum) {
            case BTN_CONVERT: {
                isBreak = BlackListUtils.hasFeatureInCm((String)"CMTra");
                break;
            }
            case BTN_OPENEXCEL: {
                isBreak = BlackListUtils.hasFeatureInCm((String)"CMlist");
                break;
            }
            case BTN_RPADATAIMPORT: {
                isBreak = BlackListUtils.hasFeatureInCm((String)"CMMI");
                break;
            }
        }
        if (isBreak) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9ed1\u540d\u5355\u3001\u767d\u540d\u5355\u63a7\u5236\u3010%1$s\u3011\uff0c\u65e0\u6cd5\u6267\u884c%2$s\u3002", (String)"CheckBeforeItemClickService_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "isSupExtMerge", this.buttonEnum.getText()));
        }
    }

    public void doCheckParamController() {
        boolean isBreak = false;
        switch (this.buttonEnum) {
            case BTN_MERGEEXT: {
                isBreak = !ConfigServiceHelper.getGlobalBoolParam((String)"isSupExtMerge");
                break;
            }
        }
        if (isBreak) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540e\u53f0\u53c2\u6570\u63a7\u5236\u3010%1$s\u3011\uff0c\u65e0\u6cd5\u6267\u884c%2$s\u3002", (String)"CheckBeforeItemClickService_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "isSupExtMerge", this.buttonEnum.getText()));
        }
    }

    public void doCheckTemplate() {
        ReportTabInfo tabInfo = this.context.getTabInfo();
        if (tabInfo == null) {
            return;
        }
        if (tabInfo.isOnlyRead() && this.buttonEnum.isModifyData()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u53ea\u8bfb\uff0c\u65e0\u6cd5\u6267\u884c%s\u3002", (String)"CheckBeforeItemClickService_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
        }
    }

    public void doCheckOrgMergeNode() {
        IDNumberTreeNode node = this.context.getSelectOrgTreeNode();
        switch (this.buttonEnum) {
            case BTN_MERGEEXT: 
            case BTN_MERGESUM: 
            case BTN_BAT_MERGESUM: {
                if (!node.isLeaf()) break;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u660e\u7ec6\u8282\u70b9\uff0c\u65e0\u6cd5\u6267\u884c%s\u3002", (String)"CheckBeforeItemClickService_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
            }
            case BTN_RPADATAIMPORT: {
                if (node.isLeaf()) break;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5408\u5e76\u8282\u70b9\uff0c\u65e0\u6cd5\u6267\u884c%s\u3002", (String)"CheckBeforeItemClickService_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
            }
        }
    }

    public void doCheckReportStatusController() {
        DynamicObject object;
        ReportTabInfo tabInfo = this.context.getTabInfo();
        if (tabInfo == null) {
            return;
        }
        ReportStatusEnum statusEnum = ReportStatusEnum.UNWEAVE;
        if (tabInfo.getReportId() != null && (object = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"reportstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)tabInfo.getReportId()))})) != null) {
            statusEnum = ReportStatusEnum.getStatusEnumBy((String)object.getString("reportstatus"));
        }
        switch (this.buttonEnum) {
            case BTN_MERGESUM: 
            case BTN_BAT_MERGESUM: 
            case BTN_SAVE: 
            case BTN_BATCH_SAVE: 
            case BTN_DATACOLLECT: 
            case BTN_BAT_DATACOLLECT: 
            case BTN_ALLCLEAN: 
            case BTN_BATALLCLEAN: {
                if (ReportStatusEnum.COMPLETE != statusEnum && ReportStatusEnum.COMMIT != statusEnum) break;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u7ecf\u7f16\u5236\u5b8c\u6210\u6216\u4e0a\u62a5\uff0c\u65e0\u6cd5\u6267\u884c%s\u3002", (String)"CheckBeforeItemClickService_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
            }
            case BTN_COMPLETE: 
            case BTN_ALLCOMPLETE: {
                break;
            }
            case BTN_WEAVING: 
            case BTN_ALLWEAVING: 
            case BTN_COMMIT: 
            case BTN_ALLCOMMIT: {
                break;
            }
            case BTN_ABACK: 
            case BTN_ALLBACK: {
                break;
            }
            case BTN_DELETE: 
            case BTN_BAT_DELETE: {
                if (!(tabInfo.isSaveDim() || ReportStatusEnum.COMPLETE != statusEnum && ReportStatusEnum.COMMIT != statusEnum)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u5236\u5b8c\u6210\u6216\u5df2\u4e0a\u62a5\u7684\u65e0\u7ef4\u5ea6\u62a5\u8868\uff0c\u65e0\u6cd5\u6267\u884c%s\u3002", (String)"CheckBeforeItemClickService_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
                }
                if (ReportStatusEnum.COMMIT != statusEnum || !OlapServiceHelper.checkMeasure((String)this.context.getModelNum(), (String)FacTabFieldDefEnum.FIELD_LOCK.getField())) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u4e0a\u62a5\u7684\u62a5\u8868\u4e0d\u5141\u8bb8\u6267\u884c\u72b6\u6001\u91cd\u7f6e\u3002", (String)"ReportListPlugin_164", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public boolean checkOrgMemberIsReadAndWrite() {
        if (MemberPermHelper.isModelManager((Long)this.context.getModelId())) {
            return true;
        }
        return PermissionServiceImpl.getInstance((Long)this.context.getModelId()).hasWritePerm(MemberReader.getDimensionIdByNum((long)this.context.getModelId(), (String)"Entity"), Long.valueOf(this.context.getBaseOrg()));
    }

    public boolean checkOrgMemberIsOnlyRead() {
        if (MemberPermHelper.isModelManager((Long)this.context.getModelId())) {
            return false;
        }
        return PermissionServiceImpl.getInstance((Long)this.context.getModelId()).hasReadPerm(MemberReader.getDimensionIdByNum((long)this.context.getModelId(), (String)"Entity"), Long.valueOf(this.context.getBaseOrg()));
    }

    public boolean checkOrgMemberIsNoPerm() {
        if (MemberPermHelper.isModelManager((Long)this.context.getModelId())) {
            return false;
        }
        return PermissionServiceImpl.getInstance((Long)this.context.getModelId()).hasNoPerm(MemberReader.getDimensionIdByNum((long)this.context.getModelId(), (String)"Entity"), Long.valueOf(this.context.getBaseOrg()));
    }

    public void doCheckEffectiveOrg() {
        FilterOrgStructParam param = new FilterOrgStructParam(this.context.getModelId(), this.context.getScenarioId(), this.context.getFyNum(), this.context.getPeriodId());
        Map filterEffectiveOrgMap = EntityVersioningUtil.filterEffectiveOrgByMergeStruct((FilterOrgStructParam)param, Collections.singleton(this.context.getSelectOrg()));
        if (MapUtils.isEmpty((Map)filterEffectiveOrgMap) || !filterEffectiveOrgMap.containsKey(this.context.getSelectOrg())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u6709\u6548\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CheckBeforeItemClickService_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (MergeControlHelper.isQuoteLocked((Long)this.context.getModelId(), (Long)this.context.getScenarioId(), (Long)this.context.getFyId(), (Long)this.context.getPeriodId(), (Long)this.context.getSelectOrg())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7248\u672c\u5316\u60c5\u666f\u4e0b\uff0c\u7ec4\u7ec7\u672a\u6267\u884c\u7248\u672c\u5316\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s\u3002", (String)"ReportListPlugin_73", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
        }
    }

    public void doCheckPeriodManangerStatus() {
        IDNumberTreeNode treeNode = this.context.getSelectOrgTreeNode();
        if (ConfigServiceHelper.getBoolParam((Long)this.context.getModelId(), (String)"CM012") && !PeriodSettingHelper.checkPeriodStatus((long)this.context.getModelId(), (String)treeNode.getNumber(), (long)this.context.getScenarioId(), (long)this.context.getFyId(), (long)this.context.getPeriodId(), (String)"datastatus")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void doCheckECSubmitStatus() {
        IDNumberTreeNode node = this.context.getCurrencyTreeNode();
        if (node != IDNumberTreeNode.NotFoundTreeNode) {
            String parentCurrencyNum;
            IDNumberTreeNode treeNode = this.context.getSelectOrgTreeNode();
            String number = node.getNumber();
            String orgCurrency = treeNode.getCurrency();
            if (orgCurrency == null) {
                return;
            }
            McStatus mcStatus = null;
            if ("DC".equals(number) || "EC".equals(number)) {
                if (StringUtils.isNotEmpty((CharSequence)this.context.getProcess())) {
                    Pair pair = TransMemberUtil.transOrgAndCurbyOrgId((long)this.context.getModelId(), (long)this.context.getSelectOrg(), (String)this.context.getProcess(), (String)number, (long)this.context.getFyId(), (long)this.context.getPeriodId());
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p2))) {
                        number = (String)pair.p2;
                    }
                } else {
                    number = orgCurrency;
                }
            }
            if (orgCurrency.equals(number) && (mcStatus = DataFlowControlStatusAccess.getMcStatus((Object)this.context.getModelId(), (Object)this.context.getSelectOrg(), (Object)this.context.getScenarioId(), (Object)this.context.getFyId(), (Object)this.context.getPeriodId())).getFlow().isSubmit()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u62a5\u8868\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u6267\u884c%s\u3002", (String)"CheckBeforeItemClickService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
            }
            IDNumberTreeNode parent = treeNode.getParent();
            if (parent != IDNumberTreeNode.NotFoundTreeNode && StringUtils.isNotEmpty((CharSequence)parent.getCurrency()) && (parentCurrencyNum = parent.getCurrency()).equals(number)) {
                if (mcStatus == null) {
                    mcStatus = DataFlowControlStatusAccess.getMcStatus((Object)this.context.getModelId(), (Object)this.context.getSelectOrg(), (Object)this.context.getScenarioId(), (Object)this.context.getFyId(), (Object)this.context.getPeriodId());
                }
                if (mcStatus.getPcFlow().isSubmit()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u62a5\u8868\u7684\u667a\u80fd\u5408\u5e76\u6298\u7b97\u5e01\u6d41\u7a0b\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u6267\u884c%s\u3002", (String)"CheckBeforeItemClickService_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.buttonEnum.getText()));
                }
            }
        }
    }
}

