/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.workBench;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.events.CustomEventArgs;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.statustab.CustomEventEnum;
import kd.fi.bcm.common.statustab.CustomStatusTab;
import kd.fi.bcm.common.statustab.CustomStatusTabAp;
import kd.fi.bcm.common.statustab.FrontMethodEnum;
import kd.fi.bcm.common.statustab.ICustomStatusTabAp;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.multi.ReportTabManager;
import kd.fi.bcm.formplugin.report.workBench.ReportWorkBenchPlugin;
import kd.fi.bcm.formplugin.report.workBench.util.ReportWorkBenchUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportStatusTabsController
implements ICustomStatusTabAp {
    private ReportWorkBenchPlugin plugin;
    public static final String CUSTOMCONTROLAP = "customcontrolap";
    protected static final String REPORT_TAB = "tabap";

    public ReportStatusTabsController(ReportWorkBenchPlugin plugin) {
        this.plugin = plugin;
    }

    public Map<String, CustomStatusTabAp> fillInitTabsInfo() {
        return MapInitHelper.ofMap((Object)this.getStatusTabControlKey(), (Object)this.initCustomStatusTabAp(this.plugin.getReportTabInfoManager()));
    }

    private CustomStatusTabAp initCustomStatusTabAp(ReportTabManager tabManager) {
        CustomStatusTabAp customStatusTabAp = new CustomStatusTabAp();
        customStatusTabAp.setCustomStatusTabs(this.initCustomStatusTabs(tabManager.getTabs()));
        ReportTabInfo tabInfo = tabManager.getCurrSelectReportTabInfo();
        if (tabInfo != null) {
            customStatusTabAp.setFocusTabId(tabInfo.getTabKey());
        }
        return customStatusTabAp;
    }

    private List<CustomStatusTab> initCustomStatusTabs(List<ReportTabInfo> infos) {
        ArrayList<CustomStatusTab> customStatusTabs = new ArrayList<CustomStatusTab>(16);
        ReportWorkBenchUtil.getReportTMapsFromTab(infos, ReportStatusEnum.getAllReportStatusEnum(), ReportWorkBenchUtil.INITCUSTOMSTATUSTABS, true).forEach(k -> {
            CustomStatusTab customStatusTab = new CustomStatusTab();
            String tabId = (String)k.get("tabkey");
            String tabName = (String)k.get("template");
            customStatusTab.setTabId(tabId);
            customStatusTab.setTabName(tabName);
            customStatusTab.setTabStatusName((String)k.get("reportstatus"));
            customStatusTab.setTabStatusBackColor(ReportStatusEnum.getColorByStatus((String)((String)k.get(ReportWorkBenchUtil.CUSTOMSTATUS))));
            customStatusTab.setIconClass(ReportStatusEnum.getIconClassByStatus((String)((String)k.get(ReportWorkBenchUtil.CUSTOMSTATUS))));
            customStatusTabs.add(customStatusTab);
        });
        return customStatusTabs;
    }

    private String getStatusTabControlKey() {
        return CUSTOMCONTROLAP;
    }

    public IFormView getView() {
        return this.plugin.getView();
    }

    public void initStatusTabs() {
        Map<String, CustomStatusTabAp> initTabsInfo = this.fillInitTabsInfo();
        initTabsInfo.forEach((k, v) -> {
            this.checkCustomStatusTabInfo((CustomStatusTabAp)v, v.getFocusTabId());
            this.invokeFrontMethod(FrontMethodEnum.INIT_STATUS_TABS, (String)k, initTabsInfo, v.getFocusTabId());
        });
    }

    public void updateStatusTabs(List<ReportTabInfo> tabInfos) {
        if (CollectionUtils.isNotEmpty(tabInfos)) {
            ReportTabInfo tabInfo = this.plugin.getReportTabInfoManager().getCurrSelectReportTabInfo();
            String select = tabInfo != null ? tabInfo.getTabKey() : null;
            this.updateStatusTabs(this.getStatusTabControlKey(), new HashSet<CustomStatusTab>(this.initCustomStatusTabs(tabInfos)), select);
        }
    }

    public void updateReportTabStatus() {
        ReportTabManager manager = this.plugin.getReportTabInfoManager();
        List<CustomStatusTab> customStatusTabs = this.initCustomStatusTabs(manager.getTabs());
        if (CollectionUtils.isNotEmpty(customStatusTabs)) {
            this.updateStatusTabs(this.getStatusTabControlKey(), new HashSet<CustomStatusTab>(customStatusTabs), manager.getCurrSelectReportTabInfo().getTabKey());
        }
    }

    public void updateCurReportReadStatus(String controlKey, String statusTabId) {
        CustomStatusTab customStatusTab;
        if (this.curCustomInitialized(controlKey) && (customStatusTab = this.getCustomStatusTabItemInfo(controlKey, statusTabId)) != null && StringUtils.isNotEmpty((CharSequence)customStatusTab.getTabName())) {
            this.updateStatusTabs(controlKey, customStatusTab, customStatusTab.getTabId());
        }
    }

    public void statusTabReLoad(ReportTabManager manager) {
        List<CustomStatusTab> customStatusTabs = this.initCustomStatusTabs(manager.getTabs());
        if (CollectionUtils.isNotEmpty(customStatusTabs)) {
            this.statusTabReLoad(this.getStatusTabControlKey(), customStatusTabs, manager.getCurrSelectReportTabInfo().getTabKey());
        }
    }

    public void tabCustomEvent(CustomEventArgs e) {
        this.statusTabCustomEvent(e);
    }

    public void cacheLastActiveTab(String tabKey) {
        this.plugin.getPageCache().put("LastActiveTab", tabKey);
    }

    public String getCachedLastActiveTab() {
        return this.plugin.getPageCache().get("LastActiveTab");
    }

    public void statusTabSelected(String controlKey, String statusTabId) {
        Tab reporttab = (Tab)this.getView().getControl(REPORT_TAB);
        if (reporttab != null) {
            if (!StringUtils.equals((CharSequence)statusTabId, (CharSequence)this.getCachedLastActiveTab())) {
                reporttab.selectTab(statusTabId);
            }
            reporttab.activeTab(statusTabId);
            this.updateCurReportReadStatus(controlKey, statusTabId);
        }
    }

    public void afterDelStatusTabs(String controlKey) {
        String selStatusTabId = this.getCurSelStatusTabId(controlKey);
        if (StringUtils.isNotEmpty((CharSequence)selStatusTabId)) {
            this.plugin.customEvent(new CustomEventArgs((Object)this.getView().getControl(REPORT_TAB), controlKey, CustomEventEnum.STATUS_TAB_SELECTED.getMethodName(), selStatusTabId));
        }
    }

    public void updateCurrentReportStatus(ReportTabInfo tabInfo) {
        if (tabInfo == null) {
            return;
        }
        List<CustomStatusTab> statusTabList = this.initCustomStatusTabs(Collections.singletonList(tabInfo));
        if (CollectionUtils.isEmpty(statusTabList)) {
            return;
        }
        this.updateStatusTabs(this.getStatusTabControlKey(), statusTabList.get(0), tabInfo.getTabKey());
    }
}

