/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.workBench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.chkcheck.model.DimensionCombination;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.report.workBench.util.AttachmentUtil;
import org.apache.commons.collections.CollectionUtils;

public class UploadAttachmentPLugin
extends AbstractBaseFormPlugin
implements UploadListener,
AttachmentMarkListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_save", "bar_cancel");
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        panel.addUploadListener((UploadListener)this);
        panel.addMarkListener((AttachmentMarkListener)this);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_save".equals(key)) {
            this.saveAttachment();
        } else if ("bar_cancel".equals(key)) {
            this.deleteAttachment();
        }
    }

    private void deleteAttachment() {
        List<Map<String, Object>> urls = this.getUrls();
        if (CollectionUtils.isNotEmpty(urls)) {
            HashSet<Object> uids = new HashSet<Object>(16);
            for (Map<String, Object> map : urls) {
                uids.add(map.get("uid"));
            }
            for (String string : uids) {
                AttachmentServiceHelper.remove((String)"bcm_chknoteinfo", (Object)0L, (Object)string);
            }
        }
        this.getView().close();
    }

    private List<Map<String, Object>> getUrls() {
        if (this.getPageCache().get("urls") == null) {
            return null;
        }
        List<Map<String, Object>> urls = new ArrayList<Map<String, Object>>(16);
        try {
            urls = (List)JSONUtils.cast((String)this.getPageCache().get("urls"), List.class);
        }
        catch (IOException e) {
            log.error("io error", (Throwable)e);
        }
        return urls;
    }

    private void saveAttachment() {
        boolean flag;
        List<Map<String, Object>> urls = this.getUrls();
        if (CollectionUtils.isNotEmpty(urls) && (flag = AttachmentUtil.saveAttachmentDataForReport(urls, this.getCHKNoteInfo()))) {
            this.returnDataToParent(this.isReportAttachment());
        }
        this.getView().close();
    }

    private DynamicObject getCHKNoteInfo() {
        Map<String, Long> filterMap = this.getReportFilterMap();
        return AttachmentUtil.getCHKNoteInfo(this.getFormCustomParam("modelid", 0L), filterMap.get("bcm_templateentity"), filterMap, this.getDimensionCombination(), this.isReportAttachment());
    }

    public void upload(UploadEvent evt) {
        if (this.getDimensionCombination() == null && !this.isReportAttachment()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u5355\u5143\u683c\u5173\u8054\u9644\u4ef6\u3002", (String)"CHKMultiTabReportProcessPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        QFilter modelQf = new QFilter("model", "=", (Object)this.getFormCustomParam("modelid", 0L));
        QFilter typeQFilter = this.getQFilter(true);
        typeQFilter.or(this.getQFilter(false));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_chknoteinfo", (String)"id", (QFilter[])new QFilter[]{modelQf, typeQFilter});
        Set ids = doc.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)"bcm_chkattachment", (String)"name", (QFilter[])new QFilter[]{new QFilter("noteinfo", "in", ids)});
        Set names = attachments.stream().map(a -> a.getString("name")).collect(Collectors.toSet());
        for (Object url : evt.getUrls()) {
            LinkedHashMap urlMap = (LinkedHashMap)url;
            String tempName = urlMap.get("name").toString();
            if (!names.contains(tempName)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u79f0\u91cd\u590d\u3002", (String)"CHKMultiTabReportProcessPlugin_012", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList<Map> urls = new ArrayList<Map>(10);
        for (Object o : evt.getUrls()) {
            urls.add((Map)o);
        }
        try {
            this.getPageCache().put("urls", JSONUtils.toString(urls));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private boolean isReportAttachment() {
        return this.getFormCustomParam("attachmenttype", true);
    }

    protected QFilter getAttachmentReportFilter(Map<String, Long> filterMap, boolean isDetails) {
        return AttachmentUtil.getAttachmentReportFilter(filterMap, filterMap.get("bcm_templateentity"), isDetails);
    }

    private Map<String, Long> getReportFilterMap() {
        Object param = this.getFormCustomParam("reportCellFilter");
        if (param != null) {
            return (Map)param;
        }
        return new HashMap<String, Long>(16);
    }

    private QFilter getQFilter(boolean isReport) {
        String key = isReport ? "reportCellFilter" : "cellFilter";
        Object s = this.getFormCustomParam(key);
        if (s != null) {
            if (isReport) {
                return this.getAttachmentReportFilter(this.getReportFilterMap(), false);
            }
            return (QFilter)ObjectSerialUtil.deSerializedBytes((String)s.toString());
        }
        throw new KDBizException(String.format("%s is not exit", s));
    }

    private DimensionCombination getDimensionCombination() {
        Object param = this.getFormCustomParam("dimensioncombination");
        if (param != null) {
            return (DimensionCombination)ObjectSerialUtil.deSerializedBytes((String)param.toString());
        }
        return null;
    }
}

