/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.workBench;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.bcm.business.chkcheck.model.DimensionCombination;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.ReportRecordHelper;
import kd.fi.bcm.business.template.model.BaseEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusEnum;
import kd.fi.bcm.common.enums.report.AttachmentTypeEnum;
import kd.fi.bcm.common.enums.report.WorkBenchButtonEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.report.csl.CslReportProcessPlugin;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.style.CellControlerByAttachment;
import kd.fi.bcm.formplugin.report.workBench.util.AttachmentUtil;
import kd.fi.bcm.formplugin.report.workBench.util.ReportWorkBenchUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.util.FormShowParameterUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.StatusBarModel;
import kd.fi.bcm.spread.util.ReportSourceUtil;
import kd.fi.bcm.spread.util.SpreadMemberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkBenchReportEditPlugin
extends CslReportProcessPlugin
implements SubPage {
    private static final String CELLMSG = "cellmsg";
    private static final String FORMULAMSG = "formulamsg";
    private static final String DATASOURCE = "datasource";
    private static final String TEMPLATEDES = "templatedes";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY_ISMD = "ismd";
    private static final String ENTRYENTITY_AREA = "area";
    private static final String VIEWENTRYENTITY = "viewentryentity";
    private static final String VIEWENTRYENTITY_DIM = "dim";
    private static final String VIEWENTRYENTITY_MEMBER = "member";
    private static final String INDICATORNAME = "indicatorname";
    private static final String UPLOADREPORTATT = "uploadreportatt";
    private static final String UPLOADCELLATT = "uploadcellatt";
    private static final String REMOVEATT = "removeatt";
    private static final String DOWNATT = "downatt";
    private static final String ATTENTRYENTITY = "attentryentity";
    private static final String REFRESH_CURRENTPAGE = "refresh_currentpage";
    private static final String BASETABAP = "basetabap";
    private static final String TABAPREPORT = "tabapreport";
    private static final String TABAPCELL = "tabapcell";
    private static final String TABAPATT = "tabapatt";
    private static final String BASETABAP_SELECT = "basetabap_select";
    private static final String HIDEAREA = "hidearea";
    private static final String SHOWAREA = "showarea";
    private static final String HIDEVIEW = "hideview";
    private static final String SHOWVIEW = "showview";
    private static final String HIDEEDIT = "hideedit";
    private static final String SHOWEDIT = "showedit";
    private static final String HIDECELLMSG = "hidecellmsg";
    private static final String SHOWCELLMSG = "showcellmsg";
    private static final String HIDEFORMULA = "hideformula";
    private static final String SHOWFORMULA = "showformula";
    private static final String HIDEIN = "hidein";
    private static final String SHOWIN = "showin";
    private static final String HIDEDS = "hideds";
    private static final String SHOWDS = "showds";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(UPLOADCELLATT, UPLOADREPORTATT, REMOVEATT, DOWNATT, REFRESH_CURRENTPAGE, HIDEAREA, SHOWAREA, HIDEVIEW, SHOWVIEW, HIDEEDIT, SHOWEDIT, HIDECELLMSG, SHOWCELLMSG, HIDEFORMULA, SHOWFORMULA, HIDEIN, SHOWIN, HIDEDS, SHOWDS, "btn_batchnote");
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid attEntryGrid = (EntryGrid)this.getControl(ATTENTRYENTITY);
        attEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Tab baseTab = (Tab)this.getControl(BASETABAP);
        if (baseTab != null) {
            baseTab.addTabSelectListener(this::baseTabSelected);
        }
    }

    private void baseTabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        this.getPageCache().put(BASETABAP_SELECT, tabKey);
        switch (tabKey) {
            case "tabapreport": {
                this.loadReportMsg();
                break;
            }
            case "tabapcell": {
                this.loadCellMsg();
                break;
            }
            case "tabapatt": {
                this.loadAttMsg();
                break;
            }
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if ("show_more".equals(ctrlKey) || "show_less".equals(ctrlKey) || REFRESH_CURRENTPAGE.equals(ctrlKey)) {
            VectorAp btnMore = new VectorAp();
            btnMore.setKey(ctrlKey);
            btnMore.setForeColor("#0000ff");
            e.setControl(btnMore.buildRuntimeControl());
            return;
        }
        super.onGetControl(e);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String sign = "";
        String otherKey = "";
        boolean isShow = false;
        switch (key) {
            case "uploadreportatt": {
                this.uploadAtt(true);
                break;
            }
            case "uploadcellatt": {
                this.uploadAtt(false);
                break;
            }
            case "removeatt": {
                this.removeAtt();
                break;
            }
            case "downatt": {
                this.downLoadAtt(null);
                break;
            }
            case "refresh_currentpage": {
                this.itemClickFresh();
                break;
            }
            case "hidearea": 
            case "showarea": {
                sign = ENTRYENTITY;
                isShow = SHOWAREA.equals(key);
                otherKey = isShow ? HIDEAREA : SHOWAREA;
                break;
            }
            case "hideview": 
            case "showview": {
                sign = VIEWENTRYENTITY;
                isShow = SHOWVIEW.equals(key);
                otherKey = isShow ? HIDEVIEW : SHOWVIEW;
                break;
            }
            case "hideedit": 
            case "showedit": {
                sign = TEMPLATEDES;
                isShow = SHOWEDIT.equals(key);
                otherKey = isShow ? HIDEEDIT : SHOWEDIT;
                break;
            }
            case "hidecellmsg": 
            case "showcellmsg": {
                sign = CELLMSG;
                isShow = SHOWCELLMSG.equals(key);
                otherKey = isShow ? HIDECELLMSG : SHOWCELLMSG;
                break;
            }
            case "hideformula": 
            case "showformula": {
                sign = FORMULAMSG;
                isShow = SHOWFORMULA.equals(key);
                otherKey = isShow ? HIDEFORMULA : SHOWFORMULA;
                break;
            }
            case "hidein": 
            case "showin": {
                sign = INDICATORNAME;
                isShow = SHOWIN.equals(key);
                otherKey = isShow ? HIDEIN : SHOWIN;
                break;
            }
            case "hideds": 
            case "showds": {
                sign = DATASOURCE;
                isShow = SHOWDS.equals(key);
                otherKey = isShow ? HIDEDS : SHOWDS;
                break;
            }
            case "btn_batchnote": {
                this.doCheckPermission("bcm_report_list", "13X5JXHMW=OF", this.getModelId(), this.getBizAppId());
                this.batchNote();
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{sign});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{key});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{otherKey});
        }
        super.click(evt);
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("toolbarap".equals(operation)) {
            this.itemClick((ItemClickEvent)com.getParam().get(0));
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        super.hyperLinkClick(arg0);
        String col = arg0.getFieldName();
        Object object = this.getModel().getValue(col, arg0.getRowIndex());
        if (object != null) {
            if ("attname".equals(col)) {
                this.downLoadAtt(this.getModel().getEntryRowEntity(ATTENTRYENTITY, arg0.getRowIndex()));
            } else if (ENTRYENTITY_AREA.equals(col)) {
                String value = (String)object;
                RangeModel rangeModel = new RangeModel(value);
                SpreadClientInvoker.invokeSetSelectionsMethod(this.getClientViewProxy(), "report", SpreadEasyInvoker.packRangeFeature(rangeModel.getY_start(), rangeModel.getX_start(), rangeModel.getRowSize(), rangeModel.getColSize()));
                SpreadSelector selector = new SpreadSelector(rangeModel.getY_start(), rangeModel.getX_start(), rangeModel.getY_end(), rangeModel.getX_end());
                this.setSelector(selector);
                this.getPageCache().put("spread_selector", ObjectSerialUtil.toByteSerialized((Object)selector));
                Tab baseTab = (Tab)this.getControl(BASETABAP);
                if (TABAPCELL.equals(baseTab.getCurrentTab())) {
                    this.loadCellMsg();
                }
            }
        }
    }

    private void downLoadAtt(DynamicObject dyo) {
        QFilter qFilter = null;
        if (dyo != null) {
            qFilter = new QFilter("uid", "=", (Object)dyo.getString("uid"));
        } else {
            EntryGrid entry = (EntryGrid)this.getControl(ATTENTRYENTITY);
            int[] selectRows = entry.getSelectRows();
            if (selectRows.length > 0) {
                HashSet uids = new HashSet(16);
                Arrays.stream(selectRows).forEach(i -> {
                    DynamicObject object = this.getModel().getEntryRowEntity(ATTENTRYENTITY, i);
                    if (object != null) {
                        uids.add(object.getString("uid"));
                    }
                });
                if (CollectionUtils.isNotEmpty(uids)) {
                    qFilter = new QFilter("uid", "in", uids);
                }
            }
        }
        if (qFilter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"ReportListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (String url : AttachmentUtil.getAttUrls(qFilter)) {
            try {
                String fullUrl = UrlService.getAttachmentFullUrl((String)url);
                this.downloadFile(fullUrl, "bcm_report_list", "47150e89000000ac");
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    private void uploadAtt(boolean attType) {
        if (!this.beforeCheckAtt(attType)) {
            return;
        }
        Map<String, Long> recordFilter = this.getRecordFilter();
        recordFilter.put("bcm_templateentity", this.getTemplateId());
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("modelid", this.getModelId());
        map.put("cellFilter", ObjectSerialUtil.toByteSerialized((Object)new QFilter("dimensionstr", "in", this.getReportCellsCombineStr())));
        map.put("reportCellFilter", recordFilter);
        map.put("attachmenttype", attType);
        DimensionCombination combination = this.pakageDimensionCombination();
        if (combination != null) {
            map.put("dimensioncombination", ObjectSerialUtil.toByteSerialized((Object)combination));
        }
        this.getView().showForm(FormShowParameterUtil.getFormShowParameter("bcm_attachment_view", ShowType.NonModal, "", new CloseCallBack((IFormPlugin)this, "markcellAttachment"), null, map));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("markcellAttachment".equals(evt.getActionId()) && evt.getReturnData() != null) {
            if (!((Boolean)ObjectSerialUtil.deSerializedBytes((String)evt.getReturnData().toString())).booleanValue()) {
                new CellControlerByAttachment(this).controlStyle();
            }
            this.loadAttMsg();
        }
    }

    private void markCellAttachment(List<Map<String, Object>> rangeList, boolean isMark) {
        String text;
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        String string = text = isMark ? "A" : "";
        if (isMark) {
            cell.setUserObject("setCornerMark", (Object)true);
        } else {
            cell.removeUserObject("setCornerMark");
        }
        this.cacheSpreadModel();
        CellControlerByAttachment.setAttachmentMark(this.getClientViewProxy(), rangeList, text, isMark);
    }

    private void removeAtt() {
        if (!this.beforeCheckAtt(true)) {
            return;
        }
        EntryGrid entry = (EntryGrid)this.getControl(ATTENTRYENTITY);
        int[] selectRows = entry.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"ReportListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, Set> map = new HashMap<Long, Set>(16);
        boolean flag = false;
        HashSet<String> allUids = new HashSet<String>(16);
        HashSet<String> cells = new HashSet<String>(16);
        for (int selectRow : selectRows) {
            String cellMsg;
            DynamicObject dyo = this.getModel().getEntryRowEntity(ATTENTRYENTITY, selectRow);
            if (!flag) {
                flag = AttachmentTypeEnum.CELL.getNumber().equals(dyo.getString("atttype"));
            }
            if (StringUtils.isNotEmpty((CharSequence)(cellMsg = dyo.getString("cellatt")))) {
                String[] split = cellMsg.split("\uff0c");
                cells.addAll(Arrays.asList(split));
            }
            allUids.add(dyo.getString("uid"));
        }
        QFilter qFilter = new QFilter("uid", "in", allUids);
        AttachmentUtil.getAttachmentDynamicObjects(qFilter).forEach(d -> {
            long noteId = d.getLong("noteinfo.id");
            map.computeIfAbsent(noteId, k -> new HashSet(16)).add(d.getString("uid"));
        });
        if (MapUtils.isNotEmpty(map)) {
            DeleteServiceHelper.delete((String)"bcm_chkattachment", (QFilter[])new QFilter[]{qFilter});
            map.forEach((k, v) -> v.forEach(v1 -> AttachmentServiceHelper.remove((String)"bcm_chknoteinfo", (Object)k, (Object)v1)));
            this.getModel().deleteEntryRows(ATTENTRYENTITY, selectRows);
        }
        if (flag && CollectionUtils.isNotEmpty(cells)) {
            ArrayList<Map<String, Object>> rangeList = new ArrayList<Map<String, Object>>(16);
            cells.forEach(c -> {
                RangeModel rangeModel = new RangeModel(c);
                rangeList.add(SpreadEasyInvoker.packRangeFeature(rangeModel.getY_start(), rangeModel.getX_start(), 1, 1));
            });
            this.markCellAttachment(rangeList, false);
        }
    }

    private boolean beforeCheckAtt(boolean attType) {
        if (ReportStatusEnum.COMMIT.status().equals(this.getCurrentReportStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u4e0a\u62a5\uff0c\u4e0d\u53ef\u4fee\u6539\u6570\u636e\u3002", (String)"CHKMultiTabReportProcessPlugin_011", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (ReportStatusEnum.COMPLETE.status().equals(this.getCurrentReportStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u7f16\u5236\u5b8c\u6210\uff0c\u4e0d\u53ef\u4fee\u6539\u6570\u636e\u3002", (String)"CHKMultiTabReportProcessPlugin_013", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!attType && !this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol()).isMdDataDomain()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u591a\u7ef4\u5355\u5143\u683c\u5173\u8054\u9644\u4ef6\u3002", (String)"CHKMultiTabReportProcessPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ((this.isOnlyReadTemplate() || this.isUsageQueryTemplate()) && !this.isEPM()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u4e3a\u53ea\u8bfb\u6216\u67e5\u8be2\u7528\u9014\u7684\u62a5\u8868\uff0c\u4e0d\u53ef\u4fee\u6539\u5f53\u524d\u62a5\u8868\u4efb\u4f55\u5355\u5143\u683c\u7684\u5185\u5bb9\u3002", (String)"AbstractMultiReportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void hide() {
        HashSet hideDims = new HashSet(16);
        this.getSpreadModel().getFilter().getViewPointDomain().getDimensions().forEach(d -> {
            String entityNumber = DimEntityNumEnum.getEntieyNumByNumber((String)d.getNumber());
            hideDims.add(this.sugarF7Key(entityNumber, d.getNumber()));
        });
        this.getSpreadModel().getFilter().getPageDomain().getDimensions().forEach(d -> {
            if (ReportWorkBenchUtil.COMMONDIM.contains(d.getNumber())) {
                String entityNumber = DimEntityNumEnum.getEntieyNumByNumber((String)d.getNumber());
                hideDims.add(this.sugarF7Key(entityNumber, d.getNumber()));
            }
        });
        this.getView().setVisible(Boolean.valueOf(false), hideDims.toArray(new String[0]));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    protected void reportTabSelected(TabSelectEvent evt) {
        this.getPageCache().put("tabselect", "checkkreport");
        super.reportTabSelected(evt);
        this.hide();
        String tabselect = TABAPREPORT;
        Tab reporttab = (Tab)this.getControl(BASETABAP);
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(BASETABAP_SELECT))) {
            tabselect = this.getPageCache().get(BASETABAP_SELECT);
        }
        reporttab.selectTab(tabselect);
        reporttab.activeTab(tabselect);
        reporttab.click();
        if (CollectionUtils.isEmpty(this.getDimsForFlexPanelAp())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"show_more", "show_less"});
        }
    }

    @Override
    protected void updateReportStausBar() {
        this.setReportStausBar(null);
    }

    @Override
    protected void setReportStausBar(NotifyEvent e) {
        try {
            StatusBarModel statusBarModel = new StatusBarModel();
            if (this.isReportStyleShow()) {
                long modelId = this.getModelId();
                Map<DimTypesEnum, Object> commonParam = this.getCurrentReportCommonParam("id");
                long orgId = LongUtil.toLong((Object)commonParam.get(DimTypesEnum.ENTITY));
                IDNumberTreeNode node = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
                if (node != IDNumberTreeNode.NotFoundTreeNode) {
                    orgId = node.getCopyfromId() != 0L ? node.getCopyfromId() : orgId;
                }
                long scenarioId = LongUtil.toLong((Object)commonParam.get(DimTypesEnum.SCENARIO));
                long fyId = LongUtil.toLong((Object)commonParam.get(DimTypesEnum.YEAR));
                long periodId = LongUtil.toLong((Object)commonParam.get(DimTypesEnum.PERIOD));
                long templateId = this.getTemplateId();
                String templateNum = this.getTemplateModel().getNumber();
                long cslschemeId = this.getCslschemeId();
                Map<String, String> commonMemberMap = this.getCommonMemberMap();
                this.dealCurrency(commonMemberMap);
                IDNumberTreeNode cyNode = MemberReader.findCurrencyMemberByNum((String)this.getModelNumber(), (String)commonMemberMap.get(DimTypesEnum.CURRENCY.getNumber()));
                ChkStatusEnum chkStatusEnum = ReportWorkBenchUtil.getChkStatusEnum(modelId, orgId, scenarioId, fyId, periodId, (long)cyNode.getId(), templateNum, cslschemeId);
                statusBarModel.setChkStatus(chkStatusEnum.getText(false));
                statusBarModel.setChkStatusColor(chkStatusEnum.getText(true));
                DataCollectRecordEnum dataCollectStatus = ReportWorkBenchUtil.getDataCollectStatus(modelId, orgId, scenarioId, fyId, periodId, templateId);
                String dcStatus = dataCollectStatus.getValue();
                if (DataCollectRecordEnum.EXECUTED == dataCollectStatus) {
                    dcStatus = ResManager.loadKDString((String)"\u5df2\u53d6\u6570", (String)"WorkBenchReportEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                statusBarModel.setDataCollectStatus(dcStatus);
                this.loadDataUnit(statusBarModel);
            }
            SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), "report", statusBarModel, true);
            Tab baseTab = (Tab)this.getControl(BASETABAP);
            if (TABAPCELL.equals(baseTab.getCurrentTab())) {
                this.loadCellMsg();
            }
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
        }
    }

    private void loadDataUnit(StatusBarModel statusBarModel) {
        String unitName = "";
        switch (this.getReportUnitInfo()) {
            case 3: {
                unitName = ResManager.loadKDString((String)"\u5343", (String)"AbstractMultiReportPlugin_167", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 4: {
                unitName = ResManager.loadKDString((String)"\u4e07", (String)"AbstractMultiReportPlugin_168", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 6: {
                unitName = ResManager.loadKDString((String)"\u767e\u4e07", (String)"AbstractMultiReportPlugin_169", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 7: {
                unitName = ResManager.loadKDString((String)"\u5343\u4e07", (String)"AbstractMultiReportPlugin_237", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 8: {
                unitName = ResManager.loadKDString((String)"\u4ebf", (String)"AbstractMultiReportPlugin_170", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 10: {
                unitName = ResManager.loadKDString((String)"\u767e\u4ebf", (String)"AbstractMultiReportPlugin_171", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        String number = this.getConcreteCY(this.getCurrentReportCommonParam("number").get(DimTypesEnum.CURRENCY).toString());
        IDNumberTreeNode memberByNum = MemberReader.findCurrencyMemberByNum((String)this.getModelNumber(), (String)number);
        String cyName = memberByNum.getName();
        if (ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"AbstractMultiReportPlugin_146", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(cyName)) {
            cyName = ResManager.loadKDString((String)"\u5143", (String)"AbstractMultiReportPlugin_147", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        cyName = unitName + cyName;
        statusBarModel.setConvertStatus(String.format(ResManager.loadKDString((String)"%s\u8868", (String)"WorkBenchReportEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), cyName));
    }

    @Override
    protected void updateReportStatusToMainPage() {
        CommandParam param = new CommandParam("bcm_workbenchreport", "bcm_report_workbenchback", "updateReportToMainPage", this.getCurrentReportTabInfo());
        param.setAsMainPage(false);
        this.sendMsg(this.getView(), param);
    }

    @Override
    public void sendMsg(IFormView curview, CommandParam com) {
        if (com.isAsMainPage()) {
            super.sendMsg(curview, com);
        } else {
            SubPage.super.sendMsg(curview, com);
        }
    }

    private void loadCellMsg() {
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        String formula = "";
        if (cell.hasFormula()) {
            formula = cell.getFormula();
        }
        this.updateCodeEdit(FORMULAMSG, formula);
        Map<String, Object> cellInfo = this.getCellInfo(true, true);
        String dimCellMsg = "";
        if (cellInfo != null) {
            dimCellMsg = cellInfo.get("infoText").toString();
        }
        this.updateCodeEdit(CELLMSG, dimCellMsg);
        Map<String, String> sourcecombo = this.getCellDimMemberMap(this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol()), true);
        String dataSource = OlapSourceEnum.getName((Object)ReportSourceUtil.getSource((String)MemberReader.findModelNumberById((Object)this.modelId), sourcecombo));
        this.getModel().setValue(DATASOURCE, (Object)dataSource);
    }

    private void updateCodeEdit(String key, String value) {
        CodeEdit edit = (CodeEdit)this.getControl(key);
        if (edit != null) {
            edit.setText(value);
        }
    }

    private void loadReportMsg() {
        this.loadAreaMsg();
        this.loadViewEntryEntity();
        long tempId = this.getTemplateId();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)tempId);
        DynamicObject temp = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"description", (QFilter[])qfBuilder.toArray());
        RichTextEditor rap = (RichTextEditor)this.getControl(TEMPLATEDES);
        rap.setText(temp.getString("description"));
    }

    private void loadViewEntryEntity() {
        long modelId = this.getModelId();
        ViewPointDimDomain viewPointDomain = this.getSpreadModel().getFilter().getViewPointDomain();
        ArrayList<Map<String, Object>> pairs = new ArrayList<Map<String, Object>>(16);
        if (viewPointDomain != null) {
            Map numberMapNameById = MemberReader.getDimNumberMapNameById((long)modelId);
            for (IDimMember dimMember : viewPointDomain.getAllMembers()) {
                String dimNum = dimMember.getDimension().getNumber();
                String p1 = (String)numberMapNameById.get(dimNum);
                String p2 = "";
                IDNumberTreeNode node = BcmThreadCache.findMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum, (String)dimMember.getNumber());
                if (node != IDNumberTreeNode.NotFoundTreeNode) {
                    p2 = node.getName();
                }
                pairs.add(MapInitHelper.ofMap((Object)VIEWENTRYENTITY_DIM, (Object)p1, (Object)VIEWENTRYENTITY_MEMBER, (Object)p2));
            }
        }
        this.updateEntryEntity(pairs, VIEWENTRYENTITY);
    }

    private void loadAreaMsg() {
        ArrayList<Map<String, Object>> pairs = new ArrayList<Map<String, Object>>(16);
        Set postionInfoSet = this.getSpreadModel().getAreaManager().getPostionInfoSet();
        if (CollectionUtils.isNotEmpty((Collection)postionInfoSet)) {
            Comparator<PositionInfo> comparator = new Comparator<PositionInfo>(){

                @Override
                public int compare(PositionInfo o1, PositionInfo o2) {
                    Point point1 = ExcelUtils.pos2Point((String)o1.getStartPosition());
                    Point point2 = ExcelUtils.pos2Point((String)o2.getStartPosition());
                    int y = point1.y - point2.y;
                    if (y != 0) {
                        return y;
                    }
                    return point1.x - point2.x;
                }
            };
            for (PositionInfo info : postionInfoSet.stream().sorted(comparator).collect(Collectors.toList())) {
                pairs.add(MapInitHelper.ofMap((Object)ENTRYENTITY_AREA, (Object)info.getAreaRange(), (Object)ENTRYENTITY_ISMD, (Object)1));
            }
        }
        this.updateEntryEntity(pairs, ENTRYENTITY);
    }

    private void updateEntryEntity(List<Map<String, Object>> pairs, String entityName) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entityName);
        if (CollectionUtils.isNotEmpty(pairs)) {
            this.getModel().batchCreateNewEntryRow(entityName, pairs.size());
            for (int i = 0; i < pairs.size(); ++i) {
                for (Map.Entry<String, Object> entry : pairs.get(i).entrySet()) {
                    Object value = entry.getValue();
                    String key = entry.getKey();
                    if ("cellatt".equals(key) && value instanceof List) {
                        value = String.join((CharSequence)"\uff0c", (List)value);
                    }
                    this.getModel().setValue(key, value, i);
                }
            }
        }
        this.getModel().endInit();
        this.getView().updateView(entityName);
    }

    private void loadAttMsg() {
        ArrayList<Map<String, Object>> pairs = new ArrayList<Map<String, Object>>(16);
        this.loadReportAttachment(pairs);
        this.loadCellAttachment(pairs);
        this.updateEntryEntity(pairs, ATTENTRYENTITY);
    }

    private void loadReportAttachment(List<Map<String, Object>> pairs) {
        QFilter qFilter = new QFilter("noteinfo.model", "=", (Object)this.getModelId());
        qFilter.and(AttachmentUtil.getAttachmentReportFilter(this.getRecordFilter(), this.getTemplateId(), true));
        String reportAtt = AttachmentTypeEnum.REPORT.getNumber();
        AttachmentUtil.getAttachmentDynamicObjects(qFilter).forEach(o -> pairs.add(AttachmentUtil.getAttachmentRow(o, "", reportAtt)));
    }

    private void loadCellAttachment(List<Map<String, Object>> pairs) {
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("noteinfo.model", "=", (Object)modelId);
        qFilter.and("noteinfo.attachmenttype", "=", (Object)AttachmentTypeEnum.CELL.getNumber());
        HashMap cellMap = new HashMap(16);
        AttachmentUtil.getAttachmentDynamicObjects(qFilter).forEach(o -> {
            String dimMemStr = o.getString("noteinfo.dimensionstr");
            cellMap.computeIfAbsent(dimMemStr, k -> new HashSet(16)).add(o);
        });
        if (MapUtils.isNotEmpty(cellMap)) {
            SpreadManager spreadModel = this.getSpreadModel();
            HashMap pageMemberMap = new HashMap(16);
            String orgNum = SpreadMemberUtil.fillPageDimMembers((long)modelId, (SpreadManager)spreadModel, pageMemberMap);
            Map<DimTypesEnum, Object> commonParam = this.getCurrentReportCommonParam("number", true);
            DimensionCombination dimCombination = new DimensionCombination(modelId);
            String cellAtt = AttachmentTypeEnum.CELL.getNumber();
            HashMap idMap = new HashMap(16);
            spreadModel.getAreaManager().getPostionInfoSet().forEach(e -> spreadModel.getBook().getSheet(0).iteratorRangeCells(new RangeModel(e.getAreaRange()), cell -> {
                Map cellDimMemberMap;
                if (cell.isMdDataDomain() && ((Boolean)cell.getUserObject("setCornerMark", (Object)false)).booleanValue() && MapUtils.isNotEmpty((Map)(cellDimMemberMap = SpreadMemberUtil.getCellDimMemberMap((Map)pageMemberMap, (String)orgNum, (Map)commonParam, (Cell)cell, (long)modelId, (boolean)false)))) {
                    SpreadMemberUtil.dealCellOrgDimMemMap((Map)cellDimMemberMap);
                    dimCombination.putAll(cellDimMemberMap);
                    String combineStr = dimCombination.getDimensionCombineStr();
                    Set objects = (Set)cellMap.get(combineStr);
                    if (CollectionUtils.isNotEmpty((Collection)objects)) {
                        objects.forEach(o -> {
                            long id = o.getLong("id");
                            Map<String, Object> result = idMap.computeIfAbsent(id, k -> new HashMap(16));
                            if (MapUtils.isNotEmpty((Map)result) && result.get("cellatt") != null) {
                                List cells = (List)result.get("cellatt");
                                if (CollectionUtils.isNotEmpty((Collection)cells)) {
                                    cells.add(ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()));
                                }
                            } else {
                                result = AttachmentUtil.getAttachmentRow(o, ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), cellAtt);
                                idMap.put(id, result);
                                pairs.add(result);
                            }
                        });
                    }
                }
            }));
        }
    }

    private FlexPanelAp getFlexPanelAp(String key, int grow, String name, String overflow) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(key);
        flexPanelAp.setGrow(grow);
        flexPanelAp.setName(new LocaleString(name));
        flexPanelAp.setOverflow(overflow);
        return flexPanelAp;
    }

    @Override
    protected void initNewStylePageViewPanel() {
        FlexPanelAp fieldsetpanelap = this.getFlexPanelAp("fieldsetpanelap", 0, ResManager.loadKDString((String)"\u89c6\u70b9\u9875\u9762\u7ef4", (String)"AbstractMultiReportPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "visible");
        this.addReportDataFieldAp(fieldsetpanelap);
        FlexPanelAp morefieldsetpanelap = this.getFlexPanelAp("morefieldsetpanel", 0, ResManager.loadKDString((String)"\u66f4\u591a\u4fe1\u606f", (String)"AbstractMultiReportPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "visible");
        List<String> dims = this.getDimsForFlexPanelAp();
        this.addDimF7Display(fieldsetpanelap, morefieldsetpanelap, false, this.getTemplateModel().getPageDimensionEntries(), dims);
        this.addDimF7Display(fieldsetpanelap, morefieldsetpanelap, false, this.getTemplateModel().getPagePropEntries(), dims);
        this.addDimF7Display(fieldsetpanelap, morefieldsetpanelap, true, this.getTemplateModel().getViewPointDimensionEntries(), dims);
        this.addDimF7Display(fieldsetpanelap, morefieldsetpanelap, false, this.getTemplateModel().getFilterDimensionEntries(), dims);
        fieldsetpanelap.getItems().add(this.createVectorAp(this.getStyle(), REFRESH_CURRENTPAGE, "kdfont kdfont-shuaxin4"));
        this.getView().updateControlMetadata("fieldsetpanelap", fieldsetpanelap.createControl());
        this.getView().updateControlMetadata("morefieldsetpanel", morefieldsetpanelap.createControl());
        boolean isDisplayMore = this.isTrueFlagInCache("has_display_more");
        this.getView().setVisible(Boolean.valueOf(isDisplayMore), new String[]{"morefieldsetpanel"});
        this.cacheTrueOrFalseFlag("has_display_more", isDisplayMore);
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : fieldsetpanelap.getItems()) {
            if (!this.checkControlKeyPrefix(this.getView(), ap.getKey())) continue;
            sb.append(ap.getKey()).append(';');
        }
        for (ControlAp ap : morefieldsetpanelap.getItems()) {
            if (!this.checkControlKeyPrefix(this.getView(), ap.getKey())) continue;
            sb.append(ap.getKey()).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("f7MapFields", sb.toString());
    }

    private List<String> getDimsForFlexPanelAp() {
        return ReportWorkBenchUtil.getDimsForFlexPanelAp(this.getTemplateModel());
    }

    @Override
    protected void initEntryFieldStyle(FieldAp f7Field) {
        super.initEntryFieldStyle(f7Field);
    }

    private void addDimF7Display(FlexPanelAp fieldsetpanelap, FlexPanelAp morefieldsetpanelap, boolean locked, List<? extends BaseEntry> entries, List<String> dims) {
        for (BaseEntry baseEntry : entries) {
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setQuickAddNew(false);
            BasedataField baseDataField = new BasedataField();
            baseDataField.setViewDetail(false);
            f7Field.setName(new LocaleString(baseEntry.getDimension().getName()));
            f7Field.setLabelDirection("h");
            f7Field.setKey(this.sugarF7Key(baseEntry.getDimension().getMemberEntityNumber(), baseEntry.getDimension().getNumber()));
            this.initEntryFieldStyle((FieldAp)f7Field);
            if (locked) {
                f7Field.setLock("new,edit,view");
            }
            f7Field.setWidth(new LocaleString("200px"));
            int labelSize = baseEntry.getDimension().getName().length();
            f7Field.setLabelWidth(new LocaleString(12 * labelSize + "px"));
            f7Field.setFieldFontSize(12);
            f7Field.setFontSize(12);
            baseDataField.setKey(baseEntry.getDimension().getMemberEntityNumber());
            baseDataField.setBaseEntityId(baseEntry.getDimension().getMemberEntityNumber());
            f7Field.setField((Field)baseDataField);
            if (dims.contains(baseEntry.getDimension().getNumber())) {
                fieldsetpanelap.getItems().add(f7Field);
                continue;
            }
            morefieldsetpanelap.getItems().add(f7Field);
        }
    }

    private Style getStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("10px");
        margin.setLeft("10px");
        margin.setTop("5px");
        margin.setRight("-10px");
        style.setMargin(margin);
        return style;
    }

    private VectorAp createVectorAp(Style style, String key, String fontClass) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey(key);
        vectorAp.setStyle(style);
        vectorAp.setForeColor("#0000ff");
        vectorAp.setfontClass(fontClass);
        vectorAp.setFontSize(12);
        return vectorAp;
    }

    private void addReportDataFieldAp(FlexPanelAp fieldsetpanelap) {
        Style style = this.getStyle();
        VectorAp btnMore = this.createVectorAp(style, "show_more", "kdfont kdfont-shouqi7");
        fieldsetpanelap.getItems().add(btnMore);
        VectorAp btnLess = this.createVectorAp(style, "show_less", "kdfont kdfont-zhankai4");
        fieldsetpanelap.getItems().add(btnLess);
        boolean isDisplayMore = this.isTrueFlagInCache("has_display_more");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{isDisplayMore ? "show_more" : "show_less"});
        FieldAp comboEntryField = new FieldAp();
        ComboField comboField = new ComboField();
        comboField.setKey("shortcut_select");
        comboField.setName(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e", (String)"AbstractMultiReportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        comboField.setMustInput(false);
        comboEntryField.setName(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e", (String)"AbstractMultiReportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        comboEntryField.setKey("shortcut_select");
        comboEntryField.setFireUpdEvt(true);
        comboEntryField.setLabelDirection("h");
        comboField.setMustInput(true);
        this.initEntryFieldStyle(comboEntryField);
        comboEntryField.setFieldFontSize(12);
        comboEntryField.setFontSize(12);
        comboEntryField.setField((Field)comboField);
        fieldsetpanelap.getItems().add(comboEntryField);
    }

    @Override
    protected void invokeAddOrRemove(NotifyEvent e) {
        super.invokeAddOrRemove(e);
        if (TABAPREPORT.equals(this.getPageCache().get(BASETABAP_SELECT))) {
            this.loadAreaMsg();
        }
    }

    @Override
    protected boolean isWorkBench() {
        return true;
    }

    protected boolean checkReportIsChange(String key) {
        WorkBenchButtonEnum buttonEnum = WorkBenchButtonEnum.getEnumByNumber((String)key);
        if (buttonEnum != null && WorkBenchButtonEnum.BTN_CHECKUPCHK != buttonEnum && buttonEnum.isModifyData() && this.isModified()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62a5\u8868\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"WorkBenchReportEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        try {
            if (!WorkBenchButtonEnum.BTN_SAVE.getNumber().equals(evt.getItemKey()) && !WorkBenchButtonEnum.BTN_ALLCLEAN.getNumber().equals(evt.getItemKey())) {
                if (this.checkReportIsChange(evt.getItemKey())) {
                    return;
                }
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5904\u7406\u4e2d...", (String)"AbstractMultiReportPlugin_144", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
            super.itemClick(evt);
            if (WorkBenchButtonEnum.BTN_DELETE.getNumber().equals(evt.getItemKey())) {
                this.actionDelete();
            }
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getView().showTipNotification(e.getMessage());
            } else {
                this.getView().showTipNotification("Internal system exception, please contact operations for handling.");
                log.error(ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)20));
            }
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void actionDelete() {
        ReportTabInfo tabInfo = this.getCurrentReportTabInfo();
        if (tabInfo == null || tabInfo.getReportId() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6709\u7f16\u5236\u8bb0\u5f55\u7684\u62a5\u8868\u3002", (String)"WorkBenchReportEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isDataLockOpen = OlapServiceHelper.checkMeasure((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)FacTabFieldDefEnum.FIELD_LOCK.getField());
        if (isDataLockOpen) {
            QFilter filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)tabInfo.getReportId()));
            filter.and("reportstatus", "=", (Object)ReportStatusEnum.COMMIT.status());
            if (QueryServiceHelper.exists((String)"bcm_reportlistentity", (QFilter[])filter.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4e0a\u62a5\u7684\u62a5\u8868\u4e0d\u5141\u8bb8\u6267\u884c\u72b6\u6001\u91cd\u7f6e\u3002", (String)"ReportListPlugin_164", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5bf9\u5df2\u9009\u62a5\u8868\u72b6\u6001\u91cd\u7f6e\uff08\u6309\u6a21\u677f\u8bbe\u7f6e\u66f4\u65b0\u62a5\u8868\uff09\uff1f\r\n\u6709\u7ef4\u5ea6\u62a5\u8868\uff1a\u7f16\u5236\u4e2d\u7684\u62a5\u8868\u4f1a\u88ab\u91cd\u7f6e\u4e3a\u672a\u7f16\u5236\u72b6\u6001\uff1b\u7f16\u5236\u5b8c\u6210\u548c\u5df2\u4e0a\u62a5\u7684\u62a5\u8868\u4e0d\u4f1a\u66f4\u65b0\u62a5\u8868\u72b6\u6001\uff0c\u4f46\u4f1a\u66f4\u65b0\u8868\u6837\u8bbe\u7f6e\u3001\u4fdd\u7559\u7ef4\u5ea6\u6570\u636e\u3002\r\n\u65e0\u7ef4\u5ea6\u62a5\u8868\uff1a\u7f16\u5236\u4e2d\u7684\u62a5\u8868\u4f1a\u88ab\u91cd\u7f6e\u4e3a\u672a\u7f16\u5236\u72b6\u6001\uff0c\u66f4\u65b0\u8868\u6837\u8bbe\u7f6e\u3001\u6e05\u7a7a\u8868\u6837\u6570\u636e\uff1b\u7f16\u5236\u5b8c\u6210\u548c\u5df2\u4e0a\u62a5\u7684\u62a5\u8868\u4e0d\u5141\u8bb8\u72b6\u6001\u91cd\u7f6e\u3002", (String)"ReportListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(WorkBenchButtonEnum.BTN_DELETE.getNumber()));
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (WorkBenchButtonEnum.BTN_DELETE.getNumber().equals(callBackId) && MessageBoxResult.Yes == e.getResult()) {
            this.doActionDelete();
        }
    }

    private void doActionDelete() {
        boolean isSuccess = true;
        try {
            ReportRecordHelper.delReportRecord((Long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getReportId()));
            if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isDeleteChkReportWithReset")) {
                this.resetChkCheckStatus();
            }
            this.reLoadReport();
            this.updateReportStatusToMainPage();
        }
        catch (Exception e) {
            isSuccess = false;
        }
        this.writeWorkBenchLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)WorkBenchButtonEnum.BTN_DELETE.getBridge(), (String)WorkBenchButtonEnum.BTN_DELETE.getNumber()), isSuccess);
    }

    private void writeWorkBenchLog(OpNameMultiLangEnumBridge opBridge, boolean isSuccess) {
        String orgNumber = (String)this.getCurrentReportCommonParam("number").get(DimTypesEnum.ENTITY);
        String orgName = (String)this.getCurrentReportCommonParam("name").get(DimTypesEnum.ENTITY);
        String yearName = null;
        String periodName = null;
        try {
            yearName = (String)this.getCurrentReportCommonParam("name").get(DimTypesEnum.YEAR);
        }
        catch (Throwable e) {
            Map yearMap = (Map)this.getCurrentReportCommonParam("name").get(DimTypesEnum.YEAR);
            yearName = WorkBenchReportEditPlugin.getCommonLocaleName(yearName, yearMap);
        }
        try {
            periodName = (String)this.getCurrentReportCommonParam("name").get(DimTypesEnum.PERIOD);
        }
        catch (Throwable e) {
            Map periodMap = (Map)this.getCurrentReportCommonParam("name").get(DimTypesEnum.PERIOD);
            periodName = WorkBenchReportEditPlugin.getCommonLocaleName(periodName, periodMap);
        }
        this.writeMultiLangLog(opBridge, new OPDescMultiLangEnumBridge("%1$s %2$s %3$s %4$s %5$s %6$s,%7$s%8$s", "AbstractMultiReportPlugin_125", "fi-bcm-formplugin", new String[]{orgNumber, orgName, yearName, periodName, this.getTemplateModel().getNumber(), this.getTemplateModel().getName(), opBridge.getDescription(), isSuccess ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName()}));
    }

    private void reLoadReport() {
        ReportTabInfo tabInfo;
        this.rememberPageViewDimFilter();
        if (this.getModel().getValue("shortcut_select") != null) {
            ThreadCache.put((Object)"shortcut_select_callclean", (Object)this.getModel().getValue("shortcut_select"));
        }
        if ((tabInfo = this.getCurrentReportTabInfo()) != null) {
            boolean flag = this.setRightTempalteId(tabInfo);
            if (!flag) {
                return;
            }
            tabInfo.setReportListModifier(0L);
            tabInfo.setReportListModifytime(null);
            tabInfo.setReportListId(0L);
            tabInfo.setReportId(null);
            this.cacherReportTabManager();
        }
        this.loadSpread();
    }

    private void resetChkCheckStatus() {
        Map<String, Pair<Long, String>> param4Pair = this.getCurrentReportCommonParam4Pair();
        if (param4Pair == null) {
            log.warn("getCurrentReportCommonParam4Pair return null!");
            return;
        }
        CalContext ctx = new CalContext(this.getModelNumber(), Long.valueOf(this.getModelId()), (Long)param4Pair.get((Object)DimTypesEnum.YEAR.getNumber()).p1, (Long)param4Pair.get((Object)DimTypesEnum.PERIOD.getNumber()).p1, (Long)param4Pair.get((Object)DimTypesEnum.SCENARIO.getNumber()).p1);
        ctx.setProperty("currencyId", param4Pair.get((Object)DimTypesEnum.CURRENCY.getNumber()).p1);
        ctx.setProperty("org2TempNums", (Object)MapInitHelper.ofMap((Object)param4Pair.get((Object)DimTypesEnum.ENTITY.getNumber()).p2, (Object)Lists.newArrayList((Object[])new String[]{this.getTemplateModel().getNumber()})));
        ctx.setProperty("currency", param4Pair.get((Object)DimTypesEnum.CURRENCY.getNumber()).p2);
        ctx.setProperty("year", param4Pair.get((Object)DimTypesEnum.YEAR.getNumber()).p2);
        ctx.setProperty("period", param4Pair.get((Object)DimTypesEnum.PERIOD.getNumber()).p2);
        try (TXHandle tx = TX.required();){
            try {
                ChkCheckStatusHelper.resetCheckStatus((ICalContext)ctx);
            }
            catch (Throwable e) {
                tx.setRollback(true);
                log.error("resetCheckStatus error!", e);
            }
        }
    }
}

