/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.workBench.util;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.chkcheck.model.DimensionCombination;
import kd.fi.bcm.common.enums.report.AttachmentTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AttachmentUtil {
    public static final String DIMENSIONSTR = "dimensionstr";
    public static final String ATTENTRYENTITY_ATTNAME = "attname";
    public static final String ATTENTRYENTITY_ATTUID = "uid";
    public static final String ATTENTRYENTITY_ATTTYPE = "atttype";
    public static final String ATTENTRYENTITY_CELLATT = "cellatt";
    public static final String ATTENTRYENTITY_UPLOADUSER = "uploaduser";
    public static final String ATTENTRYENTITY_UPLOADTIME = "uploadtime";

    public static DynamicObjectCollection getAttachmentDynamicObjects(QFilter qFilter) {
        return QueryServiceHelper.query((String)"bcm_chkattachment", (String)"id,uid,modifydate,modifier.name,name,noteinfo.id,noteinfo.dimensionstr", (QFilter[])qFilter.toArray());
    }

    public static List<String> getAttUrls(QFilter qFilter) {
        ArrayList<String> urls = new ArrayList<String>(16);
        QueryServiceHelper.query((String)"bcm_chkattachment", (String)"url", (QFilter[])qFilter.toArray()).forEach(o -> urls.add(o.getString("url")));
        return urls;
    }

    public static DynamicObject getCHKNoteInfo(long modelId, long templateId, Map<String, Long> filterMap, DimensionCombination combination, boolean isReportAtt) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (isReportAtt) {
            if (MapUtils.isEmpty(filterMap)) {
                return null;
            }
            qFilter.and(AttachmentUtil.getAttachmentReportFilter(filterMap, templateId, false));
        } else {
            if (combination == null) {
                return null;
            }
            qFilter.and(DIMENSIONSTR, "=", (Object)combination.getDimensionCombineStr());
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_chknoteinfo", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dy == null) {
            dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chknoteinfo");
            dy.set("id", (Object)DB.genGlobalLongId());
            dy.set("model", (Object)modelId);
            dy.set("attachmenttype", (Object)(isReportAtt ? AttachmentTypeEnum.REPORT.getNumber() : AttachmentTypeEnum.CELL.getNumber()));
            dy.set("template", (Object)templateId);
            if (isReportAtt) {
                dy.set("scene", (Object)filterMap.get("bcm_scenemembertree"));
                dy.set("year", (Object)filterMap.get("bcm_fymembertree"));
                dy.set("period", (Object)filterMap.get("bcm_periodmembertree"));
                dy.set("currency", (Object)filterMap.get("bcm_currencymembertree"));
                dy.set("entity", (Object)filterMap.get("bcm_entitymembertree"));
            } else {
                dy.set(DIMENSIONSTR, (Object)combination.getDimensionCombineStr());
                dy.set("dimensionsum", (Object)combination.keySet().size());
            }
        }
        return dy;
    }

    public static QFilter getAttachmentReportFilter(Map<String, Long> filterMap, long templateId, boolean isDetails) {
        String key = isDetails ? "noteinfo." : "";
        return new QFilter(key + "template", "=", (Object)templateId).and(key + "scene", "=", (Object)filterMap.get("bcm_scenemembertree")).and(key + "year", "=", (Object)filterMap.get("bcm_fymembertree")).and(key + "period", "=", (Object)filterMap.get("bcm_periodmembertree")).and(key + "currency", "=", (Object)filterMap.get("bcm_currencymembertree")).and(key + "entity", "=", (Object)filterMap.get("bcm_entitymembertree"));
    }

    public static Map<String, Object> getAttachmentRow(DynamicObject o, String cellMsg, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(ATTENTRYENTITY_ATTNAME, o.getString("name"));
        map.put(ATTENTRYENTITY_ATTTYPE, message);
        map.put(ATTENTRYENTITY_CELLATT, StringUtils.isNotEmpty((CharSequence)cellMsg) ? Lists.newArrayList((Object[])new String[]{cellMsg}) : null);
        map.put(ATTENTRYENTITY_UPLOADUSER, o.getString("modifier.name"));
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        map.put(ATTENTRYENTITY_UPLOADTIME, formate.format(o.getDate("modifydate")));
        map.put(ATTENTRYENTITY_ATTUID, o.getString(ATTENTRYENTITY_ATTUID));
        return map;
    }

    private static void saveAttachmentData(Map<String, Object> url, DynamicObject noteInfo, String urlstr) {
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        dynObj.set("fBillType", (Object)"bcm_chknoteinfo");
        dynObj.set("fnumber", url.get(ATTENTRYENTITY_ATTUID));
        dynObj.set("fInterID", noteInfo.get("id"));
        dynObj.set("fFileId", (Object)urlstr);
        dynObj.set("fAttachmentName", url.get("name"));
        dynObj.set("fExtName", url.get("type"));
        dynObj.set("fAttachmentSize", url.get("size"));
        dynObj.set("FBillStatus", (Object)"A");
        dynObj.set("fCreateMen_Id", url.get("creator"));
        dynObj.set("fCreateTime", url.get("createdate"));
        dynObj.set("fModifyMen_Id", url.get("creator"));
        dynObj.set("fModifyTime", url.get("lastModified"));
        dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    public static boolean saveAttachmentDataForReport(List<Map<String, Object>> urls, DynamicObject noteInfo) {
        if (CollectionUtils.isEmpty(urls) || noteInfo == null) {
            return false;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (Map<String, Object> url : urls) {
            String tempurl = url.get("url").toString();
            String tempName = url.get("name").toString();
            String urlstr = AttachmentServiceHelper.saveTempToFileService((String)tempurl, (String)"bcm", (String)"bcm_chknoteinfo", (Object)noteInfo.getLong("id"), (String)tempName);
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkattachment");
            dy.set("id", (Object)DB.genGlobalLongId());
            dy.set("noteinfo", (Object)noteInfo);
            dy.set("modifydate", (Object)TimeServiceHelper.now());
            dy.set("modifier", (Object)RequestContext.getOrCreate().getUserId());
            dy.set("name", url.get("name"));
            dy.set("size", url.get("size"));
            dy.set(ATTENTRYENTITY_ATTUID, url.get(ATTENTRYENTITY_ATTUID));
            dy.set("url", (Object)urlstr);
            dy.set("type", url.get("type"));
            dy.set("description", url.get("description"));
            list.add(dy);
            AttachmentUtil.saveAttachmentData(url, noteInfo, urlstr);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noteInfo});
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        return true;
    }
}

