/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.report.workBench.util;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.serviceHelper.ReportRecordHelper;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.business.template.model.BaseEntry;
import kd.fi.bcm.business.template.model.ReportEditStatus;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusEnum;
import kd.fi.bcm.common.enums.report.WorkBenchButtonEnum;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.BCMOperationResult;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanByEntity;
import kd.fi.bcm.formplugin.report.workBench.WorkBenchContext;
import kd.fi.bcm.spread.common.TemplateConstant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportWorkBenchUtil {
    public static final Set<String> COMMONDIM = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.ENTITY.getNumber()});
    public static String CUSTOMSTATUS = "customstatus";
    public static String INITCUSTOMSTATUSTABS = "initCustomStatusTabs";

    public static Set<String> getSelectTabs(Map<String, Object> paramMap) {
        HashSet<String> tabs = new HashSet<String>(16);
        if (paramMap != null && paramMap.get("selectTabs") != null) {
            tabs.addAll((List)paramMap.get("selectTabs"));
        }
        return tabs;
    }

    public static List<Long> getIdsBySelectTabs(List<ReportTabInfo> tabInfos, Set<String> tabs, boolean isTemplate) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(tabInfos) && CollectionUtils.isNotEmpty(tabs)) {
            tabInfos.forEach(t -> {
                if (tabs.contains(t.getTabKey())) {
                    long id = 0L;
                    if (isTemplate) {
                        id = LongUtil.toLong((Object)t.getTemplateId());
                    } else if (t.getReportId() != null) {
                        id = LongUtil.toLong((Object)t.getReportId());
                    }
                    if (id != 0L) {
                        ids.add(id);
                    }
                }
            });
        }
        return ids;
    }

    public static List<Long> getIdsBySelectTabs(List<ReportTabInfo> tabInfos, Map<String, Object> paramMap, boolean isTemplate) {
        return ReportWorkBenchUtil.getIdsBySelectTabs(tabInfos, ReportWorkBenchUtil.getSelectTabs(paramMap), isTemplate);
    }

    public static List<Pair<Object, Object>> getReportPairs(ReportEditStatus editStatus, List<String> status) {
        Map<Object, Object> map = new HashMap(16);
        boolean hasUnWean = status.contains(ReportStatusEnum.UNWEAVE.status());
        ArrayList<Pair<Object, Object>> pairs = new ArrayList<Pair<Object, Object>>(16);
        if (CollectionUtils.isNotEmpty((Collection)editStatus.getExitRecordTemplates()) && CollectionUtils.isNotEmpty(status) && (!hasUnWean || status.size() != 1)) {
            QFilter qFilter = new QFilter("model", "=", (Object)editStatus.getModelId());
            qFilter.and("fyear", "=", (Object)editStatus.getYearId());
            qFilter.and("period", "=", (Object)editStatus.getPeriodId());
            qFilter.and("scene", "=", (Object)editStatus.getScenarioId());
            qFilter.and("entity", "=", (Object)editStatus.getOrgId());
            qFilter.and("currency", "=", (Object)editStatus.getCurrencyId());
            qFilter.and("template", "in", (Object)editStatus.getExitRecordTemplates());
            qFilter.and("reportstatus", "in", status);
            map = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template.id", (QFilter[])qFilter.toArray()).stream().collect(Collectors.toMap(d -> d.getLong("template.id"), v -> v.getLong("id"), (v1, v2) -> v1));
        }
        HashSet ids = new HashSet(16);
        status.forEach(s -> {
            switch (ReportStatusEnum.getStatusEnumBy((String)s)) {
                case UNWEAVE: {
                    ids.addAll(editStatus.getUnweaveTemplates());
                    break;
                }
                case WEAVING: {
                    ids.addAll(editStatus.getWeavingTemplates());
                    break;
                }
                case COMPLETE: {
                    ids.addAll(editStatus.getCompleteTemplates());
                    break;
                }
                case COMMIT: {
                    ids.addAll(editStatus.getCommitTemplates());
                    break;
                }
                case BACK: {
                    ids.addAll(editStatus.getBackTemplates());
                    break;
                }
                case BACKAPPLY: {
                    ids.addAll(editStatus.getBackapplyTemplates());
                    break;
                }
            }
        });
        if (CollectionUtils.isEmpty(ids)) {
            return pairs;
        }
        ArrayList templateIds = new ArrayList(16);
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("id,sequence,number,versionnumber", "in", ids)}, (String)TemplateUtil.getListEntryOrderBy((boolean)true)).forEach(t -> templateIds.add(t.getLong("id")));
        for (Long id : templateIds) {
            long reportId = 0L;
            if (map.get(id) != null) {
                reportId = (Long)map.get(id);
            } else if (!hasUnWean) continue;
            pairs.add((Pair<Object, Object>)Pair.onePair((Object)id, (Object)reportId));
        }
        return pairs;
    }

    public static List<String> getSelectReportStatus(Object value) {
        ArrayList<String> status = new ArrayList<String>(16);
        if (value != null && StringUtils.isNotEmpty((CharSequence)value.toString())) {
            String[] split;
            for (String r : split = value.toString().split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)r)) continue;
                status.add(r);
            }
        }
        return status;
    }

    public static ReportPostmanByEntity fillReportPostmanByEntity(ReportPostmanByEntity postman, long baseOrg, long cataLogId, Object reportStatus) {
        List<String> status = ReportWorkBenchUtil.getSelectReportStatus(reportStatus);
        if (CollectionUtils.isEmpty(status)) {
            return null;
        }
        Set templateIds = TemplatePermCrossUtil.getTemplatesByCataLog((long)((Long)postman.getModelPK()), (long)cataLogId);
        if (CollectionUtils.isEmpty((Collection)templateIds)) {
            return null;
        }
        RightVersionTemplateParams params = new RightVersionTemplateParams(((Long)postman.getModelPK()).longValue(), ((Long)postman.getEntityPK(null)).longValue(), ((Long)postman.getScenarioPK()).longValue(), ((Long)postman.getYearPK()).longValue(), ((Long)postman.getPeriodPK()).longValue(), ((Long)postman.getCurrencyPK()).longValue(), RequestContext.get().getCurrUserId());
        params.setTemplateIds(templateIds);
        ReportEditStatus editStatus = (ReportEditStatus)TemplateUtil.getCommitReportCount((RightVersionTemplateParams)params).get(baseOrg);
        if (editStatus == null || CollectionUtils.isEmpty((Collection)editStatus.getAllTemplates())) {
            return null;
        }
        List<Pair<Object, Object>> pairs = ReportWorkBenchUtil.getReportPairs(editStatus, status);
        if (CollectionUtils.isEmpty(pairs)) {
            return null;
        }
        postman.getPairs().addAll(pairs);
        return postman;
    }

    public static DataCollectRecordEnum getDataCollectStatus(long modelId, long orgId, long scenarioId, long fyId, long periodId, long templateId) {
        return (DataCollectRecordEnum)ThreadCache.get((Object)String.join((CharSequence)"_", "getDataCollectStatus", modelId + "", orgId + "", scenarioId + "", fyId + "", periodId + "", templateId + ""), () -> ReportWorkBenchUtil.getDataCollectStatus(modelId, orgId, scenarioId, fyId, periodId, Collections.singleton(templateId)).get(templateId));
    }

    public static Map<Long, DataCollectRecordEnum> getDataCollectStatus(long modelId, long orgId, long scenarioId, long fyId, long periodId, Set<Long> templateIds) {
        HashMap<Long, DataCollectRecordEnum> result = new HashMap<Long, DataCollectRecordEnum>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("scenario", "=", (Object)scenarioId);
        qFilter.and("fy", "=", (Object)fyId);
        qFilter.and("period", "=", (Object)periodId);
        qFilter.and("org", "=", (Object)orgId);
        qFilter.and("template", "in", templateIds);
        QueryServiceHelper.query((String)"bcm_datacollect", (String)"collectstatus,template", (QFilter[])qFilter.toArray()).forEach(o -> result.put(o.getLong("template"), DataCollectRecordEnum.getEnumByIndex((String)o.getString("collectstatus"))));
        templateIds.forEach(id -> {
            if (!result.containsKey(id)) {
                result.put((Long)id, DataCollectRecordEnum.TOEXCUTE);
            }
        });
        return result;
    }

    public static ChkStatusEnum getChkStatusEnum(long modelId, long orgId, long scenarioId, long fyId, long periodId, long currencyId, String templateNum, long cslId) {
        return (ChkStatusEnum)ThreadCache.get((Object)String.join((CharSequence)"_", "getChkStatusEnum", modelId + "", orgId + "", scenarioId + "", fyId + "", periodId + "", currencyId + "", templateNum), () -> ReportWorkBenchUtil.getChkStatusEnum(modelId, orgId, scenarioId, fyId, periodId, currencyId, Collections.singleton(templateNum), cslId).get(templateNum));
    }

    public static Map<String, ChkStatusEnum> getChkStatusEnum(long modelId, long orgId, long scenarioId, long fyId, long periodId, long currencyId, Set<String> nums, long cslId) {
        HashMap<String, ChkStatusEnum> result = new HashMap<String, ChkStatusEnum>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("org", "=", (Object)orgId);
        qFilter.and("scenario", "=", (Object)scenarioId);
        qFilter.and("year", "=", (Object)fyId);
        qFilter.and("period", "=", (Object)periodId);
        qFilter.and("currency", "=", (Object)currencyId);
        qFilter.and("cslscheme", "in", Arrays.asList(cslId, 0L));
        qFilter.and("tmp.number", "in", nums);
        QueryServiceHelper.query((String)"bcm_status", (String)"checkedstatus,tmp.number", (QFilter[])qFilter.toArray()).forEach(o -> result.put(o.getString("tmp.number"), ChkStatusEnum.getStatusEnum((int)o.getInt("checkedstatus"))));
        nums.forEach(n -> {
            if (!result.containsKey(n)) {
                result.put((String)n, ChkStatusEnum.UNCHECK);
            }
        });
        return result;
    }

    public static void fillOtherCols(long modelId, long orgId, long scenarioId, long fyId, long periodId, long currencyId, long cslId, List<Map<String, Object>> maps, String actionId) {
        if ("btn_bat_checkupchk".equals(actionId)) {
            HashSet<String> nums = new HashSet<String>(16);
            maps.forEach(m -> nums.add((String)m.get("number")));
            Map<String, ChkStatusEnum> enumMap = ReportWorkBenchUtil.getChkStatusEnum(modelId, orgId, scenarioId, fyId, periodId, currencyId, nums, cslId);
            maps.forEach(m -> {
                m.remove("id");
                String num = (String)m.remove("number");
                ChkStatusEnum chkStatusEnum = ChkStatusEnum.UNCHECK;
                if (StringUtils.isNotEmpty((CharSequence)num) && enumMap.get(num) != null) {
                    chkStatusEnum = (ChkStatusEnum)enumMap.get(num);
                }
                m.put("chkresult", chkStatusEnum.getText(false));
            });
        } else if ("btn_bat_datacollect".equals(actionId)) {
            HashSet<Long> ids = new HashSet<Long>(16);
            maps.forEach(m -> ids.add(LongUtil.toLong(m.get("id"))));
            Map<Long, DataCollectRecordEnum> dcStatusMap = ReportWorkBenchUtil.getDataCollectStatus(modelId, orgId, scenarioId, fyId, periodId, ids);
            boolean flag = MapUtils.isNotEmpty(dcStatusMap);
            maps.forEach(m -> {
                DataCollectRecordEnum anEnum;
                m.remove("number");
                long id = LongUtil.toLong(m.remove("id"));
                DataCollectRecordEnum dataCollectRecordEnum = anEnum = flag ? (DataCollectRecordEnum)dcStatusMap.get(id) : DataCollectRecordEnum.TOEXCUTE;
                if (anEnum == null) {
                    anEnum = DataCollectRecordEnum.TOEXCUTE;
                }
                m.put("datacollectstatus", anEnum.getValue());
            });
        } else {
            maps.forEach(m -> {
                m.remove("id");
                m.remove("number");
            });
        }
    }

    public static Map<Long, DynamicObject> queryTemplates(Collection<Long> ids, String selectFields) {
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id,name,number,versionnumber,issavebydim";
        }
        return QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "in", ids).toArray()).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    public static List<Map<String, Object>> getReportTMapsFromTab(List<ReportTabInfo> tabs, List<ReportStatusEnum> statusEnums, String actionId, boolean isLeafEntity) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        if (CollectionUtils.isEmpty(tabs)) {
            return maps;
        }
        HashSet reportIds = new HashSet(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        tabs.forEach(t -> {
            if (t.getReportId() != null) {
                reportIds.add(LongUtil.toLong((Object)t.getReportId()));
            }
            ids.add(LongUtil.toLong((Object)t.getTemplateId()));
        });
        boolean isNeedCatalog = StringUtils.isNotEmpty((CharSequence)actionId);
        Map<Object, Object> statusMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty(reportIds)) {
            QFilter qFilter = new QFilter("id", "in", reportIds);
            statusMap = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,reportstatus", (QFilter[])qFilter.toArray()).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        }
        String selectFields = isNeedCatalog ? "id,name,versionnumber,number,templatecatalog.id,issavebydim" : "id,name,versionnumber,issavebydim";
        Map<Long, DynamicObject> templateMap = ReportWorkBenchUtil.queryTemplates(ids, selectFields);
        for (ReportTabInfo tab : tabs) {
            DynamicObject object;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("tabkey", tab.getTabKey());
            map.put("template", tab.getTabName());
            long templateId = LongUtil.toLong((Object)tab.getTemplateId());
            DynamicObject tempDyo = templateMap.get(templateId);
            if (tempDyo == null) continue;
            if (isNeedCatalog) {
                map.put("pid", tempDyo.getLong("templatecatalog.id"));
                map.put("id", templateId);
                map.put("number", tempDyo.getString("number"));
            }
            BigDecimal decimal = tempDyo.getBigDecimal("versionnumber");
            String version = "";
            if (decimal != null) {
                version = String.format("V%.1f", Float.valueOf(decimal.floatValue()));
            }
            map.put("version", version);
            Object reportId = tab.getReportId();
            ReportStatusEnum reportStatusEnum = ReportStatusEnum.UNWEAVE;
            if (reportId != null && (object = (DynamicObject)statusMap.get(LongUtil.toLong((Object)reportId))) != null) {
                reportStatusEnum = ReportStatusEnum.getStatusEnumBy((String)object.getString("reportstatus"));
            }
            if (CollectionUtils.isNotEmpty(statusEnums) && !statusEnums.contains(reportStatusEnum)) continue;
            map.put("reportstatus", reportStatusEnum.text());
            if (INITCUSTOMSTATUSTABS.equals(actionId)) {
                map.put(CUSTOMSTATUS, reportStatusEnum.status());
            }
            if (WorkBenchButtonEnum.BTN_BAT_DELETE.getNumber().equals(actionId) ? !tempDyo.getBoolean("issavebydim") && (ReportStatusEnum.COMPLETE == reportStatusEnum || ReportStatusEnum.COMMIT == reportStatusEnum) : WorkBenchButtonEnum.BTN_BAT_DATACOLLECT.getNumber().equals(actionId) && !isLeafEntity && tempDyo.getBoolean("issavebydim")) continue;
            maps.add(map);
        }
        return maps;
    }

    private static boolean fillTemplateCatalogTreeEntryEntity(DynamicObjectCollection result, EntryType entityType, Map<Long, List<Long>> parentCataLogMap, Map<Long, DynamicObject> dyoMap, Map<Long, List<Map<String, Object>>> cataLogToTemMap, Set<Long> idSet, long id) {
        if (idSet.contains(id) || dyoMap.get(id) == null) {
            return false;
        }
        idSet.add(id);
        List<Map<String, Object>> list = cataLogToTemMap.get(id);
        if (CollectionUtils.isEmpty(list)) {
            List<Long> cataLogs = parentCataLogMap.get(id);
            if (CollectionUtils.isEmpty(cataLogs)) {
                return false;
            }
            ReportWorkBenchUtil.addSingleRowDynamicObject(result, entityType, dyoMap.get(id));
            boolean flag = true;
            for (Long cataLog : cataLogs) {
                if (!ReportWorkBenchUtil.fillTemplateCatalogTreeEntryEntity(result, entityType, parentCataLogMap, dyoMap, cataLogToTemMap, idSet, cataLog)) continue;
                flag = false;
            }
            if (flag) {
                result.removeIf(p -> p.getLong("id") == id);
            }
        } else {
            ReportWorkBenchUtil.addSingleRowDynamicObject(result, entityType, dyoMap.get(id));
            list.forEach(s -> ReportWorkBenchUtil.addSingleRowDynamicObject(result, entityType, s));
        }
        return true;
    }

    public static void buildTreeEntryEntity(IFormView view, long modelId, long templateCataLogId, List<Map<String, Object>> maps) {
        if (CollectionUtils.isNotEmpty(maps)) {
            List list;
            HashMap parentCataLogMap = new HashMap(16);
            HashMap dyoMap = new HashMap(16);
            TemplatePermCrossUtil.getCatalogDyos((long)modelId).forEach(d -> {
                parentCataLogMap.computeIfAbsent(d.getLong(TemplateConstant.PARENT), k -> new ArrayList(16)).add(d.getLong("id"));
                dyoMap.put(d.getLong("id"), d);
            });
            DynamicObject object = (DynamicObject)dyoMap.get(templateCataLogId);
            if (object == null) {
                return;
            }
            DynamicObjectCollection result = new DynamicObjectCollection();
            HashMap cataLogToTemMap = new HashMap(16);
            maps.forEach(m -> cataLogToTemMap.computeIfAbsent(LongUtil.toLong(m.get("pid")), k -> new ArrayList(16)).add(m));
            EntryType entityType = (EntryType)view.getModel().getDataEntityType().getAllEntities().get("treeentryentity");
            result.add((Object)ReportWorkBenchUtil.createRowDyo(entityType, object, false));
            List ids = (List)parentCataLogMap.get(templateCataLogId);
            HashSet idSet = new HashSet(16);
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                ids.forEach(id -> ReportWorkBenchUtil.fillTemplateCatalogTreeEntryEntity(result, entityType, parentCataLogMap, dyoMap, cataLogToTemMap, idSet, id));
            }
            if (CollectionUtils.isNotEmpty((Collection)(list = (List)cataLogToTemMap.get(templateCataLogId)))) {
                list.forEach(l -> ReportWorkBenchUtil.addSingleRowDynamicObject(result, entityType, l));
            }
            TreeEntryGrid treeEntry = (TreeEntryGrid)view.getControl("treeentryentity");
            int[] re = new int[result.size() - 1];
            for (int i = 0; i < result.size(); ++i) {
                view.getModel().createNewEntryRow("treeentryentity", i, (DynamicObject)result.get(i));
                if (i == 0) continue;
                re[i - 1] = i;
            }
            treeEntry.setCollapse(false);
            treeEntry.collapse(re);
            treeEntry.selectRows(0);
        }
    }

    private static Set<String> getProperties() {
        return Sets.newHashSet((Object[])new String[]{"id", "pid", "template", "tabkey", "version", "sheetname", "reportstatus", "chkresult", "datacollectstatus"});
    }

    private static void addSingleRowDynamicObject(DynamicObjectCollection result, EntryType entityType, Object object) {
        if (object instanceof Map) {
            DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
            rowObj.beginInit();
            Map map = (Map)object;
            ReportWorkBenchUtil.getProperties().forEach(col -> {
                Object val = map.get(col);
                if (val != null) {
                    rowObj.set(col, val);
                }
            });
            rowObj.endInit();
            result.add((Object)rowObj);
        } else if (object instanceof DynamicObject) {
            result.add((Object)ReportWorkBenchUtil.createRowDyo(entityType, (DynamicObject)object, true));
        }
    }

    private static DynamicObject createRowDyo(EntryType entityType, DynamicObject cataLogDyo, boolean updateView) {
        DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
        if (updateView) {
            rowObj.beginInit();
        }
        rowObj.set("pid", (Object)cataLogDyo.getLong("parent"));
        rowObj.set("id", (Object)cataLogDyo.getLong("id"));
        rowObj.set("template", (Object)cataLogDyo.getString("name"));
        rowObj.set("version", (Object)"");
        if (updateView) {
            rowObj.endInit();
        }
        return rowObj;
    }

    public static void updateEntryEntity(List<Map<String, Object>> pairs, IFormView formView, long modelId, String entityName) {
        formView.getModel().deleteEntryData(entityName);
        if (CollectionUtils.isNotEmpty(pairs)) {
            if (modelId == 0L) {
                formView.getModel().batchCreateNewEntryRow(entityName, pairs.size());
                for (int i = 0; i < pairs.size(); ++i) {
                    for (Map.Entry<String, Object> entry : pairs.get(i).entrySet()) {
                        formView.getModel().setValue(entry.getKey(), entry.getValue(), i);
                    }
                }
            } else {
                long templateCataLogId = LongUtil.toLong((Object)pairs.get(0).get("id"));
                pairs.remove(0);
                ReportWorkBenchUtil.buildTreeEntryEntity(formView, modelId, templateCataLogId, pairs);
            }
        }
        formView.updateView(entityName);
    }

    public static List<String> getMultiDimsFromTemplate(TemplateModel tm) {
        ArrayList<String> dims = new ArrayList<String>(16);
        ReportWorkBenchUtil.addShowDims(tm.getPageDimensionEntries(), dims);
        ReportWorkBenchUtil.addShowDims(tm.getPagePropEntries(), dims);
        ReportWorkBenchUtil.addShowDims(tm.getFilterDimensionEntries(), dims);
        return dims;
    }

    private static void addShowDims(List<? extends BaseEntry> entries, List<String> dims) {
        if (CollectionUtils.isNotEmpty(entries)) {
            entries.forEach(e -> {
                String dimNum = e.getDimension().getNumber();
                if (!COMMONDIM.contains(dimNum)) {
                    dims.add(dimNum);
                }
            });
        }
    }

    public static List<String> getDimsForFlexPanelAp(TemplateModel tm) {
        List<String> dims = ReportWorkBenchUtil.getMultiDimsFromTemplate(tm);
        if (dims.size() > 3) {
            ArrayList<String> list = new ArrayList<String>(16);
            ReportWorkBenchUtil.addDefaultDims(dims, DimTypesEnum.PROCESS.getNumber(), list);
            ReportWorkBenchUtil.addDefaultDims(dims, DimTypesEnum.AUDITTRIAL.getNumber(), list);
            ReportWorkBenchUtil.addDefaultDims(dims, DimTypesEnum.INTERCOMPANY.getNumber(), list);
            int index = 3 - list.size();
            int size = dims.size();
            if (index > 0 && size > 0) {
                for (int i = 0; i < index; ++i) {
                    if (size <= i) continue;
                    list.add(dims.get(i));
                }
            }
            return list;
        }
        return dims;
    }

    private static void addDefaultDims(List<String> dims, String dimNum, List<String> list) {
        if (dims.remove(dimNum)) {
            list.add(dimNum);
        }
    }

    public static OperationResult delReportRecord(Set<Long> templateIds, WorkBenchContext context, IFormView view, WatchLogger log) {
        BCMOperationResult operationResult = new BCMOperationResult();
        if (CollectionUtils.isEmpty(templateIds)) {
            return operationResult;
        }
        HashSet reportIds = new HashSet(16);
        context.getTabs().forEach(t -> {
            if (templateIds.contains(LongUtil.toLong((Object)t.getTemplateId())) && t.getReportId() != null) {
                reportIds.add(LongUtil.toLong((Object)t.getReportId()));
            }
        });
        operationResult.setBillCount(templateIds.size());
        List<DataCollectRecordEnum> dataCollectRecordEnums = Arrays.asList(DataCollectRecordEnum.EXCUTING, DataCollectRecordEnum.READY);
        Map<Long, DataCollectRecordEnum> dataCollectRecordEnumMap = ReportWorkBenchUtil.getDataCollectStatus(context.getModelId(), context.getBaseOrg(), context.getScenarioId(), context.getFyId(), context.getPeriodId(), templateIds);
        HashSet<Long> failIds = new HashSet<Long>(16);
        HashSet<Long> failIdsLog = new HashSet<Long>(16);
        ArrayList<DynamicObject> sucessData = new ArrayList<DynamicObject>(16);
        ArrayList canDelIds = new ArrayList(16);
        ArrayList resetdataIDs = new ArrayList(16);
        Map<Long, DynamicObject> queriedTemplates = ReportWorkBenchUtil.queryTemplates(templateIds, "");
        ArrayList<String> templateNums = new ArrayList<String>(16);
        if (CollectionUtils.isNotEmpty(reportIds)) {
            QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template.id,template.number,template.name,template.versionnumber,template.issavebydim,reportstatus,entity.name", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)}).forEach(r -> {
                ReportStatusEnum statusEnum = ReportStatusEnum.getStatusEnumBy((String)r.getString("reportstatus"));
                long id = r.getLong("id");
                long templateId = r.getLong("template.id");
                if (dataCollectRecordEnums.contains(dataCollectRecordEnumMap.get(templateId))) {
                    failIdsLog.add(templateId);
                    return;
                }
                boolean flag = true;
                if (r.getBoolean("template.issavebydim")) {
                    if (ReportStatusEnum.COMPLETE == statusEnum || ReportStatusEnum.COMMIT == statusEnum) {
                        resetdataIDs.add(id);
                    } else {
                        canDelIds.add(id);
                    }
                } else if (ReportStatusEnum.COMPLETE == statusEnum || ReportStatusEnum.COMMIT == statusEnum) {
                    failIds.add(templateId);
                    flag = false;
                } else {
                    canDelIds.add(id);
                }
                if (flag) {
                    operationResult.putSuccessMsgMap(Long.toString(id), ReportRecordHelper.getSuccessMsgFromTemplate((DynamicObject)r));
                    templateNums.add(r.getString("template.number"));
                    sucessData.add((DynamicObject)r);
                    queriedTemplates.remove(templateId);
                }
            });
            canDelIds.forEach(arg_0 -> ((BCMOperationResult)operationResult).addSuccessPkId(arg_0));
            resetdataIDs.forEach(arg_0 -> ((BCMOperationResult)operationResult).addSuccessPkId(arg_0));
        }
        try (TXHandle tx = TX.required();){
            try {
                if (CollectionUtils.isNotEmpty(canDelIds)) {
                    MyTaskStatusHelper.synchronizeTaskStatusForPK((Object[])canDelIds.toArray(), (boolean)true);
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_reportentity"), (Object[])canDelIds.toArray());
                }
                ReportRecordHelper.resetData(resetdataIDs);
                ReportWorkBenchUtil.writeLog(view, operationResult, sucessData, context, failIds, failIdsLog, queriedTemplates);
                ReportWorkBenchUtil.resetChkCheckStatus(templateNums, context, log);
            }
            catch (Throwable e) {
                tx.markRollback();
                ReportWorkBenchUtil.addOperateErrorInfo(WorkBenchButtonEnum.BTN_BAT_DELETE.getText(), e.getMessage(), (OperationResult)operationResult, null);
                BCMOperationResult bCMOperationResult = operationResult;
                if (tx != null) {
                    if (var16_16 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var16_16.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return bCMOperationResult;
            }
        }
        return operationResult;
    }

    private static void writeLog(IFormView view, BCMOperationResult operationResult, List<DynamicObject> sucessData, WorkBenchContext context, Set<Long> failIds, Set<Long> failIdsLog, Map<Long, DynamicObject> queriedTemplates) {
        String orgName = context.getSelectOrgTreeNode().getName();
        String fyNum = context.getFyNum();
        String periodNum = context.getPeriodNum();
        long modelId = context.getModelId();
        String opName = WorkBenchButtonEnum.BTN_BAT_DELETE.getText();
        if (CollectionUtils.isNotEmpty(sucessData)) {
            ArrayList sucessLogList = new ArrayList(sucessData.size());
            sucessData.forEach(s -> {
                String tempName = s.getString("template.name");
                String tempNum = s.getString("template.number");
                sucessLogList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s %5$s,\u91cd\u7f6e\u72b6\u6001\u6210\u529f", (String)"ReportRecordHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), fyNum, periodNum, orgName, tempNum, tempName));
            });
            if (CollectionUtils.isNotEmpty(sucessLogList)) {
                OperationLogUtil.batchWriteOperationLog((IFormView)view, (String)opName, sucessLogList, (Long)modelId);
            }
        }
        if (MapUtils.isNotEmpty(queriedTemplates)) {
            ArrayList failLogList = new ArrayList(16);
            queriedTemplates.forEach((k, v) -> {
                String tempName = v.getString("name");
                String tempNum = v.getString("number");
                long templateId = v.getLong("id");
                String message = failIdsLog.contains(templateId) ? String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\u5728\u516c\u5f0f\u53d6\u6570\u83dc\u5355\u4e2d\u5904\u4e8e\u6267\u884c\u4e2d\u72b6\u6001,\u91cd\u7f6e\u72b6\u6001\u5931\u8d25", (String)"ReportRecordHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), orgName, tempNum, tempName) : (failIds.contains(templateId) ? String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u5df2\u4e0a\u62a5/\u7f16\u5236\u5b8c\u6210\u7684\u65e0\u7ef4\u5ea6\u62a5\u8868\u4e0d\u5141\u8bb8\u91cd\u7f6e\u72b6\u6001", (String)"ReportRecordHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), orgName, tempNum, tempName) : String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u672a\u7f16\u5236\u7684\u62a5\u8868\u4e0d\u9700\u8981\u72b6\u6001\u91cd\u7f6e", (String)"ReportWorkBenchUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgName, tempNum, tempName));
                ReportWorkBenchUtil.addOperateErrorInfo(opName, message, (OperationResult)operationResult, failLogList);
            });
            if (CollectionUtils.isNotEmpty(failLogList)) {
                OperationLogUtil.batchWriteOperationLog((IFormView)view, (String)opName, failLogList, (Long)modelId);
            }
        }
    }

    public static void addOperateErrorInfo(String opName, String message, OperationResult operationResult, List<String> logList) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setTitle(opName);
        operateErrorInfo.setMessage(message);
        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
        operationResult.addErrorInfo(operateErrorInfo);
        if (logList != null) {
            logList.add(message);
        }
    }

    public static void resetChkCheckStatus(List<String> templateNums, WorkBenchContext context, WatchLogger log) {
        if (ConfigServiceHelper.getBoolParam((Long)context.getModelId(), (String)"isDeleteChkReportWithReset")) {
            CalContext ctx = new CalContext(context.getModelNum(), Long.valueOf(context.getModelId()), Long.valueOf(context.getFyId()), Long.valueOf(context.getPeriodId()), Long.valueOf(context.getScenarioId()));
            ctx.setProperty("currencyId", (Object)context.getCurrencyId());
            ctx.setProperty("org2TempNums", (Object)MapInitHelper.ofMap((Object)context.getSelectOrgTreeNode().getNumber(), templateNums));
            ctx.setProperty("currency", (Object)context.getCurrencyTreeNode().getNumber());
            ctx.setProperty("year", (Object)context.getFyNum());
            ctx.setProperty("period", (Object)context.getPeriodNum());
            try (TXHandle tx = TX.required();){
                try {
                    ChkCheckStatusHelper.resetCheckStatus((ICalContext)ctx);
                }
                catch (Throwable e) {
                    tx.setRollback(true);
                    log.error("resetCheckStatus error!", e);
                }
            }
        }
    }
}

