/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.schedule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DispatchTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.task.common.IScheduleSubPage;
import kd.fi.bcm.task.common.IntelligentScheduleConfigHelper;

public class DispatchParamSettingPlugin
extends AbstractBaseFormPlugin
implements MainPage {
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String SUB_PAGE_ID_CACHE = "subPageId";
    private static final String SUB_PAGE_FLEX = "subpagepanel";
    private static final String SUB_PAGE = "subpagepanelflex";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(Collections.singletonList("mergeentity"), SingleF7TypeEnum.NOLEAF, map);
        this.asMapF7toType(Collections.singletonList("srcscenario"), SingleF7TypeEnum.LEAF, map);
        HashMap<String, String> key2dim = new HashMap<String, String>();
        key2dim.put("mergeentity", "entity");
        key2dim.put("srcscenario", "scenario");
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(key2dim));
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok", "entity", "process");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
        Long modelId = (Long)customParam.get("model");
        Long scenarioid = customParam.get("scenario") == null ? null : (Long)((Map)customParam.get("scenario")).get("id");
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId + "");
        this.getModel().setValue("scenario", (Object)scenarioid);
        if (scenarioid != null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
        }
        if (opStatus == OperationStatus.EDIT) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dispatchtype"});
            String resulttypeParam = (String)customParam.get("resulttype");
            String sendtypeparam = (String)customParam.get("sendtype");
            Long receiverParam = customParam.get("receiver") == null ? null : Long.valueOf(((Map)customParam.get("receiver")).get("id").toString());
            String dispatchtypeParam = (String)customParam.get("dispatchtype");
            String laststatusParam = (String)customParam.get("laststatus");
            this.getModel().setValue("name", customParam.get("name"));
            this.getModel().setValue("remark", customParam.get("remark"));
            this.getModel().setValue("resulttype", (Object)resulttypeParam);
            this.getModel().setValue("sendtype", (Object)sendtypeparam);
            this.getModel().setValue("receiver", (Object)receiverParam);
            this.getModel().setValue("dispatchtype", (Object)dispatchtypeParam);
            this.getModel().setValue("laststatus", (Object)laststatusParam);
            Long paramId = StringUtils.isEmpty((String)((String)customParam.get("dispatchparamid"))) ? null : Long.valueOf((String)customParam.get("dispatchparamid"));
            DynamicObject dspparamentity = BusinessDataServiceHelper.loadSingle((Object)paramId, (String)"bcm_dspparamentity");
            this.setParamVisible(2, dspparamentity.getString("subpageconfig"));
            String id = (String)customParam.get("planid");
            Boolean enable = this.getEnablePlanNumber(Long.parseLong(id));
            if (enable.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap10", "btn_ok"});
            }
            return;
        }
        this.setParamVisible(1, null);
        this.setVisibleRpt();
    }

    private Boolean getEnablePlanNumber(Long id) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_intelschedule", (String)"isenable,number", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (dy == null) {
            return false;
        }
        String status = dy.getString("isenable");
        if ("1".equals(status)) {
            return true;
        }
        return false;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            String dspType = (String)this.getModel().getValue("dispatchtype");
            if (!this.beforeSaveCheck(dspType)) {
                return;
            }
            boolean isSubPageConfig = this.isSubPageConfig(dspType);
            Pair<Long, String> subPageConfig = this.getSubPageConfig(isSubPageConfig);
            IDataModel datamodel = this.getModel();
            Long scenario = subPageConfig.p1 != null ? (Long)subPageConfig.p1 : (datamodel.getValue("scenario") == null ? null : Long.valueOf(((DynamicObject)datamodel.getValue("scenario")).getLong("id")));
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            this.doSave(resultMap, scenario, (String)subPageConfig.p2);
            resultMap.put("name", datamodel.getValue("name"));
            resultMap.put("scenario", scenario);
            resultMap.put("remark", datamodel.getValue("remark"));
            resultMap.put("resulttype", datamodel.getValue("resulttype"));
            resultMap.put("sendtype", datamodel.getValue("sendtype"));
            resultMap.put("dispatchtype", datamodel.getValue("dispatchtype"));
            resultMap.put("laststatus", datamodel.getValue("laststatus"));
            resultMap.put("collectstatus", datamodel.getValue("collectstatus"));
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        } else {
            if ("entity".equals(key) && StringUtils.isEmpty((String)((String)this.getModel().getValue("entity")))) {
                this.getPageCache().put(key, null);
            }
            this.showMultiMemberF7(key);
        }
    }

    private void doSave(Map<String, Object> resultMap, Long scenario, String subPageConfig) {
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus == OperationStatus.ADDNEW) {
            DynamicObject dspparamentity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dspparamentity");
            dspparamentity.set("model", this.getModel().getValue("model") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("model")).getLong("id")));
            dspparamentity.set("scenario", (Object)scenario);
            dspparamentity.set("year", this.getModel().getValue("year") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("year")).getLong("id")));
            dspparamentity.set("period", this.getModel().getValue("period") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("period")).getLong("id")));
            dspparamentity.set("mergeentity", this.getModel().getValue("mergeentity") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("mergeentity")).getLong("id")));
            dspparamentity.set("datapushscheme", this.getModel().getValue("datapushscheme") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("datapushscheme")).getLong("id")));
            dspparamentity.set("entity", (Object)this.getPageCache().get("entity"));
            dspparamentity.set("process", (Object)this.getPageCache().get("process"));
            dspparamentity.set("template", this.getModel().getValue("template") == null ? null : (DynamicObjectCollection)this.getModel().getValue("template"));
            dspparamentity.set("isscheme", this.getModel().getValue("isscheme") == null ? null : (DynamicObjectCollection)this.getModel().getValue("isscheme"));
            dspparamentity.set("mergeparam", (Object)((String)this.getModel().getValue("mergeparam")));
            dspparamentity.set("optype", (Object)((String)this.getModel().getValue("optype")));
            dspparamentity.set("mergeradiogroup", (Object)((String)this.getModel().getValue("mergeradiogroup")));
            dspparamentity.set("ecradiogroup", (Object)((String)this.getModel().getValue("ecradiogroup")));
            dspparamentity.set("pcradiogroup", (Object)((String)this.getModel().getValue("pcradiogroup")));
            dspparamentity.set("chkradiogroup", (Object)((String)this.getModel().getValue("chkradiogroup")));
            dspparamentity.set("rightoffsetgroup", (Object)((String)this.getModel().getValue("rightoffsetgroup")));
            dspparamentity.set("shareadjustgroup", (Object)((String)this.getModel().getValue("shareadjustgroup")));
            dspparamentity.set("executeorder", (Object)((Boolean)this.getModel().getValue("executeorder")));
            dspparamentity.set("reexecute", (Object)((Boolean)this.getModel().getValue("reexecute")));
            dspparamentity.set("collectstatus", this.getModel().getValue("collectstatus"));
            dspparamentity.set("comfortablecurrency", this.getModel().getValue("comfortablecurrency"));
            dspparamentity.set("resulttype", this.getModel().getValue("resulttype"));
            dspparamentity.set("sendtype", this.getModel().getValue("sendtype"));
            dspparamentity.set("receiver", this.getModel().getValue("receiver"));
            dspparamentity.set("mergeflowstatus", this.getModel().getValue("mergeflowstatus"));
            dspparamentity.set("srcscenario", this.getModel().getValue("srcscenario") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("srcscenario")).getLong("id")));
            dspparamentity.set("yearoffset", this.getModel().getValue("yearoffset"));
            dspparamentity.set("periodoffset", this.getModel().getValue("periodoffset"));
            dspparamentity.set("caltype", this.getModel().getValue("caltype"));
            dspparamentity.set("calrange", this.getModel().getValue("calrange"));
            dspparamentity.set("staticstock", this.getModel().getValue("staticstock"));
            dspparamentity.set("dynamicstock", this.getModel().getValue("dynamicstock"));
            ArrayList mergeSet = new ArrayList(5);
            dspparamentity.set("mergeset", (Object)String.join((CharSequence)",", mergeSet));
            dspparamentity.set("commonpapers", this.getModel().getValue("commonpapers"));
            dspparamentity.set("investedtemplates", this.getModel().getValue("investedtemplates"));
            dspparamentity.set("subpageconfig", (Object)subPageConfig);
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dspparamentity});
            resultMap.put("dispatchparamid", ((DynamicObject)result[0]).getLong("id"));
        } else {
            Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("initdata");
            Long paramId = StringUtils.isEmpty((String)((String)customParam.get("dispatchparamid"))) ? null : Long.valueOf((String)customParam.get("dispatchparamid"));
            DynamicObject dspparamentity = BusinessDataServiceHelper.loadSingle((Object)paramId, (String)"bcm_dspparamentity");
            dspparamentity.set("model", this.getModel().getValue("model") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("model")).getLong("id")));
            dspparamentity.set("scenario", (Object)scenario);
            dspparamentity.set("year", this.getModel().getValue("year") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("year")).getLong("id")));
            dspparamentity.set("period", this.getModel().getValue("period") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("period")).getLong("id")));
            dspparamentity.set("mergeentity", this.getModel().getValue("mergeentity") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("mergeentity")).getLong("id")));
            dspparamentity.set("datapushscheme", this.getModel().getValue("datapushscheme") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("datapushscheme")).getLong("id")));
            dspparamentity.set("entity", (Object)this.getPageCache().get("entity"));
            dspparamentity.set("process", (Object)this.getPageCache().get("process"));
            dspparamentity.set("template", this.getModel().getValue("template") == null ? null : (DynamicObjectCollection)this.getModel().getValue("template"));
            dspparamentity.set("isscheme", this.getModel().getValue("isscheme") == null ? null : (DynamicObjectCollection)this.getModel().getValue("isscheme"));
            dspparamentity.set("mergeparam", (Object)((String)this.getModel().getValue("mergeparam")));
            dspparamentity.set("optype", (Object)((String)this.getModel().getValue("optype")));
            dspparamentity.set("mergeradiogroup", (Object)((String)this.getModel().getValue("mergeradiogroup")));
            dspparamentity.set("ecradiogroup", (Object)((String)this.getModel().getValue("ecradiogroup")));
            dspparamentity.set("pcradiogroup", (Object)((String)this.getModel().getValue("pcradiogroup")));
            dspparamentity.set("chkradiogroup", (Object)((String)this.getModel().getValue("chkradiogroup")));
            dspparamentity.set("rightoffsetgroup", (Object)((String)this.getModel().getValue("rightoffsetgroup")));
            dspparamentity.set("shareadjustgroup", (Object)((String)this.getModel().getValue("shareadjustgroup")));
            dspparamentity.set("executeorder", (Object)((Boolean)this.getModel().getValue("executeorder")));
            dspparamentity.set("reexecute", (Object)((Boolean)this.getModel().getValue("reexecute") != false ? "1" : "0"));
            dspparamentity.set("resulttype", this.getModel().getValue("resulttype"));
            dspparamentity.set("sendtype", this.getModel().getValue("sendtype"));
            dspparamentity.set("receiver", this.getModel().getValue("receiver"));
            dspparamentity.set("comfortablecurrency", this.getModel().getValue("comfortablecurrency"));
            dspparamentity.set("mergeflowstatus", this.getModel().getValue("mergeflowstatus"));
            dspparamentity.set("srcscenario", this.getModel().getValue("srcscenario") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("srcscenario")).getLong("id")));
            dspparamentity.set("yearoffset", this.getModel().getValue("yearoffset"));
            dspparamentity.set("periodoffset", this.getModel().getValue("periodoffset"));
            dspparamentity.set("caltype", this.getModel().getValue("caltype"));
            dspparamentity.set("calrange", this.getModel().getValue("calrange"));
            dspparamentity.set("staticstock", this.getModel().getValue("staticstock"));
            dspparamentity.set("dynamicstock", this.getModel().getValue("dynamicstock"));
            dspparamentity.set("collectstatus", this.getModel().getValue("collectstatus"));
            ArrayList mergeSet = new ArrayList(5);
            dspparamentity.set("mergeset", (Object)String.join((CharSequence)",", mergeSet));
            dspparamentity.set("commonpapers", this.getModel().getValue("commonpapers"));
            dspparamentity.set("investedtemplates", this.getModel().getValue("investedtemplates"));
            dspparamentity.set("subpageconfig", (Object)subPageConfig);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dspparamentity});
            resultMap.put("dispatchparamid", paramId);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("dispatchtype".equals(propName)) {
            this.setParamVisible(1, null);
        }
    }

    private void setParamVisible(int type, String config) {
        String dsptype = (String)this.getModel().getValue("dispatchtype");
        if (IntelligentScheduleConfigHelper.isUpdated(dsptype)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exportparamflex", "notexportparamflex", "mergeparamflex", "mergeflowstatusflex", "copyinvestflex", "shareholdcalflex", "createautoadjustap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SUB_PAGE_FLEX, "laststatusflex"});
            this.showFrom(dsptype, config);
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SUB_PAGE_FLEX});
        if (dsptype == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exportparamflex", "notexportparamflex", "laststatusflex", "mergeparamflex", "mergeflowstatusflex", "copyinvestflex", "shareholdcalflex", "createautoadjustap"});
            return;
        }
        if (type == 1) {
            this.setValue("executeorder", false);
            this.setValue("reexecute", false);
        }
    }

    private void setVisibleRpt() {
        if (ApplicationTypeEnum.RPT.getAppnum().equals(this.getBizAppId())) {
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("dispatchtype");
            comboEdit.setComboItems(this.getRptComboItems());
        }
    }

    private List<ComboItem> getRptComboItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem item = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u7ba1\u7406", (String)"DispatchTypeEnum_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "1");
        items.add(item);
        item = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570", (String)"DispatchTypeEnum_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "3");
        items.add(item);
        item = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u89c4\u5219\u8ba1\u7b97", (String)"DispatchTypeEnum_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "4");
        items.add(item);
        item = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"DispatchTypeEnum_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "7");
        items.add(item);
        return items;
    }

    private void showMultiMemberF7(String number) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumberIgnoreCase((long)((DynamicObject)this.getModel().getValue("model")).getLong("id"), (String)number);
        if (dim == null) {
            return;
        }
        FormShowParameter para = new FormShowParameter();
        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dim.getString("number"))) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("KEY_MODEL_ID", ((DynamicObject)this.getModel().getValue("model")).getString("id"));
        params.put("sign", number);
        if ("process".equals(number)) {
            params.put("showScopes", ObjectSerialUtil.toByteSerialized((Object)new int[]{10}));
            QFilter customFilter = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"BPNone", "TCF"}));
            customFilter.and("longnumber", "not like", (Object)"%TCF!%");
            params.put("customFilter", customFilter.toSerializedString());
            params.put("onlyleaf", true);
        }
        para.setCustomParams(params);
        para.setCaption(dim.getString("name"));
        IFormView view = this.getView();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, number);
        para.setCloseCallBack(closeCallBack);
        view.showForm(para);
    }

    @Override
    protected Map<String, SingleF7TypeEnum> getDimKeysFromCache() {
        Map<String, SingleF7TypeEnum> dimKeys = super.getDimKeysFromCache();
        String dspType = (String)this.getModel().getValue("dispatchtype");
        if (DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue().equals(dspType)) {
            dimKeys.put("mergeentity", SingleF7TypeEnum.COMMON);
        }
        return dimKeys;
    }

    private void showFrom(String dspType, String config) {
        String form = IntelligentScheduleConfigHelper.getConfigFormId(dspType);
        if (StringUtils.isEmpty((String)form)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SUB_PAGE_FLEX});
            this.getPageCache().remove(SUB_PAGE_ID_CACHE);
            return;
        }
        String pageId = this.getPageIdAndCache(this.getPageCache(), form, true);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(SUB_PAGE);
        formShowParameter.setFormId(form);
        formShowParameter.setPageId(pageId);
        FormShowParameter customParam = this.getView().getFormShowParameter();
        formShowParameter.setStatus(customParam.getStatus());
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("initdata", customParam.getCustomParam("initdata"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam(IScheduleSubPage.class.getName(), (Object)config);
        this.getPageCache().put(SUB_PAGE_ID_CACHE, pageId);
        this.getView().showForm(formShowParameter);
    }

    private Pair<Long, String> getSubPageConfig(boolean subPageConfig) {
        if (subPageConfig) {
            IFormView cv;
            String subPageId = this.getPageCache().get(SUB_PAGE_ID_CACHE);
            if (subPageId == null || (cv = this.getView().getView(subPageId)) == null) {
                return Pair.onePair(null, null);
            }
            String dspType = (String)this.getModel().getValue("dispatchtype");
            FormViewPluginProxy proxy = (FormViewPluginProxy)cv.getService(FormViewPluginProxy.class);
            IScheduleSubPage iSchedulePlanParam = proxy.getPlugIns().stream().filter(plugin -> IScheduleSubPage.class.isAssignableFrom(plugin.getClass())).map(IScheduleSubPage.class::cast).findFirst().orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6267\u884c\u53c2\u6570\u5b50\u9875\u9762\u9875\u9762\u63d2\u4ef6\u672a\u5b9e\u73b0\u63a5\u53e3\uff1aISchedulePlanParam", (String)"DispatchParamSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), IntelligentScheduleConfigHelper.getOperatorName(dspType))));
            Long sendScene = iSchedulePlanParam.sendScene();
            FormShowParameter customParam = this.getView().getFormShowParameter();
            Map initData = (Map)customParam.getCustomParam("initdata");
            KDAssert.assertTrue((initData.get("scenario") == null || sendScene == null || sendScene.equals(((Map)initData.get("scenario")).get("id")) ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u60c5\u666f\u4e0d\u53ef\u4fee\u6539\uff0c\u4e14\u6bcf\u4e2a\u64cd\u4f5c\u4e4b\u95f4\u7684\u60c5\u666f\u5e94\u4fdd\u6301\u4e00\u81f4", (String)"DispatchParamSettingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            return Pair.onePair((Object)sendScene, (Object)iSchedulePlanParam.sendConfig());
        }
        return Pair.onePair(null, null);
    }

    private boolean isSubPageConfig(String dspType) {
        return IntelligentScheduleConfigHelper.isUpdated(dspType);
    }

    private boolean beforeSaveCheck(String dsptype) {
        OrmLocaleValue tempname = (OrmLocaleValue)this.getModel().getValue("name");
        if (tempname == null || StringUtils.isEmpty((String)tempname.getLocaleValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"DispatchParamSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)dsptype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u7c7b\u578b\u3002", (String)"DispatchParamSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

