/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.task.IntelligentScheduleHelper;

public class IntellScheduleListPlugin
extends AbstractBaseListPlugin {
    private static final String TOOL_BAR_AP = "toolbarap1";
    private static final String BTN_ADD_NEW = "btn_addnew";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_EXEC = "btn_exec";
    private static final String BTN_LOG = "btn_log";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String M_MODEL = "model";
    private static final String IS_ENABLE = "isenable";
    private static final String DELETE_CALL_BACK = "deleteCallback";
    private static final String EDIT_PLAN = "editPlan";
    private static final String ADD_PLAN = "addPlan";
    private static final String FORM_PLUGIN = "fi-bcm-formplugin";
    private static final String SHOW_EXECUTOR = "showexecutor";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private List<ListField> newListFields = new ArrayList<ListField>(10);

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addHyperClickListener(this::hyperLinkClick);
        billList.addBeforePackageDataListener(this::beforePackageData);
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOL_BAR_AP);
    }

    private void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.checkPerm(BTN_ADD_NEW);
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Object focusRowPkId = list.getFocusRowPkId();
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getClass().getSimpleName() + this.getView().getPageId() + this.getBizAppId() + this.getUserId() + "-" + focusRowPkId;
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            BillShowParameter param = new BillShowParameter();
            param.setPageId(pageId);
            param.setPkId(focusRowPkId);
            param.setFormId("bcm_intelschedule");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setBillStatus(BillOperationStatus.EDIT);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT_PLAN));
            if (parentView == null) {
                this.getView().showForm((FormShowParameter)param);
            } else {
                parentView.showForm((FormShowParameter)param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), M_MODEL);
        if (modelId != null && !Objects.equals("0", modelId)) {
            this.getModel().setValue(M_MODEL, (Object)modelId);
            this.getBillListAp().setFilterParameter(this.getRefreshFilter());
        } else {
            FilterParameter fp = new FilterParameter();
            fp.setFilter(new QFilter("1", "!=", (Object)1));
            this.getBillListAp().setFilterParameter(fp);
        }
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                for (ListField listField : listFields) {
                    if (!IntellScheduleListPlugin.SHOW_EXECUTOR.equals(listField.getFieldName())) continue;
                    DynamicProperty dp = new DynamicProperty();
                    dp.setName(IntellScheduleListPlugin.SHOW_EXECUTOR);
                    listField.setFieldProp((IDataEntityProperty)dp);
                    IntellScheduleListPlugin.this.newListFields.add(listField);
                }
                super.setListFields(listFields);
            }
        });
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        for (ListField newListField : this.newListFields) {
            e.getPageData().getDynamicObjectType().addProperty((DynamicProperty)newListField.getFieldProp());
        }
        for (DynamicObject pageDatum : e.getPageData()) {
            pageDatum.set(SHOW_EXECUTOR, (Object)this.setShowType(pageDatum.getDynamicObject("executor")));
        }
    }

    private String setShowType(DynamicObject dy) {
        return dy == null ? "" : dy.getString(NAME);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_addnew": {
                this.showIntelligentSchedulePage();
                break;
            }
            case "btn_delete": {
                this.beforeDeleteRow();
                break;
            }
            case "btn_enable": {
                this.changeStatus(Boolean.TRUE);
                break;
            }
            case "btn_disable": {
                this.changeStatus(Boolean.FALSE);
                break;
            }
            case "btn_exec": {
                this.execSchedulePlan();
                break;
            }
            case "btn_log": {
                this.showLogList();
                break;
            }
            case "btn_refresh": {
                this.refresh();
                break;
            }
            case "btn_close": {
                this.getView().close();
                break;
            }
        }
    }

    private void execSchedulePlan() {
        ListSelectedRowCollection selectedRows = this.getSelectedRowsOrTips();
        List ids = selectedRows.stream().map(lsr -> Long.valueOf(lsr.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_intelschedule", (String)"id,number,name,isenable,executor", (QFilter[])qFilter.toArray());
        ArrayList<String> disableNumbers = new ArrayList<String>(10);
        for (DynamicObject dy : dys) {
            if (!Boolean.FALSE.equals(dy.getBoolean(IS_ENABLE))) continue;
            disableNumbers.add(dy.getString(NUMBER));
        }
        if (!disableNumbers.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u201c%1$s\u201d\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u624b\u52a8\u6267\u884c\u3002", (String)"IntellScheduleListPlugin_4", (String)FORM_PLUGIN, (Object[])new Object[0]), String.join((CharSequence)", ", disableNumbers)));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        selectedRows.forEach(row -> IntelligentScheduleHelper.execPlan(Long.parseLong(row.getPrimaryKeyValue().toString()), appId));
        StringBuilder sb = new StringBuilder();
        for (DynamicObject schedule : dys) {
            sb.append(" ").append(schedule.getString(NUMBER)).append(" ").append(schedule.getString(NAME)).append(" ,");
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6267\u884c", "IntellScheduleListPlugin_12", FORM_PLUGIN, "Execute"), new OPDescMultiLangEnumBridge("%s\u6267\u884c\u6210\u529f", "IntellScheduleListPlugin_16", FORM_PLUGIN, new String[]{sb.toString()}));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u5168\u90e8\u624b\u52a8\u6267\u884c\u3002", (String)"IntellScheduleListPlugin_5", (String)FORM_PLUGIN, (Object[])new Object[0]));
    }

    private ListSelectedRowCollection getSelectedRowsOrTips() {
        ListSelectedRowCollection selectedRows = this.getBillListAp().getSelectedRows();
        if (selectedRows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u64cd\u4f5c\u7684\u65b9\u6848\u3002", (String)"IntellScheduleListPlugin_6", (String)FORM_PLUGIN, (Object[])new Object[0]));
        }
        return selectedRows;
    }

    private void showLogList() {
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getClass().getSimpleName() + this.getView().getPageId() + this.getBizAppId() + this.getUserId() + "-showLogList";
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            ListShowParameter showParameter = new ListShowParameter();
            OpenStyle openStyle = showParameter.getOpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            showParameter.setPageId(pageId);
            showParameter.setBillFormId("bcm_intelschedule_log");
            showParameter.setFormId("bcm_intelschedule_logtemp");
            showParameter.setCustomParam(M_MODEL, (Object)this.getModelId());
            if (parentView == null) {
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                parentView.showForm((FormShowParameter)showParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void changeStatus(Boolean enable) {
        DynamicObject[] scheduleDys;
        String status = "status";
        String enableStatus = Boolean.TRUE.equals(enable) ? "1" : "0";
        ListSelectedRowCollection selectedRows = this.getSelectedRowsOrTips();
        List ids = selectedRows.stream().map(lsr -> Long.valueOf(lsr.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_intelschedule", (String)"id,name,number,isenable,scheduleplanid", (QFilter[])qFilter.toArray());
        ArrayList<String> schedulePlanIds = new ArrayList<String>();
        ArrayList<String> jobIds = new ArrayList<String>();
        HashMap<String, String> schemeNumAndName = new HashMap<String, String>(dys.length);
        HashMap<String, Long> idmap = new HashMap<String, Long>(16);
        for (DynamicObject dynamicObject : dys) {
            dynamicObject.set(IS_ENABLE, (Object)enableStatus);
            schedulePlanIds.add(dynamicObject.getString("scheduleplanid"));
            idmap.put(dynamicObject.getString("scheduleplanid"), dynamicObject.getLong("id"));
            schemeNumAndName.put(dynamicObject.getString(NUMBER), dynamicObject.getString(NAME));
        }
        qFilter = new QFilter("id", "in", schedulePlanIds);
        for (DynamicObject scheduleDy : scheduleDys = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,status,job", (QFilter[])qFilter.toArray())) {
            if (scheduleDy.getDynamicObject("job") == null && enable.booleanValue()) {
                QFilter schemeQf = new QFilter("id", "=", idmap.get(scheduleDy.getString("id")));
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_intelschedule", (String)NAME, (QFilter[])new QFilter[]{schemeQf});
                String name = ((DynamicObject)query.get(0)).getString(NAME);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\u8c03\u5ea6\u88ab\u5220\u9664\uff0c\u8bf7\u5220\u9664\u65b9\u6848\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"IntellScheduleListPlugin_13", (String)FORM_PLUGIN, (Object[])new Object[0]), name));
            }
            if (scheduleDy.getDynamicObject("job") == null && !enable.booleanValue()) continue;
            scheduleDy.set("status", (Object)enableStatus);
            jobIds.add(scheduleDy.getString("job.id"));
            scheduleDy.getDynamicObject("job").set("status", (Object)enableStatus);
        }
        SaveServiceHelper.update((DynamicObject[])dys);
        SaveServiceHelper.update((DynamicObject[])scheduleDys);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        for (String schedulePlanId : schedulePlanIds) {
            if (Boolean.TRUE.equals(enable)) {
                scheduleManager.enableSchedule(schedulePlanId);
                continue;
            }
            scheduleManager.disableSchedule(schedulePlanId);
        }
        for (String jobId : jobIds) {
            if (Boolean.TRUE.equals(enable)) {
                scheduleManager.enableJob(jobId);
                continue;
            }
            scheduleManager.disableJob(jobId);
        }
        String operation = Boolean.TRUE.equals(enable) ? ResManager.loadKDString((String)"\u542f\u7528", (String)"IntellScheduleListPlugin_8", (String)FORM_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"IntellScheduleListPlugin_9", (String)FORM_PLUGIN, (Object[])new Object[0]);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\u6210\u529f\u3002", (String)"IntellScheduleListPlugin_7", (String)FORM_PLUGIN, (Object[])new Object[0]), operation));
        schemeNumAndName.forEach((k, v) -> this.writeOperationLog(operation, (String)k, (String)v, this.getOperationStstusSuccess()));
        this.refresh();
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"IntellScheduleListPlugin_10", (String)FORM_PLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "model": {
                if (e.getChangeSet()[0].getNewValue() == null) {
                    this.setValue(M_MODEL, e.getChangeSet()[0].getOldValue());
                    break;
                }
                this.refresh();
                this.saveUserSelect(e);
                break;
            }
        }
    }

    private void saveUserSelect(PropertyChangedArgs e) {
        UserSelectModel user = UserSelectServiceHelper.getUserSelect((String)Long.toString(this.getUserId()), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)ApplicationTypeEnum.CM);
        DynamicObject dobj = (DynamicObject)e.getChangeSet()[0].getNewValue();
        String modelId = dobj.getString("id");
        if (user == null) {
            ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
            UserSelectModel userSelectModel = new UserSelectModel();
            userSelectModel.setModifier(RequestContext.get().getUserId());
            userSelectModel.setApplication(application);
            userSelectModel.setModel(modelId);
            userSelectModel.setOnlyModel(false);
            UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
        } else {
            user.setModel(modelId);
            user.setOnlyModel(true);
            UserSelectServiceHelper.saveUserSelect((UserSelectModel)user);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "deleteCallback": {
                if (!result.equals((Object)MessageBoxResult.Yes)) break;
                this.execDeleteRow();
                this.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RptAdjustdListPlugin_52", (String)FORM_PLUGIN, (Object[])new Object[0]));
                break;
            }
        }
    }

    private void execDeleteRow() {
        ListSelectedRowCollection selectedRows = this.getBillListAp().getSelectedRows();
        List ids = selectedRows.stream().map(lsr -> Long.valueOf(lsr.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        DynamicObject[] intellScheduleDys = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_intelschedule"));
        List schedulePlanIds = Arrays.stream(intellScheduleDys).map(dy -> dy.getString("scheduleplanid")).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", schedulePlanIds);
        DynamicObjectCollection scheduleDys = QueryServiceHelper.query((String)"sch_schedule", (String)"job", (QFilter[])new QFilter[]{qf});
        Object[] jobIds = scheduleDys.stream().map(dy -> dy.getString("job")).toArray();
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_intelschedule"), (Object[])ids.toArray());
        OperationServiceHelper.executeOperate((String)"delete", (String)"sch_schedule", (Object[])schedulePlanIds.toArray(), null);
        OperationServiceHelper.executeOperate((String)"delete", (String)"sch_job", (Object[])jobIds, null);
        StringBuilder sb = new StringBuilder();
        for (DynamicObject schedule : intellScheduleDys) {
            sb.append(" ").append(schedule.getString(NUMBER)).append(" ").append(schedule.getString(NAME)).append(" ,");
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "IntellScheduleListPlugin_11", FORM_PLUGIN, "Delete"), new OPDescMultiLangEnumBridge("%s\u5220\u9664\u6210\u529f", "IntellScheduleListPlugin_17", FORM_PLUGIN, new String[]{sb.toString()}));
    }

    private void beforeDeleteRow() {
        BillList billListAp = this.getBillListAp();
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        List<Long> ids = selectedRows.stream().map(lsr -> Long.valueOf(lsr.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (selectedRows.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"IntellScheduleListPlugin_0", (String)FORM_PLUGIN, (Object[])new Object[0]));
        } else if (this.checkPlanStatusAndTips(ids)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6b64\u65b9\u6848\uff1f", (String)"IntellScheduleListPlugin_1", (String)FORM_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_CALL_BACK));
        }
    }

    private boolean checkPlanStatusAndTips(List<Long> ids) {
        ArrayList<String> numbers = this.getEnablePlanNumber(ids);
        if (!numbers.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848 %1$s \u72b6\u6001\u4e3a\u542f\u7528\uff0c\u8bf7\u7981\u7528\u540e\u518d\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", (String)"IntellScheduleListPlugin_2", (String)FORM_PLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", numbers)));
            return false;
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "addPlan": 
            case "editPlan": {
                this.refresh();
            }
        }
    }

    private ArrayList<String> getEnablePlanNumber(List<Long> ids) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_intelschedule", (String)"isenable,number", (QFilter[])new QFilter("id", "in", ids).toArray());
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (DynamicObject dy : dys) {
            String status = dy.getString(IS_ENABLE);
            if (!"1".equals(status)) continue;
            numbers.add(dy.getString(NUMBER));
        }
        return numbers;
    }

    private BillList getBillListAp() {
        return (BillList)this.getView().getControl(BILL_LIST_AP);
    }

    private void refresh() {
        if (this.checkModelIsNull()) {
            return;
        }
        this.getBillListAp().setFilterParameter(this.getRefreshFilter());
        this.getBillListAp().refresh();
        this.getBillListAp().clearSelection();
    }

    private FilterParameter getRefreshFilter() {
        FilterParameter fp = new FilterParameter();
        fp.setFilter(new QFilter(M_MODEL, "=", (Object)this.getModelId()));
        return fp;
    }

    private void showIntelligentSchedulePage() {
        if (this.checkModelIsNull()) {
            return;
        }
        FormShowParameter params = new FormShowParameter();
        params.setStatus(OperationStatus.ADDNEW);
        params.setFormId("bcm_intelschedule");
        params.setCustomParam(M_MODEL, (Object)this.getModelId());
        params.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_PLAN));
        params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(params);
    }

    private boolean checkModelIsNull() {
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"IntellScheduleListPlugin_3", (String)FORM_PLUGIN, (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

