/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ComboListColumn;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DispatchTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;

public class IntellScheduleLogListPlugin
extends AbstractBaseListPlugin {
    private static final String M_MODEL = "model";
    private static final String EXPORT = "btn_export";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String SHOW_EXECUTOR = "showexecutor";
    private static final String EXECUTOR = "executor";
    private static final String NUMBER = "number";
    private List<ListField> newListFields = new ArrayList<ListField>(10);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue(M_MODEL, this.getView().getFormShowParameter().getCustomParam(M_MODEL));
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final IFormView view = this.getView();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                for (ListField listField : listFields) {
                    if (!IntellScheduleLogListPlugin.SHOW_EXECUTOR.equals(listField.getFieldName())) continue;
                    DynamicProperty dp = new DynamicProperty();
                    dp.setName(IntellScheduleLogListPlugin.SHOW_EXECUTOR);
                    listField.setFieldProp((IDataEntityProperty)dp);
                    IntellScheduleLogListPlugin.this.newListFields.add(listField);
                }
                super.setListFields(listFields);
                ComboListColumn comboList = (ComboListColumn)view.getControl("combolistcolumnap");
                ComboProp fieldProp = (ComboProp)comboList.getSrcFieldProp();
                List items = Arrays.stream(DispatchTypeEnum.values()).map(dispatchTypeEnum -> new ValueMapItem(null, dispatchTypeEnum.getValue(), new LocaleString(dispatchTypeEnum.getName()))).collect(Collectors.toList());
                fieldProp.setComboItems(items);
            }
        });
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        for (ListField newListField : this.newListFields) {
            e.getPageData().getDynamicObjectType().addProperty((DynamicProperty)newListField.getFieldProp());
        }
        for (DynamicObject pageDatum : e.getPageData()) {
            pageDatum.set(SHOW_EXECUTOR, (Object)this.setShowType(pageDatum.getDynamicObject(EXECUTOR)));
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        if ("execoperation".equals(args.getListFieldKey()) && ApplicationTypeEnum.RPT.getAppnum().equals(this.getBizAppId())) {
            ArrayList<ValueMapItem> newComItems = new ArrayList<ValueMapItem>();
            for (ValueMapItem valueMapItem : args.getComboItems()) {
                if (!"4".equals(valueMapItem.getValue()) && !"1".equals(valueMapItem.getValue()) && !"3".equals(valueMapItem.getValue()) && !"7".equals(valueMapItem.getValue())) continue;
                newComItems.add(valueMapItem);
            }
            args.setComboItems(newComItems);
        }
        super.listColumnCompareTypesSet(args);
    }

    private String setShowType(DynamicObject dy) {
        return dy.getString("name");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "model": {
                if (e.getChangeSet()[0].getNewValue() == null) {
                    this.setValue(M_MODEL, e.getChangeSet()[0].getOldValue());
                    break;
                }
                BillList billListAp = this.getBillListAp();
                billListAp.refresh();
                billListAp.clearSelection();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_export": {
                QFilter qFilter;
                ListSelectedRowCollection selectedRows = this.getBillListAp().getSelectedRows();
                if (selectedRows.isEmpty()) {
                    qFilter = new QFilter(M_MODEL, "=", (Object)this.getModelId());
                } else {
                    List ids = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                    qFilter = new QFilter("id", "in", ids);
                }
                this.exportLogData("bcm_intelschedule_log", qFilter.toArray(), ResManager.loadKDString((String)"\u667a\u80fd\u8c03\u5ea6\u65e5\u5fd7", (String)"IntellScheduleLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), StringUtils.getEmpty());
                this.writeLogWithEntityNumber("bcm_intelschedule_log", new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "AbstractRptAdjustDraftBasePlugin_27", "fi-bcm-formplugin", "export"), new OPDescMultiLangEnumBridge("\u65e5\u5fd7\u5bfc\u51fa\u6210\u529f", "IntellScheduleListPlugin_15", "fi-bcm-formplugin", null));
                break;
            }
        }
    }

    private void exportLogData(String entityName, QFilter[] qFilters, String filename, String templateNumber) {
        if (qFilters.length == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)filename)) {
            filename = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"BCMBaseFunction_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String entityNameImp = entityName;
        QFBuilder filters = new QFBuilder();
        if (StringUtil.isEmptyString((String)templateNumber)) {
            filters.add(new QFilter("bizobject.number", "=", (Object)entityNameImp));
        } else {
            filters.add(new QFilter(NUMBER, "=", (Object)templateNumber));
        }
        String tempLateType = "templatetype";
        filters.add(new QFilter(tempLateType, "=", (Object)"IMPT").or(new QFilter(tempLateType, "is null", null)));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters.toArray(), (String)StringUtils.getEmpty(), (int)2);
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            DynamicObject[] dys = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilters).values().toArray(new DynamicObject[0]);
            String url = ExportUtil.export((DynamicObject[])dys, pkIds.get(0), (String)routeAppId, (String)entityNameImp, (String)(filename + ".xlsx"));
            this.downloadFile(url, "bcm_intelschedulelist", "19VS4B4PNQ9Y");
        }
        catch (Exception e) {
            watchlogger.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw new KDBizException((Throwable)e, new ErrorCode(StringUtils.getEmpty(), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"BCMBaseFunction_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    private BillList getBillListAp() {
        return (BillList)this.getView().getControl(BILL_LIST_AP);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter(M_MODEL, "=", (Object)this.getModelId()));
    }

    @Override
    public void exportData(String entityName, QFilter[] qFilters, String filename, String templateNumber, String entityNum, String permItemId) {
        if (qFilters.length == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)filename)) {
            filename = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"AbstractBaseListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        QFBuilder filters = new QFBuilder();
        if (StringUtil.isEmptyString((String)templateNumber)) {
            filters.add(new QFilter("bizobject.number", "=", (Object)entityName));
        } else {
            filters.add(new QFilter(NUMBER, "=", (Object)templateNumber));
        }
        filters.add(new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null)));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters.toArray(), (String)"", (int)2);
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            DynamicObject[] dys = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilters).values().toArray(new DynamicObject[0]);
            if (dys.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u667a\u80fd\u8c03\u5ea6\u65e5\u5fd7\u3002", (String)"IntellScheduleLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String url = ExportUtil.export((DynamicObject[])dys, pkIds.get(0), (String)routeAppId, (String)entityName, (String)(filename + ".xlsx"));
            this.downloadFile(url, entityNum, permItemId);
        }
        catch (Exception e) {
            log.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"AbstractBaseListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }
}

