/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DispatchStrategyEnum;
import kd.fi.bcm.common.enums.DispatchTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class IntellSchedulePlugin
extends AbstractBaseListPlugin {
    private static final String ENTITY_TOOL_BARAP = "advcontoolbarap";
    private static final String SAVE = "save";
    private static final String ADD_IMG = "addimg";
    private static final String ADD_CARD = "addcard";
    private static final String ADD_LABEL = "addlabel";
    private static final String EXEC_PLAN = "execplan";
    private static final String DELETE_OPER = "deleteoper";
    private static final String MOVE_ENTRY_UP = "moveentryup";
    private static final String MOVE_ENTRY_DOWN = "moveentrydown";
    private static final String EDIT_OPERATION = "editoperation";
    private static final String INTEL_SCHEDULE_ENTRY = "intelscheduleentry";
    private static final String EXEC_ORDER = "execorder";
    private static final String EXEC_OPERATION_TXT = "execoperationtxt";
    private static final String EXEC_STRATEGY_TXT = "execstrategytxt";
    private static final String OPERATION_NAME = "operationname";
    private static final String EXEC_DESC = "execdesc";
    private static final String MSG_CONDITION = "msgcondition";
    private static final String MSG_TYPE = "msgtype";
    private static final String EXEC_OPERATION = "execoperation";
    private static final String EXEC_PARAM_ID = "execparamid";
    private static final String EXEC_STRATEGY = "execstrategy";
    private static final String MSG_USER = "msguser";
    private static final String SCHEDULE_PLAN_ID = "scheduleplanid";
    private static final String EXECUTOR = "executor";
    private static final String NUMBER = "number";
    private static final String M_MODEL = "model";
    private static final String END_DATE = "enddate";
    private static final String S_SCENARIO = "scenario";
    private static final String IS_ENABLE = "isenable";
    private static final String NEW_SCHEDULE = "newschedule";
    private static final String NEW_OPERATION = "newoperation";
    private static final String MODIFY_OPERATION = "modifyoperation";
    private static final String FORM_PLUGIN = "fi-bcm-formplugin";
    private static final String ID = "id";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(EXEC_PLAN, ADD_CARD, ADD_IMG, ADD_LABEL, DELETE_OPER, EDIT_OPERATION);
        this.addItemClickListeners(ENTITY_TOOL_BARAP);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection operationEntityDys = this.getModel().getEntryEntity(INTEL_SCHEDULE_ENTRY);
        String id = this.getPlugin().getView().getModel().getDataEntity().getLong(ID) + "";
        this.getPageCache().put(ID, id);
        this.tryMutexLock(id);
        for (DynamicObject operationEntityDy : operationEntityDys) {
            int rowIndex = operationEntityDy.getInt("seq") - 1;
            this.getModel().setValue(EXEC_OPERATION_TXT, (Object)DispatchTypeEnum.getDispatchTypeEnum((String)operationEntityDy.getString(EXEC_OPERATION)).getName(), rowIndex);
            this.getModel().setValue(EXEC_STRATEGY_TXT, (Object)DispatchStrategyEnum.getDispatchStrategyEnum((String)operationEntityDy.getString(EXEC_STRATEGY)).getName(), rowIndex);
            this.getModel().setValue(EXEC_ORDER, (Object)(rowIndex + 1), rowIndex);
        }
        this.getModel().setDataChanged(false);
        Boolean enable = this.getEnablePlanNumber(Long.parseLong(id));
        if (enable.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap1"});
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String id = this.getPageCache().get(ID);
        this.releaseMutexLock(id);
        if (this.isLockedByOthers(id).booleanValue()) {
            e.setCheckDataChange(false);
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String id = this.getPageCache().get(ID);
        this.releaseMutexLock(id);
    }

    private Boolean isLockedByOthers(String id) {
        Map lockInfo = MutexServiceHelper.getLockInfo((String)id, (String)"bcm_intelschedule", (String)"intelschedule");
        if (lockInfo == null) {
            return Boolean.FALSE;
        }
        if (!RequestContext.getOrCreate().getUserId().equals(lockInfo.get("userid"))) {
            log.error(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u6b64\u65b9\u6848\uff0c\u5f53\u524d\u4ec5\u4e3a\u67e5\u770b\u3002", (String)"IntelligentSchedulePlan_14", (String)FORM_PLUGIN, (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid"))));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void releaseMutexLock(String id) {
        Map lockInfo;
        if (kd.bos.util.StringUtils.isNotEmpty((String)id) && (lockInfo = MutexServiceHelper.getLockInfo((String)id, (String)"bcm_intelschedule", (String)"intelschedule")) != null && ((String)lockInfo.get("userid")).equals(RequestContext.getOrCreate().getUserId())) {
            MutexServiceHelper.release((String)id, (String)"bcm_intelschedule", (String)"intelschedule");
        }
    }

    private void tryMutexLock(String id) {
        String mutexLocked = this.isMutexLocked(id);
        if (kd.bos.util.StringUtils.isNotEmpty((String)mutexLocked)) {
            this.getView().showTipNotification(mutexLocked);
        }
    }

    private String isMutexLocked(String id) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)id) && !"0".equals(id)) {
            Pair<String, String> mutexPair = IntellSchedulePlugin.requestMutex(id);
            if (mutexPair.p2 != null) {
                return (String)mutexPair.p2;
            }
        }
        return null;
    }

    public static Pair<String, String> requestMutex(String dataId) {
        String mutexKey = dataId + "";
        Map lockInfo = MutexServiceHelper.getLockInfo((String)mutexKey, (String)"bcm_intelschedule", (String)"intelschedule");
        if (lockInfo == null) {
            boolean success = MutexServiceHelper.request((String)mutexKey, (String)"bcm_intelschedule", (String)"intelschedule");
            if (success) {
                return Pair.onePair((Object)mutexKey, null);
            }
            return Pair.onePair((Object)mutexKey, (Object)ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25", (String)"AdjustmentServiceHelper_24", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!RequestContext.getOrCreate().getUserId().equals(lockInfo.get("userid"))) {
            return Pair.onePair((Object)mutexKey, (Object)String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u6b64\u65b9\u6848\uff0c\u5f53\u524d\u4ec5\u4e3a\u67e5\u770b\u3002", (String)"IntelligentSchedulePlan_14", (String)FORM_PLUGIN, (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid"))));
        }
        return Pair.onePair((Object)mutexKey, null);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object model = this.getView().getFormShowParameter().getCustomParam(M_MODEL);
        if (Objects.isNull(model)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f53\u7cfb\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"IntellSchedulePlugin_0", (String)FORM_PLUGIN, (Object[])new Object[0]));
        }
        this.setValue(M_MODEL, model);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getOperationKey()) {
            case "moveentryup": 
            case "moveentrydown": {
                this.operationReorder();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "execplan": {
                this.openExecPlan();
                break;
            }
            case "addlabel": 
            case "addimg": 
            case "addcard": {
                this.addOperation();
                break;
            }
            case "deleteoper": {
                this.deleteSingleOperation();
                break;
            }
            case "editoperation": {
                this.editOperation();
                break;
            }
        }
    }

    private void openExecPlan() {
        long id = (Long)this.getModel().getValue(ID);
        if (StringUtils.isBlank((Object)id) || id == 0L) {
            String tableName = this.getModel().getDataEntityType().getAlias();
            long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
            id = ids[0];
            this.getModel().getDataEntity().set(ID, (Object)id);
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sch_schedule");
        String scheduleId = (String)this.getView().getModel().getValue(SCHEDULE_PLAN_ID);
        if (scheduleId != null && scheduleId.trim().length() != 0) {
            parameter.setPkId((Object)scheduleId);
            parameter.setStatus(OperationStatus.EDIT);
        } else {
            String name = this.getModel().getValue("name").toString();
            if (name == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u540d\u79f0\u3002", (String)"IntellSchedulePlugin_8", (String)FORM_PLUGIN, (Object[])new Object[0]));
                return;
            }
            parameter.setStatus(OperationStatus.ADDNEW);
            Lang lang = RequestContext.get().getLang();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("intelligentSchedulePlanId", id);
            paramMap.put("lang", lang.getLocale().toString());
            paramMap.put("customizeCheck", this.getCustomizeCheck());
            paramMap.put("appId", this.getBizAppId());
            log.info("this new plan id:" + id + ";lang:" + lang.getLocale().toString());
            String idJson = JSONObject.toJSONString(paramMap);
            parameter.setCustomParam("paramjsonstr", (Object)idJson);
            parameter.setCustomParam("taskclassname", (Object)"kd.fi.bcm.task.IntelligentScheduleTask");
            parameter.setCustomParam("taskdefineid", (Object)"20LEULWBO13H");
            parameter.setCustomParam("taskname", (Object)name);
            parameter.setCustomParam("schedulename", (Object)name);
            parameter.setCustomParam("tasknumber", (Object)("bcm_autocreate" + System.currentTimeMillis()));
            parameter.setCustomParam("taskappnumber", (Object)"cm");
            DynamicObject executor = (DynamicObject)this.getValue(EXECUTOR);
            if (executor != null) {
                parameter.setCustomParam(EXECUTOR, executor.get(ID));
            }
        }
        parameter.setHasRight(true);
        parameter.setCustomParam("frombiz", (Object)"true");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEW_SCHEDULE));
        StyleCss css1 = new StyleCss();
        css1.setWidth("800");
        css1.setHeight("700");
        parameter.getOpenStyle().setInlineStyleCss(css1);
        parameter.setCaption(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212", (String)"IntellSchedulePlugin_7", (String)FORM_PLUGIN, (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected String getCustomizeCheck() {
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)args.getSource()).getOperateKey().equals(SAVE) && !this.beforeSaveCheck()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object schedulePlanId = this.getValue(SCHEDULE_PLAN_ID);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schedulePlanId, (String)"sch_schedule");
        DynamicObject job = dynamicObject.getDynamicObject("job");
        if (job == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u8c03\u5ea6\u88ab\u5220\u9664\uff0c\u8bf7\u5220\u9664\u65b9\u6848\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"IntellScheduleListPlugin_14", (String)FORM_PLUGIN, (Object[])new Object[0]));
        }
        job.set("runbyuser", this.getValue(EXECUTOR));
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{job});
        String number = (String)this.getModel().getValue(NUMBER);
        String name = this.getModel().getValue("name").toString();
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "RptAdjustdListPlugin_67", FORM_PLUGIN, "Save"), new OPDescMultiLangEnumBridge("%1$s %2$s\u4fdd\u5b58\u6210\u529f", "EntryCvtCurrencySettingPlugin_0", FORM_PLUGIN, new String[]{number, name}));
    }

    private boolean beforeSaveCheck() {
        String number = this.getValue(NUMBER).toString();
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u65b9\u6848\u7f16\u7801\u201d\u3002", (String)"IntellSchedulePlugin_6", (String)FORM_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        long id = (Long)this.getValue(ID);
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)this.getValue(NUMBER).toString());
        qFilter.and(M_MODEL, "=", (Object)this.getModelId());
        DynamicObject intelScheDy = QueryServiceHelper.queryOne((String)"bcm_intelschedule", (String)"id,isenable,number", (QFilter[])qFilter.toArray());
        if (intelScheDy != null && id != intelScheDy.getLong(ID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5728\u8be5\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u3002", (String)"IntellSchedulePlugin_2", (String)FORM_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        qFilter = new QFilter(ID, "=", (Object)id);
        DynamicObject statusDy = QueryServiceHelper.queryOne((String)"bcm_intelschedule", (String)"id,isenable", (QFilter[])qFilter.toArray());
        if (statusDy != null && statusDy.getString(IS_ENABLE).equals("1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u72b6\u6001\u4e3a\u542f\u7528\uff0c\u8bf7\u7981\u7528\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IntellSchedulePlugin_5", (String)FORM_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        int entryRowCount = this.getModel().getEntryRowCount(INTEL_SCHEDULE_ENTRY);
        if (entryRowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6267\u884c\u64cd\u4f5c\u7684\u65e5\u671f\u3002", (String)"IntellSchedulePlugin_3", (String)FORM_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object rtn = e.getReturnData();
        switch (actionId) {
            case "newschedule": {
                if (rtn == null) break;
                DynamicObject scheduleInfo = (DynamicObject)rtn;
                String planId = (String)scheduleInfo.get(ID);
                this.getModel().setValue(SCHEDULE_PLAN_ID, (Object)planId);
                String txtDesc = (String)scheduleInfo.get("txtdesc");
                Date endTime = scheduleInfo.getDate("endtime");
                if (StringUtils.isNotEmpty((CharSequence)txtDesc) && txtDesc.length() > 153) {
                    txtDesc = txtDesc.replace("\r\n", "").substring(0, 150) + "...";
                }
                this.getModel().setValue(EXEC_PLAN, (Object)txtDesc);
                this.getModel().setValue(END_DATE, (Object)endTime);
                break;
            }
            case "newoperation": {
                if (rtn == null) break;
                Map resultMap = (Map)rtn;
                int entityCount = this.getModel().createNewEntryRow(INTEL_SCHEDULE_ENTRY);
                try {
                    this.setOperationEntity(resultMap, entityCount);
                    break;
                }
                catch (Exception ex) {
                    this.getModel().deleteEntryRow(INTEL_SCHEDULE_ENTRY, entityCount);
                    throw new KDBizException(ex.getMessage());
                }
            }
            case "modifyoperation": {
                if (rtn == null) break;
                Map resultMap = (Map)rtn;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(INTEL_SCHEDULE_ENTRY);
                this.setOperationEntity(resultMap, rowIndex);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "number": {
                this.checkNumber();
                break;
            }
        }
    }

    private void checkNumber() {
        String number = this.getValue(NUMBER).toString();
        if (number.isEmpty()) {
            return;
        }
        boolean matches = number.matches("^[a-zA-Z]\\w{0,50}$");
        if (!matches) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff0c\u4e0d\u5141\u8bb8\u8f93\u5165\u7a7a\u683c\uff0c\u4e0d\u5141\u8bb8\u8f93\u5165\u6c49\u5b57\u3002", (String)"IntellSchedulePlugin_4", (String)FORM_PLUGIN, (Object[])new Object[0]));
            this.setValue(NUMBER, "");
        }
    }

    private void setOperationEntity(Map<String, Object> resultMap, int rowIndex) {
        Object scenario = resultMap.get(S_SCENARIO);
        if (scenario != null) {
            this.setValue(S_SCENARIO, scenario);
        }
        this.getModel().setValue(EXEC_OPERATION_TXT, (Object)DispatchTypeEnum.getDispatchTypeEnum((String)resultMap.get("dispatchtype").toString()).getName(), rowIndex);
        this.getModel().setValue(EXEC_STRATEGY_TXT, (Object)DispatchStrategyEnum.getDispatchStrategyEnum((String)resultMap.get("laststatus").toString()).getName(), rowIndex);
        this.getModel().setValue(EXEC_ORDER, (Object)(rowIndex + 1), rowIndex);
        this.getModel().setValue(OPERATION_NAME, resultMap.get("name"), rowIndex);
        this.getModel().setValue(EXEC_DESC, resultMap.get("remark"), rowIndex);
        this.getModel().setValue(MSG_CONDITION, resultMap.get("resulttype"), rowIndex);
        this.getModel().setValue(MSG_TYPE, resultMap.get("sendtype"), rowIndex);
        this.getModel().setValue(EXEC_OPERATION, resultMap.get("dispatchtype"), rowIndex);
        this.getModel().setValue(EXEC_PARAM_ID, resultMap.get("dispatchparamid"), rowIndex);
        this.getModel().setValue(EXEC_STRATEGY, resultMap.get("laststatus"), rowIndex);
        this.getModel().setValue(MSG_USER, resultMap.get("receiver"), rowIndex);
    }

    private void addOperation() {
        Boolean isEnable = this.getEnablePlanNumber(Long.parseLong(this.getPageCache().get(ID)));
        if (isEnable.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u72b6\u6001\u4e3a\u542f\u7528\uff0c\u8bf7\u7981\u7528\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IntellSchedulePlugin_5", (String)FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection operationEntry = this.getModel().getEntryEntity(INTEL_SCHEDULE_ENTRY);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        if (!operationEntry.isEmpty()) {
            customParam.put(S_SCENARIO, this.getValue(S_SCENARIO));
        }
        customParam.put(M_MODEL, this.getModelId());
        this.openOperationUI(NEW_OPERATION, customParam, OperationStatus.ADDNEW);
    }

    private Boolean getEnablePlanNumber(Long id) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_intelschedule", (String)"isenable,number", (QFilter[])new QFilter(ID, "=", (Object)id).toArray());
        if (dy == null) {
            return false;
        }
        String status = dy.getString(IS_ENABLE);
        if ("1".equals(status)) {
            return true;
        }
        return false;
    }

    private void editOperation() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(INTEL_SCHEDULE_ENTRY);
        HashMap<String, Object> customParam = this.getOperationEntity(rowIndex);
        this.openOperationUI(MODIFY_OPERATION, customParam, OperationStatus.EDIT);
    }

    private HashMap<String, Object> getOperationEntity(int rowIndex) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put(S_SCENARIO, this.getModel().getValue(S_SCENARIO));
        customParam.put(M_MODEL, this.getModelId());
        customParam.put("name", this.getModel().getValue(OPERATION_NAME, rowIndex));
        customParam.put("resulttype", this.getModel().getValue(MSG_CONDITION, rowIndex));
        customParam.put("sendtype", this.getModel().getValue(MSG_TYPE, rowIndex));
        customParam.put("dispatchtype", this.getModel().getValue(EXEC_OPERATION, rowIndex));
        customParam.put("dispatchparamid", this.getModel().getValue(EXEC_PARAM_ID, rowIndex));
        customParam.put("laststatus", this.getModel().getValue(EXEC_STRATEGY, rowIndex));
        customParam.put("receiver", this.getModel().getValue(MSG_USER, rowIndex));
        customParam.put("remark", this.getModel().getValue(EXEC_DESC, rowIndex));
        customParam.put("planid", this.getPageCache().get(ID));
        return customParam;
    }

    private void openOperationUI(String closeActionID, Map<String, Object> customParam, OperationStatus status) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bcm_dispatchparam");
        if (customParam != null && !customParam.isEmpty()) {
            parameter.setCustomParam("initdata", customParam);
        }
        parameter.setStatus(status);
        StyleCss css1 = new StyleCss();
        css1.setWidth("1200");
        css1.setHeight("800");
        parameter.getOpenStyle().setInlineStyleCss(css1);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeActionID));
        this.getView().showForm(parameter);
    }

    private void deleteSingleOperation() {
        CardEntry operationEntry = (CardEntry)this.getControl(INTEL_SCHEDULE_ENTRY);
        int focusRow = operationEntry.getEntryState().getFocusRow();
        this.getModel().deleteEntryRow(INTEL_SCHEDULE_ENTRY, focusRow);
        this.operationReorder();
    }

    private void operationReorder() {
        int entityCount = this.getModel().getEntryRowCount(INTEL_SCHEDULE_ENTRY);
        for (int i = 0; i < entityCount; ++i) {
            this.getModel().setValue(EXEC_ORDER, (Object)(i + 1), i);
        }
    }
}

