/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.spread;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.form.IClientViewProxy;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.collections.CollectionUtils;

public class SpreadEasyInvoker {
    public static final String SYNCSAVE = "syncSpreadJsData2SpreadModel";
    public static final String SYNCMULTISAVE = "syncSpreadJsData2SpreadModel";
    private IClientViewProxy view;
    private String spreadKey;
    private LinkedHashMap<String, Object> orderlist;
    private boolean isBatch;

    public SpreadEasyInvoker(IClientViewProxy view, String spreadKey) {
        this.spreadKey = spreadKey;
        this.view = view;
        this.orderlist = new LinkedHashMap();
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    public void startToInvoke() {
        Set<Map.Entry<String, Object>> set = this.orderlist.entrySet();
        for (Map.Entry<String, Object> s : set) {
            String key = s.getKey();
            if (key.contains(SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{s.getValue()});
                continue;
            }
            if (key.contains(SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k(), new Object[]{s.getValue()});
                continue;
            }
            if (key.contains(SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), new Object[]{s.getValue()});
                continue;
            }
            if (SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k().equalsIgnoreCase(key)) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k(), new Object[]{MapInitHelper.ofMap((Object)SpreadProperties.AddContextMenuItemsMethod.CALLBACK.k(), (Object)"invokeAction", (Object)SpreadProperties.AddContextMenuItemsMethod.ITEMS.k(), (Object)s.getValue())});
                continue;
            }
            if (key.contains(SpreadProperties.ResetCellMethod.RESETCELL.k())) {
                this.view.invokeControlMethod(this.spreadKey, key, new Object[]{MapInitHelper.ofMap((Object)SpreadProperties.ResetCellMethod.RANGE.k(), (Object)s.getValue())});
                continue;
            }
            this.view.invokeControlMethod(this.spreadKey, key, new Object[]{s.getValue()});
        }
    }

    public static void addContextSubMenuItem(String itemName, String itemText, String[] workArea, List<Map<String, Object>> subMenuItems) {
        HashMap<String, Object> subMenuItem = new HashMap<String, Object>(16);
        subMenuItem.put(SpreadProperties.AddContextMenuItemsMethod.NAME.k(), itemName);
        subMenuItem.put(SpreadProperties.AddContextMenuItemsMethod.TEXT.k(), itemText);
        subMenuItem.put(SpreadProperties.AddContextMenuItemsMethod.WORKAREA.k(), workArea);
        subMenuItems.add(subMenuItem);
    }

    public Map<String, Object> getOrderlist() {
        return this.orderlist;
    }

    public void setSingleSpan(int r, int c, int rc, int cc) {
        HashMap features = new HashMap();
        ArrayList<Map<String, Object>> rangeList = new ArrayList<Map<String, Object>>();
        rangeList.add(SpreadEasyInvoker.packRangeFeature(r, c, rc, cc));
        features.put(SpreadProperties.SetSpanMethod.RANGE.k(), rangeList);
        SpreadClientInvoker.invokeSetSpanMethod(this.view, this.spreadKey, features);
    }

    public void clearCellsStyle(int r, int c, int rc, int cc) {
        ArrayList<Map<String, Object>> cells = new ArrayList<Map<String, Object>>(10);
        cells.add(SpreadEasyInvoker.packRangeFeature(r, c, rc, cc));
        if (this.isBatch) {
            ArrayList<Map<String, Object>> oldMapList = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.ClearCellsStyleMethod.CLEARCELLSSTYLE.k());
            if (oldMapList == null) {
                oldMapList = cells;
            } else {
                oldMapList.addAll(cells);
            }
            this.orderlist.put(SpreadProperties.ClearCellsStyleMethod.CLEARCELLSSTYLE.k(), oldMapList);
        } else {
            SpreadClientInvoker.clearCellsStyle(this.view, this.spreadKey, cells);
        }
    }

    public void resetCellStyle(int r, int c, int rc, int cc) {
        ArrayList<Map<String, Object>> cells = new ArrayList<Map<String, Object>>(10);
        cells.add(SpreadEasyInvoker.packRangeFeature(r, c, rc, cc));
        if (this.isBatch) {
            ArrayList<Map<String, Object>> oldMapList = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.ResetCellMethod.RESETCELL.k());
            if (oldMapList == null) {
                oldMapList = cells;
            } else {
                oldMapList.addAll(cells);
            }
            this.orderlist.put(SpreadProperties.ResetCellMethod.RESETCELL.k(), oldMapList);
        } else {
            HashMap<String, ArrayList<Map<String, Object>>> features = new HashMap<String, ArrayList<Map<String, Object>>>(16);
            features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), cells);
            SpreadClientInvoker.invokeResetCellMethod(this.view, this.spreadKey, features);
        }
    }

    public void setSpan(int r, int c, int rc, int cc) {
        HashMap features = new HashMap();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetSpanMethod.RANGE.k(), rangeList);
        if (this.isBatch) {
            HashMap oldparam = (HashMap)this.orderlist.get(SpreadProperties.SetSpanMethod.SETSPAN.k());
            if (oldparam == null) {
                oldparam = features;
            } else {
                List rm = (List)oldparam.get(SpreadProperties.SetSpanMethod.RANGE.k());
                rm.add(rangeMap);
            }
            this.orderlist.put(SpreadProperties.SetSpanMethod.SETSPAN.k(), oldparam);
        } else {
            SpreadClientInvoker.invokeSetSpanMethod(this.view, this.spreadKey, features);
        }
    }

    public void updataValue(int r, int c, Object value) {
        Map<String, Object> valMap = SpreadEasyInvoker.packedUpdateCellMap(r, c, value);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> oldparam = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.UpdataValueMethod.UPDATAVALUE.k());
            if (oldparam == null) {
                oldparam = new ArrayList<Map<String, Object>>();
            }
            oldparam.add(valMap);
            this.orderlist.put(SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), oldparam);
        } else {
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
            cellValues.add(valMap);
            SpreadClientInvoker.invokeUpdataValueMethod(this.view, this.spreadKey, cellValues);
        }
    }

    public void setFormula(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.SetFormulaMethod.R.k(), r);
        valMap.put(SpreadProperties.SetFormulaMethod.C.k(), c);
        valMap.put(SpreadProperties.SetFormulaMethod.F.k(), value);
        if (this.isBatch) {
            ArrayList oldparam = (ArrayList)this.orderlist.get(SpreadProperties.SetFormulaMethod.SETFORMULA.k());
            if (oldparam == null) {
                oldparam = new ArrayList();
            }
            oldparam.add(valMap);
            this.orderlist.put(SpreadProperties.SetFormulaMethod.SETFORMULA.k(), oldparam);
        } else {
            ArrayList<HashMap<String, Object>> cellValues = new ArrayList<HashMap<String, Object>>();
            cellValues.add(valMap);
            SpreadClientInvoker.invokeSetFormulaMethod(this.view, this.spreadKey, cellValues);
        }
    }

    public void setF7TypeCell(int r, int c, int rc, int cc, int selectType, int dst) {
        HashMap<String, Integer> feature = new HashMap<String, Integer>();
        feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), r);
        feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), c);
        feature.put(SpreadProperties.SetF7TypeCellMethod.RC.k(), rc);
        feature.put(SpreadProperties.SetF7TypeCellMethod.CC.k(), cc);
        if (this.isBatch) {
            String key = SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k() + selectType + dst;
            HashMap<String, Serializable> features = (HashMap<String, Serializable>)this.orderlist.get(key);
            List<HashMap<String, Integer>> items = new ArrayList<HashMap<String, Integer>>();
            if (features != null) {
                items = (List)features.get(SpreadProperties.SetF7TypeCellMethod.RANGE.k());
            } else {
                features = new HashMap<String, Serializable>();
            }
            items.add(feature);
            features.put(SpreadProperties.SetF7TypeCellMethod.RANGE.k(), (Serializable)((Object)items));
            features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(selectType));
            features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), Integer.valueOf(dst));
            this.orderlist.put(key, features);
        } else {
            HashMap<String, Serializable> features = new HashMap<String, Serializable>();
            ArrayList<HashMap<String, Integer>> items = new ArrayList<HashMap<String, Integer>>();
            items.add(feature);
            features.put(SpreadProperties.SetF7TypeCellMethod.RANGE.k(), items);
            features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(selectType));
            features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), Integer.valueOf(dst));
            SpreadClientInvoker.invokeSetF7TypeCellMethod(this.view, this.spreadKey, features);
        }
    }

    public void lockCell(int r, int c, int rc, int cc) {
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.LockCellMethod.R.k(), r);
        cell.put(SpreadProperties.LockCellMethod.C.k(), c);
        cell.put(SpreadProperties.LockCellMethod.RC.k(), rc);
        cell.put(SpreadProperties.LockCellMethod.CC.k(), cc);
        if (this.isBatch) {
            ArrayList cells = (ArrayList)this.orderlist.get(SpreadProperties.LockCellMethod.LOACKCELL.k());
            if (cells == null) {
                cells = new ArrayList();
            }
            cells.add(cell);
            this.orderlist.put(SpreadProperties.LockCellMethod.LOACKCELL.k(), cells);
        } else {
            ArrayList<HashMap<String, Integer>> cells = new ArrayList<HashMap<String, Integer>>();
            cells.add(cell);
            SpreadClientInvoker.invokeLockCellMethod(this.view, this.spreadKey, cells);
        }
    }

    public void lockCell(List<Map<String, Object>> cells) {
        if (!cells.isEmpty()) {
            if (this.isBatch) {
                ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.LockCellMethod.LOACKCELL.k());
                if (list == null) {
                    list = new ArrayList<Map<String, Object>>(16);
                }
                if (cells.isEmpty()) {
                    return;
                }
                list.addAll(cells);
                this.orderlist.put(SpreadProperties.LockCellMethod.LOACKCELL.k(), list);
            } else {
                SpreadClientInvoker.invokeLockCellMethod(this.view, this.spreadKey, cells);
            }
        }
    }

    public void unlockCell(int r, int c, int rc, int cc) {
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.UnlockCellMethod.R.k(), r);
        cell.put(SpreadProperties.UnlockCellMethod.C.k(), c);
        cell.put(SpreadProperties.UnlockCellMethod.RC.k(), rc);
        cell.put(SpreadProperties.UnlockCellMethod.CC.k(), cc);
        if (this.isBatch) {
            ArrayList cells = (ArrayList)this.orderlist.get(SpreadProperties.UnlockCellMethod.UNLOACKCELL.k());
            if (cells == null) {
                cells = new ArrayList();
            }
            cells.add(cell);
            this.orderlist.put(SpreadProperties.UnlockCellMethod.UNLOACKCELL.k(), cells);
        } else {
            ArrayList<HashMap<String, Integer>> cells = new ArrayList<HashMap<String, Integer>>();
            cells.add(cell);
            SpreadClientInvoker.invokeUnLockCellMethod(this.view, this.spreadKey, cells);
        }
    }

    public void setColumnsWidth(int col, int num) {
        if (this.isBatch) {
            String key = SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k() + num;
            HashMap<String, Serializable> map = (HashMap<String, Serializable>)this.orderlist.get(key);
            List<Integer> colindex = new ArrayList<Integer>();
            if (map != null) {
                colindex = (List)map.get(SpreadProperties.SetColumnsWidthMethod.INDEX.k());
            } else {
                map = new HashMap<String, Serializable>();
            }
            colindex.add(col);
            map.put(SpreadProperties.SetColumnsWidthMethod.INDEX.k(), (Serializable)((Object)colindex));
            map.put(SpreadProperties.SetColumnsWidthMethod.NUM.k(), Integer.valueOf(num));
            this.orderlist.put(key, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int[] colindex = new int[]{col};
            map.put(SpreadProperties.SetColumnsWidthMethod.INDEX.k(), colindex);
            map.put(SpreadProperties.SetColumnsWidthMethod.NUM.k(), 100);
            SpreadClientInvoker.invokeSetColumsWidthMethod(this.view, this.spreadKey, map);
        }
    }

    public void setColumnsWidth(List<Integer> colIndexs, int num) {
        if (this.isBatch) {
            String key = SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k() + num;
            HashMap<String, Serializable> map = (HashMap<String, Serializable>)this.orderlist.get(key);
            List<Integer> oldcColindex = new ArrayList<Integer>();
            if (map != null) {
                oldcColindex = (List)map.get(SpreadProperties.SetColumnsWidthMethod.INDEX.k());
            } else {
                map = new HashMap<String, Serializable>();
            }
            oldcColindex.addAll(colIndexs);
            map.put(SpreadProperties.SetColumnsWidthMethod.INDEX.k(), (Serializable)((Object)oldcColindex));
            map.put(SpreadProperties.SetColumnsWidthMethod.NUM.k(), Integer.valueOf(num));
            this.orderlist.put(key, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(SpreadProperties.SetColumnsWidthMethod.INDEX.k(), colIndexs);
            map.put(SpreadProperties.SetColumnsWidthMethod.NUM.k(), num);
            SpreadClientInvoker.invokeSetColumsWidthMethod(this.view, this.spreadKey, map);
        }
    }

    public void setRowsHeight(List<Integer> rowIndexs, int height) {
        if (this.isBatch) {
            String key = SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k() + height;
            HashMap<String, Object> map = (HashMap<String, Object>)this.orderlist.get(key);
            List<Integer> oldIndexs = new ArrayList(16);
            if (map != null) {
                oldIndexs = (List)map.get(SpreadProperties.SetRowsHeightMethod.INDEX.k());
            } else {
                map = new HashMap<String, Object>(16);
            }
            oldIndexs.addAll(rowIndexs);
            map.put(SpreadProperties.SetRowsHeightMethod.INDEX.k(), oldIndexs);
            map.put(SpreadProperties.SetRowsHeightMethod.NUM.k(), height);
            this.orderlist.put(key, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put(SpreadProperties.SetRowsHeightMethod.INDEX.k(), rowIndexs);
            map.put(SpreadProperties.SetRowsHeightMethod.NUM.k(), height);
            SpreadClientInvoker.invokeSetRowsHeightMethod(this.view, this.spreadKey, map);
        }
    }

    public void setFrozenSheet(int r, int c, int tr, int tc, String flc, int si) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetFrozenSheetMethod.R.k(), r);
        features.put(SpreadProperties.SetFrozenSheetMethod.C.k(), c);
        features.put(SpreadProperties.SetFrozenSheetMethod.TR.k(), tr);
        features.put(SpreadProperties.SetFrozenSheetMethod.TC.k(), tc);
        features.put(SpreadProperties.SetFrozenSheetMethod.FLC.k(), flc);
        features.put(SpreadProperties.SetFrozenSheetMethod.SI.k(), si);
        SpreadClientInvoker.invokeSetFrozenSheetMethod(this.view, this.spreadKey, features);
    }

    public void setStyle(int r, int c, int rc, int cc, Map<String, Object> styleMap) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        if (this.isBatch) {
            ArrayList list = (ArrayList)this.orderlist.get(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k());
            if (list == null) {
                list = new ArrayList(16);
                this.orderlist.put(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), list);
            }
            list.add(features);
        } else {
            SpreadClientInvoker.invokeSetCellStyleMethod(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    public void setDataStyle(int r, int c, int rc, int cc, Map<String, Object> styleMap) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        ArrayList<HashMap<String, Object>> featrueList = new ArrayList<HashMap<String, Object>>();
        featrueList.add(features);
        HashMap<String, ArrayList<HashMap<String, Object>>> newFeatures = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        newFeatures.put("data", featrueList);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.view, this.spreadKey, newFeatures);
    }

    public void setStyle(List<Map<String, Object>> rangeList, Map<String, Object> styleMap) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        if (this.isBatch) {
            ArrayList list = (ArrayList)this.orderlist.get(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k());
            if (list == null) {
                list = new ArrayList(16);
                this.orderlist.put(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), list);
            }
            list.add(features);
        } else {
            SpreadClientInvoker.invokeSetCellStyleMethod(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    public static Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    public Map<String, Object> packedStyleCellMap(int r, int c, int rc, int cc, Map<String, Object> styleMap) {
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        ArrayList rangeList = new ArrayList(10);
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        return features;
    }

    public static Map<String, Object> packedFormulaCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.SetFormulaMethod.R.k(), r);
        valMap.put(SpreadProperties.SetFormulaMethod.C.k(), c);
        valMap.put(SpreadProperties.SetFormulaMethod.F.k(), value);
        return valMap;
    }

    public static void setColumnVisble(IClientViewProxy view, String spreadKey, int[] colArray, boolean isVisible) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetColumnsVisible.COLS.k(), colArray);
        features.put(SpreadProperties.SetColumnsVisible.VALUE.k(), isVisible);
        SpreadClientInvoker.invokeSetColumnsVisibleMethod(view, spreadKey, features);
    }

    public static void setRowsVisble(IClientViewProxy view, String spreadKey, int[] rowArray, boolean isVisible) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetRowsVisible.ROWS.k(), rowArray);
        features.put(SpreadProperties.SetRowsVisible.VALUE.k(), isVisible);
        SpreadClientInvoker.invokeSetRowsVisibleMethod(view, spreadKey, features);
    }

    public void updateRowAndCol(AskExcuteInfo excuteinfo) {
        SpreadBasePlugin.updateRowAndCol2View(this.view, this.spreadKey, excuteinfo);
    }

    public void setWorksheetOptions(String optionkey, Object optionValue) {
        HashMap workSheetOptions = new HashMap();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(optionkey, optionValue);
        workSheetOptions.put(SpreadProperties.SetWorkSheetOptions.OPTIONS.k(), options);
        SpreadClientInvoker.invokeSetWorksheetOptions(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{workSheetOptions}));
    }

    public void syncSpreadJsData2SpreadModel(SpreadManager sm) {
        HashMap<String, Serializable> features = new HashMap<String, Serializable>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Sheet sheet = sm.getBook().getSheet(0);
        int maxRowCount = sheet.getMaxRowCount();
        int maxColumnCount = sheet.getMaxColumnCount();
        list.add(SpreadEasyInvoker.packRangeFeatureCompress(0, 0, maxRowCount, maxColumnCount));
        if (list.isEmpty()) {
            return;
        }
        features.put(SpreadProperties.GetRangeValues.RANGE.k(), list);
        features.put(SpreadProperties.GetRangeValues.COMPRESSION.k(), Boolean.valueOf(true));
        SpreadClientInvoker.invokeMethod(this.view, SpreadProperties.GetRangeValues.GETRANGEVALUES.k(), this.spreadKey, features);
    }

    public static Map<String, Object> packRangeFeature(int r, int c, int rc, int cc) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        feature.put(SpreadProperties.GetRangeValues.R.k(), r);
        feature.put(SpreadProperties.GetRangeValues.C.k(), c);
        feature.put(SpreadProperties.GetRangeValues.RC.k(), rc);
        feature.put(SpreadProperties.GetRangeValues.CC.k(), cc);
        return feature;
    }

    public static Map<String, Object> packRangeFeatureCompress(int r, int c, int rc, int cc) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        feature.put(SpreadProperties.GetRangeValues.R.k(), r);
        feature.put(SpreadProperties.GetRangeValues.C.k(), c);
        feature.put(SpreadProperties.GetRangeValues.RC.k(), rc);
        feature.put(SpreadProperties.GetRangeValues.CC.k(), cc);
        return feature;
    }

    public void addContextMenuItem(String itemName, String itemText, String[] workArea) {
        this.addContextMenuItem(itemName, itemText, workArea, false);
    }

    public void addContextMenuItem(String itemName, String itemText, String[] workArea, boolean isLine) {
        HashMap<String, Object> item = new HashMap<String, Object>(10);
        item.put(SpreadProperties.AddContextMenuItemsMethod.NAME.k(), itemName);
        item.put(SpreadProperties.AddContextMenuItemsMethod.TEXT.k(), itemText);
        item.put(SpreadProperties.AddContextMenuItemsMethod.WORKAREA.k(), workArea);
        if (isLine) {
            item.put("type", "separator");
        }
        if (this.isBatch) {
            ArrayList list = (ArrayList)this.orderlist.get(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k());
            if (list == null) {
                list = new ArrayList(16);
            }
            list.add(item);
            this.orderlist.put(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k(), list);
        } else {
            ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>(16);
            items.add(item);
            HashMap<String, Object> features = new HashMap<String, Object>();
            features.put(SpreadProperties.AddContextMenuItemsMethod.CALLBACK.k(), "invokeAction");
            features.put(SpreadProperties.AddContextMenuItemsMethod.ITEMS.k(), items);
            SpreadClientInvoker.addContextMenuItemsMethod(this.view, this.spreadKey, features);
        }
    }

    public void addContextMenuSeparator() {
        this.addContextMenuItem("", "", new String[]{"viewport"}, true);
    }

    public void addContextMenuItemAndSubMenu(String itemName, String itemText, String[] workArea, List<Map<String, Object>> subMenuItems) {
        HashMap<String, Object> item = new HashMap<String, Object>(10);
        item.put(SpreadProperties.AddContextMenuItemsMethod.NAME.k(), itemName);
        item.put(SpreadProperties.AddContextMenuItemsMethod.TEXT.k(), itemText);
        item.put(SpreadProperties.AddContextMenuItemsMethod.WORKAREA.k(), workArea);
        item.put(SpreadProperties.AddContextMenuItemsMethod.SUBMENU.k(), subMenuItems);
        if (this.isBatch) {
            ArrayList list = (ArrayList)this.orderlist.get(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k());
            if (list == null) {
                list = new ArrayList(16);
            }
            list.add(item);
            this.orderlist.put(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k(), list);
        } else {
            ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>(16);
            items.add(item);
            HashMap<String, Object> features = new HashMap<String, Object>();
            features.put(SpreadProperties.AddContextMenuItemsMethod.CALLBACK.k(), "invokeAction");
            features.put(SpreadProperties.AddContextMenuItemsMethod.ITEMS.k(), items);
            SpreadClientInvoker.addContextMenuItemsMethod(this.view, this.spreadKey, features);
        }
    }

    public void setHyperLinkCellSimple(int r, int c, int rc, int cc, String callBackName) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.R.k(), r);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.C.k(), c);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.setHyperLinkCellMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.setHyperLinkCellMethod.CALLBACK.k(), "invokeAction");
        features.put(SpreadProperties.setHyperLinkCellMethod.INVOKEMETHOD.k(), callBackName);
        SpreadClientInvoker.setHyperLinkCellMethod(this.view, this.spreadKey, features);
    }

    public void setHyperLinkCellSimple(List<Map<String, Object>> rangeList, String callBackName) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.setHyperLinkCellMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.setHyperLinkCellMethod.CALLBACK.k(), "invokeAction");
        features.put(SpreadProperties.setHyperLinkCellMethod.INVOKEMETHOD.k(), callBackName);
        SpreadClientInvoker.setHyperLinkCellMethod(this.view, this.spreadKey, features);
    }

    public void lockAllToolbarItems(boolean islock, SpreadProperties.ToolbarItemNamesEnum ... items) {
        int lockinfo = islock ? 1 : 0;
        ArrayList<Map> toolbarItems = new ArrayList<Map>(items.length);
        for (SpreadProperties.ToolbarItemNamesEnum itemNamesEnum : items) {
            toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)itemNamesEnum, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)lockinfo));
        }
        SpreadClientInvoker.invokeLockToolbarItems(this.view, this.spreadKey, toolbarItems);
    }

    public void batchDelRow(int startrow, int count) {
        LinkedHashMap<String, Object> map = SpreadEasyInvoker.packInsertMap(startrow, count);
        SpreadClientInvoker.invokeDelRow(this.view, this.spreadKey, map);
    }

    public void batchDelCol(int startrow, int count) {
        LinkedHashMap<String, Object> map = SpreadEasyInvoker.packInsertMap(startrow, count);
        SpreadClientInvoker.invokeDelCol(this.view, this.spreadKey, map);
    }

    private static LinkedHashMap<String, Object> packInsertMap(int startindex, int count) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        map.put("status", true);
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("index", startindex);
        data.put("count", count);
        rangeList.add(data);
        map.put("data", rangeList);
        return map;
    }

    public static Map<String, Object> packHideMap(int startindex, int count) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(SpreadProperties.HideRow.ISUNDO.k(), true);
        map.put(SpreadProperties.HideRow.SI.k(), 0);
        ArrayList<Map> data = new ArrayList<Map>(16);
        data.add(MapInitHelper.ofMap((Object)SpreadProperties.HideRow.INDEX.k(), (Object)startindex, (Object)SpreadProperties.HideRow.COUNT.k(), (Object)count));
        map.put(SpreadProperties.HideRow.DATA.k(), data);
        return map;
    }

    public static void setCellStyleMethod(SpreadManager spreadModel, IClientViewProxy clientViewProxy, String spreadKey, Map<String, Object> styleMap, boolean isOnlyDataArea, Predicate<Cell> predicate) {
        ArrayList rangeList = new ArrayList(16);
        if (!isOnlyDataArea) {
            spreadModel.getBook().getSheet(0).iteratorCells(cell -> {
                if (predicate.test((Cell)cell)) {
                    rangeList.add(SpreadEasyInvoker.packRangeFeature(cell.getRow(), cell.getCol(), 1, 1));
                }
            });
        } else {
            spreadModel.getAreaManager().getPostionInfoSet().forEach(e -> spreadModel.getBook().getSheet(0).iteratorRangeCells(new RangeModel(e.getAreaRange()), cell -> {
                if (predicate.test((Cell)cell)) {
                    rangeList.add(SpreadEasyInvoker.packRangeFeature(cell.getRow(), cell.getCol(), 1, 1));
                }
            }));
        }
        if (CollectionUtils.isNotEmpty(rangeList)) {
            HashMap<String, Object> features = new HashMap<String, Object>(16);
            features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
            features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
            SpreadClientInvoker.invokeSetCellStyleMethod(clientViewProxy, spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    public static void clearAllCornerMark(SpreadManager sm, IClientViewProxy clientViewProxy, String spreadKey) {
        ArrayList parameters = new ArrayList(1);
        ArrayList rangedetails = new ArrayList(sm.getAreaManager().getPostionInfoSet().size());
        HashMap<String, Object> parameter = new HashMap<String, Object>(6);
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            RangeModel rm = new RangeModel(ps.getAreaRange());
            HashMap<String, Integer> rangedetail = new HashMap<String, Integer>(4);
            rangedetail.put("r", rm.getY_start());
            rangedetail.put("c", rm.getX_start());
            rangedetail.put("rc", rm.getY_end() - rm.getY_start() + 1);
            rangedetail.put("cc", rm.getX_end() - rm.getX_start() + 1);
            rangedetails.add(rangedetail);
        }
        parameter.put("range", rangedetails.toArray());
        parameter.put("vi", false);
        parameter.put("pos", new int[]{0, 1, 2, 3});
        parameters.add(parameter);
        SpreadClientInvoker.invokeMethod(clientViewProxy, "setCornerMark", spreadKey, parameters.toArray());
    }
}

