/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.spread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.DistributionDetailsSpreadLogic;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Book;
import kd.fi.bcm.spread.domain.view.Sheet;

public class SpreadUtils {
    private static final String NUMBER = "number";

    public static void spreadF7lookUpData(IClientViewProxy clientViewProxy, String spreadKey, String entityNum, String dimNum, LookUpDataArgs args, long modelId, QFilter filtdetail, String yearNum, String periodId, String sceneId) {
        SpreadUtils.spreadF7lookUpData(clientViewProxy, spreadKey, entityNum, dimNum, args, modelId, filtdetail, yearNum, periodId, false, sceneId, true);
    }

    public static void spreadF7lookUpData(IClientViewProxy clientViewProxy, String spreadKey, String entityNum, String dimNum, LookUpDataArgs args, long modelId, QFilter filtdetail, String yearNum, String periodId, boolean needShare, String sceneId, boolean needPerm) {
        DataSet ds;
        QFilter filtpermisson;
        ORM orm = ORM.create();
        boolean isUseFtlike = ConfigServiceHelper.getGlobalBoolParam((String)"isUseFtlike");
        QFilter nameAndNumberfilter = new QFilter("1", "ftlike", (Object)("name,number#" + args.getValue().trim()));
        QFilter filtname = new QFilter("name", "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight()));
        QFilter filtnumber = new QFilter(NUMBER, "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight()));
        if (!isUseFtlike) {
            nameAndNumberfilter = filtname.or(filtnumber);
        }
        QFilter filtmodel = new QFilter("model", "=", (Object)modelId);
        QFilter filtdim = new QFilter("dimension.number", "=", (Object)dimNum);
        int top = 20;
        if (StringUtils.isNotBlank((Object)args.getCountEnd())) {
            top = args.getCountEnd();
        }
        QFilter qFilter = filtpermisson = needPerm ? SpreadUtils.getPermissonFilter(entityNum, dimNum, modelId) : null;
        if ("bcm_fetchtype".equals(entityNum) || "bcm_reclassparam".equals(entityNum)) {
            top = 20;
            ds = orm.queryDataSet(SpreadUtils.class.getName(), entityNum, "id,number,name", new QFilter[]{nameAndNumberfilter, filtdetail}, NUMBER, top);
        } else {
            ds = orm.queryDataSet(SpreadUtils.class.getName(), entityNum, "id,number,name", new QFilter[]{nameAndNumberfilter, filtmodel, filtpermisson, filtdetail, filtdim}, NUMBER, top);
        }
        DynamicObjectCollection queryCollection = orm.toPlainDynamicObjectCollection(ds, args.getCountStart() - 1, top);
        if (StringUtils.isNotBlank((CharSequence)yearNum) && StringUtils.isNotBlank((CharSequence)periodId)) {
            if ("bcm_entitymembertree".equals(entityNum)) {
                if (StringUtils.isNotEmpty((CharSequence)sceneId)) {
                    FilterOrgStructParam param = new FilterOrgStructParam(modelId, Long.parseLong(sceneId), yearNum, Long.parseLong(periodId));
                    EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)queryCollection);
                }
            } else if ("bcm_accountmembertree".equals(entityNum)) {
                // empty if block
            }
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        ArrayList arrs = new ArrayList();
        Iterator iterator = queryCollection.iterator();
        while (iterator.hasNext()) {
            ArrayList<String> arr = new ArrayList<String>();
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            arr.add(dynamicObject.getString("id"));
            arr.add(dynamicObject.getString(NUMBER));
            arr.add(dynamicObject.getString("name"));
            arrs.add(arr);
        }
        data.put("data", arrs);
        data.put("r", Integer.valueOf(args.getR()));
        data.put("c", Integer.valueOf(args.getC()));
        clientViewProxy.invokeControlMethod(spreadKey, "setLookupData", new Object[]{data});
    }

    public static void spreadF7lookUpData(IClientViewProxy clientViewProxy, String spreadKey, String entityNum, LookUpDataArgs args, QFilter filtdetail) {
        ORM orm = ORM.create();
        boolean isUseFtlike = ConfigServiceHelper.getGlobalBoolParam((String)"isUseFtlike");
        QFilter nameAndNumberfilter = new QFilter("1", "ftlike", (Object)("name,number#" + args.getValue().trim()));
        QFilter filtname = new QFilter("name", "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight()));
        QFilter filtnumber = new QFilter(NUMBER, "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight()));
        if (!isUseFtlike) {
            nameAndNumberfilter = filtname.or(filtnumber);
        }
        int top = 20;
        if (StringUtils.isNotBlank((Object)args.getCountEnd())) {
            top = args.getCountEnd();
        }
        DataSet ds = orm.queryDataSet(SpreadUtils.class.getName(), entityNum, "id,number,name", new QFilter[]{filtdetail, nameAndNumberfilter}, NUMBER, top);
        DynamicObjectCollection queryCollection = orm.toPlainDynamicObjectCollection(ds, args.getCountStart() - 1, top);
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        ArrayList arrs = new ArrayList();
        Iterator iterator = queryCollection.iterator();
        while (iterator.hasNext()) {
            ArrayList<String> arr = new ArrayList<String>();
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            arr.add(dynamicObject.getString("id"));
            arr.add(dynamicObject.getString(NUMBER));
            arr.add(dynamicObject.getString("name"));
            arrs.add(arr);
        }
        data.put("data", arrs);
        data.put("r", Integer.valueOf(args.getR()));
        data.put("c", Integer.valueOf(args.getC()));
        clientViewProxy.invokeControlMethod(spreadKey, "setLookupData", new Object[]{data});
    }

    public static void spreadF7lookUpData(IClientViewProxy clientViewProxy, String spreadKey, String entityNum, String dimNum, LookUpDataArgs args, long modelId) {
        QFilter filtdetail = null;
        if ("bcm_entitymembertree".equals(entityNum)) {
            filtdetail = new QFilter("isexchangerate", "!=", (Object)"1");
        }
        SpreadUtils.spreadF7lookUpData(clientViewProxy, spreadKey, entityNum, dimNum, args, modelId, filtdetail, null, null, null);
    }

    public static QFilter getPermissonFilter(String entityName, String dimNum, Object modelid) {
        if (MemberPermHelper.getLimitedModelListByUser().contains(modelid)) {
            return null;
        }
        long modelId = modelid != null ? Long.parseLong(modelid.toString()) : 0L;
        long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        QFilter permissonFilter = PermissionServiceImpl.getInstance((Long)modelId).getWritePermFilter(Long.valueOf(dimensionId), DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), "id");
        return permissonFilter;
    }

    public static void updateCellOnUnchangeState(Book book) {
        SpreadUtils.updateCellOnUnchangeState(book, true);
    }

    public static void updateCellOnUnchangeState(Book book, boolean isOnlyMdDomain) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            book.getSheet(i).iteratorCells(cell -> {
                if (isOnlyMdDomain && cell.isMdDataDomain() || !isOnlyMdDomain) {
                    cell.setChangeVal(false);
                }
            });
        }
    }

    public static DynamicObjectCollection queryMemberByMembProperty(CustomProperty property, List<MembProperty> membProps, Dimension dim) {
        return SpreadUtils.queryMemberByMembProperty(Collections.singletonList(property), membProps, dim);
    }

    public static DynamicObjectCollection queryMemberByMembProperty(List<CustomProperty> property, List<MembProperty> membProps, Dimension dim) {
        ArrayList pids = new ArrayList();
        property.forEach(e -> pids.add(e.getId()));
        DynamicObjectCollection propertyDy = QueryServiceHelper.query((String)property.get(0).getDataEntityNumber(), (String)"propertyn", (QFilter[])new QFilter[]{new QFilter("id", "in", pids)});
        HashSet set = new HashSet();
        QFilter qf = new QFilter("id", "=", (Object)dim.getId());
        DynamicObject dymodel = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"model.id", (QFilter[])new QFilter[]{qf});
        String modelid = String.valueOf(dymodel.get("model.id"));
        DistributionDetailsSpreadLogic ddsl = new DistributionDetailsSpreadLogic();
        for (MembProperty p : membProps) {
            int range = p.getScope();
            Long valueid = p.getId();
            set.addAll(ddsl.chooseMethodByRange("bcm_definedpropertyvalue", range, valueid, modelid, "parentid", DetailTypeEnum.OTHERS));
        }
        DynamicObjectCollection members = null;
        for (int i = 0; i < propertyDy.size(); ++i) {
            if (set.isEmpty() || (members = QueryServiceHelper.query((String)dim.getMemberEntityNumber(), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter(((DynamicObject)propertyDy.get(i)).getString("propertyn"), "in", set)})) == null || members.size() <= 0) continue;
            return members;
        }
        return members;
    }

    public static void cleanCellInfoBySpecifiedArea(Sheet sheet, String area, Consumer<Cell> s) {
        String[] splitArr = area.split(":");
        int[] from = ExcelUtils.pos2XY((String)splitArr[0]);
        int[] end = ExcelUtils.pos2XY((String)splitArr[1]);
        sheet.iteratorRangeCells(from[1], end[1], from[0], end[0], s);
    }

    public static int getMaxNotNullRow(Sheet sheet, int first) {
        int max = sheet.getMaxRowCount();
        if (first > max) {
            return first;
        }
        for (int i = max - 1; i >= first; --i) {
            List cells = sheet.getRow(i);
            boolean notallnull = sheet.getRow(i).stream().anyMatch(c -> c.getValue() != null && StringUtils.isNotEmpty((CharSequence)c.getValue().toString()));
            if (notallnull) {
                return i + 1;
            }
            max = i + 1;
        }
        return max;
    }
}

