/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.standingbook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import org.apache.commons.lang3.StringUtils;

public class ExtDataStandingBookPlugin
extends AbstractBaseListPlugin
implements MainPage,
DynamicPage {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ExtDataStandingBookPlugin.class);
    private static final String BTN_QUERY = "btn_query";
    private static final String BTN_RESET = "btn_reset";
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_EXPORT = "btn_export";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_CLOSE = "btn_close";
    private static final String OPEN_AP = "openap";
    private static final String OPEN_LABEL = "openfilter";
    private static final String OPEN_ICON = "vectorap";
    private static final String CLOSE_AP = "closeap";
    private static final String CLOSE_LABEL = "closefilter";
    private static final String CLOSE_ICON = "vectorap1";
    private static final String FILTER_AP = "filterap";
    private static final String MODEL = "model";
    private static final String EXT_MODEL = "extdatamodel";
    private static final String SCENE = "scenario";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String CURRENCY = "currency";
    private static final String ENTITY = "entity";
    private static final String PROCESS = "process";
    private static final String AUDIT = "audittrail";
    protected static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period", "currency"});
    private static final List<Pair<String, String>> mustInputF7 = Arrays.asList(new Pair((Object)"model", (Object)ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"ExtDataStandingBookPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Pair((Object)"extdatamodel", (Object)ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b", (String)"ExtDataStandingBookPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Pair((Object)"scenario", (Object)DimTypesEnum.SCENARIO.getName()), new Pair((Object)"year", (Object)DimTypesEnum.YEAR.getName()), new Pair((Object)"period", (Object)DimTypesEnum.PERIOD.getName()), new Pair((Object)"currency", (Object)DimTypesEnum.CURRENCY.getName()), new Pair((Object)"entity", (Object)ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtDataStandingBookPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Pair((Object)"process", (Object)DimTypesEnum.PROCESS.getName()), new Pair((Object)"audittrail", (Object)DimTypesEnum.AUDITTRIAL.getName()));

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap", "toolbarap1");
        BasedataEdit extModel = (BasedataEdit)this.getControl(EXT_MODEL);
        extModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(ENTITY, PROCESS, AUDIT, OPEN_LABEL, OPEN_ICON, CLOSE_LABEL, CLOSE_ICON);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = ((BasedataEdit)evt.getSource()).getKey();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (EXT_MODEL.equals(key)) {
            QFilter qf = new QFilter(MODEL, "=", (Object)this.getModelId());
            qf.and(new QFilter("extendsgroup.grouptype", "in", Arrays.asList(ExtendDimGroupType.COMMON.getIndex(), ExtendDimGroupType.TRANSACTION.getIndex())));
            qf.and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().getQFilters().add(qf);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, true);
        this.setBtnVisible(null);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{ENTITY, PROCESS, AUDIT})) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtDataStandingBookPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String dimNum = DimEntityNumEnum.getNumberByLowercaseNumber((String)key);
            IDNumberTreeNode entityNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)dimNum, (String)dimNum);
            this.showMulTiF7(key, dimNum, entityNode.getId());
        } else if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{CLOSE_LABEL, CLOSE_ICON})) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FILTER_AP, CLOSE_AP});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{OPEN_AP});
        } else if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{OPEN_LABEL, OPEN_ICON})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FILTER_AP, CLOSE_AP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OPEN_AP});
        }
    }

    private void showMulTiF7(String key, String number, Long rootid) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)this.getModelId(), (String)number);
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_mulmemberf7base_tem");
        para.setCaption(String.format(ResManager.loadKDString((String)"%s-\u6210\u5458\u9009\u62e9", (String)"ExtDataStandingBookPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString("name")));
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("sign", key);
        para.setCustomParams(params);
        if (rootid != 0L) {
            para.setCustomParam("rootid", (Object)rootid);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
        if (doc != null) {
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            StringBuilder sb = new StringBuilder();
            ArrayList list = new ArrayList(doc.size());
            Object[] ids = new Object[doc.size()];
            for (int i = 0; i < doc.size(); ++i) {
                ids[i] = ((DynamicObject)doc.get(i)).get(4);
                HashMap<String, String> map = new HashMap<String, String>();
                String id = ((DynamicObject)doc.get(i)).get(4).toString();
                String name = ((DynamicObject)doc.get(i)).get(3).toString();
                map.put("id", id);
                map.put("scope", ((DynamicObject)doc.get(i)).get(5).toString());
                map.put("number", ((DynamicObject)doc.get(i)).get(2).toString());
                map.put("name", name);
                map.put("pid", ((DynamicObject)doc.get(i)).get(6).toString());
                if (RangeEnum.getRangeByVal((int)((DynamicObject)doc.get(i)).getInt(5)) == RangeEnum.VALUE_10) {
                    sb.append(((DynamicObject)doc.get(i)).get(3).toString()).append(',');
                } else {
                    sb.append(((DynamicObject)doc.get(i)).get(3).toString()).append(ResManager.loadKDString((String)"\u7684", (String)"ChechedBasicInfoPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)((DynamicObject)doc.get(i)).getInt(5)).getName()).append(',');
                }
                list.add(map);
            }
            if (StringUtils.isEmpty((CharSequence)sb.toString())) {
                this.getModel().setValue(key, (Object)"");
                this.getPageCache().put(key, null);
            } else {
                this.getModel().setValue(key, (Object)sb.substring(0, sb.length() - 1));
                this.getPageCache().put(key, SerializationUtils.toJsonString(list));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsAny((CharSequence)itemKey, (CharSequence[])new CharSequence[]{BTN_EDIT, BTN_SAVE, BTN_EXPORT, BTN_REFRESH}) && this.getPageCache().get("standing_book_child") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u67e5\u8be2\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ExtDataStandingBookPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equalsAny((CharSequence)itemKey, (CharSequence[])new CharSequence[]{BTN_QUERY, BTN_EDIT, BTN_SAVE})) {
            this.checkF7MustInput();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_query": {
                this.query();
                this.setBtnVisible(itemKey);
                break;
            }
            case "btn_reset": {
                this.resetF7Select();
                break;
            }
            case "btn_refresh": {
                this.sendMsg2ResultPage(itemKey);
                this.setBtnVisible(itemKey);
                break;
            }
            case "btn_edit": 
            case "btn_save": {
                this.sendMsg2ResultPage(itemKey);
                this.setBtnVisible(itemKey);
                break;
            }
            case "btn_import": {
                break;
            }
            case "btn_export": {
                this.sendMsg2ResultPage(itemKey);
                break;
            }
            case "btn_close": {
                break;
            }
        }
    }

    private void resetF7Select() {
        this.getModel().setValue(SCENE, null);
        this.getModel().setValue(YEAR, null);
        this.getModel().setValue(PERIOD, null);
        this.getModel().setValue(CURRENCY, null);
        this.getModel().setValue(ENTITY, null);
        this.getModel().setValue(PROCESS, null);
        this.getModel().setValue(AUDIT, null);
        this.getPageCache().remove(ENTITY);
        this.getPageCache().remove(PROCESS);
        this.getPageCache().remove(AUDIT);
    }

    private void checkF7MustInput() {
        IDataModel model = this.getModel();
        mustInputF7.forEach(p -> {
            if (model.getValue((String)p.p1) == null || "".equals(model.getValue((String)p.p1))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u3002", (String)"ExtDataStandingBookPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), p.p2));
            }
        });
    }

    private void sendMsg2ResultPage(String itemKey) {
        CommandParam commandParam = new CommandParam("bcm_standingbook", "bcm_standingbook_result", itemKey, "");
        this.sendMsg(this.getView(), commandParam);
    }

    private void setBtnVisible(String itemKey) {
        if (BTN_EDIT.equals(itemKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_SAVE});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "model": {
                this.propertyChangedModelUse(dimKeys);
                break;
            }
            case "entity": 
            case "process": 
            case "audittrail": {
                if (newValue != null && !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getPageCache().put(key, null);
                break;
            }
        }
        if (dimKeys.contains(key)) {
            this.propertyChangedDimUse(key, (DynamicObject)newValue, false, true);
        }
    }

    private void query() {
        try {
            if (this.getModel().getValue(EXT_MODEL) == null) {
                return;
            }
            Long id = ((DynamicObject)this.getModel().getValue(EXT_MODEL)).getLong("id");
            Map<String, String[]> f7ValueMap = this.getDimeF7NumberMap();
            FormShowParameter showParameter = new FormShowParameter();
            String pageId = this.getPageIdAndCache(this.getPageCache(), "bcm_standingbook_result", true);
            showParameter.setPageId(pageId);
            showParameter.setFormId("bcm_standingbook_result");
            showParameter.setCustomParam("extModelId", (Object)id);
            showParameter.setCustomParam("f7ValueMap", (Object)ObjectSerialUtil.toByteSerialized(f7ValueMap));
            showParameter.setCustomParam(ENTITY, (Object)this.getPageCache().get(ENTITY));
            showParameter.setCustomParam(PROCESS, (Object)this.getPageCache().get(PROCESS));
            showParameter.setCustomParam("audit", (Object)this.getPageCache().get(AUDIT));
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("result");
            this.getPageCache().put("standing_book_child", pageId);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            log.error("standingBook query failed:", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ExtDataStandingBookPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, String[]> getDimeF7NumberMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("Scenario", new String[]{((DynamicObject)this.getModel().getValue(SCENE)).getString("number")});
        map.put("Year", new String[]{((DynamicObject)this.getModel().getValue(YEAR)).getString("number")});
        map.put("Period", new String[]{((DynamicObject)this.getModel().getValue(PERIOD)).getString("number")});
        map.put("Currency", new String[]{((DynamicObject)this.getModel().getValue(CURRENCY)).getString("number")});
        return map;
    }
}

