/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.standingbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataQueryService;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.extdata.sql.StbSaveComInfo;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.page.model.ComboEditElement;
import kd.fi.bcm.business.page.model.DecimalEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.entry.DynamicEntry;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.DataSetUtil;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExtDataStandingBookResultPlugin
extends AbstractBaseFormPlugin
implements DynamicPage,
SubPage {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String LABEL = "labelap";
    private static final String BTN_ADDROW = "addrow";
    private static final String BTN_DELETEROW = "deleterow";
    private static final String PK_ID = "id";
    private static final String ORG = "org";
    private static final String cache_delIds = "delIds";
    private static final String cache_updateIds = "updateIds";
    private static final String cache_colSigns = "colSigns";
    private static final String cache_colNames = "colNames";
    private static final String cache_colSign2DimNumber = "colSign2DimNumber";
    private static final String cache_mustInputColSigns = "mustInputColSigns";
    private static final String cache_ext2MulF7 = "ext2MulF7";
    private static final Map<String, String> extraColumn = new LinkedHashMap<String, String>(){
        {
            this.put(ExtDataStandingBookResultPlugin.ORG, ResManager.loadKDString((String)"\u5b58\u50a8\u7ec4\u7ec7", (String)"ExtDataStandingBookResultPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.put(DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ROOT), ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtDataStandingBookResultPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.put(DimTypesEnum.PROCESS.getNumber().toLowerCase(Locale.ROOT), DimTypesEnum.PROCESS.getName());
            this.put(DimTypesEnum.CURRENCY.getNumber().toLowerCase(Locale.ROOT), DimTypesEnum.CURRENCY.getName());
            this.put(DimTypesEnum.AUDITTRIAL.getNumber().toLowerCase(Locale.ROOT), DimTypesEnum.AUDITTRIAL.getName());
        }
    };

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.buildPage();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADDROW, BTN_DELETEROW});
        }
        catch (Exception exp) {
            log.error("standingBook query failed:", (Throwable)exp);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ExtDataStandingBookResultPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("btn_edit".equals(operation)) {
            this.makeEntryCanEdit();
        } else if ("btn_save".equals(operation)) {
            this.save();
        } else if ("btn_export".equals(operation)) {
            this.export();
        } else if ("btn_refresh".equals(operation)) {
            this.refresh();
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (extraColumn.containsKey(key) || this.getColSign2DimNumber().containsKey(key) || this.getExt2MulF7().containsKey(key)) {
            TextEdit edit = new TextEdit();
            edit.setKey(e.getKey());
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        }
    }

    private void refresh() {
        DynamicObjectCollection data = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (data != null) {
            List<Object> ids = data.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            ids.addAll(this.getDelIds());
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.fillData(this.getExtendsModel(), ids);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADDROW, BTN_DELETEROW});
        }
    }

    private void export() {
        String url = "";
        url = this.handleExportData();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)url)) {
            this.downloadFile(url, "bcm_query_mainpage", "47150e89000000ac");
            HashMap f7ValueMap = (HashMap)this.deSerializedBytes((String)this.getFormCustomParam("f7ValueMap"));
            String logStr = new StringJoiner("|").add(this.getExtendsModel().getNumber()).add(((String[])f7ValueMap.get(DimTypesEnum.SCENARIO.getNumber()))[0]).add(((String[])f7ValueMap.get(DimTypesEnum.YEAR.getNumber()))[0]).add(((String[])f7ValueMap.get(DimTypesEnum.PERIOD.getNumber()))[0]).toString();
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "ExtDataStandingBookResultPlugin_23", "fi-bcm-formplugin", "Export"), new OPDescMultiLangEnumBridge("%s\u5bfc\u51fa\u6210\u529f\u3002", "ExtDataStandingBookResultPlugin_24", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{logStr})));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleExportData() {
        DynamicObjectCollection allData = this.getModel().getEntryEntity(ENTRY_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Set rowsSet = Arrays.stream(selectRows).boxed().collect(Collectors.toSet());
        List toExportData = allData.stream().filter(d -> rowsSet.contains(d.getInt("seq") - 1)).collect(Collectors.toList());
        try (XSSFWorkbook workBook = new XSSFWorkbook();){
            XSSFCell cell;
            XSSFCellStyle style = workBook.createCellStyle();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFCellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillForegroundColor(s);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            XSSFSheet xssfSheet = workBook.createSheet(StringUtils.isEmpty((CharSequence)this.getExtendsModel().getName()) ? "noName" : this.getExtendsModel().getName());
            LinkedHashSet<String> headerSet = this.getAllColSigns();
            LinkedHashSet<String> allColNames = this.getAllColNames();
            int rowNum = 0;
            XSSFRow headerRow1 = xssfSheet.createRow(rowNum);
            int i = 0;
            for (String headName : allColNames) {
                if ("org_id".equals(headName)) continue;
                cell = headerRow1.createCell(i, CellType.STRING);
                cell.setCellValue(headName);
                cell.setCellStyle((CellStyle)headerStyle);
                ++i;
            }
            ++rowNum;
            Object string = toExportData.iterator();
            while (true) {
                Iterator iterator;
                ArrayList row;
                DynamicObject rowData;
                if (string.hasNext()) {
                    rowData = (DynamicObject)string.next();
                    row = Lists.newArrayListWithExpectedSize((int)headerSet.size());
                    i = 0;
                    iterator = headerSet.iterator();
                } else {
                    string = ImportAndExportUtil.writeFile(workBook, String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u53f0\u8d26_%s", (String)"ExtDataStandingBookResultPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TimeServiceHelper.formatUserNow()));
                    return string;
                }
                while (iterator.hasNext()) {
                    String s1 = (String)iterator.next();
                    if ("org_id".equals(s1)) continue;
                    row.add(rowData.get(s1));
                    ++i;
                }
                XSSFRow xssfRow = xssfSheet.createRow(rowNum);
                for (int j = 0; j < row.size(); ++j) {
                    cell = xssfRow.createCell(j);
                    Object cellData = row.get(j);
                    if (cellData instanceof DynamicObject) {
                        cell.setCellValue(((DynamicObject)cellData).getString("name"));
                    } else if (cellData != null) {
                        if (cellData.toString().length() < SpreadsheetVersion.EXCEL2007.getMaxTextLength()) {
                            cell.setCellValue(cellData.toString());
                        } else {
                            XSSFRichTextString richText = workBook.getCreationHelper().createRichTextString(cellData.toString());
                            cell.setCellValue((RichTextString)richText);
                        }
                    }
                    cell.setCellStyle((CellStyle)style);
                }
                ++rowNum;
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void save() {
        try {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            Map data = entryGrid.getEntryData().getData();
            DynamicObject[] datas = entryGrid.getEntryData().getDataEntitys();
            ExtendsModel extendsModel = this.getExtendsModel();
            if (datas.length > 0 || !this.getDelIds().isEmpty()) {
                Set<Long> updateIds = this.getUpdateIds();
                Map<String, List<DynamicObject>> groupMap = Arrays.stream(datas).filter(d -> updateIds.contains(d.getLong(PK_ID)) || d.getLong(PK_ID) == 0L).collect(Collectors.groupingBy(d -> d.get(ORG) + "@@" + d.get("currency") + "@@" + d.get("process") + "@@" + d.get("audittrail")));
                this.illegalDataFilter(groupMap, extendsModel);
                List<StbSaveComInfo> saveComInfos = this.buildSaveInfo(groupMap, extendsModel);
                JobInfo jobInfo = new JobInfo();
                IFormView view = this.getView();
                jobInfo.setAppId(view.getFormShowParameter().getServiceAppId());
                jobInfo.setJobType(JobType.REALTIME);
                jobInfo.setId(UUID.randomUUID().toString());
                jobInfo.setName(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u53f0\u8d26\u4fdd\u5b58", (String)"ExtDataStandingBookResultPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                jobInfo.setTaskClassname("kd.fi.bcm.formplugin.standingbook.ExtStandingBookSaveTask");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put(cache_delIds, ObjectSerialUtil.toByteSerialized(this.getDelIds()));
                params.put("saveComInfos", ObjectSerialUtil.toByteSerialized(saveComInfos));
                params.put("groupType", extendsModel.getExtendsGroupType());
                jobInfo.setParams(params);
                jobInfo.setRunByLang(Lang.get());
                jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
                JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "save");
                clientJobInfo.setCloseCallBack(closeCallBack);
                clientJobInfo.setCanBackground(false);
                clientJobInfo.setTimeout(3600);
                clientJobInfo.setParentPageId(view.getPageId());
                JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
            }
        }
        catch (KDBizException kde) {
            throw kde;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5f02\u5e38\uff1a", (Throwable)e);
            throw new KDBizException("save failed, system error");
        }
    }

    private void illegalDataFilter(Map<String, List<DynamicObject>> groupMap, ExtendsModel extendsModel) {
        Collection allOrgNode = MemberReader.getAllNodeByDimNum((String)DimTypesEnum.ENTITY.getNumber(), (String)this.getCurModelNumber());
        List allOrgIds = allOrgNode.stream().map(IDNumberTreeNode::getId).collect(Collectors.toList());
        Map org_ccy = OrgCurrencyServiceHelper.getOrgDefaultCurrencys((long)this.getModelId(), (Collection)allOrgNode.stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        Map<String, Long> orgNumber2Id = allOrgNode.stream().collect(Collectors.toMap(IDNumberTreeNode::getNumber, IDNumberTreeNode::getId, (o, n) -> o));
        HashSet<String> mustInputColSigns = this.getMustInputColSigns();
        HashMap f7ValueMap = (HashMap)this.deSerializedBytes((String)this.getFormCustomParam("f7ValueMap"));
        Long sceneId = MemberReader.findScenaMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.SCENARIO.getNumber()))[0]).getId();
        Long yearId = MemberReader.findFyMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.YEAR.getNumber()))[0]).getId();
        Long periodId = MemberReader.findPeriodMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.PERIOD.getNumber()))[0]).getId();
        Map mcStatusMap = McStatus.batchGetMcStatus((Object)this.getModelId(), allOrgIds, (Object)sceneId, (Object)yearId, (Object)periodId);
        for (Map.Entry<String, List<DynamicObject>> next : groupMap.entrySet()) {
            String rowIndex = next.getValue().get(0).getString("seq");
            String[] split = next.getKey().split("@@");
            if (split.length < 4) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7b2c%s\u884c\u7684\u7ec4\u7ec7\u3001\u5e01\u79cd\u3001\u8fc7\u7a0b\u3001\u5ba1\u8ba1\u7ebf\u7d22\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ExtDataStandingBookResultPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowIndex));
            }
            String orgNumber = split[0].contains("_") ? split[0].split("_")[1] : split[0];
            this.checkMustInputAndDateFormat(mustInputColSigns, next.getValue(), extendsModel);
            if (!this.isSpecificCcy(split[1])) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7b2c%s\u884c\u8f93\u5165\u5177\u4f53\u5e01\u79cd\u3002", (String)"ExtDataStandingBookResultPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowIndex));
            }
            String errorMsg = this.canSaveDimComb(split[0], split[2], split[3]);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                throw new KDBizException(errorMsg);
            }
            if (split[1].equals(((DynamicObject)org_ccy.get(orgNumber2Id.get(orgNumber))).getString("number")) || !StringUtils.isNotEmpty((CharSequence)(errorMsg = this.checkAutoConvert(extendsModel, split[0])))) continue;
            throw new KDBizException(errorMsg);
        }
    }

    private void checkFlowAndPeriodSts(Long sceneId, Long yearId, Long periodId, McStatus mcStatus, String orgNumber, DynamicObject row) {
        if (row.getLong(PK_ID) == 0L) {
            return;
        }
        if (!PeriodSettingHelper.checkPeriodStatus((long)this.getModelId(), (String)orgNumber, (long)sceneId, (long)yearId, (long)periodId, (String)"datastatus")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u7ec4\u7ec7\u671f\u95f4\u672a\u5f00\u542f\u6216\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u4fee\u6539\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNumber));
        }
        if (mcStatus != null && mcStatus.getFlow().isSubmit()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u7ec4\u7ec7\u6d41\u7a0b\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u4fee\u6539\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNumber));
        }
    }

    private void checkMustInputAndDateFormat(HashSet<String> mustInputColSigns, List<DynamicObject> value, ExtendsModel extendsModel) {
        List dataTypeFields = extendsModel.getExtFieldEntry().stream().filter(f -> DataTypeEnum.DATETP.index.equals(f.getExtField().getDataType())).map(f -> f.getExtField().getNumber().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        for (DynamicObject dyn : value) {
            for (String colSign : mustInputColSigns) {
                if (dyn.get(colSign) != null && !StringUtils.isEmpty((CharSequence)dyn.getString(colSign))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8bf7\u8f93\u5165\u5fc5\u5f55\u5b57\u6bb5%2$s\u7684\u503c\u3002", (String)"ExtDataStandingBookResultPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.get("seq"), colSign));
            }
            for (String dataTypeField : dataTypeFields) {
                if (!StringUtils.isNotEmpty((CharSequence)dyn.getString(dataTypeField))) continue;
                try {
                    Date date = DateTimeUtils.parseStrDate((String)dyn.getString(dataTypeField));
                }
                catch (Exception e) {
                    log.error("\u65e5\u671f\u683c\u5f0f\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff1a", (Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u65e5\u671f\u683c\u5f0f\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExtDataStandingBookResultPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyn.get("seq")));
                }
            }
        }
    }

    private boolean isSpecificCcy(String ccy) {
        return !"EC".equals(ccy) && !"DC".equals(ccy) && !"PC".equals(ccy);
    }

    private String canSaveDimComb(String org, String process, String audit) {
        String modelNumber = this.getCurModelNumber();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)(org.contains("_") ? org.split("_")[0] : org));
        CanSaveCombineEnum combineEnum = this.getCombineEnum(process, audit);
        if (combineEnum == null) {
            return String.format(ResManager.loadKDString((String)"%1$s + %2$s\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5141\u8bb8\u4fdd\u5b58\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), process, audit);
        }
        if (orgNode.isLeaf()) {
            if (combineEnum == CanSaveCombineEnum.mergeUnitAdj) {
                return String.format(ResManager.loadKDString((String)"%s\uff1a\u660e\u7ec6\u7ec4\u7ec7\u4e0d\u53ef\u8fdb\u884c\u5408\u5e76\u5355\u5143\u8c03\u6574\u62b5\u9500\u3002", (String)"ExtDataStandingBookResultPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), org);
            }
        } else {
            HashMap f7ValueMap = (HashMap)this.deSerializedBytes((String)this.getFormCustomParam("f7ValueMap"));
            Long sceneId = MemberReader.findScenaMemberByNum((String)modelNumber, (String)((String[])f7ValueMap.get(DimTypesEnum.SCENARIO.getNumber()))[0]).getId();
            Long yearId = MemberReader.findFyMemberByNum((String)modelNumber, (String)((String[])f7ValueMap.get(DimTypesEnum.YEAR.getNumber()))[0]).getId();
            Long periodId = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)((String[])f7ValueMap.get(DimTypesEnum.PERIOD.getNumber()))[0]).getId();
            Long orgId = orgNode.getId();
            MergeDataSourceEnum mergeSource = MergeControlHelper.getMergeSource((Object)this.getModelId(), (Object)sceneId, (Object)yearId, (Object)periodId, (Object)orgId);
            if (MergeDataSourceEnum.SIRpt == mergeSource && combineEnum == CanSaveCombineEnum.reportInput) {
                return String.format(ResManager.loadKDString((String)"%s\uff1a\u5408\u5e76\u6570\u636e\u6765\u6e90\u4e3a\u62a5\u8868\u6c47\u603b\uff0c\u4e0d\u5141\u8bb8\u62a5\u8868\u8fc7\u7a0b\u5f55\u5165\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber());
            }
            if (MergeDataSourceEnum.CSTE == mergeSource && combineEnum == CanSaveCombineEnum.merge2ChildAdj) {
                return String.format(ResManager.loadKDString((String)"%s\uff1a\u5408\u5e76\u6570\u636e\u6765\u6e90\u4e3a\u5408\u5e76\u5f55\u5165\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u5bf9\u4e0b\u7ea7\u8c03\u6574\u62b5\u9500\u3002", (String)"ExtDataStandingBookResultPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber());
            }
        }
        return "";
    }

    private String checkAutoConvert(ExtendsModel extendsModel, String org) {
        if (extendsModel.getIsConvert()) {
            return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3010%s\u3011\u652f\u6301\u6298\u7b97\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u5f55\u5165\u6298\u7b97\u5e01\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extendsModel.getNumber());
        }
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)this.getCurModelNumber(), (String)org);
        if (org.contains("_")) {
            orgNode = StringUtils.equals((CharSequence)orgNode.getParent_SonNumber(), (CharSequence)org) ? orgNode.getParent() : orgNode.getShareNodes().stream().filter(s -> StringUtils.equals((CharSequence)s.getParent_SonNumber(), (CharSequence)org)).findFirst().orElse(orgNode).getParent();
        }
        HashMap f7ValueMap = (HashMap)this.deSerializedBytes((String)this.getFormCustomParam("f7ValueMap"));
        Long sceneId = MemberReader.findScenaMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.SCENARIO.getNumber()))[0]).getId();
        Long yearId = MemberReader.findFyMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.YEAR.getNumber()))[0]).getId();
        Long periodId = MemberReader.findPeriodMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.PERIOD.getNumber()))[0]).getId();
        if (ExchangeQueryHelper.getAutoConvert((Long)this.getModelId(), (Long)sceneId, (Long)yearId, (Long)periodId, (SimpleVo)SimpleVo.newOne((IDNumberTreeNode)orgNode)).booleanValue()) {
            return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%s\u3011\u5f00\u542f\u4e86\u81ea\u52a8\u6298\u7b97\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u5f55\u5165\u6298\u7b97\u5e01\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), org);
        }
        return "";
    }

    private CanSaveCombineEnum getCombineEnum(String process, String audit) {
        boolean isAdjLeaf;
        IDNumberTreeNode auditNode = MemberReader.findMemberByNumber((String)this.getCurModelNumber(), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)audit);
        boolean bl = isAdjLeaf = auditNode.isLeaf() && auditNode.getLongNumber().contains("ADJE!");
        if (("IRpt".equals(process) || "EIRpt".equals(process)) && "EntityInput".equals(audit)) {
            return CanSaveCombineEnum.reportInput;
        }
        if ("RAdj".equals(process) || "ERAdj".equals(process) && isAdjLeaf) {
            return CanSaveCombineEnum.reportAdj;
        }
        if (("DADJ".equals(process) || "DEJE".equals(process)) && isAdjLeaf) {
            return CanSaveCombineEnum.mergeUnitAdj;
        }
        if (("ADJ".equals(process) || "CADJ".equals(process) || "EJE".equals(process) || "CCADJ".equals(process)) && isAdjLeaf) {
            return CanSaveCombineEnum.merge2ChildAdj;
        }
        return null;
    }

    private List<StbSaveComInfo> buildSaveInfo(Map<String, List<DynamicObject>> groupMap, ExtendsModel extendsModel) {
        if (groupMap != null && !groupMap.isEmpty()) {
            ArrayList<StbSaveComInfo> saveComInfos = new ArrayList<StbSaveComInfo>(groupMap.size());
            for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
                String entityNumber;
                String[] split = entry.getKey().split("@@");
                List<DynamicObject> dynList = entry.getValue();
                StbSaveComInfo saveComInfo = new StbSaveComInfo(MemberReader.findModelSNumberById((Object)this.getModelId()), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
                HashMap<String, String> fixDimension = new HashMap<String, String>();
                if (split[0].contains("_")) {
                    entityNumber = split[0].split("_")[1];
                    saveComInfo.setParentOrg(split[0].split("_")[0]);
                } else {
                    entityNumber = split[0];
                }
                fixDimension.put(DimTypesEnum.ENTITY.getNumber(), entityNumber);
                fixDimension.put(DimTypesEnum.SCENARIO.getNumber(), ((DynamicObject)this.getView().getParentView().getModel().getValue("scenario")).getString("number"));
                fixDimension.put(DimTypesEnum.YEAR.getNumber(), ((DynamicObject)this.getView().getParentView().getModel().getValue("year")).getString("number"));
                fixDimension.put(DimTypesEnum.PERIOD.getNumber(), ((DynamicObject)this.getView().getParentView().getModel().getValue("period")).getString("number"));
                fixDimension.put(DimTypesEnum.CURRENCY.getNumber(), split[1]);
                fixDimension.put(DimTypesEnum.PROCESS.getNumber(), split[2]);
                fixDimension.put(DimTypesEnum.AUDITTRIAL.getNumber(), split[3]);
                saveComInfo.setFixDim(fixDimension);
                saveComInfo.setDims(extendsModel.getDimFieldEntry().stream().map(f -> f.getDimension().getNumber()).collect(Collectors.toList()).toArray(new String[0]));
                saveComInfo.setCols(extendsModel.getExtFieldEntry().stream().map(f -> f.getExtField().getNumber()).collect(Collectors.toList()).toArray(new String[0]));
                Set<Long> updateIds = this.getUpdateIds();
                for (DynamicObject dyn : dynList) {
                    if (dyn.getLong(PK_ID) == 0L) {
                        saveComInfo.addValue(this.extractExtValues(dyn, extendsModel), this.extractDimValues(dyn, extendsModel));
                        continue;
                    }
                    if (!updateIds.contains(dyn.getLong(PK_ID))) continue;
                    saveComInfo.putUpdateValues(dyn.getLong(PK_ID), this.extractExtValues(dyn, extendsModel), this.extractDimValues(dyn, extendsModel));
                }
                saveComInfo.setUniquecheck(true);
                saveComInfos.add(saveComInfo);
            }
            return saveComInfos;
        }
        return new ArrayList<StbSaveComInfo>(10);
    }

    private Object[] extractExtValues(DynamicObject data, ExtendsModel extendsModel) {
        ArrayList<Object> objects = new ArrayList<Object>(10);
        int dimSize = extendsModel.getDimFieldEntry().size();
        int size = extendsModel.getExtFieldEntry().size();
        for (int i = 0; i < size; ++i) {
            Object o = data.get(i + dimSize + 7);
            objects.add(o instanceof String && "".equals(o) ? null : o);
        }
        return objects.toArray();
    }

    private String[] extractDimValues(DynamicObject data, ExtendsModel extendsModel) {
        ArrayList<String> objects = new ArrayList<String>(10);
        int size = extendsModel.getDimFieldEntry().size();
        for (int i = 0; i < size; ++i) {
            objects.add(data.getString(i + 7));
        }
        return objects.toArray(new String[0]);
    }

    private void makeEntryCanEdit() {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        if (entry == null) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{ENTRY_ENTITY});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_ADDROW, BTN_DELETEROW});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ORG});
    }

    private void buildPage() {
        ExtendsModel extendsModel = this.getExtendsModel();
        this.buildLabelStr(extendsModel);
        this.createTable(extendsModel);
        this.fillData(extendsModel, null);
    }

    private ExtendsModel getExtendsModel() {
        Object id = this.getFormCustomParam("extModelId");
        return new ExtendsModel().getExtendsModel(LongUtil.toLong((Object)id));
    }

    private void buildLabelStr(ExtendsModel extendsModel) {
        StringJoiner fieldSj = new StringJoiner("/");
        for (ExtFieldEntry fieldEntry : extendsModel.getExtFieldEntry()) {
            if (!fieldEntry.getUniqueCheck()) continue;
            fieldSj.add(fieldEntry.getExtField().getName());
        }
        String uqField = String.format(ResManager.loadKDString((String)"\u552f\u4e00\u6027\u5b57\u6bb5\uff1a%s", (String)"ExtDataStandingBookResultPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldSj.toString());
        IDNumberTreeNode extGroup = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_structofextend", (Long)extendsModel.getExtendsGroup());
        String isMerge = String.format(ResManager.loadKDString((String)"\u6a21\u578b\u662f\u5426\u53c2\u4e0e\u5408\u5e76\uff1a%s", (String)"ExtDataStandingBookResultPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extGroup.getProperty("isparticipmerge") != null && (Boolean)extGroup.getProperty("isparticipmerge") != false ? ResManager.loadKDString((String)"\u662f", (String)"ExtDataStandingBookResultPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ExtDataStandingBookResultPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String isConvert = String.format(ResManager.loadKDString((String)"\u6a21\u578b\u662f\u5426\u53c2\u4e0e\u6298\u7b97\uff1a%s", (String)"ExtDataStandingBookResultPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extendsModel.getIsConvert() ? ResManager.loadKDString((String)"\u662f", (String)"ExtDataStandingBookResultPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ExtDataStandingBookResultPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        StringJoiner sj = new StringJoiner(" | ");
        Label label = (Label)this.getControl(LABEL);
        label.setText(sj.add(isMerge).add(isConvert).add(uqField).toString());
    }

    private void createTable(ExtendsModel extendsModel) {
        Object colSign;
        List dimFieldEntry = extendsModel.getDimFieldEntry();
        List extFieldEntry = extendsModel.getExtFieldEntry();
        HashMap<String, String> dimFieldColSigns = new HashMap<String, String>(10);
        LinkedHashSet<String> mustInputColSigns = new LinkedHashSet<String>(10);
        LinkedHashSet<String> allColSigns = new LinkedHashSet<String>(extraColumn.size() + dimFieldEntry.size() + extFieldEntry.size());
        LinkedHashSet<String> allColNames = new LinkedHashSet<String>(extraColumn.size() + dimFieldEntry.size() + extFieldEntry.size());
        Page page = new Page();
        DynamicEntry entry = new DynamicEntry(ENTRY_ENTITY);
        entry.setShowSeq(true);
        entry.setHasOperateIcon(true);
        page.addEntry(entry);
        for (Map.Entry<String, String> en : extraColumn.entrySet()) {
            Element element = this.createEditElement(en.getValue(), en.getKey());
            entry.addElement(element);
            allColSigns.add(en.getKey());
            allColNames.add(en.getValue());
            mustInputColSigns.add(en.getKey());
        }
        for (DimFieldEntry field : dimFieldEntry) {
            colSign = this.buildColSign(field.getDimension().getNumber());
            String name = field.getDimension().getName();
            Element element = this.createEditElement(name, (String)colSign);
            entry.addElement(element);
            allColSigns.add((String)colSign);
            allColNames.add(field.getDimension().getName());
            dimFieldColSigns.put((String)colSign, field.getDimension().getNumber());
            mustInputColSigns.add((String)colSign);
        }
        List allExtMemNums = extendsModel.getExtFieldEntry().stream().map(e -> e.getExtField().getNumber()).collect(Collectors.toList());
        Map f7ValueByExtMems = ExtDataUtil.getMultiF7ValueByExtMems(allExtMemNums, (long)this.getModelId());
        this.dealMultiF7ValueByExtMems(f7ValueByExtMems);
        for (ExtFieldEntry field : extFieldEntry) {
            String colSign2 = this.buildColSign(field.getExtField().getNumber());
            Element element = this.createExtEditElement(field, colSign2, f7ValueByExtMems.containsKey(field.getExtField().getNumber()));
            entry.addElement(element);
            allColSigns.add(colSign2);
            allColNames.add(field.getExtField().getName());
            if (!field.getIsNecessary()) continue;
            mustInputColSigns.add(colSign2);
        }
        colSign = this.buildColSign("org_id");
        Element element = this.createEditElement("org_id", (String)colSign);
        entry.addElement(element);
        allColSigns.add((String)colSign);
        allColNames.add("org_id");
        this.cacheColSign2DimNumber(dimFieldColSigns);
        this.cacheMustInputColSigns(mustInputColSigns);
        this.cacheAllColSigns(allColSigns);
        this.cacheAllColNames(allColNames);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void dealMultiF7ValueByExtMems(Map<String, MultiF7Results> f7ValueByExtMems) {
        HashMap<String, MultiF7Results> map = new HashMap<String, MultiF7Results>(f7ValueByExtMems.size());
        f7ValueByExtMems.forEach((key, value) -> map.put(this.buildColSign((String)key), (MultiF7Results)value));
        this.cacheExt2MulF7(map);
    }

    private Element createEditElement(String name, String sign) {
        TextEditElement element = new TextEditElement(name, sign, DimEntityNumEnum.getEntieyNumByNumber((String)sign));
        element.setWidth(new LocaleString("8%"));
        element.setMustInput(true);
        if (ORG.equals(sign)) {
            element.setLock("new,edit,view");
        }
        if ("org_id".equals(sign)) {
            element.setMustInput(false);
            element.setVisible("");
        }
        return element;
    }

    private Element createExtEditElement(ExtFieldEntry field, String sign, boolean isLink) {
        LocaleString width = new LocaleString("8%");
        String fieldType = field.getExtField().getDataType();
        String name = field.getExtField().getName();
        if (DataTypeEnum.DEFAULT.index.equals(fieldType) || DataTypeEnum.CURRENCY.index.equals(fieldType) || DataTypeEnum.UNCURRENCY.index.equals(fieldType) || DataTypeEnum.PROPORTION.index.equals(fieldType)) {
            DecimalEditElement element = new DecimalEditElement(name, sign, "");
            element.setWidth(width);
            element.setMustInput(field.getIsNecessary());
            element.setNoDisplayScaleZero(true);
            return element;
        }
        if (DataTypeEnum.ENUMTP.index.equals(fieldType)) {
            ComboEditElement element = new ComboEditElement(sign, name, this.getEnumConItems(field.getExtField().getEnumItemId()));
            element.setWidth(width);
            element.setMustinput(field.getIsNecessary());
            return element;
        }
        TextEditElement element = new TextEditElement(name, sign, "");
        element.setEditStyle(isLink ? 1 : 0);
        element.setWidth(width);
        element.setMustInput(field.getIsNecessary());
        return element;
    }

    private List<ComboItem> getEnumConItems(long enumItemId) {
        DynamicObject object = (DynamicObject)ThreadCache.get((Object)("enumitemid-" + enumItemId), () -> QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"id,datatype", (QFilter[])new QFilter(PK_ID, "=", (Object)enumItemId).toArray()));
        QFilter idQf = new QFilter("enumitemid", "=", (Object)enumItemId);
        idQf.and(new QFilter("model", "=", (Object)this.getModelId()));
        DynamicObjectCollection dyns = (DynamicObjectCollection)ThreadCache.get((Object)("enumvalue|" + this.getModelId() + "|" + enumItemId), () -> QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,datatype,enumvalue", (QFilter[])idQf.toArray()));
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dyns.size());
        for (DynamicObject dyo : dyns) {
            comboItems.add(new ComboItem(new LocaleString(dyo.getString("enumvalue")), dyo.getString("enumvalue")));
        }
        return comboItems;
    }

    private DataSet queryData(ExtendsModel extendsModel, List<Object> ids) {
        String[] extSelects;
        String modelShowNumber = MemberReader.findModelSNumberById((Object)this.getModelId());
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(modelShowNumber, extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        ArrayList dimFields = new ArrayList(extendsModel.getDimFieldEntry().size() + 2);
        extraColumn.keySet().forEach(e -> {
            if (ORG.equals(e)) {
                dimFields.add(ORG);
            } else {
                dimFields.add(e);
            }
        });
        extendsModel.getDimFieldEntry().forEach(s -> dimFields.add(s.getDimension().getNumber()));
        edQueryComInfo.setDimselects(dimFields.toArray(new String[0]));
        edQueryComInfo.setExtselects(extendsModel.getExtFieldEntry().stream().map(s -> s.getExtField().getNumber()).collect(Collectors.toList()).toArray(new String[0]));
        StringJoiner sj = new StringJoiner(",");
        sj.add(PK_ID);
        String[] dimSelects = edQueryComInfo.getDimselects();
        if (dimSelects != null) {
            Map fieldMappedForDims = edQueryComInfo.getFieldMappedForDims(dimSelects);
            Arrays.stream(dimSelects).forEach(dimSelect -> sj.add((CharSequence)fieldMappedForDims.get(dimSelect)));
        }
        if ((extSelects = edQueryComInfo.getExtselects()) != null) {
            Map fieldMappedForCols = edQueryComInfo.getFieldMappedForCols(extSelects);
            Arrays.stream(extSelects).forEach(extSelect -> sj.add((CharSequence)fieldMappedForCols.get(extSelect)));
        }
        String selectCols = sj.toString();
        QFilter[] qFilters = CollectionUtils.isEmpty(ids) ? this.getQFilters(extendsModel) : new QFilter(PK_ID, "in", ids).toArray();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bcm_ext", (String)ExtDataQueryService.getExtendEntity((EdQueryComInfo)edQueryComInfo), (String)selectCols, (QFilter[])qFilters, null);
        Map f7ValueMap = (Map)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("f7ValueMap")));
        if (!this.isSpecificCcy(((String[])f7ValueMap.get(DimTypesEnum.CURRENCY.getNumber()))[0])) {
            dataSet = this.filterNonDefaultCcyData(dataSet);
        }
        return dataSet;
    }

    private DataSet filterNonDefaultCcyData(DataSet dataSet) {
        Collection allOrgNode = MemberReader.getAllNodeByDimNum((String)DimTypesEnum.ENTITY.getNumber(), (String)this.getCurModelNumber());
        Set allOrgId = allOrgNode.stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet());
        final Map org_EC = OrgCurrencyServiceHelper.getOrgDefaultCurrencys((long)this.getModelId(), allOrgId);
        final Map org_PC = OrgCurrencyServiceHelper.getOrgParentCurrencys((long)this.getModelId(), allOrgId);
        FilterFunction function = new FilterFunction(){

            public boolean test(Row row) {
                String orgNum = row.getString(ExtDataStandingBookResultPlugin.ORG);
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)ExtDataStandingBookResultPlugin.this.getCurModelNumber(), (String)orgNum);
                if (orgNode == IDNumberTreeNode.NotFoundTreeNode) {
                    return false;
                }
                String dc = orgNum.contains("_") ? ((DynamicObject)org_PC.get(orgNode.getId())).getString("number") : ((DynamicObject)org_EC.get(orgNode.getId())).getString("number");
                return StringUtils.equals((CharSequence)row.getString("currency"), (CharSequence)dc);
            }
        };
        return dataSet.filter(function);
    }

    private QFilter[] getQFilters(ExtendsModel extendsModel) {
        String modelSNumber = MemberReader.findModelSNumberById((Object)this.getModelId());
        QFBuilder qfBuilder = new QFBuilder("modelnumber", "=", (Object)modelSNumber);
        qfBuilder.and("datamodel", "=", (Object)extendsModel.getNumber());
        Map f7ValueMap = (Map)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("f7ValueMap")));
        f7ValueMap.forEach((k, v) -> {
            if (DimTypesEnum.CURRENCY.getNumber().equals(k) && !this.isSpecificCcy(v[0])) {
                return;
            }
            qfBuilder.add(k, "in", v);
        });
        this.addMulDimFilter(qfBuilder);
        return qfBuilder.toArray();
    }

    private void addMulDimFilter(QFBuilder qfBuilder) {
        JSONArray mulMember;
        Object entity = this.getFormCustomParam("entity");
        Object process = this.getFormCustomParam("process");
        Object audit = this.getFormCustomParam("audit");
        if (entity != null) {
            mulMember = JSONArray.parseArray((String)entity.toString());
            qfBuilder.add(DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ROOT), "in", (Object)this.parseRangeFilter(mulMember, "bcm_entitymembertree"));
        }
        if (process != null) {
            mulMember = JSONArray.parseArray((String)process.toString());
            qfBuilder.add(DimTypesEnum.PROCESS.getNumber().toLowerCase(Locale.ROOT), "in", (Object)this.parseRangeFilter(mulMember, "bcm_processmembertree"));
        }
        if (audit != null) {
            mulMember = JSONArray.parseArray((String)audit.toString());
            qfBuilder.add(DimTypesEnum.AUDITTRIAL.getNumber().toLowerCase(Locale.ROOT), "in", (Object)this.parseRangeFilter(mulMember, "bcm_audittrialmembertree"));
        }
    }

    private String[] parseRangeFilter(JSONArray mulMember, String entity) {
        JSONArray members = JSONArray.parseArray((String)mulMember.toString());
        HashSet<String> numberFilters = new HashSet<String>(members.size());
        if ("bcm_entitymembertree".equals(entity)) {
            HashSet ids = new HashSet();
            for (int i = 0; i < members.size(); ++i) {
                JSONObject member = members.getJSONObject(i);
                ids.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange((String)entity, (Long)member.getLong(PK_ID), (int)member.getInteger("scope"), (String)String.valueOf(this.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            Set writePermIds = PermissionServiceImpl.getInstance((Long)this.getModelId()).matchReadOrWritePermMembers(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Entity"), "bcm_entitymembertree", ids);
            QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number", (QFilter[])new QFilter(PK_ID, "in", (Object)writePermIds).toArray()).forEach(d -> numberFilters.add(d.getString("number")));
        } else {
            for (int i = 0; i < members.size(); ++i) {
                JSONObject member = members.getJSONObject(i);
                numberFilters.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)entity, (Long)member.getLong(PK_ID), (String)member.getString("number"), (int)member.getInteger("scope"), (String)String.valueOf(this.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            if ("bcm_processmembertree".equals(entity)) {
                if (numberFilters.contains("ERpt")) {
                    numberFilters.add("Rpt");
                }
                if (numberFilters.contains("EIRpt")) {
                    numberFilters.add("IRpt");
                }
                if (numberFilters.contains("ERAdj")) {
                    numberFilters.add("RAdj");
                }
            }
        }
        return numberFilters.toArray(new String[0]);
    }

    private void fillData(ExtendsModel extendsModel, List<Object> ids) {
        DataSet dataSet = this.queryData(extendsModel, ids);
        if (dataSet == null || dataSet.isEmpty()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(PK_ID, new Object[0]);
        for (String colName : this.getAllColSigns()) {
            vs.addField(colName, new Object[0]);
        }
        String cacheId = DataSetUtil.cacheDataSet((DataSet)dataSet);
        List allData = DataSetUtil.getAllData((String)cacheId);
        for (Row row : allData) {
            vs.addRow(((PersistedArrayRow)row).values());
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private String buildColSign(String sign) {
        return sign.toLowerCase(Locale.ROOT);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (this.getView().getPageCache().get("delConfirmed") != null) {
            this.getView().getPageCache().remove("delConfirmed");
            return;
        }
        HashMap f7ValueMap = (HashMap)this.deSerializedBytes((String)this.getFormCustomParam("f7ValueMap"));
        Long sceneId = MemberReader.findScenaMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.SCENARIO.getNumber()))[0]).getId();
        Long yearId = MemberReader.findFyMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.YEAR.getNumber()))[0]).getId();
        Long periodId = MemberReader.findPeriodMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.PERIOD.getNumber()))[0]).getId();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        List selectRows = Arrays.stream(e.getRowIndexs()).mapToObj(arg_0 -> entryEntity.get(arg_0)).collect(Collectors.toList());
        for (DynamicObject row : selectRows) {
            String orgNumber = row.getString(ORG);
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)this.getCurModelNumber(), (String)orgNumber);
            IDNumberTreeNode pOrgNode = IDNumberTreeNode.NotFoundTreeNode;
            if (orgNumber.contains("_")) {
                pOrgNode = MemberReader.findEntityMemberByNum((String)this.getCurModelNumber(), (String)orgNumber.split("_")[0]);
            }
            this.checkEditPerm(orgNode.getId(), pOrgNode.getId(), row);
            McStatus mcStatus = McStatus.getMcStatus((Object)this.getModelId(), (Object)orgNode.getId(), (Object)sceneId, (Object)yearId, (Object)periodId);
            this.checkFlowAndPeriodSts(sceneId, yearId, periodId, mcStatus, orgNode.getNumber(), row);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        HashMap nameMap = new HashMap();
        ArrayList delRows = new ArrayList(e.getRowIndexs().length);
        HashSet delIds = new HashSet(e.getRowIndexs().length);
        Arrays.stream(e.getRowIndexs()).forEach(i -> {
            delRows.add(i);
            delIds.add(dataEntitys[i].getLong(PK_ID));
        });
        String custValue = SerializationUtils.toJsonString(delRows) + "|" + SerializationUtils.toJsonString(delIds);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ExtDataStandingBookResultPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("del", (IFormPlugin)this), nameMap, custValue);
        e.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        if ("del".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            String[] split = evt.getCustomVaule().split("\\|");
            if (split.length != 2) {
                return;
            }
            this.getView().getPageCache().put("delConfirmed", "1");
            this.getModel().deleteEntryRows(ENTRY_ENTITY, (int[])SerializationUtils.fromJsonString((String)split[0], int[].class));
            this.cacheDelId((Set)SerializationUtils.fromJsonString((String)split[1], Set.class));
        }
    }

    private void checkEditPerm(Long orgId, Long pOrgId, DynamicObject row) {
        if (row.getLong(PK_ID) == 0L) {
            return;
        }
        if (ThreadCache.exists((Object)(orgId + "|" + pOrgId))) {
            return;
        }
        Set writePermIds = (Set)ThreadCache.get((Object)(orgId + "|" + pOrgId), () -> PermissionServiceImpl.getInstance((Long)this.getModelId()).matchWritePermMembers(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Entity"), "bcm_entitymembertree", Arrays.asList(orgId, pOrgId)));
        if (!writePermIds.contains(orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6765\u6e90\u7ec4\u7ec7\u7684\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"ExtDataStandingBookResultPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (pOrgId != -1L && !writePermIds.contains(pOrgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u7236\u7ea7\u7ec4\u7ec7\u7684\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"ExtDataStandingBookResultPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        Element c;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(key)) != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
            long rootid = 0L;
            String sign = ((TextEditElement)c).getSign();
            this.showSingleF7(sign, !DimTypesEnum.ENTITY.getNumber().equalsIgnoreCase(sign));
        }
    }

    private void showSingleF7(String signKey, boolean onlyLeaf) {
        String dimName;
        String entityNum;
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_listf7");
        boolean isCustDim = false;
        ListFilterParameter listFilter = new ListFilterParameter();
        if (this.getExt2MulF7().containsKey(signKey)) {
            MultiF7Results multiF7Results = this.getExt2MulF7().get(signKey);
            entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)multiF7Results.getDimDy().getString("number"));
            dimName = multiF7Results.getDimDy().getString("name");
            HashSet ids = new HashSet(10);
            multiF7Results.getList().forEach(e -> ids.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange((String)entityNum, (Long)e.getId(), (int)e.getScope(), (String)String.valueOf(this.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS)));
            listFilter.getQFilters().add(new QFilter(PK_ID, "in", ids));
        } else {
            if (ORG.equals(signKey)) {
                entityNum = "bcm_entitymembertree";
                dimName = DimTypesEnum.ENTITY.getName();
            } else {
                entityNum = DimEntityNumEnum.getEntieyNumByNumber((String)signKey);
                if ("bcm_userdefinedmembertree".equals(entityNum)) {
                    isCustDim = true;
                    dimName = (String)MemberReader.getUsetDefineDimNumberMapNameById((long)this.getModelId()).get(this.getColSign2DimNumber().get(signKey));
                } else {
                    dimName = DimTypesEnum.getDimTypesEnumByNumber((String)signKey).getName();
                }
            }
            listFilter.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
            if (onlyLeaf) {
                listFilter.getQFilters().add(new QFilter("isleaf", "=", (Object)true));
            }
            if (isCustDim) {
                listFilter.getQFilters().add(new QFilter("dimension", "=", (Object)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)this.getColSign2DimNumber().get(signKey))));
            }
            if ("Currency".equalsIgnoreCase(signKey)) {
                listFilter.getQFilters().add(new QFilter("number", "not in", Arrays.asList("EC", "DC", "OC")));
            }
        }
        param.setBillFormId(entityNum);
        param.setListFilterParameter(listFilter);
        param.setShowUsed(false);
        param.setLookUp(true);
        param.setSelectedEntity(entityNum);
        param.setShowFilter(false);
        param.setShowQuickFilter(false);
        param.setShowTitle(false);
        param.setMultiSelect(false);
        param.setCaption(dimName);
        param.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        param.getOpenStyle().setInlineStyleCss(css);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, signKey));
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = data.getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject row = (DynamicObject)entry.get(rowIndex);
        HashMap f7ValueMap = (HashMap)this.deSerializedBytes((String)this.getFormCustomParam("f7ValueMap"));
        Long sceneId = MemberReader.findScenaMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.SCENARIO.getNumber()))[0]).getId();
        Long yearId = MemberReader.findFyMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.YEAR.getNumber()))[0]).getId();
        Long periodId = MemberReader.findPeriodMemberByNum((String)this.getCurModelNumber(), (String)((String[])f7ValueMap.get(DimTypesEnum.PERIOD.getNumber()))[0]).getId();
        String orgNumber = row.getString(ORG);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)this.getCurModelNumber(), (String)orgNumber);
        IDNumberTreeNode pOrgNode = IDNumberTreeNode.NotFoundTreeNode;
        if (orgNumber.contains("_")) {
            pOrgNode = MemberReader.findEntityMemberByNum((String)this.getCurModelNumber(), (String)orgNumber.split("_")[0]);
        }
        try {
            this.checkEditPerm(orgNode.getId(), pOrgNode.getId(), row);
            McStatus mcStatus = McStatus.getMcStatus((Object)this.getModelId(), (Object)orgNode.getId(), (Object)sceneId, (Object)yearId, (Object)periodId);
            this.checkFlowAndPeriodSts(sceneId, yearId, periodId, mcStatus, orgNode.getNumber(), row);
        }
        catch (KDBizException kde) {
            row.set(name, e.getChangeSet()[0].getOldValue());
            this.getView().updateView(name, rowIndex);
            this.getView().showErrorNotification(kde.getMessage());
            return;
        }
        if (this.getAllColSigns().contains(name) && e.getChangeSet()[0].getDataEntity().getLong(PK_ID) != 0L) {
            this.cacheUpdateId(e.getChangeSet()[0].getDataEntity().getLong(PK_ID));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object data = evt.getReturnData();
        if ("save".equals(actionId) && data != null) {
            String taskInfoJson = (String)((Map)data).get("taskinfo");
            JSONObject taskInfo = JSONObjectUtil.parseObjectOrder((String)taskInfoJson);
            String msg = taskInfo.getJSONObject("data").getString("msg");
            String modelSNumber = MemberReader.findModelSNumberById((Object)this.getModelId());
            ExtendsModel extendsModel = this.getExtendsModel();
            HashMap f7ValueMap = (HashMap)this.deSerializedBytes((String)this.getFormCustomParam("f7ValueMap"));
            String logStr = new StringJoiner("|").add(extendsModel.getNumber()).add(((String[])f7ValueMap.get(DimTypesEnum.SCENARIO.getNumber()))[0]).add(((String[])f7ValueMap.get(DimTypesEnum.YEAR.getNumber()))[0]).add(((String[])f7ValueMap.get(DimTypesEnum.PERIOD.getNumber()))[0]).toString();
            if ("success".equals(msg)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ExtDataStandingBookResultPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().getPageCache().remove(cache_updateIds);
                this.getView().getPageCache().remove(cache_delIds);
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                this.fillData(this.getExtendsModel(), null);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADDROW, BTN_DELETEROW});
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ExtDataStandingBookResultPlugin_21", "fi-bcm-formplugin", "Save"), new OPDescMultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f\u3002", "ExtDataStandingBookResultPlugin_22", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{logStr})));
            } else {
                this.getView().showErrorNotification(String.valueOf(msg));
            }
        } else if ((extraColumn.containsKey(actionId) || this.getColSign2DimNumber().containsKey(actionId) || this.getExt2MulF7().containsKey(actionId)) && data != null) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int index = entryGrid.getSelectRows()[0];
            String entityNum = ORG.equals(actionId) ? "bcm_entitymembertree" : (this.getExt2MulF7().containsKey(actionId) ? DimEntityNumEnum.getEntieyNumByNumber((String)this.getExt2MulF7().get(actionId).getDimDy().getString("number")) : DimEntityNumEnum.getEntieyNumByNumber((String)actionId));
            IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)entityNum, (Long)LongUtil.toLong((Object)data.toString().replace("[", "").replace("]", "")));
            this.getModel().setValue(actionId, (Object)memberNode.getNumber(), index);
            if (DimTypesEnum.ENTITY.getNumber().equalsIgnoreCase(actionId)) {
                this.getModel().setValue("org_id", (Object)memberNode.getId(), index);
            }
            if (StringUtils.equalsAny((CharSequence)actionId, (CharSequence[])new CharSequence[]{"entity", "process", "audittrail"})) {
                this.fillOrgValue(index);
            }
        }
    }

    private void fillOrgValue(int rowIndex) {
        String org = (String)this.getModel().getValue(ORG, rowIndex);
        String entity = (String)this.getModel().getValue("entity", rowIndex);
        String entityId = (String)this.getModel().getValue("org_id", rowIndex);
        String process = (String)this.getModel().getValue("process", rowIndex);
        String audit = (String)this.getModel().getValue("audittrail", rowIndex);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{entity, process, audit})) {
            return;
        }
        CanSaveCombineEnum combineEnum = this.getCombineEnum(process, audit);
        if (combineEnum == null) {
            this.getModel().setValue(ORG, null, rowIndex);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s + %2$s\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5141\u8bb8\u4fdd\u5b58\u6570\u636e\u3002", (String)"ExtDataStandingBookResultPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), process, audit));
        } else if (CanSaveCombineEnum.merge2ChildAdj == combineEnum) {
            if (StringUtils.isNotEmpty((CharSequence)entityId)) {
                IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)LongUtil.toLong((Object)entityId));
                this.getModel().setValue(ORG, (Object)(entityNode.getParent().getNumber() + "_" + entityNode.getNumber()), rowIndex);
            } else if (!org.contains("_")) {
                IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)this.getCurModelNumber(), (String)entity);
                this.getModel().setValue(ORG, (Object)(entityNode.getParent().getNumber() + "_" + entityNode.getNumber()), rowIndex);
            }
        } else {
            this.getModel().setValue(ORG, (Object)entity, rowIndex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    private void cacheDelId(Set<Long> pkIds) {
        Set<Long> ids = this.getDelIds();
        ids.addAll(pkIds);
        this.getPageCache().put(cache_delIds, ObjectSerialUtil.toByteSerialized(ids));
    }

    private Set<Long> getDelIds() {
        return this.getPageCache().get(cache_delIds) == null ? new HashSet<Long>(10) : (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cache_delIds));
    }

    private void cacheUpdateId(long pkId) {
        Set<Long> ids = this.getUpdateIds();
        ids.add(pkId);
        this.getPageCache().put(cache_updateIds, ObjectSerialUtil.toByteSerialized(ids));
    }

    private Set<Long> getUpdateIds() {
        return this.getPageCache().get(cache_updateIds) == null ? new HashSet<Long>(10) : (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cache_updateIds));
    }

    private void cacheColSign2DimNumber(HashMap<String, String> colSigns) {
        this.getPageCache().put(cache_colSign2DimNumber, ObjectSerialUtil.toByteSerialized(colSigns));
    }

    private HashMap<String, String> getColSign2DimNumber() {
        return this.getPageCache().get(cache_colSign2DimNumber) == null ? new HashMap(10) : (HashMap)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cache_colSign2DimNumber));
    }

    private void cacheMustInputColSigns(Set<String> colSigns) {
        this.getPageCache().put(cache_mustInputColSigns, ObjectSerialUtil.toByteSerialized(colSigns));
    }

    private HashSet<String> getMustInputColSigns() {
        return this.getPageCache().get(cache_mustInputColSigns) == null ? new HashSet(10) : (HashSet)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cache_mustInputColSigns));
    }

    private void cacheAllColSigns(LinkedHashSet<String> colSigns) {
        this.getPageCache().put(cache_colSigns, ObjectSerialUtil.toByteSerialized(colSigns));
    }

    private LinkedHashSet<String> getAllColSigns() {
        return this.getPageCache().get(cache_colSigns) == null ? new LinkedHashSet(10) : (LinkedHashSet)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cache_colSigns));
    }

    private void cacheAllColNames(LinkedHashSet<String> colSigns) {
        this.getPageCache().put(cache_colNames, ObjectSerialUtil.toByteSerialized(colSigns));
    }

    private LinkedHashSet<String> getAllColNames() {
        return this.getPageCache().get(cache_colNames) == null ? new LinkedHashSet(10) : (LinkedHashSet)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cache_colNames));
    }

    private void cacheExt2MulF7(HashMap<String, MultiF7Results> colSigns) {
        this.getPageCache().put(cache_ext2MulF7, ObjectSerialUtil.toByteSerialized(colSigns));
    }

    private HashMap<String, MultiF7Results> getExt2MulF7() {
        return this.getPageCache().get(cache_ext2MulF7) == null ? new HashMap(16) : (HashMap)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(cache_ext2MulF7));
    }

    static enum CanSaveCombineEnum {
        reportInput(0),
        reportAdj(1),
        mergeUnitAdj(2),
        merge2ChildAdj(3);

        private int index;

        private CanSaveCombineEnum(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

