/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.standingbook;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.StbSaveComInfo;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class ExtStandingBookSaveTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ExtStandingBookSaveTask.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List saveComInfos = (List)ObjectSerialUtil.deSerializedBytes((String)map.get("saveComInfos").toString());
        Set deleteIds = (Set)ObjectSerialUtil.deSerializedBytes((String)map.get("delIds").toString());
        String groupType = map.get("groupType").toString();
        HashMap<String, String> feedbackData = new HashMap<String, String>();
        try (TXHandle tx = TX.required((String)"ExtStandingBookSaveTask");){
            try {
                if (!deleteIds.isEmpty()) {
                    String extendEntity = ExtendDimGroupType.COMMON.getIndex().equals(groupType) ? "bcm_extenddata" : "bcm_extenddata_bus";
                    DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)extendEntity).getDynamicObjectType(), (Object[])deleteIds.toArray());
                }
                int i = 1;
                for (StbSaveComInfo s : saveComInfos) {
                    ExtDataServiceHelper.saveData((EDSaveComInfo)s);
                    this.feedbackProgress(100 * (++i / saveComInfos.size()));
                }
                feedbackData.put("msg", "success");
            }
            catch (Exception e) {
                LOG.error("extStandingBook save error:", (Throwable)e);
                tx.markRollback();
                feedbackData.put("msg", e.getMessage());
            }
            finally {
                this.feedbackCustomdata(feedbackData);
            }
        }
    }
}

