/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.TaskStatusEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.task.Counter;
import kd.fi.bcm.formplugin.task.MyTaskTreeUtil;
import kd.fi.bcm.formplugin.tree.task.TaskTreeBulider;
import kd.fi.bcm.formplugin.tree.task.TaskTreeNode;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;

public class AbstractMyTaskListPlugin
extends AbstractBaseFormPlugin {
    public static final String TREENODES = "treeNodes";
    private static final String NUMBER = "number";
    private static final String TREEENTRY_ENTITY = "treeentryentity";
    private static final String TASK_STATUS = "taskstatus";
    private static final String REPORT_TASK = "reporttask";
    private static final String HAS_OVERDUE = "hasoverdue";
    private static final String UN_OVERDUE = "unoverdue";
    protected String cKeysCacheId = "cKeys";

    protected void refreshMyTask(boolean isCollapse, boolean isInit) {
        String userId = RequestContext.get().getUserId();
        this.getModel().deleteEntryData(TREEENTRY_ENTITY);
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("taskname");
        properties.add("remaintime");
        properties.add("financeyear");
        properties.add("period");
        properties.add("scenario");
        properties.add("reportstatus");
        properties.add(TASK_STATUS);
        properties.add("orgid");
        properties.add("rootid");
        properties.add("taskid");
        properties.add("modifier");
        properties.add("modifytime");
        properties.add("memberid");
        properties.add("tasktype");
        Counter counter = new Counter();
        TaskTreeBulider builder = new TaskTreeBulider();
        TaskTreeNode root = builder.initTree(userId, true, true, true, true, true, ModelUtil.queryApp(this.getView()));
        if (root == null) {
            return;
        }
        TreeNode virtualRoot = root.toTreeNode();
        MyTaskTreeUtil.countAllTask(virtualRoot, counter);
        MyTaskTreeUtil.setTimeInfoByTreeNode(virtualRoot);
        MyTaskTreeUtil.setTreeNodeStatus(virtualRoot);
        this.setFildAmount(virtualRoot);
        this.cacheTree(virtualRoot);
        if (isInit) {
            MyTaskTreeUtil.fillTreeEntryEntityByTreeNode(this.getModel(), virtualRoot, properties, counter);
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRY_ENTITY);
            treeEntry.setCollapse(isCollapse);
            if (counter.getFirstTaskRow() >= 0) {
                int[] eids = TreeEntryEntityUtil.focus(this.getModel(), counter.getFirstTaskRow());
                treeEntry.expandOne(eids);
            }
            treeEntry.selectRows(0);
        }
    }

    protected void cacheTree(TreeNode rootNodes) {
        this.getPageCache().put(TREENODES, SerializationUtils.toJsonString((Object)rootNodes));
    }

    protected TreeNode getCacheTree() {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREENODES), TreeNode.class);
        return rootNode;
    }

    protected void refreshByCondition(String selectKey) {
        String userId = RequestContext.get().getUserId();
        ArrayList<String> displayIds = new ArrayList<String>();
        if (selectKey.contains("all")) {
            this.searchTaskForCondition(null);
            return;
        }
        this.getDisplayList(selectKey, userId, displayIds);
        this.searchTaskForCondition(displayIds);
    }

    protected void setFildAmount(TreeNode virtualRoot) {
        Counter count = new Counter();
        MyTaskTreeUtil.countNumber(virtualRoot, count);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("hasoverduenum", count.getTaskHasOverdue());
        map.put("comingoverduenum", count.getTaskComingOverdue());
        map.put("unoverduenum", count.getTaskUnOverdue());
        map.put("finishnum", count.getTaskDone());
        map.put("allnum", count.getTaskDone() + count.getTaskHasOverdue() + count.getTaskUnOverdue());
        for (Map.Entry entry : map.entrySet()) {
            Label label = (Label)this.getControl((String)entry.getKey());
            label.setText("\uff08" + ((Integer)entry.getValue()).toString() + "\uff09");
        }
    }

    protected void getDisplayList(String selectKey, String userId, List<String> displayIds) {
        String statusFields;
        Long[] taskIds;
        DynamicObjectCollection myTaskColl;
        String selectFields;
        if (selectKey.contains(HAS_OVERDUE)) {
            displayIds.addAll(this.searchByTime(HAS_OVERDUE));
        }
        if (selectKey.contains("comingoverdue")) {
            displayIds.addAll(this.searchByTime("comingoverdue"));
        }
        if (selectKey.contains(UN_OVERDUE)) {
            displayIds.addAll(this.searchByTime(UN_OVERDUE));
        }
        if (selectKey.contains("haspretask")) {
            selectFields = "id,pretasks";
            myTaskColl = MyTaskServiceHelper.getTaskByUser4Union((String)userId, null, (String[])new String[]{String.valueOf(TaskTypeEnum.REPORT.getValue())}, (String)selectFields, (String)NUMBER);
            if (((DynamicObject[])myTaskColl).length == 0) {
                return;
            }
            taskIds = new HashSet();
            taskIds.add(100L);
            for (Object myTask : myTaskColl) {
                DynamicObjectCollection pretasks = myTask.getDynamicObjectCollection("pretasks");
                if (pretasks.size() <= 0) continue;
                taskIds.add(myTask.getLong("id"));
            }
            statusFields = MyTaskTreeUtil.genUniqueKey("id", "entity.id as orgId", "reporttask.id as taskid", "template.id as tempid");
            QFilter taskFilter = new QFilter(REPORT_TASK, "in", (Object)taskIds);
            QFilter[] filters = new QFilter[]{taskFilter};
            displayIds.addAll(this.refreshByCondition(statusFields, filters));
        }
        if (selectKey.contains("hasaftertask")) {
            Object myTask;
            selectFields = "id";
            myTaskColl = MyTaskServiceHelper.getTaskByUser((String)userId, null, (String[])new String[]{String.valueOf(TaskTypeEnum.REPORT.getValue())}, (String)selectFields, (String)NUMBER);
            if (myTaskColl.size() == 0) {
                return;
            }
            taskIds = new Long[myTaskColl.size()];
            for (int i = 0; i < myTaskColl.size(); ++i) {
                taskIds[i] = ((DynamicObject)myTaskColl.get(i)).getLong("id");
            }
            StringBuffer baseSql = new StringBuffer();
            baseSql.append("select distinct ftaskconfid from t_bcm_taskforpre where ftaskconfid in (").append(MyTaskTreeUtil.genUniqueLongKey(taskIds)).append(')');
            HashSet<Long> hasAfterIds = new HashSet<Long>();
            DataSet result = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)BCMConstant.DBROUTE, (String)baseSql.toString(), null);
            myTask = null;
            try {
                Iterator memberIt = result.iterator();
                hasAfterIds.add(100L);
                while (memberIt.hasNext()) {
                    Row memberRow = (Row)memberIt.next();
                    Long id = memberRow.getLong("ftaskconfid");
                    hasAfterIds.add(id);
                }
            }
            catch (Throwable memberIt) {
                myTask = memberIt;
                throw memberIt;
            }
            finally {
                if (result != null) {
                    if (myTask != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable memberIt) {
                            ((Throwable)myTask).addSuppressed(memberIt);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            String statusFields2 = MyTaskTreeUtil.genUniqueKey("id", "entity.id as orgId", "reporttask.id as taskid", "template.id as tempid");
            QFilter taskFilter = new QFilter(REPORT_TASK, "in", hasAfterIds);
            QFilter[] filters = new QFilter[]{taskFilter};
            displayIds.addAll(this.refreshByCondition(statusFields2, filters));
        }
        if (selectKey.contains("finish")) {
            selectFields = "id";
            myTaskColl = MyTaskServiceHelper.getTaskByUser((String)userId, null, (String[])new String[]{String.valueOf(TaskTypeEnum.ROOT.getValue())}, (String)selectFields, (String)NUMBER);
            if (myTaskColl.size() == 0) {
                return;
            }
            HashSet rootIdSet = new HashSet();
            myTaskColl.forEach(root -> rootIdSet.add(root.getLong("id")));
            statusFields = MyTaskTreeUtil.genUniqueKey("id", "entity.id as orgId", "reporttask.id as taskid", "template.id as tempid");
            QFilter rootFilter = new QFilter("root", "in", rootIdSet);
            QFilter statusFilter = new QFilter(TASK_STATUS, "=", (Object)TaskStatusEnum.COMPLETE.index);
            QFilter[] filters = new QFilter[]{rootFilter, statusFilter};
            displayIds.addAll(this.refreshByCondition(statusFields, filters));
        }
    }

    private List<String> searchByTime(String key) {
        String userId = RequestContext.get().getUserId();
        String selectFields = "id,endtime,warningbegintime";
        DynamicObjectCollection myTaskColl = MyTaskServiceHelper.getTaskByUser((String)userId, null, (String[])new String[]{String.valueOf(TaskTypeEnum.REPORT.getValue()), String.valueOf(TaskTypeEnum.UNFITASK.getValue())}, (String)selectFields, (String)NUMBER);
        if (myTaskColl.size() == 0) {
            return new ArrayList<String>();
        }
        HashSet<Long> taskIds = new HashSet<Long>();
        taskIds.add(100L);
        for (DynamicObject myTask : myTaskColl) {
            Date endtime = myTask.getDate("endtime");
            Date warningbegintime = myTask.getDate("warningbegintime");
            Date now = TimeServiceHelper.now();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String s = sdf.format(now);
            String t = sdf.format(endtime);
            try {
                String w;
                Date warningbeginDate;
                Date nowDate = sdf.parse(s);
                Date endDate = sdf.parse(t);
                if (HAS_OVERDUE.equals(key)) {
                    if (!nowDate.after(endDate)) continue;
                    taskIds.add(myTask.getLong("id"));
                    continue;
                }
                if (UN_OVERDUE.equals(key)) {
                    if (nowDate.after(endDate)) continue;
                    taskIds.add(myTask.getLong("id"));
                    continue;
                }
                if (warningbegintime == null || nowDate.before(warningbeginDate = sdf.parse(w = sdf.format(warningbegintime))) || nowDate.after(endDate)) continue;
                taskIds.add(myTask.getLong("id"));
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u65e5\u671f\u9519\u8bef", (String)"AbstractMyTaskListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        String statusFields = MyTaskTreeUtil.genUniqueKey("id", "entity.id as orgId", "reporttask.id as taskid", "template.id as tempid");
        QFilter taskFilter = new QFilter(REPORT_TASK, "in", taskIds);
        if (taskIds.size() == 0) {
            return new ArrayList<String>();
        }
        QFilter statusFilter = new QFilter(TASK_STATUS, "=", (Object)TaskStatusEnum.UNDO.index);
        QFilter[] filters = new QFilter[]{taskFilter, statusFilter};
        return this.refreshByCondition(statusFields, filters);
    }

    protected void searchTaskForCondition(List<String> displayIds) {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("taskname");
        properties.add("remaintime");
        properties.add("financeyear");
        properties.add("period");
        properties.add("scenario");
        properties.add("reportstatus");
        properties.add(TASK_STATUS);
        properties.add("orgid");
        properties.add("rootid");
        properties.add("taskid");
        properties.add("modifier");
        properties.add("modifytime");
        properties.add("memberid");
        properties.add("tasktype");
        this.getModel().deleteEntryData(TREEENTRY_ENTITY);
        TreeNode virtualRoot = this.getCacheTree();
        Counter count = new Counter();
        if (displayIds != null) {
            MyTaskTreeUtil.selectDisplay(null, virtualRoot, displayIds);
        }
        MyTaskTreeUtil.countAllTask(virtualRoot, count);
        MyTaskTreeUtil.fillTreeEntryEntityByTreeNode(this.getModel(), virtualRoot, properties, count);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREEENTRY_ENTITY);
        this.getView().updateView();
        if (count.getFirstTaskRow() >= 0) {
            int[] eids = TreeEntryEntityUtil.focus(this.getModel(), count.getFirstTaskRow());
            treeEntry.expandOne(eids);
        }
        treeEntry.selectRows(0);
    }

    protected List<String> refreshByCondition(String statusFields, QFilter[] filters) {
        DynamicObjectCollection taskStatusColl = QueryServiceHelper.query((String)"bcm_taskstatus", (String)statusFields, (QFilter[])filters);
        ArrayList<String> displayIds = new ArrayList<String>();
        taskStatusColl.forEach(status -> displayIds.add(String.valueOf(status.getLong("id"))));
        return displayIds;
    }
}

