/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.task.Counter;
import kd.fi.bcm.formplugin.task.MyTaskTreeUtil;
import kd.fi.bcm.formplugin.tree.task.TaskTreeBulider;
import kd.fi.bcm.formplugin.tree.task.TaskTreeNode;
import kd.fi.bcm.formplugin.util.OpenMenuPageUtil;
import kd.fi.bcm.formplugin.util.PageParamModel;

public class MyTaskHomePlugin
extends AbstractFormPlugin
implements BCMBaseFunction {
    private static final String STATUS = "status";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"pending", "done", "all", "overnum", "duenum"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String userId = RequestContext.get().getUserId();
        Counter count = new Counter();
        TaskTreeBulider builder = new TaskTreeBulider();
        TaskTreeNode root = builder.initTree(userId, true, true, true, true, true, ModelUtil.queryApp(this.getView()));
        if (root != null) {
            TreeNode virtualRoot = root.toTreeNode();
            MyTaskTreeUtil.setTreeNodeStatus(virtualRoot);
            MyTaskTreeUtil.countNumber(virtualRoot, count);
        }
        String text1 = String.format(ResManager.loadKDString((String)"\u5176\u4e2d\u8d85\u671f%1$s\u6761\uff0c\u5373\u5c06\u5230\u671f%2$s\u6761\u3002", (String)"MyTaskHomePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count.getTaskHasOverdue(), count.getTaskComingOverdue());
        ((Label)this.getControl("pendingnum")).setText(count.getTaskUndone() + "");
        ((Label)this.getControl("donenum")).setText(count.getTaskDone() + "");
        ((Label)this.getControl("allnum")).setText(count.getTaskDone() + count.getTaskUndone() + "");
        ((Label)this.getControl("overnum")).setText(text1);
        ((Label)this.getControl("pendingreportnum")).setText(String.format(ResManager.loadKDString((String)"\u5305\u542b\u62a5\u8868%1$s\u6761\u3002", (String)"MyTaskHomePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count.getReportHasOverdue() + count.getReportUnOverdue()));
        ((Label)this.getControl("donereportnum")).setText(String.format(ResManager.loadKDString((String)"\u5305\u542b\u62a5\u8868%1$s\u6761\u3002", (String)"MyTaskHomePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count.getReportDone()));
        ((Label)this.getControl("allreportnum")).setText(String.format(ResManager.loadKDString((String)"\u5305\u542b\u62a5\u8868%1$s\u6761\u3002", (String)"MyTaskHomePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count.getReportDone() + count.getReportHasOverdue() + count.getReportUnOverdue()));
        String parentPage = this.getView().getParentView() == null ? DB.genGlobalLongId() + "" : this.getView().getParentView().getPageId();
        this.getPageCache().put("appPageId", parentPage);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        FormShowParameter param = new FormShowParameter();
        switch (key) {
            case "pending": {
                param.setCustomParam(STATUS, (Object)"unoverdue");
                this.showListView("bcm_executetask", param);
                break;
            }
            case "done": {
                param.setCustomParam(STATUS, (Object)"done");
                this.showListView("bcm_mytask", param);
                break;
            }
            case "all": {
                param.setCustomParam(STATUS, (Object)"all");
                this.showListView("bcm_mytask", param);
                break;
            }
        }
    }

    private void showListView(String formid, FormShowParameter param) {
        PageParamModel pageModel = new PageParamModel(this.getView(), true, this.getPageCache().get("appPageId"), formid, param);
        OpenMenuPageUtil.showFormViewByParam(pageModel);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.bcmPreOpen(e);
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }
}

