/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.TaskStatusEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.report.util.ReportRecordUtil;
import kd.fi.bcm.formplugin.task.AbstractMyTaskListPlugin;
import kd.fi.bcm.formplugin.task.Counter;
import kd.fi.bcm.formplugin.task.MyTaskTreeUtil;
import kd.fi.bcm.formplugin.util.ShowOperationMsgUtil;
import org.apache.commons.lang3.StringUtils;

public class MyTaskItemPlugin
extends AbstractMyTaskListPlugin {
    private static final String ITEM_MASK = "itemmark";
    private static final String ITEM_UNMASK = "itemunmark";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String REPORT_STATUS = "reportstatus";
    private static final String BTN_COMMIT = "btn_commit";
    private static final String BTN_BACK = "btn_back";
    private static final String TASK_STATUS = "taskstatus";
    private static final String MODEL = "model";
    private static final String TEMPLATE = "template";
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";
    private static final String TASK_TYPE = "tasktype";
    private static final String ENTITY = "entity";
    private static final String TASK_MESSAGE = "taskmessage";
    private static final String TASK_ID = "taskid";
    private static final String PERIOD = "period";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        ArrayList<TreeNode> taskStatusNodes;
        TreeNode node;
        String id;
        TreeNode virtualRoot;
        String taskType;
        DynamicObject selectDy;
        int[] selectIndexs;
        TreeEntryGrid treeEntry;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("itemexit".equals(key)) {
            this.getView().close();
        } else if ("itemrefresh".equals(key)) {
            this.refreshMyTask(true, false);
            Set cKeys = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.cKeysCacheId), Set.class);
            StringBuilder sb = new StringBuilder();
            cKeys.forEach(p -> sb.append((String)p));
            this.refreshByCondition(sb.toString());
        } else if (ITEM_MASK.equals(key) || ITEM_UNMASK.equals(key)) {
            DynamicObjectCollection dyc;
            treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            selectIndexs = treeEntry.getSelectRows();
            int sel = 0;
            if (selectIndexs.length != 0) {
                sel = selectIndexs[0];
            }
            if ((dyc = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY)) == null || dyc.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"MyTaskItemPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            selectDy = (DynamicObject)dyc.get(sel);
            taskType = selectDy.getString(TASK_TYPE);
            virtualRoot = this.getCacheTree();
            id = selectDy.getString("id");
            node = virtualRoot.getTreeNode(id, 10);
            taskStatusNodes = new ArrayList();
            ArrayList<TreeNode> failTaskNodes = new ArrayList<TreeNode>();
            ArrayList<TreeNode> taskNodes = new ArrayList<TreeNode>();
            try {
                if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(taskType) || String.valueOf(TaskTypeEnum.UNFITASK.getValue()).equals(taskType)) {
                    if (this.prepareTask(key, node)) {
                        if (this.doCheck(key, node)) {
                            taskNodes.add(node);
                            this.arrageTaskStatus(key, taskNodes, taskStatusNodes);
                        } else {
                            failTaskNodes.add(node);
                        }
                    }
                } else {
                    this.arrageReportTask4Check(key, node, taskNodes);
                    this.doCheckPre(key, taskNodes, failTaskNodes);
                    this.arrageTaskStatus(key, taskNodes, taskStatusNodes);
                }
                if (!this.showMsg(key, failTaskNodes, taskNodes)) {
                    this.setReportTaskStatus(key, taskStatusNodes, taskNodes, failTaskNodes);
                    this.refreshMyTask(true, false);
                    Set cKeys = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.cKeysCacheId), Set.class);
                    StringBuilder sb = new StringBuilder();
                    cKeys.forEach(p -> sb.append((String)p));
                    this.refreshByCondition(sb.toString());
                }
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                treeEntry.selectRows(sel);
            }
        }
        if (BTN_COMMIT.equals(key) || BTN_BACK.equals(key)) {
            treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            selectIndexs = treeEntry.getSelectRows();
            DynamicObjectCollection dyc = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
            if (dyc == null || dyc.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"MyTaskItemPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            int sel = 0;
            if (selectIndexs.length != 0) {
                sel = selectIndexs[0];
            }
            selectDy = (DynamicObject)dyc.get(sel);
            taskType = selectDy.getString(TASK_TYPE);
            virtualRoot = this.getCacheTree();
            id = selectDy.getString("id");
            node = virtualRoot.getTreeNode(id, 10);
            taskStatusNodes = new ArrayList<TreeNode>();
            ArrayList<TreeNode> taskNodes = new ArrayList<TreeNode>();
            try {
                if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(taskType) || String.valueOf(TaskTypeEnum.UNFITASK.getValue()).equals(taskType)) {
                    taskNodes.add(node);
                    this.arrageTaskStatus(key, taskNodes, taskStatusNodes);
                } else {
                    this.arrageReportTask(node, taskNodes);
                    this.arrageTaskStatus(key, taskNodes, taskStatusNodes);
                }
                List<Long> rightTaskStatus = this.actionCommitOrBack(key, taskStatusNodes);
                this.partRefresh4Report(key, rightTaskStatus);
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                treeEntry.selectRows(sel);
            }
        }
    }

    private boolean prepareTask(String key, TreeNode node) {
        if (ITEM_MASK.equals(key)) {
            Map data = (Map)node.getData();
            return TaskStatusEnum.UNDO.index.equals(data.get(TASK_STATUS).toString());
        }
        if (ITEM_UNMASK.equals(key)) {
            Map data = (Map)node.getData();
            return TaskStatusEnum.COMPLETE.index.equals(data.get(TASK_STATUS).toString());
        }
        return true;
    }

    private List<Long> actionCommitOrBack(String key, List<TreeNode> taskStatusNodes) {
        ArrayList<Long> rightTaskStatus = new ArrayList<Long>();
        if (taskStatusNodes.size() > 0) {
            ArrayList<String> WrongName = new ArrayList<String>();
            ArrayList<Long> rightReportIds = new ArrayList<Long>();
            try (TXHandle tx = TX.required((String)"bcm_taskCommitOrBack");){
                try {
                    for (TreeNode treenode : taskStatusNodes) {
                        QFilter[] qfs;
                        DynamicObject dycot;
                        Iterator taskStatusId = Long.valueOf(treenode.getId());
                        DynamicObject statusDy = QueryServiceHelper.queryOne((String)"bcm_taskstatus", (String)"template,model,entity,fy,period", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskStatusId)});
                        long template = statusDy.getLong(TEMPLATE);
                        long modid = statusDy.getLong(MODEL);
                        long entid = statusDy.getLong(ENTITY);
                        long yearid = statusDy.getLong("fy");
                        long periodid = statusDy.getLong(PERIOD);
                        DynamicObject OrgDy = OrgCurrencyServiceHelper.getOrgModelAndCurrency((Long)entid, (Long)yearid, (Long)periodid);
                        String curnumber = OrgDy.getString("currency.number");
                        DynamicObject CurrencyDy = QueryDimensionServiceHelper.getMemberMsgByNumber((long)modid, (String)curnumber, (String)"bcm_currencymembertree");
                        long curid = CurrencyDy.getLong("id");
                        QFilter qf1 = new QFilter(MODEL, "=", (Object)modid);
                        QFilter qf2 = new QFilter(ENTITY, "=", (Object)entid);
                        QFilter qf3 = new QFilter("fyear", "=", (Object)yearid);
                        QFilter qf4 = new QFilter(PERIOD, "=", (Object)periodid);
                        QFilter qf5 = new QFilter("currency", "=", (Object)curid);
                        QFilter qf6 = null;
                        QFilter qf7 = new QFilter(TEMPLATE, "=", (Object)template);
                        if (BTN_COMMIT.equals(key)) {
                            qf6 = new QFilter(REPORT_STATUS, "=", (Object)ReportStatusEnum.COMPLETE.status());
                        }
                        if (BTN_BACK.equals(key)) {
                            qf6 = new QFilter(REPORT_STATUS, "=", (Object)ReportStatusEnum.COMMIT.status());
                        }
                        if ((dycot = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"id", (QFilter[])(qfs = new QFilter[]{qf1, qf2, qf3, qf4, qf5, qf6, qf7}))) == null) {
                            WrongName.add(treenode.getText());
                            continue;
                        }
                        rightReportIds.add(dycot.getLong("id"));
                        rightTaskStatus.add((Long)((Object)taskStatusId));
                    }
                    if (!rightReportIds.isEmpty()) {
                        ReportStatusEnum status = null;
                        if (BTN_COMMIT.equals(key)) {
                            status = ReportStatusEnum.COMMIT;
                        }
                        if (BTN_BACK.equals(key)) {
                            status = ReportStatusEnum.BACK;
                        }
                        ReportServiceHelper.updateReportStatus((ReportStatusEnum)status, (Object[])rightReportIds.toArray());
                        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(rightTaskStatus.size());
                        for (Long taskStatus : rightTaskStatus) {
                            DynamicObject dytask = BusinessDataServiceHelper.loadSingle((Object)taskStatus, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_taskstatus"));
                            if (status != null) {
                                dytask.set(REPORT_STATUS, (Object)status.status());
                            }
                            dataEntities.add(dytask);
                        }
                        BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_taskstatus"), (Object[])dataEntities.toArray());
                    }
                    OperationResult operationResult = new OperationResult();
                    operationResult.setBillCount(WrongName.size() + rightReportIds.size());
                    if (!WrongName.isEmpty()) {
                        String messg = null;
                        if (BTN_COMMIT.equals(key)) {
                            messg = ResManager.loadKDString((String)"\u53ea\u80fd\u4e0a\u62a5\u5df2\u5b8c\u6210\u7f16\u5236\u7684\u62a5\u8868\u3002", (String)"MyTaskItemPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                        }
                        if (BTN_BACK.equals(key)) {
                            messg = ResManager.loadKDString((String)"\u53ea\u80fd\u6253\u56de\u5df2\u4e0a\u62a5\u72b6\u6001\u7684\u62a5\u8868\u3002", (String)"MyTaskItemPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                        }
                        for (String ss : WrongName) {
                            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                            operateErrorInfo.setMessage(ss + messg);
                            operateErrorInfo.setLevel(ErrorLevel.Error);
                            operationResult.addErrorInfo(operateErrorInfo);
                        }
                    }
                    for (Long l : rightReportIds) {
                        operationResult.addSuccessPkId((Object)l);
                        operationResult.setMessage(BTN_COMMIT.equals(key) ? ResManager.loadKDString((String)"\u4e0a\u62a5\u6210\u529f", (String)"MyTaskItemPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6253\u56de\u6210\u529f", (String)"MyTaskItemPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    ShowOperationMsgUtil.showOperationResultMulti(operationResult, "", this.getView(), "", WrongName.size(), 5);
                }
                catch (KDBizException e) {
                    throw e;
                }
                finally {
                    tx.markRollback();
                }
            }
        }
        return rightTaskStatus;
    }

    private boolean doCheck(String key, TreeNode node) {
        Map data = (Map)node.getData();
        Long taskid = Long.valueOf(data.get(TASK_ID).toString());
        Long orgid = Long.valueOf(data.get("orgid").toString());
        return MyTaskTreeUtil.doCheck(key, taskid, orgid);
    }

    private void doCheckPre(String key, List<TreeNode> tasknodes, List<TreeNode> failTaskNodes) {
        Long taskid;
        Map data;
        LinkedList<Long> taskids = new LinkedList<Long>();
        for (TreeNode tree : tasknodes) {
            data = (Map)tree.getData();
            taskid = Long.valueOf(data.get(TASK_ID).toString());
            taskids.add(taskid);
        }
        Iterator<TreeNode> iter = tasknodes.iterator();
        block1: while (iter.hasNext()) {
            Long orgid;
            TreeNode node = iter.next();
            data = (Map)node.getData();
            taskid = Long.valueOf(data.get(TASK_ID).toString());
            DynamicObjectCollection dot = MyTaskTreeUtil.doCheckPre(key, taskid, orgid = Long.valueOf(data.get("orgid").toString()));
            if (dot == null) continue;
            for (DynamicObject dy : dot) {
                if (taskids.contains(dy.getLong("reporttask"))) continue;
                iter.remove();
                taskids.remove(taskid);
                continue block1;
            }
        }
    }

    private boolean showMsg(String key, List<TreeNode> failTaskNodes, List<TreeNode> taskNodes) {
        StringBuilder taskNameMsg = new StringBuilder();
        if (failTaskNodes.size() > 0) {
            StringJoiner failText = new StringJoiner("\u3001");
            for (int i = 0; i < failTaskNodes.size(); ++i) {
                failText.add(failTaskNodes.get(i).getText());
            }
            if (ITEM_MASK.equals(key)) {
                taskNameMsg.append(String.format(ResManager.loadKDString((String)"%s\u7684\u524d\u7f6e\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u65e0\u6cd5\u5c06\u5176\u7f6e\u4e3a\u5df2\u5b8c\u6210\u72b6\u6001\u3002", (String)"MyTaskItemPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), failText.toString()));
            } else {
                taskNameMsg.append(String.format(ResManager.loadKDString((String)"%s\u7684\u540e\u7f6e\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u5c06\u5176\u6807\u8bb0\u4e3a\u672a\u5b8c\u6210\u72b6\u6001\u3002", (String)"MyTaskItemPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), failText.toString()));
            }
        }
        if (taskNameMsg.length() > 0) {
            this.getPageCache().put(TASK_MESSAGE, taskNameMsg.toString());
        } else {
            this.getPageCache().put(TASK_MESSAGE, null);
        }
        if (taskNodes.size() == 0) {
            OperationResult operationResult = new OperationResult();
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(taskNameMsg.toString());
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operationResult.addErrorInfo(operateErrorInfo);
            operationResult.setBillCount(failTaskNodes.size());
            ShowOperationMsgUtil.showOperationResultMulti(operationResult, "", this.getView(), String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%1$s\u5f20\u3002", (String)"MyTaskItemPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), failTaskNodes.size(), 0));
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date setReportTaskStatus(String key, List<TreeNode> taskStatusNodes, List<TreeNode> taskNodes, List<TreeNode> failTaskNodes) {
        Long[] taskStatusIds = new Long[taskStatusNodes.size()];
        for (int i = 0; i < taskStatusNodes.size(); ++i) {
            taskStatusIds[i] = Long.valueOf(taskStatusNodes.get(i).getId());
        }
        if (taskStatusNodes.size() <= 0) return null;
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            HashMap<String, String> entity4TemplteName = new HashMap<String, String>();
            DynamicObject example = QueryServiceHelper.queryOne((String)"bcm_taskstatus", (String)"id,template,model,entity,entity.name,fy,period,scenario,template.name,currency.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskStatusIds[0])});
            String curnumber = example.getString("currency.number");
            long modid = example.getLong(MODEL);
            long sceneid = example.getLong("scenario");
            long yearid = example.getLong("fy");
            long periodid = example.getLong(PERIOD);
            DynamicObject obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)modid, (String)curnumber, (String)"bcm_currencymembertree");
            long curid = obj.getLong("id");
            HashMap entity4Templte = new HashMap();
            if (taskStatusIds.length == 1) {
                ArrayList<Long> templateIds = new ArrayList<Long>();
                templateIds.add(example.getLong(TEMPLATE));
                Long entityId = example.getLong(ENTITY);
                entity4Templte.put(entityId, templateIds);
                entity4TemplteName.put(this.generateKey(example.getLong(TEMPLATE), example.getLong(ENTITY)), example.getString("entity.name") + example.getString("template.name"));
            } else {
                DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_taskstatus", (String)"template,template.name,entity,entity.name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskStatusIds)});
                for (Object taskStatus : dcs) {
                    Long l = taskStatus.getLong(ENTITY);
                    Long templeteId = taskStatus.getLong(TEMPLATE);
                    List list = (List)entity4Templte.get(l);
                    if (list != null) {
                        list.add(templeteId);
                    } else {
                        ArrayList<Long> templateIds = new ArrayList<Long>();
                        templateIds.add(templeteId);
                        entity4Templte.put(l, templateIds);
                    }
                    entity4TemplteName.put(this.generateKey(templeteId, l), taskStatus.getString("entity.name") + taskStatus.getString("template.name"));
                }
            }
            ArrayList<String> notSaveTabName = new ArrayList<String>();
            ArrayList<String> makingTabName = new ArrayList<String>();
            for (Map.Entry entry : entity4Templte.entrySet()) {
                Long entityId = (Long)entry.getKey();
                ArrayList arrayList = new ArrayList();
                List notSaveTemplates = ReportServiceHelper.TestReportIsSave((List)((List)entry.getValue()), (Object)modid, (Object)curid, (Object)entityId, (Object)yearid, (Object)periodid, arrayList);
                if (ITEM_MASK.equals(key) && !notSaveTemplates.isEmpty()) {
                    ReportRecordUtil.batchSaveNewReportRecords(notSaveTemplates.stream().map(c -> LongUtil.toLong((Object)c)).collect(Collectors.toList()), modid, curid, entityId, sceneid, yearid, periodid, ReportStatusEnum.WEAVING, false);
                }
                for (Object notsavetemplate : notSaveTemplates) {
                    notSaveTabName.add((String)entity4TemplteName.get(this.generateKey(notsavetemplate, entityId)));
                }
                for (Object existReports : arrayList) {
                    makingTabName.add((String)entity4TemplteName.get(this.generateKey(existReports, entityId)));
                }
            }
            Date modifyTime = MyTaskStatusHelper.completeOrUndo((String)key, (Long[])taskStatusIds);
            ArrayList<Long> arrayList = new ArrayList<Long>();
            taskNodes.forEach(e -> arrayList.add(Long.valueOf(e.getId())));
            failTaskNodes.forEach(e -> arrayList.add(Long.valueOf(e.getId())));
            HashMap<String, Integer> taskSum = new HashMap<String, Integer>();
            taskSum.put("successtask", taskNodes.size());
            taskSum.put("failtask", failTaskNodes.size());
            ShowOperationMsgUtil.showOperationMsg(arrayList, notSaveTabName, makingTabName, this.getView(), this.getPageCache().get(TASK_MESSAGE), taskSum);
            this.getPageCache().put(TASK_MESSAGE, null);
            for (Long long1 : taskStatusIds) {
                if (ITEM_MASK.equals(key)) {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4efb\u52a1\u5b8c\u6210", "AbstractMultiReportPlugin_104", FI_BCM_FORMPLUGIN, "task complete"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%s\u4efb\u52a1\u5b8c\u6210\u6210\u529f\u3002", "AbstractMultiReportPlugin_389", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{String.valueOf(long1)})));
                    continue;
                }
                if (!ITEM_UNMASK.equals(key)) continue;
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u53d6\u6d88\u4efb\u52a1\u5b8c\u6210", "AbstractMultiReportPlugin_102", FI_BCM_FORMPLUGIN, "cancel task end"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%s\u53d6\u6d88\u4efb\u52a1\u5b8c\u6210\u6210\u529f\u3002", "AbstractMultiReportPlugin_388", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{String.valueOf(long1)})));
            }
            Date date = modifyTime;
            return date;
        }
        catch (KDBizException e2) {
            try {
                tx.markRollback();
                throw e2;
                catch (Throwable e3) {
                    tx.markRollback();
                    throw e3;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String generateKey(Object key1, Object key2) {
        return String.valueOf(key1) + String.valueOf(key2);
    }

    private void arrageReportTask4Check(String key, TreeNode node, List<TreeNode> taskNodes) {
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(child.getType()) || String.valueOf(TaskTypeEnum.UNFITASK.getValue()).equals(child.getType())) {
                    if (!this.prepareTask(key, child)) continue;
                    taskNodes.add(child);
                    continue;
                }
                this.arrageReportTask4Check(key, child, taskNodes);
            }
        }
    }

    private void arrageReportTask(TreeNode node, List<TreeNode> taskNodes) {
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(child.getType()) || String.valueOf(TaskTypeEnum.UNFITASK.getValue()).equals(child.getType())) {
                    taskNodes.add(child);
                    continue;
                }
                this.arrageReportTask(child, taskNodes);
            }
        }
    }

    private void arrageTaskStatus(String key, List<TreeNode> taskNodes, List<TreeNode> taskStatusNodes) {
        for (TreeNode node : taskNodes) {
            if (node.getChildren() == null) continue;
            for (TreeNode child : node.getChildren()) {
                if (String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(child.getType())) {
                    taskStatusNodes.add(child);
                    continue;
                }
                if (!String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(child.getType()) && !String.valueOf(TaskTypeEnum.UNFITASK.getValue()).equals(child.getType())) continue;
                ArrayList<TreeNode> subChild = new ArrayList<TreeNode>();
                subChild.add(child);
                this.arrageTaskStatus(key, subChild, taskNodes);
            }
        }
    }

    private void partRefresh(String key, List<TreeNode> taskStatusNodes, Date modifyTime) {
        if (taskStatusNodes.size() > 0) {
            RequestContext tx = RequestContext.get();
            String userName = tx.getUserName();
            ArrayList<String> taskStatusIds = new ArrayList<String>(taskStatusNodes.size());
            for (int i = 0; i < taskStatusNodes.size(); ++i) {
                taskStatusIds.add(String.valueOf(taskStatusNodes.get(i).getId()));
            }
            TreeNode virtualRoot = this.getCacheTree();
            HashSet<String> parentNodeIds = new HashSet<String>(16);
            for (String taskStatusId : taskStatusIds) {
                String reportStatus;
                TreeNode detail = virtualRoot.getTreeNode(taskStatusId, 10);
                Map data = (Map)detail.getData();
                if (ITEM_MASK.equals(key)) {
                    data.put(TASK_STATUS, TaskStatusEnum.COMPLETE.index);
                } else {
                    data.put(TASK_STATUS, TaskStatusEnum.UNDO.index);
                }
                data.put("modifytime", modifyTime);
                data.put("modifier", userName);
                String string = reportStatus = data.get(REPORT_STATUS) == null ? "" : data.get(REPORT_STATUS).toString();
                if (ITEM_MASK.equals(key)) {
                    if (ReportStatusEnum.UNWEAVE.status().equals(reportStatus) || ReportStatusEnum.WEAVING.status().equals(reportStatus) || ReportStatusEnum.BACK.status().equals(reportStatus)) {
                        data.put(REPORT_STATUS, ReportStatusEnum.COMPLETE.status());
                    }
                } else if (ReportStatusEnum.COMPLETE.status().equals(reportStatus)) {
                    data.put(REPORT_STATUS, ReportStatusEnum.WEAVING.status());
                }
                parentNodeIds.add(detail.getParentid());
            }
            MyTaskTreeUtil.setTimeInfoByTreeNode(virtualRoot);
            this.cacheTree(virtualRoot);
            Set cKeys = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.cKeysCacheId), Set.class);
            StringBuilder selectKeyBuff = new StringBuilder();
            cKeys.forEach(selectKeyBuff::append);
            String selectKey = selectKeyBuff.toString();
            List<Object> deleteList = new ArrayList();
            ArrayList<String> displayIds = new ArrayList<String>();
            if (!selectKey.contains("all")) {
                String userId = RequestContext.get().getUserId();
                this.getDisplayList(selectKey, userId, displayIds);
                deleteList = MyTaskTreeUtil.selectDisplay(null, virtualRoot, displayIds);
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (!deleteList.contains(entry.getString("id"))) continue;
                    this.getModel().deleteEntryRow(TREE_ENTRY_ENTITY, i);
                }
                Counter count = new Counter();
                MyTaskTreeUtil.countAllTask(virtualRoot, count);
            }
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                TreeNode currentNode = virtualRoot.getTreeNode(entry.getString("id"), 10);
                Map data = (Map)currentNode.getData();
                if (!String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(currentNode.getType())) {
                    this.getModel().setValue(TASK_STATUS, data.get(TASK_STATUS), i);
                }
                this.getModel().setValue(REPORT_STATUS, data.get(REPORT_STATUS), i);
                this.getModel().setValue("remaintime", data.get("remaintime"), i);
                if (!selectKey.contains("all")) {
                    String taskName = (String)data.get("taskname");
                    String str = (String)data.get("count");
                    if (StringUtils.isNotEmpty((CharSequence)str)) {
                        String[] countNumber = str.split(",");
                        taskName = String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(currentNode.getType()) ? String.format(ResManager.loadKDString((String)"%1$s\uff08\u5171%2$s\u5f20\u62a5\u8868\uff09\u3002", (String)"MyTaskItemPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), taskName, new Object[]{countNumber[1]}) : String.format(ResManager.loadKDString((String)"%1$s\u3002\u5171\u6709%2$s\u4e2a\u4efb\u52a1\u548c%2$s\u5f20\u62a5\u8868\u3002", (String)"MyTaskItemPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), taskName, new Object[]{countNumber[0], countNumber[1]});
                    }
                    this.getModel().setValue("taskname", (Object)taskName, i);
                }
                if (!taskStatusIds.contains(entry.getString("id"))) continue;
                this.getModel().setValue("modifytime", (Object)modifyTime, i);
                this.getModel().setValue("modifier", (Object)userName, i);
            }
            this.setFildAmount(virtualRoot);
            this.getView().updateView();
        }
    }

    private void partRefresh4Report(String key, List<Long> rightTaskStatus) {
        TreeNode virtualRoot = this.getCacheTree();
        for (Long taskStatusId : rightTaskStatus) {
            TreeNode detail = virtualRoot.getTreeNode(String.valueOf(taskStatusId), 10);
            Map data = (Map)detail.getData();
            if (BTN_COMMIT.equals(key)) {
                data.put(REPORT_STATUS, ReportStatusEnum.COMMIT.status());
                continue;
            }
            data.put(REPORT_STATUS, ReportStatusEnum.BACK.status());
        }
        this.cacheTree(virtualRoot);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (!rightTaskStatus.contains(Long.valueOf(entry.getString("id")))) continue;
            TreeNode currentNode = virtualRoot.getTreeNode(entry.getString("id"), 10);
            Map data = (Map)currentNode.getData();
            this.getModel().setValue(REPORT_STATUS, data.get(REPORT_STATUS), i);
            if (BTN_COMMIT.equals(key)) {
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4e0a\u62a5", "MyTaskItemPlugin_16", FI_BCM_FORMPLUGIN, "submit"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%s\u4e0a\u62a5\u6210\u529f\u3002", "AbstractMultiReportPlugin_390", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{entry.getString("id")})));
                continue;
            }
            if (!BTN_BACK.equals(key)) continue;
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6253\u56de", "MyTaskItemPlugin_17", FI_BCM_FORMPLUGIN, "reject"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%s\u6253\u56de\u6210\u529f\u3002", "AbstractMultiReportPlugin_391", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{entry.getString("id")})));
        }
        this.getView().updateView();
    }

    private List<String> transmitInfoFromDownToTop(Set<String> parentNodeIds, TreeNode virtualRoot) {
        ArrayList<String> result = new ArrayList<String>();
        if (parentNodeIds.size() > 0) {
            HashSet<String> parentUpLevelId = new HashSet<String>();
            for (String parentId : parentNodeIds) {
                TreeNode current = virtualRoot.getTreeNode(parentId, 10);
                List childRen = current.getChildren();
                String currentStatus = TaskStatusEnum.COMPLETE.index;
                if (childRen != null && childRen.size() > 0) {
                    for (TreeNode child : childRen) {
                        String taskStatus;
                        String taskType;
                        Map data = (Map)child.getData();
                        String string = taskType = data.get(TASK_TYPE) == null ? "" : data.get(TASK_TYPE).toString();
                        if (String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(taskType)) {
                            result.add(child.getId());
                        }
                        if (!(taskStatus = data.get(TASK_STATUS) == null ? "" : data.get(TASK_STATUS).toString()).equals(TaskStatusEnum.UNDO.index)) continue;
                        currentStatus = TaskStatusEnum.UNDO.index;
                        break;
                    }
                }
                Map data = (Map)current.getData();
                data.put(TASK_STATUS, currentStatus);
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{current.getParentid()})) {
                    parentUpLevelId.add(current.getParentid());
                }
                result.add(parentId);
            }
            List<String> upLevel = this.transmitInfoFromDownToTop(parentUpLevelId, virtualRoot);
            result.addAll(upLevel);
        }
        return result;
    }
}

