/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.TaskStatusEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.task.AbstractMyTaskListPlugin;
import kd.fi.bcm.formplugin.task.MyTaskTreeUtil;
import kd.fi.bcm.formplugin.util.OpenMenuPageUtil;

public class MyTaskListPlugin
extends AbstractMyTaskListPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String FINISH = "finish";
    private List<String> arrays = Arrays.asList("hasoverdue", "comingoverdue", "unoverdue", "finish");
    private Set<String> cKeys = new HashSet<String>();
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String TASK_TYPE = "tasktype";
    private static final String TASK_ID = "taskid";
    private static final String ORG_ID = "orgid";
    private static final String MEMBER_ID = "memberid";
    private static final String ROOT_ID = "rootid";
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";
    private static final String TASK_SEQ = "taskkseq";

    @Override
    public void initialize() {
        super.initialize();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        treeEntry.addHyperClickListener((HyperLinkClickListener)this);
        treeEntry.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshMyTask(true, true);
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        if (StringUtils.isEmpty((CharSequence)status) || "all".equals(status)) {
            this.getModel().setValue("all", (Object)true);
            this.isAllChecked(true, this.arrays);
            this.cKeys.addAll(this.arrays);
            this.getPageCache().put(this.cKeysCacheId, SerializationUtils.toJsonString(this.cKeys));
        } else if ("done".equals(status)) {
            String selectFields = "id";
            DynamicObjectCollection myTaskColl = MyTaskServiceHelper.getTaskByUser((String)RequestContext.get().getUserId(), null, (String[])new String[]{String.valueOf(TaskTypeEnum.ROOT.getValue())}, (String)selectFields, (String)"number");
            this.getModel().setValue(FINISH, (Object)true);
            this.cKeys.add(FINISH);
            this.getPageCache().put(this.cKeysCacheId, SerializationUtils.toJsonString(this.cKeys));
            if (myTaskColl.size() == 0) {
                return;
            }
            HashSet rootIdSet = new HashSet();
            myTaskColl.forEach(root -> rootIdSet.add(root.getLong("id")));
            String statusFields = MyTaskTreeUtil.genUniqueKey("id", "entity.id as orgId", "reporttask.id as taskid", "template.id as tempid");
            QFilter rootFilter = new QFilter("root", "in", rootIdSet);
            QFilter statusFilter = new QFilter("taskstatus", "=", (Object)TaskStatusEnum.COMPLETE.index);
            QFilter[] filters = new QFilter[]{rootFilter, statusFilter};
            List<String> displayIds = this.refreshByCondition(statusFields, filters);
            this.searchTaskForCondition(displayIds);
        }
        if (ModelUtil.queryApp(this.getView()).getAppnum().equals(ApplicationTypeEnum.EB.getAppnum())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"scenario"});
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Long orgid;
        Long rootid;
        QFilter idFilter;
        Long rootid2;
        Long memberId;
        DynamicObjectCollection taskcoll = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        DynamicObject taskEntry = (DynamicObject)taskcoll.get(arg0.getRowIndex());
        String taskType = taskEntry.getString(TASK_TYPE);
        if (!(String.valueOf(TaskTypeEnum.ROOT.getValue()).equals(taskType) || String.valueOf(TaskTypeEnum.PARAM.getValue()).equals(taskType) || String.valueOf(TaskTypeEnum.EXPLAIN.getValue()).equals(taskType))) {
            String orgId = taskEntry.getString(ORG_ID);
            QFilter qfId = new QFilter("id", "=", (Object)Long.valueOf(orgId));
            DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"model", (QFilter[])new QFilter[]{qfId});
            long modelid = org.getLong("model");
            Long memberId2 = Long.valueOf(orgId.trim());
            if (PermissionServiceImpl.getInstance((Long)modelid).hasNoPerm(MemberReader.findMemberById((long)modelid, (String)"bcm_entitymembertree", (Long)memberId2).getDimId(), memberId2)) {
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOPERM());
                return;
            }
        }
        HashMap<String, Object> openParameter = new HashMap<String, Object>(16);
        openParameter.put("formId", "bcm_executetask");
        if (String.valueOf(TaskTypeEnum.ROOT.getValue()).equals(taskType)) {
            memberId = taskEntry.getLong(MEMBER_ID);
            openParameter.put(ROOT_ID, memberId);
            openParameter.put(TASK_TYPE, TaskTypeEnum.ROOT.getValue());
        } else if (String.valueOf(TaskTypeEnum.PARAM.getValue()).equals(taskType)) {
            memberId = taskEntry.getLong(MEMBER_ID);
            if (!QueryServiceHelper.exists((String)"bcm_taskconfig", (Object)memberId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u53c2\u6570\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"MyTaskListPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            rootid2 = taskEntry.getLong(ROOT_ID);
            openParameter.put(ROOT_ID, rootid2);
            openParameter.put(TASK_TYPE, TaskTypeEnum.PARAM.getValue());
            openParameter.put("paramid", memberId);
        } else if (String.valueOf(TaskTypeEnum.EXPLAIN.getValue()).equals(taskType)) {
            memberId = taskEntry.getLong(MEMBER_ID);
            rootid2 = taskEntry.getLong(ROOT_ID);
            openParameter.put(ROOT_ID, rootid2);
            openParameter.put("explainid", memberId);
            openParameter.put(TASK_TYPE, TaskTypeEnum.EXPLAIN.getValue());
        } else if (String.valueOf(TaskTypeEnum.ORG_DISPLAY.getValue()).equals(taskType)) {
            Long rootid3 = taskEntry.getLong(ROOT_ID);
            openParameter.put(ROOT_ID, rootid3);
            Long orgid2 = taskEntry.getLong(ORG_ID);
            openParameter.put(ORG_ID, orgid2);
            openParameter.put(TASK_TYPE, TaskTypeEnum.ORG_DISPLAY.getValue());
        } else if (String.valueOf(TaskTypeEnum.LABEL.getValue()).equals(taskType)) {
            memberId = taskEntry.getLong(MEMBER_ID);
            if (!QueryServiceHelper.exists((String)"bcm_taskconfig", (Object)memberId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"MyTaskListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            idFilter = new QFilter("id", "=", (Object)memberId);
            DynamicObject task = QueryServiceHelper.queryOne((String)"bcm_taskconfig", (String)"kseq", (QFilter[])new QFilter[]{idFilter});
            rootid = taskEntry.getLong(ROOT_ID);
            openParameter.put(ROOT_ID, rootid);
            orgid = taskEntry.getLong(ORG_ID);
            openParameter.put(ORG_ID, orgid);
            Long taskid = taskEntry.getLong(TASK_ID);
            openParameter.put(TASK_ID, taskid);
            openParameter.put(TASK_TYPE, TaskTypeEnum.LABEL.getValue());
            openParameter.put(TASK_SEQ, task.getInt("kseq"));
        } else if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(taskType)) {
            memberId = taskEntry.getLong(MEMBER_ID);
            if (!QueryServiceHelper.exists((String)"bcm_taskconfig", (Object)memberId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"MyTaskListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            idFilter = new QFilter("id", "=", (Object)memberId);
            DynamicObject task = QueryServiceHelper.queryOne((String)"bcm_taskconfig", (String)"kseq", (QFilter[])new QFilter[]{idFilter});
            rootid = taskEntry.getLong(ROOT_ID);
            openParameter.put(ROOT_ID, rootid);
            orgid = taskEntry.getLong(ORG_ID);
            openParameter.put(ORG_ID, orgid);
            Long taskid = taskEntry.getLong(TASK_ID);
            openParameter.put(TASK_ID, taskid);
            openParameter.put(TASK_TYPE, TaskTypeEnum.REPORT.getValue());
            openParameter.put(TASK_SEQ, task.getInt("kseq"));
        } else if (String.valueOf(TaskTypeEnum.UNFITASK.getValue()).equals(taskType)) {
            memberId = taskEntry.getLong(MEMBER_ID);
            if (!QueryServiceHelper.exists((String)"bcm_taskconfig", (Object)memberId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"MyTaskListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            idFilter = new QFilter("id", "=", (Object)memberId);
            DynamicObject task = QueryServiceHelper.queryOne((String)"bcm_taskconfig", (String)"kseq", (QFilter[])new QFilter[]{idFilter});
            rootid = taskEntry.getLong(ROOT_ID);
            openParameter.put(ROOT_ID, rootid);
            orgid = taskEntry.getLong(ORG_ID);
            openParameter.put(ORG_ID, orgid);
            Long taskid = taskEntry.getLong(TASK_ID);
            openParameter.put(TASK_ID, taskid);
            openParameter.put(TASK_TYPE, TaskTypeEnum.UNFITASK.getValue());
            openParameter.put(TASK_SEQ, task.getInt("kseq"));
        } else if (String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(taskType)) {
            memberId = taskEntry.getLong(MEMBER_ID);
            rootid2 = taskEntry.getLong(ROOT_ID);
            openParameter.put(ROOT_ID, rootid2);
            openParameter.put("taskList_appoint_templateId", memberId);
            Long orgid3 = taskEntry.getLong(ORG_ID);
            openParameter.put(ORG_ID, orgid3);
            Long taskid = taskEntry.getLong(TASK_ID);
            QFilter idFilter2 = new QFilter("id", "=", (Object)taskid);
            DynamicObject task = QueryServiceHelper.queryOne((String)"bcm_taskconfig", (String)"kseq", (QFilter[])new QFilter[]{idFilter2});
            openParameter.put(TASK_ID, taskid);
            openParameter.put("tempid", memberId);
            openParameter.put(TASK_TYPE, TaskTypeEnum.REPORT.getValue());
            openParameter.put(TASK_SEQ, task.getInt("kseq"));
        }
        String menuId = OpenMenuPageUtil.getMarkIdByFormApp("bcm_executetask", this.getView());
        IFormView mainPageView = this.getView().getMainView();
        if (mainPageView == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u89c6\u56fe\u4e0d\u5b58\u5728", (String)"MyTaskListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String pageid = menuId + mainPageView.getPageId();
        IFormView parentView = this.getView().getParentView();
        if (mainPageView.getView(pageid) == null) {
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.setCustomParam("status", (Object)this.getPageCache().get(this.cKeysCacheId));
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPageId(pageid);
            showParameter.setParentPageId(parentView.getPageId());
            showParameter.setParentFormId(parentView.getEntityId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm(showParameter);
            this.getView().sendFormAction(mainPageView);
        } else {
            IFormView childFormView = mainPageView.getView(pageid);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObjectCollection taskcoll = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        if (evt.getRow() < 0 || evt.getRow() >= taskcoll.size()) {
            return;
        }
        DynamicObject taskEntry = (DynamicObject)taskcoll.get(evt.getRow());
        String taskType = taskEntry.getString(TASK_TYPE);
        if (String.valueOf(TaskTypeEnum.PARAM.getValue()).equals(taskType) || String.valueOf(TaskTypeEnum.EXPLAIN.getValue()).equals(taskType) || String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(taskType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"itemmark"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"itemunmark"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_commit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_back"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"itemmark"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"itemunmark"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_commit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_back"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "all": 
            case "hasoverdue": 
            case "comingoverdue": 
            case "unoverdue": 
            case "finish": {
                this.cKeys = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.cKeysCacheId), Set.class);
                String selectKey = "";
                boolean flag = Boolean.parseBoolean(e.getChangeSet()[0].getNewValue().toString());
                if ("all".equals(key)) {
                    this.isAllChecked(flag, this.arrays);
                    if (flag) {
                        selectKey = "all";
                        this.cKeys.addAll(this.arrays);
                    } else {
                        this.cKeys.clear();
                    }
                } else {
                    if (flag) {
                        this.cKeys.add(key);
                    } else {
                        this.cKeys.remove(key);
                    }
                    StringBuilder sb = new StringBuilder();
                    this.cKeys.forEach(p -> sb.append((String)p));
                    this.isAllCBCheck(this.arrays.size() == this.cKeys.size());
                    selectKey = sb.toString();
                }
                this.getPageCache().put(this.cKeysCacheId, SerializationUtils.toJsonString(this.cKeys));
                this.refreshByCondition(selectKey);
            }
        }
    }

    private void isAllCBCheck(boolean flag) {
        this.getModel().beginInit();
        this.getModel().setValue("all", (Object)flag);
        this.getModel().endInit();
    }

    private void isAllChecked(boolean flag, List<String> arrays) {
        this.getModel().beginInit();
        arrays.forEach(p -> this.getModel().setValue(p, (Object)flag));
        this.getModel().endInit();
    }
}

