/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.TaskStatusEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.formplugin.task.Counter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MyTaskTreeUtil {
    public static final String treeentryentity = "treeentryentity";
    public static final long PARAM = 100L;
    public static final long EXPLAIN = 101L;

    public static void setTreeNodeStatus(TreeNode virtualRoot) {
        if (virtualRoot != null && virtualRoot.getChildren() != null && virtualRoot.getChildren().size() > 0) {
            for (int i = 0; i < virtualRoot.getChildren().size(); ++i) {
                TreeNode rootNode = (TreeNode)virtualRoot.getChildren().get(i);
                MyTaskTreeUtil.setStatus(rootNode);
            }
        }
    }

    private static TaskStatusEnum setStatus(TreeNode node) {
        if (String.valueOf(TaskTypeEnum.PARAM.getValue()).equals(node.getType()) || String.valueOf(TaskTypeEnum.EXPLAIN.getValue()).equals(node.getType())) {
            return TaskStatusEnum.COMPLETE;
        }
        Map data = (Map)node.getData();
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            ArrayList<String> childstatus = new ArrayList<String>(10);
            for (TreeNode child : node.getChildren()) {
                childstatus.add(MyTaskTreeUtil.setStatus((TreeNode)child).index);
            }
            if (childstatus.contains(TaskStatusEnum.UNDO.index)) {
                data.put("taskstatus", TaskStatusEnum.UNDO.index);
            } else {
                data.put("taskstatus", TaskStatusEnum.COMPLETE.index);
            }
        }
        return TaskStatusEnum.getTaskStatus((String)data.get("taskstatus").toString());
    }

    public static int[] countAllTask(TreeNode parentNode, Counter counter) {
        if (parentNode.getChildren() != null && parentNode.getChildren().size() > 0) {
            Map data;
            List children = parentNode.getChildren();
            int taskNum = 0;
            int temNum = 0;
            for (TreeNode node : children) {
                int[] count = MyTaskTreeUtil.countAllTask(node, counter);
                taskNum += count[0];
                temNum += count[1];
                counter.setNum(counter.getNum() + 1);
            }
            if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(parentNode.getType())) {
                data = (Map)parentNode.getData();
                data.put("count", "1," + temNum);
                return new int[]{1, temNum};
            }
            data = (Map)parentNode.getData();
            data.put("count", taskNum + "," + temNum);
            return new int[]{taskNum, temNum};
        }
        if (String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(parentNode.getType())) {
            return new int[]{0, 1};
        }
        return new int[]{0, 0};
    }

    public static void fillTreeEntryEntityByTreeNode(IDataModel model, TreeNode virtualRoot, List<String> propertyList, Counter count) {
        if (count.getNum() == 0) {
            return;
        }
        count.setFirstTaskRow(0);
        model.batchCreateNewEntryRow(treeentryentity, count.getNum());
        if (virtualRoot != null && virtualRoot.getChildren().size() > 0) {
            int rowNum = -1;
            for (int i = 0; i < virtualRoot.getChildren().size(); ++i) {
                TreeNode root = (TreeNode)virtualRoot.getChildren().get(i);
                Map data = (Map)root.getData();
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++rowNum);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("taskname".equals(property)) {
                        Object value = MyTaskTreeUtil.getValue(data, "count");
                        String str = "";
                        if (value != null) {
                            str = (String)value;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)str)) {
                            String[] countNumber = str.split(",");
                            rowObj.set(property, (Object)String.format(ResManager.loadKDString((String)"%1$s\u3002\u5171\u6709%2$s\u4e2a\u4efb\u52a1\u548c%3$s\u5f20\u62a5\u8868\u3002", (String)"MyTaskTreeUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MyTaskTreeUtil.getValue(data, property), countNumber[0], countNumber[1]));
                            continue;
                        }
                        rowObj.set(property, MyTaskTreeUtil.getValue(data, property));
                        continue;
                    }
                    rowObj.set(property, MyTaskTreeUtil.getValue(data, property));
                }
                rowObj.set("id", (Object)Long.valueOf(root.getId()));
                rowObj.set("pid", (Object)0);
                rowNum = MyTaskTreeUtil.expandNextLevelByTreeNode(model, propertyList, rowNum, root, count);
            }
        }
    }

    private static int expandNextLevelByTreeNode(IDataModel model, List<String> propertyList, int rowNum, TreeNode parentNode, Counter count) {
        if (parentNode.getChildren() != null && parentNode.getChildren().size() > 0) {
            List children = parentNode.getChildren();
            for (TreeNode child : children) {
                ++rowNum;
                Map data = (Map)child.getData();
                if (count.getFirstTaskRow() == 0 && String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(child.getType())) {
                    count.setFirstTaskRow(rowNum);
                }
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, rowNum);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("taskstatus".equals(property) && String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(child.getType())) continue;
                    if ("taskname".equals(property)) {
                        Object value = MyTaskTreeUtil.getValue(data, "count");
                        String str = "";
                        if (value != null) {
                            str = (String)value;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)str)) {
                            String[] countNumber = str.split(",");
                            if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(child.getType())) {
                                rowObj.set(property, (Object)String.format(ResManager.loadKDString((String)"%1$s\uff08\u5171%2$s\u5f20\u62a5\u8868\uff09\u3002", (String)"MyTaskTreeUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MyTaskTreeUtil.getValue(data, property), countNumber[1]));
                                continue;
                            }
                            rowObj.set(property, (Object)String.format(ResManager.loadKDString((String)"%1$s\u3002\u5171\u6709%2$s\u4e2a\u4efb\u52a1\u548c%3$s\u5f20\u62a5\u8868\u3002", (String)"MyTaskTreeUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MyTaskTreeUtil.getValue(data, property), countNumber[0], countNumber[1]));
                            continue;
                        }
                        rowObj.set(property, MyTaskTreeUtil.getValue(data, property));
                        continue;
                    }
                    rowObj.set(property, MyTaskTreeUtil.getValue(data, property));
                }
                rowObj.set("id", (Object)Long.valueOf(child.getId()));
                rowObj.set("pid", (Object)Long.valueOf(child.getParentid()));
                rowNum = MyTaskTreeUtil.expandNextLevelByTreeNode(model, propertyList, rowNum, child, count);
            }
        }
        return rowNum;
    }

    private static Object getValue(Map<String, Object> data, String property) {
        Object value;
        Object object = value = data.get(property) == null ? data.get(property.toUpperCase(Locale.ENGLISH)) : data.get(property);
        if (value != null && "modifytime".equals(property)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse(value.toString());
                return date;
            }
            catch (ParseException e) {
                return new Date();
            }
        }
        return value;
    }

    public static String genUniqueKey(String ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    public static String genUniqueLongKey(Long ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    public static List<String> selectDisplay(TreeNode ancestorNode, TreeNode parentNode, List<String> displayIds) {
        ArrayList<String> deleteList = new ArrayList<String>();
        if (parentNode.getChildren() != null) {
            for (int i = parentNode.getChildren().size() - 1; i >= 0; --i) {
                TreeNode child = (TreeNode)parentNode.getChildren().get(i);
                if (String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(child.getType())) {
                    if (displayIds.contains(child.getId())) continue;
                    deleteList.add(child.getId());
                    parentNode.deleteChildNode(child.getId());
                    continue;
                }
                deleteList.addAll(MyTaskTreeUtil.selectDisplay(parentNode, child, displayIds));
            }
        }
        if (!(ancestorNode == null || parentNode.getChildren() != null && parentNode.getChildren().size() != 0 || String.valueOf(TaskTypeEnum.PARAM.getValue()).equals(parentNode.getType()) || String.valueOf(TaskTypeEnum.EXPLAIN.getValue()).equals(parentNode.getType()))) {
            deleteList.add(parentNode.getId());
            ancestorNode.deleteChildNode(parentNode.getId());
        }
        return deleteList;
    }

    public static boolean doCheck(String key, Long taskid, Long orgid) {
        if ("itemmark".equals(key)) {
            QFilter idFilter = new QFilter("id", "=", (Object)taskid);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject[] taskColl = BusinessDataServiceHelper.load((String)"bcm_taskconfig", (String)"pretasks.taskconf", (QFilter[])filters, (String)"");
            if (taskColl.length > 0) {
                DynamicObjectCollection pretasks = taskColl[0].getDynamicObjectCollection("pretasks");
                if (pretasks.size() > 0) {
                    HashSet preTaskIds = new HashSet();
                    pretasks.forEach(pretask -> preTaskIds.add(pretask.getDynamicObject("taskconf").getLong("id")));
                    QFilter rootFilter = new QFilter("reporttask", "in", preTaskIds);
                    QFilter orgFilter = new QFilter("entity", "=", (Object)orgid);
                    QFilter statusFilter = new QFilter("taskstatus", "=", (Object)TaskStatusEnum.UNDO.getOIndex());
                    QFilter[] taskStatusfilters = new QFilter[]{rootFilter, orgFilter, statusFilter};
                    boolean exists = QueryServiceHelper.exists((String)"bcm_taskstatus", (QFilter[])taskStatusfilters);
                    return !exists;
                }
                return true;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"MyTaskTreeUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        StringBuilder baseSql = new StringBuilder();
        baseSql.append("select distinct fid from t_bcm_taskforpre where ftaskconfid = ? ");
        HashSet<Long> afterTaskIds = new HashSet<Long>();
        try (DataSet result = DB.queryDataSet((String)"MyTaskTreeUtil", (DBRoute)BCMConstant.DBROUTE, (String)baseSql.toString(), (Object[])new Object[]{taskid});){
            for (Row memberRow : result) {
                Long id = memberRow.getLong("fid");
                afterTaskIds.add(id);
            }
        }
        if (afterTaskIds.size() > 0) {
            QFilter rootFilter = new QFilter("reporttask", "in", afterTaskIds);
            QFilter orgFilter = new QFilter("entity", "=", (Object)orgid);
            QFilter statusFilter = new QFilter("taskstatus", "=", (Object)TaskStatusEnum.COMPLETE.getOIndex());
            QFilter[] taskStatusfilters = new QFilter[]{rootFilter, orgFilter, statusFilter};
            boolean exists = QueryServiceHelper.exists((String)"bcm_taskstatus", (QFilter[])taskStatusfilters);
            return !exists;
        }
        return true;
    }

    public static DynamicObjectCollection doCheckPre(String key, Long taskid, Long orgid) {
        if ("itemmark".equals(key)) {
            QFilter idFilter = new QFilter("id", "=", (Object)taskid);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject[] taskColl = BusinessDataServiceHelper.load((String)"bcm_taskconfig", (String)"pretasks.taskconf", (QFilter[])filters, (String)"");
            if (taskColl.length > 0) {
                DynamicObjectCollection pretasks = taskColl[0].getDynamicObjectCollection("pretasks");
                if (pretasks.size() > 0) {
                    HashSet preTaskIds = new HashSet();
                    pretasks.forEach(pretask -> preTaskIds.add(pretask.getDynamicObject("taskconf").getLong("id")));
                    QFilter rootFilter = new QFilter("reporttask", "in", preTaskIds);
                    QFilter orgFilter = new QFilter("entity", "=", (Object)orgid);
                    QFilter statusFilter = new QFilter("taskstatus", "=", (Object)TaskStatusEnum.UNDO.getOIndex());
                    QFilter[] taskStatusfilters = new QFilter[]{rootFilter, orgFilter, statusFilter};
                    DynamicObjectCollection dot = QueryServiceHelper.query((String)"bcm_taskstatus", (String)"reporttask", (QFilter[])taskStatusfilters);
                    if (dot != null && dot.size() > 0) {
                        return dot;
                    }
                    return null;
                }
                return null;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"MyTaskTreeUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        StringBuilder baseSql = new StringBuilder();
        baseSql.append("select distinct fid from t_bcm_taskforpre where ftaskconfid = ? ");
        HashSet<Long> afterTaskIds = new HashSet<Long>();
        try (DataSet result = DB.queryDataSet((String)"MyTaskTreeUtil", (DBRoute)BCMConstant.DBROUTE, (String)baseSql.toString(), (Object[])new Object[]{taskid});){
            for (Row memberRow : result) {
                Long id = memberRow.getLong("fid");
                afterTaskIds.add(id);
            }
        }
        if (afterTaskIds.size() > 0) {
            QFilter rootFilter = new QFilter("reporttask", "in", afterTaskIds);
            QFilter orgFilter = new QFilter("entity", "=", (Object)orgid);
            QFilter statusFilter = new QFilter("taskstatus", "=", (Object)TaskStatusEnum.COMPLETE.getOIndex());
            QFilter[] taskStatusfilters = new QFilter[]{rootFilter, orgFilter, statusFilter};
            DynamicObjectCollection dot = QueryServiceHelper.query((String)"bcm_taskstatus", (String)"reporttask", (QFilter[])taskStatusfilters);
            if (dot != null && dot.size() > 0) {
                return dot;
            }
            return null;
        }
        return null;
    }

    public static void setTimeInfoByTreeNode(TreeNode root) {
        String userId = RequestContext.get().getUserId();
        String selectFieldsForUnion = "id,name,pretasks.taskconf,endtime";
        DynamicObject[] myTaskArray = MyTaskServiceHelper.getTaskByUser4Union((String)userId, null, (String[])new String[]{String.valueOf(TaskTypeEnum.REPORT.getValue()), String.valueOf(TaskTypeEnum.UNFITASK.getValue())}, (String)selectFieldsForUnion, (String)"number");
        HashMap<Long, String> preStatus = new HashMap<Long, String>();
        HashMap<Long, Date> modifyTimeCatch = new HashMap<Long, Date>();
        HashMap<Long, Set<Long>> preTasksCatch = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Date> endTimeCatch = new HashMap<Long, Date>(16);
        HashSet<Object> preTaskIds = new HashSet<Object>();
        for (DynamicObject myTask : myTaskArray) {
            Long id = myTask.getLong("id");
            Date endtime = myTask.getDate("endtime");
            HashSet currentPreTaskIds = new HashSet();
            DynamicObjectCollection pretasks = myTask.getDynamicObjectCollection("pretasks");
            if (pretasks.size() > 0) {
                pretasks.stream().filter(pretask -> pretask.getDynamicObject("taskconf") != null).forEach(pretask -> preTaskIds.add(pretask.getDynamicObject("taskconf").getLong("id")));
                pretasks.stream().filter(pretask -> pretask.getDynamicObject("taskconf") != null).forEach(pretask -> currentPreTaskIds.add(pretask.getDynamicObject("taskconf").getLong("id")));
            }
            preTasksCatch.put(id, currentPreTaskIds);
            endTimeCatch.put(id, endtime);
            preTaskIds.add(id);
        }
        String statusFields = "reporttask.id as taskid,entity.id as entityid,taskstatus,modifytime";
        QFilter rootFilter = new QFilter("reporttask", "in", preTaskIds);
        QFilter[] filters = new QFilter[]{rootFilter};
        DynamicObjectCollection taskStatusColl = QueryServiceHelper.query((String)"bcm_taskstatus", (String)statusFields, (QFilter[])filters, (String)"taskstatus");
        for (DynamicObject taskStatus : taskStatusColl) {
            Long taskId = taskStatus.getLong("taskid");
            Long entityid = taskStatus.getLong("entityid");
            Date modifyTime = taskStatus.getDate("modifytime");
            String status = taskStatus.getString("taskstatus");
            if (!preStatus.containsKey(entityid + taskId)) {
                preStatus.put(entityid + taskId, "1");
            }
            if (TaskStatusEnum.UNDO.index.equals(status)) {
                preStatus.put(entityid + taskId, "0");
            }
            if (modifyTime == null) continue;
            if (!modifyTimeCatch.containsKey(entityid + taskId)) {
                modifyTimeCatch.put(entityid + taskId, modifyTime);
                continue;
            }
            if (!((Date)modifyTimeCatch.get(entityid + taskId)).before(modifyTime)) continue;
            modifyTimeCatch.put(entityid + taskId, modifyTime);
        }
        if (root.getChildren() != null && root.getChildren().size() > 0) {
            for (int i = 0; i < root.getChildren().size(); ++i) {
                MyTaskTreeUtil.expandNextLevelByTreeNode((TreeNode)root.getChildren().get(i), preStatus, preTasksCatch, modifyTimeCatch, endTimeCatch);
            }
        }
    }

    private static void expandNextLevelByTreeNode(TreeNode treeNode, Map<Long, String> preStatus, Map<Long, Set<Long>> preTasksCatch, Map<Long, Date> modifyTimeCatch, Map<Long, Date> endTimeCatch) {
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            for (TreeNode childNode : treeNode.getChildren()) {
                Map child = (Map)childNode.getData();
                if (child.get("tasktype") != null) {
                    int taskType = Integer.parseInt(child.get("tasktype").toString());
                    if (TaskTypeEnum.REPORT.getValue() == taskType || TaskTypeEnum.UNFITASK.getValue() == taskType) {
                        int diff;
                        Date ctime;
                        String ctimeStr;
                        StringBuffer timeMessage = new StringBuffer();
                        Long memberid = (Long)child.get("memberid");
                        Long entityid = Long.valueOf(child.get("orgid").toString());
                        String currentStatus = (String)child.get("taskstatus");
                        Date endTime = endTimeCatch.get(memberid);
                        Date completime = modifyTimeCatch.get(entityid + memberid);
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                        if (TaskStatusEnum.COMPLETE.index.equals(currentStatus)) {
                            ctimeStr = formatter.format(completime);
                            try {
                                ctime = formatter.parse(ctimeStr);
                            }
                            catch (ParseException e) {
                                throw new KDBizException(e.getMessage());
                            }
                            diff = (int)((ctime.getTime() - endTime.getTime()) / 86400000L);
                            if (diff > 0) {
                                timeMessage.append(ResManager.loadKDString((String)"\u8d85\u671f", (String)"MyTaskTreeUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(diff).append(ResManager.loadKDString((String)"\u5929\u65f6\u5b8c\u6210", (String)"MyTaskTreeUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            } else {
                                timeMessage.append(ResManager.loadKDString((String)"\u5269\u4f59", (String)"MyTaskTreeUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(Math.abs(diff)).append(ResManager.loadKDString((String)"\u5929\u65f6\u5b8c\u6210", (String)"MyTaskTreeUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            }
                        } else {
                            ctimeStr = formatter.format(TimeServiceHelper.getCurrentSystemTime());
                            try {
                                ctime = formatter.parse(ctimeStr);
                            }
                            catch (ParseException e) {
                                throw new KDBizException(e.getMessage());
                            }
                            diff = (int)((ctime.getTime() - endTime.getTime()) / 86400000L);
                            if (diff > 0) {
                                timeMessage.append(String.format(ResManager.loadKDString((String)"\u5df2\u8d85\u671f%s\u5929\uff0c", (String)"MyTaskTreeUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), diff));
                            } else {
                                timeMessage.append(String.format(ResManager.loadKDString((String)"\u5269\u4f59%s\u5929\uff0c", (String)"MyTaskTreeUtil_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Math.abs(diff)));
                            }
                            Set<Long> preTasks = preTasksCatch.get(memberid);
                            boolean isComplete = true;
                            if (preTasks == null || preTasks.isEmpty()) {
                                timeMessage.append(ResManager.loadKDString((String)"\u6ca1\u6709\u524d\u7f6e\u4efb\u52a1", (String)"MyTaskTreeUtil_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            } else {
                                for (Long preTaskID : preTasks) {
                                    if (!"0".equals(preStatus.get(entityid + preTaskID))) continue;
                                    isComplete = false;
                                }
                                if (isComplete) {
                                    timeMessage.append(ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1\u5df2\u5b8c\u6210\u3002", (String)"MyTaskTreeUtil_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                } else {
                                    timeMessage.append(ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1\u672a\u5b8c\u6210\u3002", (String)"MyTaskTreeUtil_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                }
                            }
                        }
                        child.put("remaintime", timeMessage);
                    }
                }
                MyTaskTreeUtil.expandNextLevelByTreeNode(childNode, preStatus, preTasksCatch, modifyTimeCatch, endTimeCatch);
            }
        }
    }

    public static Boolean getTaskStausIsCompleteForLong(Long orgId, Long taskId) {
        QFilter filter1 = new QFilter("entity", "=", (Object)orgId);
        QFilter filter2 = new QFilter("reporttask", "=", (Object)taskId);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_taskstatus", (String)"taskstatus", (QFilter[])new QFilter[]{filter1, filter2});
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return null;
        }
        for (DynamicObject dy : dys) {
            if (dy.getInt("taskstatus") != 0) continue;
            return false;
        }
        return true;
    }

    public static void countNumber(TreeNode virtualRoot, Counter count) {
        List children = virtualRoot.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                String taskStatus;
                Map result;
                if (String.valueOf(TaskTypeEnum.REPORT.getValue()).equals(child.getType())) {
                    result = (Map)child.getData();
                    taskStatus = (String)result.get("taskstatus");
                    if (TaskStatusEnum.COMPLETE.index.equals(taskStatus)) {
                        count.setTaskDone(count.getTaskDone() + 1);
                    } else {
                        count.setTaskUndone(count.getTaskUndone() + 1);
                        MyTaskTreeUtil.countTaskAndReport(count, result);
                    }
                    MyTaskTreeUtil.countNumber(child, count);
                    continue;
                }
                if (String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()).equals(child.getType())) {
                    Object t;
                    Object endtime;
                    result = (Map)child.getData();
                    taskStatus = (String)result.get("taskstatus");
                    if (TaskStatusEnum.COMPLETE.index.equals(taskStatus)) {
                        count.setReportDone(count.getReportDone() + 1);
                        continue;
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    if (result.get("endtime") instanceof String) {
                        t = endtime = (String)result.get("endtime");
                    } else {
                        endtime = (Date)result.get("endtime");
                        t = sdf.format((Date)endtime);
                    }
                    Date now = TimeServiceHelper.now();
                    String s = sdf.format(now);
                    try {
                        Date warningbeginDate;
                        String w;
                        Date nowDate = sdf.parse(s);
                        Date endDate = sdf.parse((String)t);
                        if (nowDate.after(endDate)) {
                            count.setReportHasOverdue(count.getReportHasOverdue() + 1);
                        }
                        if (!nowDate.after(endDate)) {
                            count.setReportUnOverdue(count.getReportUnOverdue() + 1);
                        }
                        if (result.get("warningbegintime") == null) continue;
                        if (result.get("warningbegintime") instanceof String) {
                            w = (String)result.get("warningbegintime");
                        } else {
                            Date warningbegintime = (Date)result.get("warningbegintime");
                            w = sdf.format(warningbegintime);
                        }
                        if (nowDate.before(warningbeginDate = sdf.parse(w)) || nowDate.after(endDate)) continue;
                        count.setReportComingOverdue(count.getReportComingOverdue() + 1);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u65e5\u671f\u9519\u8bef", (String)"MyTaskTreeUtil_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                MyTaskTreeUtil.countNumber(child, count);
            }
        }
    }

    private static void countTaskAndReport(Counter count, Map<String, Object> result) {
        Object t;
        Object endtime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (result.get("endtime") instanceof String) {
            t = endtime = (String)result.get("endtime");
        } else {
            endtime = (Date)result.get("endtime");
            t = sdf.format((Date)endtime);
        }
        Date now = TimeServiceHelper.now();
        String s = sdf.format(now);
        try {
            Date nowDate = sdf.parse(s);
            Date endDate = sdf.parse((String)t);
            if (nowDate.after(endDate)) {
                count.setTaskHasOverdue(count.getTaskHasOverdue() + 1);
            }
            if (!nowDate.after(endDate)) {
                count.setTaskUnOverdue(count.getTaskUnOverdue() + 1);
            }
            if (result.get("warningbegintime") != null) {
                String w;
                if (result.get("warningbegintime") instanceof String) {
                    w = (String)result.get("warningbegintime");
                } else {
                    Date warningbegintime = (Date)result.get("warningbegintime");
                    w = sdf.format(warningbegintime);
                }
                Date warningbeginDate = sdf.parse(w);
                if (!nowDate.before(warningbeginDate) && !nowDate.after(endDate)) {
                    count.setTaskComingOverdue(count.getTaskComingOverdue() + 1);
                }
            }
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u65e5\u671f\u9519\u8bef", (String)"MyTaskTreeUtil_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

