/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.task.TaskUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;

public class TaskCatalogAllEditPlugin
extends AbstractBaseFormPlugin {
    private DynamicObject catalog;
    private DynamicObject param;
    private static final String YEAR = "year";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period", "currency"});
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String DESCRIBE = "describe";
    private static final String PERIOD = "period";
    private static final String CURRENCY = "currency";
    private static final String SCENARIO = "scenario";
    private static final String ISSYS_TASK_EXPLAIN = "issystaskexplain";
    private static final String NUMBER = "number";
    private static final String ADD_NEW = "addnew";
    private static final String CATALOG_ID = "catalogid";
    private static final String TASK_CATALOG = "taskcatalog";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelid = this.getModelId();
        String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionname");
        this.getModel().setValue(MODEL, (Object)modelid);
        String dscribe = ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u4efb\u52a1", (String)"TaskCatalogAllEditPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        this.getModel().setValue(DESCRIBE, (Object)dscribe);
        BasedataEdit fy = (BasedataEdit)this.getControl(YEAR);
        BasedataEdit period = (BasedataEdit)this.getControl(PERIOD);
        BasedataEdit currency = (BasedataEdit)this.getControl(CURRENCY);
        fy.setCaption(new LocaleString(DimensionServiceHelper.getDimensionMessage((Object)modelid, (String)"bcm_fymembertree", (String)"name", (String)"").getString("name")));
        period.setCaption(new LocaleString(DimensionServiceHelper.getDimensionMessage((Object)modelid, (String)"bcm_periodmembertree", (String)"name", (String)"").getString("name")));
        currency.setCaption(new LocaleString(DimensionServiceHelper.getDimensionMessage((Object)modelid, (String)"bcm_currencymembertree", (String)"name", (String)"").getString("name")));
        QFilter filter = new QFilter(MODEL, "=", (Object)modelid);
        this.setF7NoPermIds("bcm_fymembertree", fy, filter);
        this.setF7NoPermIds("bcm_periodmembertree", period, filter);
        this.setF7NoPermIds("bcm_currencymembertree", currency, filter);
        BasedataEdit scenario = (BasedataEdit)this.getControl(SCENARIO);
        scenario.setCaption(new LocaleString(DimensionServiceHelper.getDimensionMessage((Object)modelid, (String)"bcm_scenemembertree", (String)"name", (String)"").getString("name")));
        this.setF7NoPermIds("bcm_scenemembertree", scenario, filter);
        this.assemModel(actionName);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("cancel", "confirm");
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelid != null) {
            this.getPageCache().put("KEY_MODEL_ID", modelid);
            HashMap map = new HashMap();
            this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
            this.initSingleMemberF7(map);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "model": {
                String modelId = this.getPageCache().get("KEY_MODEL_ID");
                SingleMemberF7Util.cacheDimPrem(this.getPageCache(), modelId, dimKeys);
                break;
            }
            case "period": 
            case "year": 
            case "scenario": 
            case "describe": {
                this.getModel().setValue("name", (Object)this.getNameStr());
                break;
            }
            case "currency": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                boolean isSureReturn = SingleMemberF7Util.isSureReturn(this.getPageCache(), propName, newValue, false);
                if (!isSureReturn) {
                    this.getModel().beginInit();
                    this.getModel().setValue(propName, null);
                    this.getModel().endInit();
                    this.getView().updateView();
                }
                this.getModel().setValue("name", (Object)this.getNameStr());
                break;
            }
            case "name": {
                break;
            }
            case "issystaskexplain": {
                break;
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_taskcatalog";
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            String message = this.validator();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionname");
            try (TXHandle tx = TX.required((String)"bcm_savaTask");){
                try {
                    this.saveDynamicobject(actionName);
                    if (ADD_NEW.equals(actionName)) {
                        TaskUtil.saveSysTaskConfig((Boolean)this.getModel().getValue(ISSYS_TASK_EXPLAIN), this.catalog, this.param);
                    }
                    Long taskCatalogId = this.catalog.getLong("id");
                    OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "TaskCatalogAllEditPlugin_1", FI_BCM_FORMPLUGIN, "save");
                    super.writeSuccessLog(opName, this.catalog.getString(NUMBER));
                    QFilter qfCatalog = new QFilter(TASK_CATALOG, "=", (Object)taskCatalogId);
                    QFilter qfTaskType = new QFilter("tasktype", "=", (Object)(TaskTypeEnum.REPORT.getValue() + ""));
                    DynamicObjectCollection reportTasks = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id", (QFilter[])new QFilter[]{qfCatalog, qfTaskType});
                    MyTaskStatusHelper.refreshTaskStatusRecord((DynamicObjectCollection)reportTasks);
                    this.getView().returnDataToParent((Object)this.catalog.getLong("id"));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            this.getView().close();
        } else {
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (e.getSource() instanceof Save && issuccess) {
            this.getView().returnDataToParent((Object)this.catalog.getLong("id"));
            this.getView().close();
        }
    }

    private void assemModel(String actionName) {
        if (!ADD_NEW.equals(actionName)) {
            long catalogid = (Long)this.getView().getFormShowParameter().getCustomParam(CATALOG_ID);
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)catalogid, (String)"bcm_taskcatalog", (String)"number,name,describe,issystaskexplain");
            QFilter filter = new QFilter("taskcatalog.id", "=", (Object)catalogid);
            DynamicObject param = BusinessDataServiceHelper.loadSingle((String)"bcm_taskparam", (String)MyTaskServiceHelper.getTaskParamSelector(), (QFilter[])new QFilter[]{filter});
            this.getModel().setValue(NUMBER, (Object)dy.getString(NUMBER));
            this.getModel().setValue("name", (Object)dy.getString("name"));
            this.getModel().setValue(DESCRIBE, (Object)dy.getString(DESCRIBE));
            this.getModel().setValue(ISSYS_TASK_EXPLAIN, dy.get(ISSYS_TASK_EXPLAIN));
            this.getModel().setValue(YEAR, (Object)param.getDynamicObject(YEAR));
            this.getModel().setValue(PERIOD, (Object)param.getDynamicObject(PERIOD));
            this.getModel().setValue(CURRENCY, (Object)param.getDynamicObject(CURRENCY));
            this.getModel().setValue(SCENARIO, (Object)param.getDynamicObject(SCENARIO));
        } else {
            this.getModel().setValue(NUMBER, (Object)TaskUtil.getSeriaNextNumber(this.getModelId()));
            Long id = TaskUtil.getIdByNumAndModel(CurrencyEnum.EC.getNumber(), this.getModelId(), "bcm_currencymembertree");
            if (Objects.nonNull(id)) {
                this.getModel().setValue(CURRENCY, (Object)id);
                this.getModel().setValue("name", (Object)this.getNameStr());
            }
        }
    }

    private void saveDynamicobject(String actionName) {
        if (!ADD_NEW.equals(actionName)) {
            String catalogid = this.getView().getFormShowParameter().getCustomParam(CATALOG_ID).toString();
            this.catalog = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(catalogid), (String)"bcm_taskcatalog");
            boolean flag = this.catalog.getBoolean(ISSYS_TASK_EXPLAIN);
            QFilter filter = new QFilter("taskcatalog.id", "=", (Object)Long.valueOf(catalogid));
            this.param = BusinessDataServiceHelper.loadSingle((String)"bcm_taskparam", (String)MyTaskServiceHelper.getTaskParamSelector(), (QFilter[])new QFilter[]{filter});
            this.assemDynamicObject(this.catalog, this.param);
            DimensionServiceHelper.assemModifyField((DynamicObject)this.catalog);
            Object[] objs = BusinessDataWriter.save((IDataEntityType)this.catalog.getDataEntityType(), (Object[])new Object[]{this.catalog});
            BusinessDataWriter.save((IDataEntityType)this.param.getDataEntityType(), (Object[])new Object[]{this.param});
            this.editDefaultTaskConfig(flag);
            this.getPageCache().put("catalog", ((DynamicObject)objs[0]).getString("id"));
        } else {
            this.catalog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskcatalog");
            this.param = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskparam");
            this.catalog.set("id", (Object)DBServiceHelper.genGlobalLongId());
            this.assemDynamicObject(this.catalog, this.param);
            DimensionServiceHelper.initObject4BaseInfo((DynamicObject)this.catalog);
            Object[] objs = BusinessDataWriter.save((IDataEntityType)this.catalog.getDataEntityType(), (Object[])new Object[]{this.catalog});
            this.catalog = (DynamicObject)objs[0];
            this.param.set(TASK_CATALOG, (Object)this.catalog);
            BusinessDataWriter.save((IDataEntityType)this.param.getDataEntityType(), (Object[])new Object[]{this.param});
            this.getPageCache().put("catalog", ((DynamicObject)objs[0]).getString("id"));
        }
    }

    private void assemDynamicObject(DynamicObject newCatalog, DynamicObject newParam) {
        newCatalog.set(NUMBER, this.getModel().getValue(NUMBER));
        newCatalog.set("name", this.getModel().getValue("name"));
        newCatalog.set(MODEL, this.getModel().getValue(MODEL));
        newCatalog.set(DESCRIBE, this.getModel().getValue(DESCRIBE));
        newCatalog.set(ISSYS_TASK_EXPLAIN, this.getModel().getValue(ISSYS_TASK_EXPLAIN));
        newCatalog.set("copyfrom", (Object)newCatalog);
        newParam.set(YEAR, this.getModel().getValue(YEAR));
        newParam.set(PERIOD, this.getModel().getValue(PERIOD));
        newParam.set(CURRENCY, this.getModel().getValue(CURRENCY));
        newParam.set(SCENARIO, this.getModel().getValue(SCENARIO));
    }

    private String validator() {
        if (this.getModel().getValue(SCENARIO) == null) {
            return ResManager.loadKDString((String)"\"\u60c5\u666f\"\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"TaskCatalogAllEditPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (this.getModel().getValue(YEAR) == null) {
            return ResManager.loadKDString((String)"\"\u8d22\u5e74\"\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"TaskCatalogAllEditPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (this.getModel().getValue(PERIOD) == null) {
            return ResManager.loadKDString((String)"\"\u671f\u95f4\"\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"TaskCatalogAllEditPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (this.getModel().getValue(CURRENCY) == null) {
            return ResManager.loadKDString((String)"\"\u5e01\u79cd\"\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"TaskCatalogAllEditPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (this.getModel().getValue(DESCRIBE) == null) {
            return ResManager.loadKDString((String)"\"\u63cf\u8ff0\"\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"TaskCatalogAllEditPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        return "";
    }

    private String getNameStr() {
        String str1 = this.getModel().getValue(YEAR) != null ? ((DynamicObject)this.getModel().getValue(YEAR)).getString("name") : "";
        String str2 = this.getModel().getValue(PERIOD) != null ? ((DynamicObject)this.getModel().getValue(PERIOD)).getString("name") : "";
        String str = this.getModel().getValue(CURRENCY) != null ? ((DynamicObject)this.getModel().getValue(CURRENCY)).getString("name") : "";
        String str3 = this.getModel().getValue(SCENARIO) != null ? ((DynamicObject)this.getModel().getValue(SCENARIO)).getString("name") : "";
        String str4 = StringUtils.isNotEmpty((CharSequence)this.getModel().getValue(DESCRIBE).toString()) ? this.getModel().getValue(DESCRIBE).toString() : "";
        return str1 + str2 + str3 + str + str4;
    }

    private void editDefaultTaskConfig(boolean dyflag) {
        QFilter filter1 = new QFilter("level", "=", (Object)0);
        QFilter filter2 = new QFilter(TASK_CATALOG, "=", this.getView().getFormShowParameter().getCustomParam(CATALOG_ID));
        DynamicObject root = BusinessDataServiceHelper.loadSingle((String)"bcm_taskconfig", (String)"name,modifytime,modifier", (QFilter[])new QFilter[]{filter1, filter2});
        filter1 = new QFilter(NUMBER, "=", (Object)"rootparam");
        DynamicObject param = BusinessDataServiceHelper.loadSingle((String)"bcm_taskconfig", (String)"name,modifytime,modifier", (QFilter[])new QFilter[]{filter1, filter2});
        root.set("name", this.getModel().getValue("name"));
        DimensionServiceHelper.assemModifyField((DynamicObject)root);
        param.set("name", (Object)(((DynamicObject)this.getModel().getValue(YEAR)).getString("name") + ((DynamicObject)this.getModel().getValue(PERIOD)).getString("name") + ((DynamicObject)this.getModel().getValue(SCENARIO)).getString("name") + ((DynamicObject)this.getModel().getValue(CURRENCY)).getString("name")));
        DimensionServiceHelper.assemModifyField((DynamicObject)param);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{root, param});
        boolean modelFlag = (Boolean)this.getModel().getValue(ISSYS_TASK_EXPLAIN);
        if (modelFlag != dyflag) {
            if (((Boolean)this.getModel().getValue(ISSYS_TASK_EXPLAIN)).booleanValue()) {
                TaskUtil.saveDefaultTaskConf(this.catalog, ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"TaskCatalogAllEditPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), "rootdiscribe", root.getLong("id"), "root.rootdiscribe", 1, 1, this.catalog.getLong("id"), 2, true);
            } else {
                filter1 = new QFilter(NUMBER, "=", (Object)"rootdiscribe");
                DynamicObject rootdiscribe = BusinessDataServiceHelper.loadSingle((String)"bcm_taskconfig", (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
                BusinessDataWriter.delete((IDataEntityType)rootdiscribe.getDataEntityType(), (Object[])new Object[]{rootdiscribe.getLong("id")});
            }
        }
    }

    private void setF7NoPermIds(String entityType, BasedataEdit basedata, QFilter filter) {
        long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        Map dimMap = MemberReader.getDimDyoByModelId((long)modelId);
        Optional<Long> dimIdOpt = dimMap.values().stream().filter(dy -> Objects.equals(dy.getString("membermodel"), entityType)).map(dy -> dy.getLong("id")).findFirst();
        if (!dimIdOpt.isPresent()) {
            basedata.setQFilter(filter);
            return;
        }
        filter.and(PermissionServiceImpl.getInstance((Long)modelId).getReadOrWritePermFilter(dimIdOpt.get(), entityType, "id"));
        basedata.setQFilter(filter);
    }
}

