/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.serviceHelper.QueryTreenodeHelper;
import kd.fi.bcm.business.sql.util.QCfilterUtils;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.datatypeutil.DataTypeConvertUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.PeriodTypeEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.task.TaskUtil;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaskConfListPlugin
extends AbstractBaseFormPlugin {
    private String addmessage = ResManager.loadKDString((String)"\u53ea\u53ef\u65b0\u589e\u6839\u4efb\u52a1\u6216\u6807\u7b7e\u7c7b\u578b\u4efb\u52a1\u7684\u4e0b\u7ea7\u4efb\u52a1\u3002", (String)"TaskConfListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    private static final String TASK_CATALOG = "taskcatalog";
    private static final String FOCUS_NODE_ID = "focusnodeid";
    private static final String SELECT_TASK_TREE = "selecttasktree";
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";
    private static final String TASK_TYPE = "tasktype";
    private static final String LONG_NUMBER = "longnumber";
    private static final String LEVEL = "level";
    private static final String MODIFY_TIME = "modifytime";
    private static final String PRE_TASKS = "pretasks";
    private static final String MODEL = "model";
    private static final String COPY_FROM = "copyfrom";
    private static final String MODELBD = "modelbd";
    private static final String CATALOG_ID = "catalogid";
    private static final String NUMBER = "number";
    private static final String PARENT = "parent";
    private static final String MODIFIER = "modifier";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String CUTROW_ID = "cutrowid";
    private static final String COPY_CATALOG_ID = "copycatalogid";
    private static final String PARENT_ID = "parentid";
    private static final String ACTION_NAME = "actionname";
    private static final String START_TIME = "starttime";
    private static final String END_TIME = "endtime";
    private static final String ALL_CUT_PKS = "allcutpks";
    private static final String PLAN_USE_TIME = "planusetime";
    private static final String BTN_ADD_NEW = "btn_addnew";
    private static final String BTN_MODIFY = "btn_modify";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BARITEMUP = "baritemup";
    private static final String NAME = "name";

    @Override
    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    @Override
    public String getModelSign() {
        return MODELBD;
    }

    private void addListeners() {
        this.addClickListeners(BTN_ADD_NEW, BTN_DELETE, BTN_MODIFY);
        this.addItemClickListeners("toolbarap");
        TreeView tview = (TreeView)this.getControl(TASK_CATALOG);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                TaskConfListPlugin.this.getPageCache().put(TaskConfListPlugin.FOCUS_NODE_ID, evt.getNodeId().toString());
                TaskConfListPlugin.this.refrushBillList(0);
            }
        });
        TreeEntryGrid treeentry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        treeentry.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent p0) {
                TaskConfListPlugin.this.hyperclick(p0);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.validator()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"treecheckbox", BTN_ADD_NEW, BTN_MODIFY, BTN_DELETE, MODELBD});
            return;
        }
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelId) || modelId.equals("0")) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODELBD);
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
        }
        if (modelId == null || modelId.equals("0")) {
            return;
        }
        this.getModel().setValue(MODELBD, (Object)modelId);
        this.modelChange(modelId);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeEntryGrid teg = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        teg.selectRows(0);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        this.validator();
        Control c = (Control)evt.getSource();
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        long modelid = this.getModelId();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addnew": {
                if (modelid == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"OlapQueryDataPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (nodeId == null) {
                    nodeId = "0";
                }
                this.newTaskCatalog(nodeId, true);
                break;
            }
            case "btn_delete": {
                if (!this.checkHaveTaskCatalog(nodeId)) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u4efb\u52a1\u5217\u8868\uff1f", (String)"TaskConfListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecatalog_comfirm", (IFormPlugin)this));
                break;
            }
            case "btn_modify": {
                if (!this.checkHaveTaskCatalog(nodeId)) break;
                HashMap<String, Object> openparams = new HashMap<String, Object>();
                openparams.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_taskcatalogedit");
                openparams.put(ACTION_NAME, "edit");
                openparams.put(CATALOG_ID, Long.valueOf(nodeId));
                this.showEditForm(openparams, closeCallBack, Long.parseLong(nodeId), ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"TaskConfListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean checkHaveTaskCatalog(String catalogid) {
        if (StringUtils.isEmpty((String)catalogid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u4efb\u52a1\u5217\u8868\u3002", (String)"TaskConfListPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.validator();
        String key = evt.getItemKey();
        String catalogid = this.getPageCache().get(FOCUS_NODE_ID);
        if ("btn_refrush".equals(key)) {
            this.refrushBillList(0);
            return;
        }
        if (catalogid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u4e00\u4e2a\u4efb\u52a1\u5217\u8868\u3002", (String)"TaskConfListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        long taskcatalogid = Long.parseLong(catalogid);
        if ("btn_del".equals(key)) {
            TreeEntryGrid teg = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            int focusrow = teg.getEntryState().getFocusRow();
            DynamicObject rowdo = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, focusrow);
            int typevalue = rowdo.getInt(TASK_TYPE);
            long selectpkid = rowdo.getLong("id");
            boolean isexists = this.checkPreTask(selectpkid, typevalue);
            if (isexists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u88ab\u8bbe\u7f6e\u4e3a\u524d\u7f6e\u4efb\u52a1\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"TaskConfListPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (TaskTypeEnum.ROOT.getValue() == typevalue || TaskTypeEnum.EXPLAIN.getValue() == typevalue || TaskTypeEnum.PARAM.getValue() == typevalue) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u4efb\u52a1\u4e0d\u53ef\u5220\u9664\u3002", (String)"TaskConfListPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\uff1f", (String)"TaskConfListPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("taskdel_comfirm", (IFormPlugin)this));
            }
        } else if ("btn_userdistribute".equals(key)) {
            String msg = this.checkCanDistribute(taskcatalogid);
            if (StringUtils.isNotEmpty((String)msg)) {
                if ("confirm".equals(msg)) {
                    return;
                }
                this.getView().showTipNotification(msg);
                return;
            }
            this.showUserDistributeView(taskcatalogid);
        } else if ("btn_details".equals(key)) {
            this.showUserDisDetailsView(taskcatalogid);
        } else if ("btn_temdistribute".equals(key)) {
            List<Long> pks = this.getTemplatePKs(taskcatalogid);
            this.showDistributionView(pks);
        } else if ("baritemaddsub".equals(key) || "baritemaddlevel".equals(key)) {
            this.BaritemAdd(key, taskcatalogid);
        } else if ("baritemcut".equals(key)) {
            DynamicObject dy = this.getClickRow();
            if (dy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u526a\u5207\u7684\u884c\u3002", (String)"TaskConfListPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            Long selectid = dy.getLong("id");
            Long parentid = dy.getLong(PARENT);
            String datatype = dy.getString(TASK_TYPE);
            if (0L == parentid || "1".equals(datatype) || "2".equals(datatype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u526a\u5207\u9884\u7f6e\u4efb\u52a1\u3002", (String)"TaskConfListPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            Set<String> ls = this.getChildPks(selectid.toString(), catalogid);
            this.getPageCache().put(CUTROW_ID, String.valueOf(selectid));
            this.getPageCache().put(ALL_CUT_PKS, SerializationUtils.toJsonString(ls));
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"bcm_taskconfig", (String)NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)DataTypeConvertUtil.convert(ls))});
            StringBuilder sb = new StringBuilder();
            for (DynamicObject task : tasks) {
                sb.append("  ").append(task.getString(NAME));
            }
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u526a\u5207", "TaskConfListPlugin_11", FI_BCM_FORMPLUGIN, "cut"), new OPDescMultiLangEnumBridge("\u201c%1$s\u201d \u526a\u5207\u6210\u529f\u3002", "TaskConfListPlugin_10", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{sb.toString()})));
        } else if ("baritempaste".equals(key)) {
            DynamicObject dy = this.getClickRow();
            if (dy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7c98\u8d34\u7684\u884c\u3002", (String)"TaskConfListPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            Long selectid = dy.getLong("id");
            Long parentid = dy.getLong(PARENT);
            String tasktype = dy.getString(TASK_TYPE);
            if (this.getPageCache().get(CUTROW_ID) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u526a\u5207\u7ef4\u5ea6\u6210\u5458\u3002", (String)"TaskConfListPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.PASTE.getMultiLangEnumBridge(), (String)"paste"), new OPDescMultiLangEnumBridge("\u7c98\u8d34\u5931\u8d25\u3002", "TaskConfListPlugin_40", FI_BCM_FORMPLUGIN, null));
                return;
            }
            Set cutallpks = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL_CUT_PKS), Set.class);
            if (cutallpks.contains(String.valueOf(selectid))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u7c98\u8d34\u5230\u672c\u8eab\u53ca\u5176\u4e0b\u7ea7\u3002", (String)"TaskConfListPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.PASTE.getMultiLangEnumBridge(), (String)"paste"), new OPDescMultiLangEnumBridge("\u7c98\u8d34\u5931\u8d25\u3002", "TaskConfListPlugin_40", FI_BCM_FORMPLUGIN, null));
                return;
            }
            if (!"4".equals(tasktype) && parentid != 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u65b0\u589e\u6839\u4efb\u52a1\u6216\u6807\u7b7e\u7c7b\u578b\u4efb\u52a1\u7684\u4e0b\u7ea7\u4efb\u52a1\uff0c\u65e0\u6cd5\u5b8c\u6210\u65b0\u589e\u5904\u7406\u3002", (String)"TaskConfListPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.PASTE.getMultiLangEnumBridge(), (String)"paste"), new OPDescMultiLangEnumBridge("\u7c98\u8d34\u5931\u8d25\u3002", "TaskConfListPlugin_40", FI_BCM_FORMPLUGIN, null));
                return;
            }
            this.getPageCache().put("pasterowid", String.valueOf(selectid));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u5c06\u526a\u5207\u9009\u62e9\u7684\u4efb\u52a1\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u4efb\u52a1\u79fb\u52a8\u7c98\u8d34\u4e3a\u9009\u62e9\u4efb\u52a1\u7684\u4e0b\u7ea7\uff1f", (String)"TaskConfListPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("paste_comfirm", (IFormPlugin)this));
        } else if (BARITEMUP.equals(key)) {
            DynamicObject dy = this.getClickRow();
            if (dy != null) {
                String moveTaskName = dy.getString(NAME);
                boolean success = this.BaritemMove(key);
                if (success) {
                    int moverows = (Integer)SerializationUtils.fromJsonString((String)this.getPageCache().get(SELECT_TASK_TREE), Integer.class);
                    this.refrushBillList(Integer.parseInt(this.getPageCache().get("row")) - moverows + 1);
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4e0a\u79fb", "TaskConfListPlugin_18", FI_BCM_FORMPLUGIN, BARITEMUP), new OPDescMultiLangEnumBridge("\u201c%1$s \u201d\u4e0a\u79fb\u6210\u529f\u3002", "TaskConfListPlugin_17", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{moveTaskName})));
                }
            }
        } else if ("baritemdown".equals(key)) {
            DynamicObject dy = this.getClickRow();
            if (dy != null) {
                String moveTaskName = dy.getString(NAME);
                boolean success = this.BaritemMove(key);
                if (success) {
                    int moverows = (Integer)SerializationUtils.fromJsonString((String)this.getPageCache().get(SELECT_TASK_TREE), Integer.class);
                    this.refrushBillList(Integer.parseInt(this.getPageCache().get("row")) + moverows);
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4e0b\u79fb", "TaskConfListPlugin_20", FI_BCM_FORMPLUGIN, "baritemdown"), new OPDescMultiLangEnumBridge("\u201c%1$s\u201d \u4e0b\u79fb\u6210\u529f\u3002", "TaskConfListPlugin_19", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{moveTaskName})));
                }
            }
        } else if ("bar_copy".equals(key)) {
            String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
            this.getPageCache().put("isOp", "false");
            this.copyTaskCatalog(nodeId);
        }
    }

    private void showUserDisDetailsView(long catalogid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CATALOG_ID, catalogid);
        params.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
        this.showEditFormView("bcm_tasklistdis_details", params, null, ShowType.Modal, OperationStatus.ADDNEW);
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u67e5\u770b", "TaskConfListPlugin_21", FI_BCM_FORMPLUGIN, "view"), new OPDescMultiLangEnumBridge("\u4efb\u52a1\u5217\u8868\u5206\u914d\u8be6\u60c5\u67e5\u770b\u6210\u529f\u3002", "TaskConfListPlugin_22", FI_BCM_FORMPLUGIN, null));
    }

    private boolean checkPreTask(long selectpkid, int tasktype) {
        String catalogid = this.getPageCache().get(FOCUS_NODE_ID);
        Set<Object> childs = new HashSet<String>();
        if (TaskTypeEnum.LABEL.getValue() == tasktype) {
            childs = this.getChildPks(String.valueOf(selectpkid), catalogid);
        } else {
            childs.add(String.valueOf(selectpkid));
        }
        HashMap contains = new HashMap();
        childs.forEach(e -> contains.put(e, "1"));
        QFilter qf = new QFilter("taskforpre", "in", (Object)DataTypeConvertUtil.convert(childs));
        DynamicObjectCollection dot = QueryServiceHelper.query((String)"bcm_taskforpre", (String)"taskconfig", (QFilter[])new QFilter[]{qf});
        for (DynamicObject d : dot) {
            if (contains.get(d.getString("taskconfig")) != null) continue;
            return true;
        }
        return false;
    }

    private void showUserDistributeView(long catalogId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CATALOG_ID, catalogId);
        params.put(MODEL, this.getPageCache().get("KEY_MODEL_ID"));
        long id = 0L;
        QFilter filter1 = new QFilter(TASK_CATALOG, "=", (Object)catalogId);
        QFilter[] filters = new QFilter[]{filter1};
        String selectProperties = "id";
        DynamicObject userdis = QueryServiceHelper.queryOne((String)"bcm_userdistribute", (String)selectProperties, (QFilter[])filters);
        if (userdis != null) {
            id = userdis.getLong("id");
        }
        this.showForm("bcm_userdistribute", params, new CloseCallBack((IFormPlugin)this, "bcm_userdistribute"), ShowType.Modal, id, ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u914d", (String)"TaskConfListPlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    private String checkCanDistribute(long catalogid) {
        QFilter filter1 = new QFilter(TASK_CATALOG, "=", (Object)catalogid);
        QFilter[] filters = new QFilter[]{filter1};
        boolean result = QueryServiceHelper.exists((String)"bcm_taskparam", (QFilter[])filters);
        if (!result) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5217\u8868\u7684\u53c2\u6570\u4e0d\u5168\uff0c\u8bf7\u586b\u5199\u5f53\u524d\u4efb\u52a1\u5217\u8868\u7684\u4efb\u52a1\u53c2\u6570\u540e\u91cd\u8bd5\u3002", (String)"TaskConfListPlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        HashSet<Integer> tasktypes = new HashSet<Integer>();
        for (DynamicObject row : entrys) {
            tasktypes.add(row.getInt(TASK_TYPE));
        }
        tasktypes.removeAll(Arrays.asList(0, 1, 2, 4));
        if (tasktypes.size() == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5217\u8868\u6ca1\u6709\u5305\u542b\u4efb\u4f55\u5177\u4f53\u4efb\u52a1\uff0c\u786e\u5b9a\u5206\u914d\u7ed9\u7528\u6237\u6267\u884c\uff1f", (String)"TaskConfListPlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("distribute_comfirm", (IFormPlugin)this));
            return "confirm";
        }
        return null;
    }

    private List<Long> getTemplatePKs(long catalogid) {
        QFilter filter2 = new QFilter(TASK_CATALOG, "=", (Object)catalogid);
        QFilter filter3 = new QFilter(TASK_TYPE, "in", (Object)new Object[]{TaskTypeEnum.REPORT.getValue() + "", TaskTypeEnum.UNFITASK.getValue() + ""});
        QFilter[] filters = new QFilter[]{filter2, filter3};
        String selectProperties = "id,templates.template";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_taskconfig", (String)selectProperties, (QFilter[])filters);
        return dys.stream().map(dy -> dy.getLong("templates.template")).collect(Collectors.toList());
    }

    private void BaritemAdd(String key, long taskcatalogid) {
        DynamicObject dy = this.getClickRow();
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"TaskConfListPlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String tasktype = dy.getString(TASK_TYPE);
        Long selectid = dy.getLong("id");
        Long parentid = Long.valueOf(dy.getString(PARENT).trim());
        HashMap<String, Object> params = new HashMap<String, Object>();
        if ("baritemaddsub".equals(key)) {
            if (0L != parentid && !"4".equals(tasktype)) {
                this.getView().showTipNotification(this.addmessage);
                return;
            }
            params.put(PARENT_ID, selectid);
        } else {
            if (0L == parentid) {
                this.getView().showTipNotification(this.addmessage);
                return;
            }
            params.put(PARENT_ID, parentid);
        }
        params.put("taskcatalogid", taskcatalogid);
        params.put("id", selectid);
        params.put(TASK_TYPE, tasktype);
        params.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
        params.put(ACTION_NAME, key);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_taskconfig");
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId("bcm_taskconfigedit");
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    private void modelChange(String modelid) {
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        this.refrushTree();
        this.refrushBillList(0);
    }

    private void newTaskCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_taskcatalogedit");
        if (isAddNew) {
            params.put(ACTION_NAME, "addnew");
            this.showEditForm(params, closeCallBack, 0L, ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"TaskConfListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            params.put(ACTION_NAME, "edit");
            long id = Long.parseLong(nodeId);
            params.put(CATALOG_ID, String.valueOf(id));
            this.showEditForm(params, closeCallBack, id, ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"TaskConfListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void copyTaskCatalog(String nodeId) {
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"bcm_taskcatalog");
        DynamicObject dy = (DynamicObject)OrmUtils.clone((IDataEntityBase)catalog, (boolean)false, (boolean)true);
        dy.set("id", (Object)DBServiceHelper.genGlobalLongId());
        dy.set(NUMBER, (Object)TaskUtil.getSeriaNextNumber(this.getModelId()));
        dy.set(COPY_FROM, (Object)catalog.getDynamicObject(COPY_FROM));
        DimensionServiceHelper.initObject4BaseInfo((DynamicObject)dy);
        DynamicObject param = this.copyParams(Long.parseLong(nodeId), dy);
        if (param == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u5b58\u5728\uff01", (String)"TaskConfListPlugin_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.COPYTASKLIST.getMultiLangEnumBridge(), (String)"copy tasklist"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%1$s,\u590d\u5236\u5931\u8d25\u3002", "TaskConfListPlugin_41", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dy.getString(NUMBER)})));
            return;
        }
        DynamicObject explain = this.copyExplain(dy, Long.parseLong(nodeId));
        dy.set(NAME, (Object)(TaskUtil.getParamTaskConfName(param) + catalog.getString("describe")));
        try (TXHandle tx = TX.required((String)"bcm_taskCopy");){
            try {
                BusinessDataServiceHelper.save((IDataEntityType)dy.getDataEntityType(), (Object[])new Object[]{dy});
                BusinessDataServiceHelper.save((IDataEntityType)param.getDataEntityType(), (Object[])new Object[]{param});
                if (explain != null) {
                    BusinessDataServiceHelper.save((IDataEntityType)explain.getDataEntityType(), (Object[])new Object[]{explain});
                }
                TaskUtil.saveSysTaskConfig(catalog.getBoolean("issystaskexplain"), dy, param);
                this.copyAboutTaskCatalog(dy.getLong("id"), Long.parseLong(nodeId));
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.COPYTASKLIST.getMultiLangEnumBridge(), (String)"copy tasklist"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%1$s,\u590d\u5236\u6210\u529f\u3002", "TaskConfListPlugin_42", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dy.getString(NUMBER)})));
            }
            catch (Throwable e) {
                tx.markRollback();
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.COPYTASKLIST.getMultiLangEnumBridge(), (String)"copy tasklist"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%1$s,\u590d\u5236\u5931\u8d25\u3002", "TaskConfListPlugin_41", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dy.getString(NUMBER)})));
                throw e;
            }
        }
        this.refrushTree();
        TreeView tview = (TreeView)this.getControl(TASK_CATALOG);
        TreeNode node = new TreeNode();
        node.setId(nodeId);
        tview.focusNode(node);
        this.getPageCache().put(FOCUS_NODE_ID, nodeId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868\u590d\u5236\u6210\u529f\u3002", (String)"TaskConfListPlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        this.refrushBillList(0);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "modelbd": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODELBD);
                if (modelId == null) {
                    this.getModel().setValue(MODELBD, (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.modelChange(modelId);
                break;
            }
        }
    }

    private void refrushTree() {
        TreeView Tree = (TreeView)this.getControl(TASK_CATALOG);
        Tree.deleteAllNodes();
        this.initTaskCatalog();
    }

    private void initTaskCatalog() {
        String selectFields = "id,name";
        QFilter filter1 = new QFilter(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection dcsFromDataBase = QueryServiceHelper.query((String)"bcm_taskcatalog", (String)selectFields, (QFilter[])new QFilter[]{filter1});
        if (dcsFromDataBase.size() == 0) {
            this.getPageCache().remove(FOCUS_NODE_ID);
            return;
        }
        DynamicObjectCollection dcs = this.taskOrder(dcsFromDataBase);
        TreeNode taskcatalog = new TreeNode();
        taskcatalog.setParentid("");
        taskcatalog.setId("0");
        for (DynamicObject dd : dcs) {
            TreeNode task = new TreeNode();
            task.setId(dd.getString("id"));
            task.setText(dd.getString(NAME));
            task.setParentid("0");
            taskcatalog.addChild(task);
        }
        this.getPageCache().put(FOCUS_NODE_ID, ((DynamicObject)dcs.get(0)).getString("id"));
        taskcatalog.setIsOpened(true);
        TreeView tview = (TreeView)this.getControl(TASK_CATALOG);
        tview.addNode(taskcatalog);
        TreeNode tn = (TreeNode)taskcatalog.getChildren().get(0);
        tview.focusNode(tn);
    }

    private DynamicObjectCollection queryAllChild(String entity, Long entityid, long modelid, long taskcatalogid) {
        QFilter filter = new QFilter("id", "=", (Object)entityid);
        String selectFields = LONG_NUMBER;
        DynamicObject orgmen = QueryServiceHelper.queryOne((String)entity, (String)selectFields, (QFilter[])new QFilter[]{filter});
        QFilter filter1 = new QFilter(MODEL, "=", (Object)modelid);
        QFilter filter2 = new QFilter(TASK_CATALOG, "=", (Object)taskcatalogid);
        QFilter filter3 = new QFilter(LONG_NUMBER, "like", (Object)(orgmen.get(LONG_NUMBER) + ".%"));
        String selectFields1 = "id,number,name";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entity, (String)selectFields1, (QFilter[])new QFilter[]{filter1, filter2, filter3});
        return doc;
    }

    private void refrushBillList(int row) {
        this.getModel().deleteEntryData(TREE_ENTRY_ENTITY);
        this.initTreeBill(row);
        this.getPageCache().remove(CUTROW_ID);
        this.getPageCache().remove(ALL_CUT_PKS);
    }

    private void initTreeBill(int row) {
        DynamicObject[] dcs;
        String catalogid = this.getPageCache().get(FOCUS_NODE_ID);
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(NAME);
        properties.add(TASK_TYPE);
        properties.add(START_TIME);
        properties.add(END_TIME);
        properties.add(PLAN_USE_TIME);
        properties.add(PRE_TASKS);
        properties.add("discription");
        properties.add(MODIFIER);
        properties.add(MODIFY_TIME);
        properties.add(PARENT);
        properties.add("id");
        properties.add("kseq");
        properties.add(LEVEL);
        DynamicObject[] dynamicObjectArray = dcs = catalogid == null ? null : this.queryTaskConfigration(Long.parseLong(catalogid), properties);
        if (dcs == null) {
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<Map<String, Object>> newdcs = new ArrayList<Map<String, Object>>(dcs.length);
        for (DynamicObject dd : dcs) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            block25: for (String colname : properties) {
                Object coldata = null;
                switch (colname) {
                    case "id": {
                        long id = dd.getLong("id");
                        map.put("id", id);
                        continue block25;
                    }
                    case "modifier": {
                        DynamicObject moid = dd.getDynamicObject(colname);
                        if (moid != null) {
                            coldata = moid.getString(NAME);
                        }
                        map.put(MODIFIER, coldata);
                        continue block25;
                    }
                    case "tasktype": {
                        coldata = dd.getInt(TASK_TYPE);
                        map.put(TASK_TYPE, coldata);
                        continue block25;
                    }
                    case "planusetime": {
                        int usetime = dd.getInt(colname);
                        if (usetime != 0) {
                            coldata = String.format(ResManager.loadKDString((String)"%s\u5929", (String)"TaskConfListPlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), usetime);
                        }
                        map.put(PLAN_USE_TIME, coldata);
                        continue block25;
                    }
                    case "modifytime": {
                        Date date = dd.getDate(colname);
                        coldata = date;
                        map.put(MODIFY_TIME, coldata);
                        continue block25;
                    }
                    case "starttime": {
                        Date date2 = dd.getDate(colname);
                        coldata = date2;
                        map.put(START_TIME, coldata);
                        continue block25;
                    }
                    case "endtime": {
                        Date date3 = dd.getDate(colname);
                        coldata = date3;
                        map.put(END_TIME, coldata);
                        continue block25;
                    }
                    case "parent": {
                        DynamicObject parent = dd.getDynamicObject(PARENT);
                        coldata = parent != null ? (Number)parent.getLong("id") : (Number)0;
                        map.put(PARENT, coldata);
                        continue block25;
                    }
                    case "level": {
                        coldata = dd.getInt(LEVEL);
                        map.put(LEVEL, coldata);
                        continue block25;
                    }
                    case "pretasks": {
                        DynamicObjectCollection pretasks = dd.getDynamicObjectCollection(PRE_TASKS);
                        StringBuilder sb = new StringBuilder();
                        for (DynamicObject task : pretasks) {
                            DynamicObject taskconf = task.getDynamicObject("taskconf");
                            boolean isEmpty = taskconf == null || taskconf.getString(NAME) == null;
                            sb.append(isEmpty ? "" : taskconf.getString(NAME));
                            sb.append(',');
                        }
                        coldata = sb.toString();
                        map.put(PRE_TASKS, coldata);
                        continue block25;
                    }
                }
                coldata = dd.getString(colname);
                map.put(colname, coldata);
            }
            newdcs.add(map);
        }
        if (newdcs.size() == 0) {
            return;
        }
        TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(model, newdcs, properties);
        TreeEntryGrid teg = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        teg.getView().updateView();
        teg.setCollapse(false);
        teg.selectRows(row);
    }

    private DynamicObject[] queryTaskConfigration(long taskcatalogid, List<String> properties) {
        String selectFields = properties.toString();
        selectFields = selectFields.substring(1, selectFields.length() - 1);
        selectFields = selectFields + ",pretasks.taskconf";
        QFilter filter = new QFilter(TASK_CATALOG, "=", (Object)taskcatalogid);
        return BusinessDataServiceHelper.load((String)"bcm_taskconfig", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"parent,kseq");
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id, String caption) {
        BaseShowParameter param = new BaseShowParameter();
        if (StringUtils.isNotEmpty((String)caption)) {
            param.setCaption(caption);
        }
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void showDistributionView(List<Long> pks) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_template_distribution");
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.setCustomParam("tpks", (Object)pks.toArray());
        param.setCustomParam("rows", (Object)pks.toArray());
        param.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d", (String)"TaskConfListPlugin_30", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        this.getView().showForm(param);
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6a21\u677f\u5206\u914d", "TaskConfListPlugin_30", FI_BCM_FORMPLUGIN, "template allocation"), new OPDescMultiLangEnumBridge("\u6253\u5f00\u6a21\u677f\u5206\u914d\u754c\u9762", "TaskConfListPlugin_31", FI_BCM_FORMPLUGIN, null));
    }

    private boolean validator() {
        String modulid = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modulid)) {
            QFilter filter = null;
            filter = ApplicationTypeEnum.EB == ModelUtil.queryApp(this.getView()) ? new QFilter("reporttype", "=", (Object)"4") : new QFilter("reporttype", "=", (Object)(ApplicationTypeEnum.RPT == ModelUtil.queryApp(this.getView()) ? ApplicationTypeEnum.RPT.getOIndex() : "1"));
            if (!QueryServiceHelper.exists((String)"bcm_model", (QFilter[])new QFilter[]{filter})) {
                this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        var3_3 = actionId = evt.getActionId();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case 967403787: {
                if (!var3_3.equals("bcm_taskcatalogedit")) break;
                var4_4 = 0;
                break;
            }
            case 854745151: {
                if (!var3_3.equals("bcm_userdistribute")) break;
                var4_4 = 1;
                break;
            }
            case 867630652: {
                if (!var3_3.equals("explaincallback")) break;
                var4_4 = 2;
                break;
            }
            case 942496722: {
                if (!var3_3.equals("paramcallback")) break;
                var4_4 = 3;
                break;
            }
            case -1880411430: {
                if (!var3_3.equals("bcm_taskconfig")) break;
                var4_4 = 4;
                break;
            }
            case 967354998: {
                if (!var3_3.equals("bcm_taskcatalogcopy")) break;
                var4_4 = 5;
                break;
            }
            case -1614494998: {
                if (!var3_3.equals("bcm_taskparamcopy")) break;
                var4_4 = 6;
            }
        }
        switch (var4_4) {
            case 0: {
                id = evt.getReturnData();
                if (ObjectUtils.isEmpty((Object)id)) break;
                this.refrushTree();
                nodeid = id.toString();
                tview = (TreeView)this.getControl("taskcatalog");
                node = new TreeNode();
                node.setId(nodeid);
                tview.focusNode(node);
                this.getPageCache().put("focusnodeid", nodeid);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskConfListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refrushBillList(0);
                break;
            }
            case 1: {
                msg = this.getView().getReturnData();
                if (ObjectUtils.isEmpty((Object)msg)) break;
                this.getView().showSuccessNotification(msg.toString());
                break;
            }
            case 2: 
            case 3: {
                paramdata = String.valueOf(evt.getReturnData());
                if (!"savesuccess".equals(paramdata)) break;
                this.refrushBillList(0);
                break;
            }
            case 4: {
                this.refrushBillList(0);
                break;
            }
            case 5: {
                params = new HashMap<String, Object>();
                copycatalogid = evt.getReturnData();
                if (copycatalogid == null) break;
                this.getPageCache().put("copycatalogid", copycatalogid.toString());
                params.put("actionname", "copy");
                params.put("copycatalogid", copycatalogid);
                params.put("catalogid", this.getPageCache().get("focusnodeid"));
                params.put("model", this.getPageCache().get("KEY_MODEL_ID"));
                closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_taskparamcopy");
                this.showForm("bcm_taskparam", params, closeCallBack, ShowType.Modal, 0L, null);
                break;
            }
            case 6: {
                opkey = String.valueOf(evt.getReturnData());
                copycatalog = Long.parseLong(this.getPageCache().get("copycatalogid"));
                if (StringUtils.isNotEmpty((String)opkey) && !"null".equals(opkey)) {
                    isOp = this.getPageCache().get("isOp");
                    if (opkey == null || !"copysuccess".equals(opkey) || !"false".equals(isOp)) break;
                    catalogid = Long.parseLong(this.getPageCache().get("focusnodeid"));
                    this.copyAboutTaskCatalog(copycatalog, catalogid);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskConfListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("isOp", "true");
                    this.refrushTree();
                    tree = (TreeView)this.getControl("taskcatalog");
                    treeNode = new TreeNode();
                    treeNode.setId(this.getPageCache().get("copycatalogid"));
                    tree.focusNode(treeNode);
                    this.getPageCache().put("focusnodeid", String.valueOf(copycatalog));
                    this.refrushBillList(0);
                    break;
                }
                filter1 = new QFilter("tasktype", "in", (Object)Lists.newArrayList((Object[])new String[]{String.valueOf(TaskTypeEnum.PARAM.getValue()), String.valueOf(TaskTypeEnum.EXPLAIN.getValue()), String.valueOf(TaskTypeEnum.ROOT.getValue())}));
                dys = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("taskcatalog.id", "=", (Object)copycatalog)});
                deleteIds = dys.stream().map((Function<DynamicObject, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$closedCallBack$2(kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Ljava/lang/Long;)()).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(deleteIds)) break;
                tx = TX.required();
                var18_25 = null;
                try {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_taskconfig"), (Object[])new Object[]{deleteIds});
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_taskcatalog"), (Object[])new Object[]{copycatalog});
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
                if (tx == null) break;
                if (var18_25 == null) ** GOTO lbl115
                try {
                    tx.close();
                }
                catch (Throwable var19_27) {
                    var18_25.addSuppressed(var19_27);
                }
                break;
lbl115:
                // 1 sources

                tx.close();
                break;
                catch (Throwable var19_28) {
                    try {
                        var18_25 = var19_28;
                        throw var19_28;
                    }
                    catch (Throwable var20_29) {
                        if (tx != null) {
                            if (var18_25 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable var21_30) {
                                    var18_25.addSuppressed(var21_30);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw var20_29;
                    }
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "deletecatalog_comfirm": {
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                long taskcatalogid = Long.parseLong(this.getPageCache().get(FOCUS_NODE_ID));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter(COPY_FROM, "=", (Object)taskcatalogid));
                qFilters.add(new QFilter("id", "!=", (Object)taskcatalogid));
                boolean flag = QueryServiceHelper.exists((String)"bcm_taskcatalog", (QFilter[])qFilters.toArray(new QFilter[0]));
                if (flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5217\u8868\u5df2\u7ecf\u88ab\u590d\u5236\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"TaskConfListPlugin_33", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.updateTaskCatalogBeforeDelete(taskcatalogid);
                QFilter filter = new QFilter(TASK_CATALOG, "=", (Object)taskcatalogid);
                QFilter numberFilter = new QFilter(NUMBER, "=", (Object)"root");
                DynamicObject root = QueryServiceHelper.queryOne((String)"bcm_taskconfig", (String)"id", (QFilter[])new QFilter[]{filter, numberFilter});
                Long rootId = root.getLong("id");
                QFilter rootIdFilter = new QFilter("root", "=", (Object)rootId);
                String number = QueryServiceHelper.queryOne((String)"bcm_taskcatalog", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskcatalogid)}).getString(NUMBER);
                try (TXHandle tx = TX.required();){
                    try {
                        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "TaskConfListPlugin_34", FI_BCM_FORMPLUGIN, "delete"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%s\u5220\u9664\u6210\u529f\u3002", "AbstractMultiReportPlugin_392", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number})));
                        BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_taskcatalog"), (Object[])new Object[]{taskcatalogid});
                        QFilter[] filters = new QFilter[]{filter};
                        DeleteServiceHelper.delete((String)"bcm_taskconfig", (QFilter[])filters);
                        DeleteServiceHelper.delete((String)"bcm_userdistribute", (QFilter[])filters);
                        MyTaskStatusHelper.deleteTaskStatusRecord((QFilter[])new QFilter[]{rootIdFilter});
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        this.getView().showTipNotification(e.getMessage());
                    }
                }
                this.refrushTree();
                this.refrushBillList(0);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaskConfListPlugin_35", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "paste_comfirm": {
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.pasteUpdate();
                this.getPageCache().put(CUTROW_ID, null);
                this.getPageCache().put(ALL_CUT_PKS, null);
                this.refrushBillList(Integer.parseInt(this.getPageCache().get("row")));
                break;
            }
            case "distribute_comfirm": {
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                String catalogId = this.getPageCache().get(FOCUS_NODE_ID);
                this.showUserDistributeView(Long.parseLong(catalogId));
                break;
            }
            case "taskdel_comfirm": {
                OPDescMultiLangEnumBridge opDescMultiLangEnumBridge;
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                String delTackName = this.getPageCache().get("delTackName");
                if (this.deleteTask()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaskConfListPlugin_35", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    this.refrushBillList(0);
                    opDescMultiLangEnumBridge = new OPDescMultiLangEnumBridge("\u201c%1$s\u201d \u5220\u9664\u6210\u529f\u3002", "TaskConfListPlugin_36", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{delTackName}));
                } else {
                    opDescMultiLangEnumBridge = new OPDescMultiLangEnumBridge("\u201c%1$s\u201d \u5220\u9664\u5931\u8d25\u3002", "TaskConfListPlugin_37", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{delTackName}));
                }
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "TaskConfListPlugin_34", FI_BCM_FORMPLUGIN, "delete"), opDescMultiLangEnumBridge);
                break;
            }
        }
    }

    private boolean deleteTask() {
        String catalogid = this.getPageCache().get(FOCUS_NODE_ID);
        long taskCatalogid = Long.parseLong(catalogid);
        long modelid = this.getModelId();
        TreeEntryGrid teg = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        int focusrow = teg.getEntryState().getFocusRow();
        DynamicObject rowdo = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, focusrow);
        int typevalue = rowdo.getInt(TASK_TYPE);
        long taskid = rowdo.getLong("id");
        HashSet<Long> taskids = new HashSet<Long>();
        taskids.add(taskid);
        StringBuilder taskNames = new StringBuilder();
        taskNames.append(rowdo.getString(NAME));
        if (TaskTypeEnum.LABEL.getValue() == typevalue) {
            DynamicObjectCollection doc = this.queryAllChild("bcm_taskconfig", taskid, modelid, taskCatalogid);
            for (DynamicObject dd : doc) {
                taskids.add(dd.getLong("id"));
                taskNames.append("  ").append(dd.getString(NAME));
            }
        }
        this.getPageCache().put("delTackName", taskNames.toString());
        QFilter filter = new QFilter("id", "in", (Object)taskids.toArray());
        DynamicObjectCollection tasksNumber = QueryServiceHelper.query((String)"bcm_taskconfig", (String)NUMBER, (QFilter[])new QFilter[]{filter});
        boolean flag = true;
        try (TXHandle tx = TX.required();){
            try {
                for (DynamicObject object : tasksNumber) {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "TaskConfListPlugin_34", FI_BCM_FORMPLUGIN, "delete"), new OPDescMultiLangEnumBridge("\u7f16\u53f7%s\u5220\u9664\u6210\u529f\u3002", "AbstractMultiReportPlugin_392", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{object.getString(NUMBER)})));
                }
                DeleteServiceHelper.delete((String)"bcm_taskconfig", (QFilter[])new QFilter[]{filter});
                MyTaskStatusHelper.deleteTaskStatusRecord((QFilter[])new QFilter[]{new QFilter("reporttask", "in", (Object)taskids.toArray())});
            }
            catch (Throwable e) {
                tx.markRollback();
                this.getView().showTipNotification(e.getMessage());
                flag = false;
            }
        }
        return flag;
    }

    protected void hyperclick(HyperLinkClickEvent p0) {
        this.hyperLinkClick(p0);
        long Taskcatalogid = Long.parseLong(this.getPageCache().get(FOCUS_NODE_ID));
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        DynamicObjectCollection dyc = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        DynamicObject dy = (DynamicObject)dyc.get(p0.getRowIndex());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskcatalogid", Taskcatalogid);
        params.put("KEY_MODEL_ID", modelid);
        int typevalue = dy.getInt(TASK_TYPE);
        if (TaskTypeEnum.EXPLAIN.getValue() == typevalue) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "explaincallback");
            DynamicObjectCollection dcs = this.queryParam(Taskcatalogid, "bcm_taskexplain", "text,id");
            if (dcs == null) {
                this.showForm("bcm_taskexplain", params, closeCallBack, ShowType.Modal, 0L, null);
            } else {
                this.showForm("bcm_taskexplain", params, closeCallBack, ShowType.Modal, ((DynamicObject)dcs.get(0)).getLong("id"), null);
            }
        } else if (TaskTypeEnum.PARAM.getValue() == typevalue) {
            HashMap<String, Object> openparams = new HashMap<String, Object>();
            openparams.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_taskcatalogedit");
            openparams.put(ACTION_NAME, "edit");
            openparams.put(CATALOG_ID, Taskcatalogid);
            this.showEditForm(openparams, closeCallBack, Taskcatalogid, ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"TaskConfListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (TaskTypeEnum.UNFITASK.getValue() == typevalue || TaskTypeEnum.LABEL.getValue() == typevalue || TaskTypeEnum.REPORT.getValue() == typevalue) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_taskconfig");
            params.put("id", dy.getLong("id"));
            params.put("savetype", "edit");
            this.showEditFormView("bcm_taskconfigedit", params, closeCallBack, ShowType.MainNewTabPage, OperationStatus.EDIT);
        } else if (0 == typevalue) {
            String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
            HashMap<String, Object> openparams = new HashMap<String, Object>();
            openparams.put("KEY_MODEL_ID", this.getPageCache().get("KEY_MODEL_ID"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_taskcatalogedit");
            openparams.put(ACTION_NAME, "edit");
            openparams.put(CATALOG_ID, Long.valueOf(nodeId));
            this.showEditForm(openparams, closeCallBack, Taskcatalogid, ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"TaskConfListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u67e5\u770b", "TaskConfListPlugin_21", FI_BCM_FORMPLUGIN, "view"), new OPDescMultiLangEnumBridge("\u201c%1$s\u201d \u67e5\u770b\u6210\u529f\u3002", "TaskConfListPlugin_38", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dy.getString(NAME)})));
    }

    private void showEditFormView(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, OperationStatus operationStatus) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        param.setStatus(operationStatus);
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    private DynamicObjectCollection queryParam(long Taskcatalogid, String entityname, String selectFileds) {
        QFilter qf = new QFilter(TASK_CATALOG, "=", (Object)Taskcatalogid);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityname, (String)selectFileds, (QFilter[])qfs);
        if (dcs != null && dcs.size() != 0) {
            return dcs;
        }
        return null;
    }

    private DynamicObject getClickRow() {
        DynamicObjectCollection dyc = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        TreeEntryGrid treeentry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        int[] rows = treeentry.getSelectRows();
        int selectIndex = 0;
        if (rows != null && rows.length > 0) {
            selectIndex = rows[rows.length - 1];
            DynamicObject dy = (DynamicObject)dyc.get(selectIndex);
            this.getPageCache().put("row", String.valueOf(selectIndex));
            return dy;
        }
        return null;
    }

    private Set<String> getChildPks(String nodeId, String Taskcatalogid) {
        HashSet<String> allnodelist = new HashSet<String>();
        allnodelist.add(nodeId);
        QFilter qf = new QFilter(TASK_CATALOG, "=", (Object)Long.valueOf(Taskcatalogid));
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id,parent", (QFilter[])qfs);
        if (dcs != null && dcs.size() != 0) {
            ArrayList treeList = new ArrayList();
            for (DynamicObject a : dcs) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", a.getString(0));
                map.put(PARENT_ID, a.getString(1));
                treeList.add(map);
            }
            return QueryTreenodeHelper.queryAllChildNodeSet((String)nodeId, treeList, allnodelist);
        }
        return new HashSet<String>();
    }

    private void pasteUpdate() {
        String pasterowid = this.getPageCache().get("pasterowid");
        String cutrowid = this.getPageCache().get(CUTROW_ID);
        Set pks = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL_CUT_PKS), Set.class);
        DynamicObject cutTree = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(cutrowid), (String)"bcm_taskconfig");
        DynamicObject pasteTree = QueryServiceHelper.queryOne((String)"bcm_taskconfig", (String)"longnumber,level,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(pasterowid))});
        String cutTreeLongnumber = cutTree.getString("parent.longnumber");
        String oldParentName = cutTree.getString("parent.name");
        String pastrTreeLongnumber = pasteTree.getString(LONG_NUMBER);
        int cutlevel = cutTree.getInt(LEVEL);
        int pastelevel = pasteTree.getInt(LEVEL);
        cutTree.set(PARENT, (Object)pasterowid);
        int newlevel = pastelevel + 1;
        cutTree.set(LEVEL, (Object)newlevel);
        int dseq = this.getMaxDSeq(Long.parseLong(pasterowid));
        cutTree.set("kseq", (Object)(dseq + 1));
        cutTree.set(LONG_NUMBER, (Object)(pasteTree.getString(LONG_NUMBER) + "." + cutTree.getString(NUMBER)));
        Date createTime = TimeServiceHelper.getCurrentSystemTime();
        String userid = RequestContext.get().getUserId();
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)userid);
        cutTree.set(MODIFIER, (Object)user);
        cutTree.set(MODIFY_TIME, (Object)createTime);
        ArrayList<DynamicObject> treeDataEntities = new ArrayList<DynamicObject>();
        treeDataEntities.add(cutTree);
        for (String set : pks) {
            if (set.equals(cutrowid)) continue;
            DynamicObject dysubTree = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(set), (String)"bcm_taskconfig");
            int levelshort = dysubTree.getInt(LEVEL) > cutlevel ? dysubTree.getInt(LEVEL) - cutlevel : cutlevel - dysubTree.getInt(LEVEL);
            dysubTree.set(LEVEL, (Object)(newlevel + levelshort));
            dysubTree.set(MODIFIER, (Object)user);
            dysubTree.set(MODIFY_TIME, (Object)createTime);
            String newlongnumber = pastrTreeLongnumber + dysubTree.getString(LONG_NUMBER).substring(cutTreeLongnumber.length());
            dysubTree.set(LONG_NUMBER, (Object)newlongnumber);
            treeDataEntities.add(dysubTree);
        }
        SaveServiceHelper.save((DynamicObject[])treeDataEntities.toArray(new DynamicObject[0]));
        if (!treeDataEntities.isEmpty()) {
            String nodeName = ((DynamicObject)treeDataEntities.get(0)).getString(NAME);
            treeDataEntities.remove(0);
            StringBuilder sb = new StringBuilder();
            StringBuilder subnames = new StringBuilder();
            if (!treeDataEntities.isEmpty()) {
                for (DynamicObject dy : treeDataEntities) {
                    sb.append("  ").append(dy.getString(NAME));
                }
                subnames.append(OpItemEnum.WITHSUB.getName()).append((CharSequence)sb);
            }
            this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.PASTE.getMultiLangEnumBridge(), (String)"paste"), new OPDescMultiLangEnumBridge("%1$s%2$s\u4ece%3$s\u7c98\u8d34\u5230%4$s\u4e0b\u7ea7,\u7c98\u8d34\u6210\u529f\u3002", "TaskConfListPlugin_43", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{nodeName, subnames.toString(), oldParentName, pasteTree.getString(NAME)})));
        }
    }

    public int getMaxDSeq(long id) {
        QFilter fdimenId = new QFilter(PARENT, "=", (Object)id);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_taskconfig", (String)"kseq", (QFilter[])filters, (String)"kseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 0;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("kseq");
        }
        return 0;
    }

    private boolean BaritemMove(String key) {
        QFilter[] qfs;
        QFilter qf2;
        QFilter qf1;
        DynamicObject dy = this.getClickRow();
        if (dy == null) {
            return false;
        }
        String SelectTasktype = dy.getString(TASK_TYPE);
        Long selectid = dy.getLong("id");
        Long parentid = dy.getLong(PARENT);
        if ("1".equals(SelectTasktype) || "2".equals(SelectTasktype) || parentid == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u6539\u53d8\u9884\u7f6e\u4efb\u52a1\u7684\u987a\u5e8f\u3002", (String)"TaskConfListPlugin_39", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        int kseq = dy.getInt("kseq");
        DynamicObjectCollection dcs = null;
        if (BARITEMUP.equals(key)) {
            qf1 = new QFilter("kseq", "<", (Object)kseq);
            qf2 = new QFilter(PARENT, "=", (Object)parentid);
            qfs = new QFilter[]{qf1, qf2};
            dcs = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id,tasktype", (QFilter[])qfs, (String)"kseq desc", (int)1);
        } else {
            qf1 = new QFilter("kseq", ">", (Object)kseq);
            qf2 = new QFilter(PARENT, "=", (Object)parentid);
            qfs = new QFilter[]{qf1, qf2};
            dcs = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id,tasktype", (QFilter[])qfs, (String)"kseq", (int)1);
        }
        if (dcs != null && dcs.size() > 0) {
            String tasktype = ((DynamicObject)dcs.get(0)).getString(TASK_TYPE);
            if ("1".equals(tasktype) || "2".equals(tasktype) || parentid == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u6539\u53d8\u9884\u7f6e\u4efb\u52a1\u7684\u987a\u5e8f\u3002", (String)"TaskConfListPlugin_39", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
            Long movedid = ((DynamicObject)dcs.get(0)).getLong("id");
            DynamicObject select = BusinessDataServiceHelper.loadSingle((Object)selectid, (String)"bcm_taskconfig");
            DynamicObject moved = BusinessDataServiceHelper.loadSingle((Object)movedid, (String)"bcm_taskconfig");
            this.cacheMoveRows(key, select, moved);
            int selectseq = select.getInt("kseq");
            int movedseq = moved.getInt("kseq");
            select.set("kseq", (Object)movedseq);
            moved.set("kseq", (Object)selectseq);
            DynamicObject[] dataEntities = new DynamicObject[]{select, moved};
            SaveServiceHelper.save((DynamicObject[])dataEntities);
            return true;
        }
        return false;
    }

    private void cacheMoveRows(String key, DynamicObject select, DynamicObject moved) {
        QFBuilder qfBuilder = new QFBuilder();
        if (BARITEMUP.equals(key)) {
            qfBuilder.add(LONG_NUMBER, "like", (Object)(select.getString(LONG_NUMBER) + "%"));
        } else {
            qfBuilder.add(LONG_NUMBER, "like", (Object)(moved.getString(LONG_NUMBER) + "%"));
        }
        qfBuilder.add("taskcatalog.id", "=", (Object)Long.valueOf(this.getPageCache().get(FOCUS_NODE_ID)));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id", (QFilter[])qfBuilder.toArray());
        this.getPageCache().put(SELECT_TASK_TREE, SerializationUtils.toJsonString((Object)dys.size()));
    }

    private void copyAboutTaskCatalog(long copyCatalogId, long catalogId) {
        this.copyUserDistribute(copyCatalogId, catalogId);
        Object[] objs = this.copyTaskConfig(copyCatalogId, catalogId);
        if (objs != null && objs.length > 0) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            for (Object obj : objs) {
                if (!"3".equals(((DynamicObject)obj).getString(TASK_TYPE)) && !"5".equals(((DynamicObject)obj).getString(TASK_TYPE))) continue;
                list.add((DynamicObject)obj);
            }
            MyTaskStatusHelper.refreshTaskStatusRecord((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
        }
    }

    private void copyUserDistribute(long copyCatalogId, long catalogId) {
        QFilter filter = new QFilter("taskcatalog.id", "=", (Object)catalogId);
        DynamicObject disdy = BusinessDataServiceHelper.loadSingle((Object)copyCatalogId, (String)"bcm_taskcatalog");
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_userdistribute", (String)(this.getUserDistributeFiledStr() + ",userdisentry.seq"), (QFilter[])new QFilter[]{filter});
        if (dys != null && dys.length > 0) {
            DynamicObject[] objs = new DynamicObject[dys.length];
            for (int i = 0; i < dys.length; ++i) {
                DynamicObject dy = (DynamicObject)OrmUtils.clone((IDataEntityBase)dys[i], (boolean)false, (boolean)true);
                dy.set(TASK_CATALOG, (Object)disdy);
                objs[i] = dy;
            }
            SaveServiceHelper.save((DynamicObject[])objs);
        }
    }

    private Object[] copyTaskConfig(long copyCatalogId, long catalogId) {
        QFilter filter1 = new QFilter("taskcatalog.id", "=", (Object)catalogId);
        QFilter filter2 = new QFilter(TASK_TYPE, "!=", (Object)(TaskTypeEnum.PARAM.getValue() + ""));
        QFilter filter3 = new QFilter(TASK_TYPE, "!=", (Object)(TaskTypeEnum.EXPLAIN.getValue() + ""));
        QFilter filter4 = new QFilter(TASK_TYPE, "!=", (Object)(TaskTypeEnum.ROOT.getValue() + ""));
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_taskconfig", (String)this.getTaskConfigFiledStr(), (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4});
        filter1 = new QFilter("taskcatalog.id", "=", (Object)catalogId);
        filter2 = new QFilter(TASK_TYPE, "=", (Object)(TaskTypeEnum.ROOT.getValue() + ""));
        DynamicObjectCollection dysall = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"longnumber,id", (QFilter[])new QFilter[]{filter1, filter2});
        ArrayList<Long> taskConfigIds = new ArrayList<Long>();
        HashMap<String, Long> map = new HashMap<String, Long>();
        HashMap taskConfigOldNewIdMap = new HashMap();
        map.put(((DynamicObject)dysall.get(0)).getString(LONG_NUMBER), ((DynamicObject)dysall.get(0)).getLong("id"));
        if (dys != null && dys.length > 0) {
            DynamicObject dy;
            int i;
            HashMap<String, Long> oldLongNumberIdMap = new HashMap<String, Long>(16);
            for (int i2 = 0; i2 < dys.length; ++i2) {
                DynamicObject dy2 = dys[i2];
                oldLongNumberIdMap.put(dy2.getString(LONG_NUMBER), dy2.getLong("id"));
            }
            DynamicObject[] objs = new DynamicObject[dys.length];
            for (i = 0; i < dys.length; ++i) {
                dy = (DynamicObject)OrmUtils.clone((IDataEntityBase)dys[i], (boolean)false, (boolean)true);
                DynamicObjectCollection doc = dy.getDynamicObjectCollection("templates");
                int index = 0;
                for (DynamicObject obj : doc) {
                    String seq = obj.getString("seq");
                    if (!StringUtils.isEmpty((String)seq)) continue;
                    obj.set("seq", (Object)String.valueOf(index));
                    ++index;
                }
                dy.set("taskcatalog.id", (Object)copyCatalogId);
                dy.set("id", (Object)DBServiceHelper.genGlobalLongId());
                taskConfigIds.add(dy.getLong("id"));
                objs[i] = dy;
                map.put(dy.getString(LONG_NUMBER), dy.getLong("id"));
                taskConfigOldNewIdMap.put(oldLongNumberIdMap.get(dy.getString(LONG_NUMBER)), dy.getLong("id"));
            }
            for (i = 0; i < objs.length; ++i) {
                dy = objs[i];
                DynamicObjectCollection pretasks = (DynamicObjectCollection)dy.get(PRE_TASKS);
                if (pretasks.size() <= 0) continue;
                for (DynamicObject pretask : pretasks) {
                    long oldPreTaskId = pretask.getLong("taskconf_id");
                    Long newPreTaskId = (Long)taskConfigOldNewIdMap.get(oldPreTaskId);
                    if (newPreTaskId == null) continue;
                    pretask.set("taskconf_id", (Object)newPreTaskId);
                }
                objs[i].set(PRE_TASKS, (Object)pretasks);
            }
            SaveServiceHelper.save((DynamicObject[])objs);
            Object[] objs2 = BusinessDataServiceHelper.load((Object[])taskConfigIds.toArray(), (IDataEntityType)objs[0].getDataEntityType());
            dy = BusinessDataServiceHelper.loadSingle((Object)copyCatalogId, (String)"bcm_taskcatalog");
            filter1 = new QFilter("taskcatalog.id", "=", (Object)dy.getLong("id"));
            filter2 = new QFilter(NUMBER, "=", (Object)"root");
            DynamicObject root = QueryServiceHelper.queryOne((String)"bcm_taskconfig", (String)"id,longnumber", (QFilter[])new QFilter[]{filter1, filter2});
            map.put(root.getString(LONG_NUMBER), root.getLong("id"));
            for (int j = 0; j < objs2.length; ++j) {
                ((DynamicObject)objs2[j]).set(TASK_CATALOG, (Object)dy);
                String longnumber = ((DynamicObject)objs2[j]).getString(LONG_NUMBER);
                if (!"root".equals(longnumber)) {
                    TaskUtil.assembleSysField((DynamicObject)objs2[j]);
                    ((DynamicObject)objs2[j]).set(PARENT, map.get(TaskUtil.getParentLongNumber(longnumber)));
                    continue;
                }
                ((DynamicObject)objs2[j]).set(NAME, (Object)dy.getString(NAME));
            }
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)objs2[0]).getDataEntityType(), (Object[])objs2);
            return objs2;
        }
        return null;
    }

    private String getUserDistributeFiledStr() {
        return String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_userdistribute").getAllFields().keySet());
    }

    private String getTaskConfigFiledStr() {
        return "createtime,creator,modifytime,modifier,model,longnumber,level,isleaf,parent,taskcatalog,kseq,finishstatus,number,name,tasktype,discription,templates,templates.template,templates.seq,templates.fseqpretasks,pretasks.taskconf,starttime,endtime,planusetime,warningbegintime,warningbegintype,warningfrequency,outfrequency";
    }

    private void showEditForm(Map<String, Object> params, CloseCallBack closeCallBack, long id, String caption) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_taskcatalogedit");
        param.setStatus(OperationStatus.ADDNEW);
        if (id != 0L) {
            param.setStatus(OperationStatus.EDIT);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        param.setCustomParam(CATALOG_ID, (Object)String.valueOf(id));
        param.setCustomParams(params);
        this.getView().showForm(param);
    }

    private DynamicObject copyParams(long catalogid, DynamicObject copyCatalog) {
        QFilter filter = new QFilter("taskcatalog.copyfrom", "=", (Object)copyCatalog.getLong("copyfrom.id"));
        DynamicObject[] params = BusinessDataServiceHelper.load((String)"bcm_taskparam", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_taskparam").getAllFields().keySet()), (QFilter[])new QFilter[]{filter}, (String)"year.number desc,period.number desc", (int)1);
        DynamicObject param = params[0];
        if (param != null) {
            String modelId = copyCatalog.getString("model.id");
            String yearId = param.getString("year.id");
            String periodId = param.getString("period.id");
            String[] nextPeriod = QCfilterUtils.getNextPeriod((String)modelId, (String)yearId, (String)periodId, (String)PeriodTypeEnum.NEXT.getIndex());
            DynamicObject copyparam = (DynamicObject)OrmUtils.clone((IDataEntityBase)param, (boolean)false, (boolean)true);
            copyparam.set("id", (Object)DBServiceHelper.genGlobalLongId());
            if (nextPeriod == null) {
                return null;
            }
            DynamicObject fyYear = BusinessDataServiceHelper.loadSingle((String)"bcm_fymembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(nextPeriod[0]))});
            DynamicObject periodObj = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(nextPeriod[1]))});
            copyparam.set("year", (Object)fyYear);
            copyparam.set("period", (Object)periodObj);
            copyparam.set(TASK_CATALOG, (Object)copyCatalog);
            return copyparam;
        }
        return null;
    }

    private DynamicObject copyExplain(DynamicObject copyCatalog, long catalogid) {
        QFilter filter = new QFilter(TASK_CATALOG, "=", (Object)catalogid);
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((String)"bcm_taskexplain", (String)"id,text,taskcatalog", (QFilter[])new QFilter[]{filter});
        if (dyObj != null) {
            DynamicObject explain = (DynamicObject)OrmUtils.clone((IDataEntityBase)dyObj, (boolean)false, (boolean)true);
            explain.set("id", (Object)DBServiceHelper.genGlobalLongId());
            explain.set(TASK_CATALOG, (Object)copyCatalog);
            return explain;
        }
        return null;
    }

    private void updateTaskCatalogBeforeDelete(long catalogid) {
        QFilter filter1 = new QFilter("copyfrom.id", "=", (Object)catalogid);
        Object[] dys = BusinessDataServiceHelper.load((String)"bcm_taskcatalog", (String)"id,copyfrom", (QFilter[])new QFilter[]{filter1});
        if (dys != null && dys.length > 1) {
            DynamicObject copysource = dys[0];
            for (DynamicObject dynamicObject : dys) {
                if (dynamicObject.getString("id").equals(String.valueOf(catalogid))) continue;
                copysource = dynamicObject;
                break;
            }
            for (DynamicObject dynamicObject : dys) {
                dynamicObject.set(COPY_FROM, (Object)copysource);
            }
            BusinessDataServiceHelper.save((IDataEntityType)dys[0].getDataEntityType(), (Object[])dys);
        }
    }

    private DynamicObjectCollection taskOrder(DynamicObjectCollection taskCatalogs) {
        HashMap<String, DynamicObject> mapForOrder = new HashMap<String, DynamicObject>();
        ArrayList keyList = new ArrayList();
        DynamicObjectCollection orderedCollection = new DynamicObjectCollection();
        for (DynamicObject taskCatalog : taskCatalogs) {
            QFilter selectByIdFilter = new QFilter("taskcatalog.id", "=", taskCatalog.get("id"));
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_taskparam", (String)"year.number,period.number", (QFilter[])new QFilter[]{selectByIdFilter});
            String fy = dy.getString("year.number");
            String period = dy.getString("period.number");
            if (fy.startsWith("FY") && period.startsWith("M_M")) {
                mapForOrder.put(fy.substring(2) + period.substring(3), taskCatalog);
                continue;
            }
            orderedCollection.add((Object)taskCatalog);
        }
        keyList.addAll(mapForOrder.keySet());
        Collections.sort(keyList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TaskConfListPlugin.this.toPinYinString(o1).compareTo(TaskConfListPlugin.this.toPinYinString(o2));
            }
        });
        for (String key : keyList) {
            orderedCollection.add(mapForOrder.get(key));
        }
        return orderedCollection;
    }

    private String toPinYinString(String str) {
        StringBuilder sb = new StringBuilder();
        String[] arr = null;
        for (int i = 0; i < str.length(); ++i) {
            arr = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i));
            if (arr != null && arr.length > 0) {
                for (String string : arr) {
                    sb.append(string);
                }
                continue;
            }
            if (arr != null) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    private static /* synthetic */ Long lambda$closedCallBack$2(DynamicObject dy) {
        return dy.getLong("id");
    }
}

