/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.Close;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;
import kd.fi.bcm.formplugin.task.TaskUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TaskConfigPlugin
extends AbstractBaseBasicPlugIn
implements BeforeF7SelectListener {
    private static final String SELECT_ID = "selectid";
    private static final String START_TIME = "starttime";
    private static final String END_TIME = "endtime";
    private static final String PLAN_USE_TIME = "planusetime";
    private static final String PRE_TASKS = "pretasks";
    private static final String TASK_TYPE = "tasktype";
    private static final String DATE_FIELD = "datefield";
    private static final String REPORT_TEMPLATES = "reporttemplates";
    private static final String SAVE_TYPE = "savetype";
    private static final String NUMBER = "number";
    private static final String TASK_CATALOG_ID = "taskcatalogid";
    private static final String TASK_CATALOG = "taskcatalog";
    private static final String LEVEL = "level";
    private static final String IS_LEAF = "isleaf";
    private static final String LONG_NUMBER = "longnumber";
    private static final String TABLE_FKID = "tablefkid";

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "starttime": {
                this.setPlanUseTime();
                Date startDate = (Date)this.getModel().getValue(START_TIME);
                this.setMinTime(startDate, END_TIME);
                break;
            }
            case "endtime": {
                this.setPlanUseTime();
                break;
            }
            case "planusetime": {
                this.setEndTimeByPlanUseTime();
                break;
            }
            case "pretasks": {
                this.setStartTimeByPreTask();
                break;
            }
            case "tasktype": {
                this.getModel().setValue(REPORT_TEMPLATES, null);
                break;
            }
        }
    }

    private void setPlanUseTime() {
        Date startDate = (Date)this.getModel().getValue(START_TIME);
        Date endDate = (Date)this.getModel().getValue(END_TIME);
        if (startDate != null && endDate != null && TaskUtil.compareDate(endDate, startDate) > -1) {
            long date = TaskUtil.getCalendar(endDate).getTimeInMillis() - TaskUtil.getCalendar(startDate).getTimeInMillis();
            double planDate = Math.ceil((double)date / 8.64E7);
            this.getModel().setValue(PLAN_USE_TIME, (Object)(planDate == 0.0 ? 1 : (int)planDate + 1));
        } else {
            this.getModel().setValue(END_TIME, (Object)startDate);
        }
        this.setMinTime(startDate, DATE_FIELD);
        this.setMaxTime(endDate, DATE_FIELD);
    }

    private void setEndTimeByPlanUseTime() {
        int value;
        String valueStr = this.getModel().getValue(PLAN_USE_TIME).toString();
        Date startDate = (Date)this.getModel().getValue(START_TIME);
        Date endDate = (Date)this.getModel().getValue(END_TIME);
        double planDate = 0.0;
        if (startDate != null && endDate != null && (startDate.before(endDate) || startDate.getTime() - endDate.getTime() < 86400000L)) {
            long date = endDate.getTime() - startDate.getTime();
            planDate = Math.ceil((double)date / 8.64E7);
            double d = planDate = planDate == 0.0 ? 1.0 : (double)((int)planDate + 1);
        }
        if (!StringUtils.isEmpty((String)this.getModel().getValue(PLAN_USE_TIME).toString()) && (double)(value = Integer.parseInt(this.getModel().getValue(PLAN_USE_TIME).toString())) != planDate && !StringUtils.isEmpty((String)valueStr)) {
            startDate = (Date)this.getModel().getValue(START_TIME);
            if (value == 1) {
                this.getModel().setValue(END_TIME, (Object)startDate);
                return;
            }
            Calendar c = Calendar.getInstance();
            c.setTime(startDate);
            c.add(5, value - 1);
            this.getModel().setValue(END_TIME, (Object)c.getTime());
            this.setMaxTime(c.getTime(), DATE_FIELD);
            this.setMinTime(startDate, DATE_FIELD);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String savetype = (String)this.getView().getFormShowParameter().getCustomParam(SAVE_TYPE);
        if (!"edit".equals(savetype)) {
            this.intiNewModel();
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER});
            this.editModel();
        }
        this.setPreTaskF7Qfilter();
        this.getModel().setDataChanged(false);
    }

    private void intiNewModel() {
        long taskcatalogid = (Long)this.getView().getFormShowParameter().getCustomParam(TASK_CATALOG_ID);
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        long parentid = (Long)this.getView().getFormShowParameter().getCustomParam("parentid");
        String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionname");
        String model = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getModel().setValue(TASK_CATALOG, (Object)taskcatalogid);
        this.getPageCache().put(SELECT_ID, String.valueOf(id));
        this.getModel().setValue("parent", (Object)parentid);
        this.getModel().setValue(SAVE_TYPE, (Object)actionName);
        this.getModel().setValue("model", (Object)model);
        Date today = TaskUtil.getNeedTime(0, 0, 0, 0, new int[0]);
        this.getModel().setValue(START_TIME, (Object)today);
        this.getModel().setValue(END_TIME, (Object)today);
        DateEdit endtimede = (DateEdit)this.getView().getControl(END_TIME);
        endtimede.setMinDate(today);
        if ("baritemaddsub".equals(actionName)) {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_taskconfig", (String)"level,kseq,isleaf");
            this.getModel().setValue(LEVEL, (Object)(dy.getInt(LEVEL) + 1));
            int kseq = TaskUtil.getMaxDSeq(id, "bcm_taskconfig", this.getClass().getName());
            this.getModel().setValue("kseq", (Object)(kseq + 1));
            this.getModel().setValue(IS_LEAF, (Object)1);
            String longNumber = TaskUtil.queryLongNum(id, "bcm_taskconfig", this.getClass().getName());
            this.getModel().setValue(LONG_NUMBER, (Object)longNumber);
        } else if ("baritemaddlevel".equals(actionName)) {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_taskconfig", (String)"level,kseq,isleaf");
            this.getModel().setValue(LEVEL, (Object)dy.getInt(LEVEL));
            int kseq = TaskUtil.getMaxDSeq(parentid, "bcm_taskconfig", this.getClass().getName());
            this.getModel().setValue("kseq", (Object)(kseq + 1));
            this.getModel().setValue(IS_LEAF, (Object)1);
            String longNumber = TaskUtil.queryLongNum(parentid, "bcm_taskconfig", this.getClass().getName());
            this.getModel().setValue(LONG_NUMBER, (Object)longNumber);
        }
    }

    private void editModel() {
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_taskconfig");
        this.getModel().setValue(TABLE_FKID, (Object)id);
        this.getModel().setValue(NUMBER, (Object)dy.getString(NUMBER));
        this.getModel().setValue("name", (Object)dy.getString("name"));
        this.getModel().setValue(TASK_TYPE, (Object)dy.getInt(TASK_TYPE));
        this.getModel().setValue("description", (Object)dy.getString("discription"));
        if (3 == dy.getInt(TASK_TYPE) || dy.getInt(TASK_TYPE) == TaskTypeEnum.UNFITASK.getValue()) {
            Object[] objs = TaskUtil.getTaskTem(id);
            if (objs != null) {
                this.getModel().setValue(REPORT_TEMPLATES, (Object)objs);
            }
            if ((objs = TaskUtil.getTaskForPre(id)) != null) {
                this.getModel().setValue(PRE_TASKS, (Object)objs);
                Date latedEndTime = TaskUtil.queryEndTime((Long)objs[0], this.getClass().getName());
                for (Object dyId : objs) {
                    Date endTime = TaskUtil.queryEndTime((Long)dyId, this.getClass().getName());
                    if (latedEndTime.before(endTime)) {
                        latedEndTime = endTime;
                    }
                    this.setMinTime(new Date(latedEndTime.getTime() + 86400000L), START_TIME);
                }
            }
            Date endtime = dy.getDate(END_TIME);
            this.setMinTime(dy.getDate(START_TIME), END_TIME);
            this.getModel().setValue(START_TIME, (Object)dy.getDate(START_TIME));
            this.getModel().setValue(END_TIME, (Object)dy.getDate(END_TIME));
            this.getModel().setValue(PLAN_USE_TIME, (Object)dy.getInt(PLAN_USE_TIME));
            int value = dy.getInt("warningbegintype");
            this.getModel().setValue("radiogroupfield", (Object)value);
            switch (value) {
                case 1: {
                    break;
                }
                case 2: {
                    int value2 = dy.getInt("warningfrequency");
                    this.setRadioGroupKey(value2, "radiogroupfield1");
                    Date warningbegintime = dy.getDate("warningbegintime");
                    int planusetime = (int)(endtime.getTime() - warningbegintime.getTime()) / 1000 / 60 / 60 / 24;
                    this.getModel().setValue("integerfield", (Object)(planusetime == 0 ? 1 : planusetime));
                    break;
                }
                case 3: {
                    int value3 = dy.getInt("warningfrequency");
                    this.setRadioGroupKey(value3, "radiogroupfield1");
                    Date datefield = dy.getDate("warningbegintime");
                    this.getModel().setValue(DATE_FIELD, (Object)datefield);
                }
            }
            this.setRadioGroupKey(dy.getInt("outfrequency"), "radiogroupfield11");
        }
        long taskcatalogid = (Long)this.getView().getFormShowParameter().getCustomParam(TASK_CATALOG_ID);
        int tasktype = dy.getInt(TASK_TYPE);
        long parentid = dy.getLong("parent.id");
        String savetype = (String)this.getView().getFormShowParameter().getCustomParam(SAVE_TYPE);
        long modelId = dy.getLong("model.id");
        this.getModel().setValue(TASK_CATALOG, (Object)taskcatalogid);
        this.getPageCache().put(SELECT_ID, String.valueOf(id));
        this.getModel().setValue("parent", (Object)parentid);
        this.getModel().setValue(TASK_TYPE, (Object)tasktype);
        this.getModel().setValue(SAVE_TYPE, (Object)savetype);
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue(LEVEL, (Object)dy.getInt(LEVEL));
        this.getModel().setValue("kseq", (Object)dy.getInt("kseq"));
        this.getModel().setValue(IS_LEAF, (Object)(dy.getBoolean(IS_LEAF) ? 1 : 0));
        this.getModel().setValue(LONG_NUMBER, (Object)dy.getString(LONG_NUMBER));
        this.setEndTimeByAfterTask();
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save"});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{TASK_TYPE});
    }

    private void setRadioGroupKey(int value, String fieldName) {
        int key = 0;
        switch (value) {
            case 2: {
                key = 1;
                break;
            }
            case 4: {
                key = 2;
                break;
            }
            case 6: {
                key = 3;
                break;
            }
            case 8: {
                key = 4;
            }
        }
        this.getModel().setValue(fieldName, (Object)key);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        String savaType = "";
        if (e.getSource() instanceof Donothing && issuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            savaType = this.getModel().getValue(SAVE_TYPE).toString();
            this.getModel().setValue(SAVE_TYPE, (Object)"edit");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TASK_TYPE});
            this.getModel().setValue(TABLE_FKID, e.getOperationResult().getSuccessPkIds().get(0));
            this.setPreTaskF7Qfilter();
            this.getView().returnDataToParent((Object)"bcm_taskconfig");
            this.getModel().setDataChanged(false);
        } else if (e.getSource() instanceof Close && issuccess) {
            this.getView().returnDataToParent((Object)"bcm_taskconfig");
        } else if (!issuccess) {
            // empty if block
        }
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey) && StringUtils.isNotEmpty((String)savaType) && !savaType.equals("edit")) {
            String desc = issuccess ? ResManager.loadKDString((String)"\u201c%1$s\u201d \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c%1$s \u201d\u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TaskConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opdescriptione = String.format(desc, this.getModel().getValue("name"));
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58", (String)"TaskConfigPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)opdescriptione, (Long)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit bs = (MulBasedataEdit)this.getView().getControl(REPORT_TEMPLATES);
        bs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String k = e.getProperty().getName();
        if (REPORT_TEMPLATES.equals(k)) {
            ListShowParameter l = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter lf = l.getListFilterParameter();
            List<QFilter> qFilters = this.getTemplateFilter();
            if (lf.getQFilters() != null) {
                lf.getQFilters().addAll(qFilters);
            } else {
                lf.setQFilters(qFilters);
            }
        }
    }

    private Set<Long> getPerm() {
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!DataTypeEnum.NO.getIndex().equals(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }

    private List<QFilter> getTemplateFilter() {
        long taskcatalogid = (Long)this.getView().getFormShowParameter().getCustomParam(TASK_CATALOG_ID);
        long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        long modelId = this.getModelId();
        String actionName = (String)this.getView().getFormShowParameter().getCustomParam("actionname");
        filters.add(new QFilter("model.id", "=", (Object)modelId));
        List<Long> ls = actionName == null || actionName.equals("baritemaddsub") ? TaskUtil.getTaskTemplate(taskcatalogid, id) : TaskUtil.getTaskTemplate(taskcatalogid, 0L);
        filters.add(new QFilter("id", "not in", (Object)ls.toArray()));
        if ("3".equals(this.getModel().getValue(TASK_TYPE))) {
            filters.add(new QFilter("isfintemplate", "!=", (Object)Character.valueOf('0')));
            filters.add(new QFilter("usage", "=", (Object)Character.valueOf('1')));
        } else if ("5".equals(this.getModel().getValue(TASK_TYPE))) {
            filters.add(new QFilter("isfintemplate", "=", (Object)Character.valueOf('0')));
        }
        List<Long> list = this.getDimfilIds(filters);
        if (list.isEmpty()) {
            return filters;
        }
        Set<Long> perm = this.getPerm();
        if (!perm.isEmpty()) {
            list.removeAll(perm);
        }
        QFilter q = new QFilter("id", "in", list);
        ArrayList<QFilter> ql = new ArrayList<QFilter>();
        ql.add(q);
        return ql;
    }

    private List<Long> getDimfilIds(List<QFilter> filters) {
        ArrayList<Long> rids = new ArrayList<Long>();
        long id = (Long)this.getView().getFormShowParameter().getCustomParam(TASK_CATALOG_ID);
        DynamicObject d = QueryServiceHelper.queryOne((String)"bcm_taskparam", (String)"year,currency,period,scenario", (QFilter[])new QFilter(TASK_CATALOG, "=", (Object)id).toArray());
        if (d == null) {
            return rids;
        }
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Collection)dc)) {
            return rids;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dynamicObject : dc) {
            ids.add(dynamicObject.getLong("id"));
        }
        List templist = TemplateRangeService.getTemplateModels(ids, (long)this.getModelId(), (boolean)false, (boolean)true);
        for (TemplateModel templateModel : templist) {
            if (!TemplateRangeService.isInnerRange((String)"bcm_fymembertree", (TemplateModel)templateModel, (Object)d.getLong("year")) || !TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)templateModel, (Object)d.getLong("scenario")) || !TemplateRangeService.isInnerRange((String)"bcm_currencymembertree", (TemplateModel)templateModel, (Object)d.getLong("currency")) || !TemplateRangeService.isInnerRange((String)"bcm_periodmembertree", (TemplateModel)templateModel, (Object)d.getLong("period"))) continue;
            rids.add(templateModel.getId());
        }
        return rids;
    }

    private void setPreTaskF7Qfilter() {
        MulBasedataEdit bs = (MulBasedataEdit)this.getView().getControl(PRE_TASKS);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        long taskcatalogid = (Long)this.getView().getFormShowParameter().getCustomParam(TASK_CATALOG_ID);
        filters.add(new QFilter(TASK_CATALOG, "=", (Object)taskcatalogid));
        Object value = this.getModel().getValue(TABLE_FKID);
        if (!StringUtils.isEmpty((String)value.toString()) && !"0".equals(value.toString())) {
            filters.add(new QFilter("id", "!=", (Object)Long.valueOf(value.toString())));
        }
        filters.add(new QFilter(TASK_TYPE, "in", (Object)new char[]{'3', '5'}));
        bs.setQFilters(filters);
    }

    private void setStartTimeByPreTask() {
        DynamicObjectCollection dcs = (DynamicObjectCollection)this.getModel().getValue(PRE_TASKS);
        if (dcs != null && dcs.size() > 0) {
            Date endTime = new Date();
            Date latedEndTime = TaskUtil.queryEndTime(((DynamicObject)((DynamicObject)dcs.get(0)).get(1)).getLong("id"), this.getClass().getName());
            for (DynamicObject dy : dcs) {
                boolean isCirclePre;
                endTime = TaskUtil.queryEndTime(((DynamicObject)dy.get(1)).getLong("id"), this.getClass().getName());
                if (latedEndTime != null && endTime != null && latedEndTime.before(endTime)) {
                    latedEndTime = endTime;
                }
                if (!(isCirclePre = TaskUtil.isCirclePre(Long.parseLong(this.getModel().getValue(TABLE_FKID).toString()), ((DynamicObject)dy.get(1)).getLong("id"), this.getClass().getName()))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5faa\u73af\u524d\u7f6e!", (String)"TaskConfigPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Date startDate = (Date)this.getModel().getValue(START_TIME);
            if (latedEndTime != null && startDate != null && TaskUtil.compareDate(latedEndTime, startDate) > -1) {
                this.getModel().setValue(START_TIME, (Object)new Date(latedEndTime.getTime() + 86400000L));
                if (TaskUtil.compareDate((Date)this.getModel().getValue(START_TIME), (Date)this.getModel().getValue(END_TIME)) > -1) {
                    this.getModel().setValue(END_TIME, (Object)new Date(latedEndTime.getTime() + 86400000L));
                    this.getModel().setValue(DATE_FIELD, (Object)new Date(latedEndTime.getTime() + 86400000L));
                }
            }
            DateEdit starttimede = (DateEdit)this.getView().getControl(START_TIME);
            DateEdit endtimede = (DateEdit)this.getView().getControl(END_TIME);
            if (latedEndTime != null) {
                starttimede.setMinDate(new Date(latedEndTime.getTime() + 86400000L));
                endtimede.setMinDate(new Date(latedEndTime.getTime() + 86400000L));
            }
        } else {
            this.setMinTime(TaskUtil.getLastDayOfMonth(1990, 1), START_TIME);
        }
    }

    private void setEndTimeByAfterTask() {
        QFilter filter = new QFilter("taskforpre.id", "=", this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_taskforpre", (String)"taskconfig", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> list = new ArrayList<Long>();
        if (doc != null && doc.size() > 0) {
            for (DynamicObject dy : doc) {
                list.add(dy.getLong("taskconfig"));
            }
        }
        if (list.size() > 0 && (doc = QueryServiceHelper.query((String)"bcm_taskconfig", (String)START_TIME, (QFilter[])new QFilter[]{filter = new QFilter("id", "in", (Object)list.toArray())}, (String)START_TIME)) != null && doc.size() > 0) {
            Date maxDate = new Date(((DynamicObject)doc.get(0)).getDate(START_TIME).getTime() - 86400000L);
            this.setMaxTime(maxDate, END_TIME);
        }
    }

    private void setMinTime(Date date, String controlName) {
        DateEdit timeEdit = (DateEdit)this.getView().getControl(controlName);
        timeEdit.setMinDate(date);
    }

    private void setMaxTime(Date date, String controlName) {
        DateEdit timeEdit = (DateEdit)this.getView().getControl(controlName);
        timeEdit.setMaxDate(date);
    }
}

