/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class TaskListDisDetailsPlugin
extends AbstractBaseFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BOS_USER = "bos_user";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long catalogid = (Long)this.getView().getFormShowParameter().getCustomParam("catalogid");
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("modelid");
        this.getModel().setValue("tasklist", (Object)catalogid);
        BasedataEdit taskList = (BasedataEdit)this.getControl("tasklist");
        taskList.setQFilter(new QFilter("model", "=", (Object)modelid));
        this.createEntryData(catalogid);
    }

    private void createEntryData(long catalogid) {
        QFilter filter = new QFilter("taskcatalog", "=", (Object)catalogid);
        DynamicObject entry = BusinessDataServiceHelper.loadSingle((String)"bcm_userdistribute", (String)"userdisentry,userdisentry.etype,userdisentry.eusers", (QFilter[])new QFilter[]{filter});
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (entry == null || entry.getDynamicObjectCollection("userdisentry").size() < 1) {
            return;
        }
        HashMap map = new HashMap();
        HashSet<Long> userIds = new HashSet<Long>();
        DynamicObjectCollection dcs = entry.getDynamicObjectCollection("userdisentry");
        for (DynamicObject cc : dcs) {
            switch (cc.getString("etype")) {
                case "bos_user": {
                    userIds.add(cc.getDynamicObject("eusers").getLong("id"));
                    break;
                }
                case "bos_usergroup": {
                    DynamicObject eusers = cc.getDynamicObject("eusers");
                    if (Objects.isNull(eusers)) break;
                    Object groupId = eusers.getPkValue();
                    DynamicObjectCollection users = UserDistributeServiceHelper.queryAllUsersByGroupId((Object)groupId);
                    users.forEach(p -> map.put(p.getLong("user"), p));
                }
            }
        }
        Set keys = map.keySet();
        userIds.removeAll(keys);
        if (userIds.size() > 0) {
            filter = new QFilter("id", "in", (Object)userIds.toArray());
            QueryServiceHelper.query((String)BOS_USER, (String)"id,name,phone,email", (QFilter[])new QFilter[]{filter}).forEach(p -> map.put(p.getLong("id"), p));
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, map.size());
        int i = 0;
        ArrayList orderIds = new ArrayList();
        filter = new QFilter("id", "in", (Object)map.keySet().toArray());
        QueryServiceHelper.query((String)BOS_USER, (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"name").forEach(p -> orderIds.add(p.getLong("id")));
        for (Long ss : orderIds) {
            this.getModel().setValue("user", (Object)((DynamicObject)map.get(ss)).getString("name"), i);
            this.getModel().setValue("phone", (Object)((DynamicObject)map.get(ss)).getString("phone"), i);
            this.getModel().setValue("email", (Object)((DynamicObject)map.get(ss)).getString("email"), i++);
        }
    }
}

