/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.task.TaskUtil;

public class TaskParamEdit
extends AbstractBaseFormPlugin {
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String CURRENCY = "currency";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period", "currency"});
    private static final String ACTION_NAME = "actionname";
    private static final String TASK_CATALOG = "taskcatalog";

    @Override
    public void initialize() {
        super.initialize();
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelid != null) {
            this.alterF7Name();
            this.getPageCache().put("KEY_MODEL_ID", modelid);
            HashMap map = new HashMap();
            this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
            this.initSingleMemberF7(map);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("copy".equals(this.getView().getFormShowParameter().getCustomParam(ACTION_NAME))) {
            long modelId = this.getModelId();
            Object copycatalogid = this.getView().getFormShowParameter().getCustomParam("copycatalogid");
            Object catalogid = this.getView().getFormShowParameter().getCustomParam("catalogid");
            this.getModel().setValue(TASK_CATALOG, copycatalogid);
            QFilter filter = new QFilter(TASK_CATALOG, "=", catalogid);
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_taskparam", (String)MyTaskServiceHelper.getTaskParamSelector(), (QFilter[])new QFilter[]{filter});
            if (dy != null) {
                String periodStr = TaskUtil.getNextPeriod(dy.getString("period.number"));
                if (periodStr.isEmpty()) {
                    periodStr = dy.getString("period.number");
                }
                if (YEAR.equals(periodStr.substring(0, 4))) {
                    Long fyYearId;
                    String number = dy.getString("year.number");
                    if (number.startsWith("FY")) {
                        String yearStr = number.substring(2);
                        int fy = Integer.parseInt(yearStr) + 1;
                        number = "FY" + fy;
                    }
                    if (Objects.isNull(fyYearId = TaskUtil.getIdByNumAndModel(number, modelId, "bcm_fymembertree"))) {
                        this.getModel().setValue(YEAR, (Object)dy.getLong("year.id"));
                    } else {
                        this.getModel().setValue(YEAR, (Object)fyYearId);
                    }
                    Long periodDy = TaskUtil.getIdByNumAndModel(periodStr.substring(4), modelId, "bcm_periodmembertree");
                    this.getModel().setValue(PERIOD, (Object)periodDy);
                } else {
                    this.getModel().setValue(YEAR, (Object)dy.getLong("year.id"));
                    Long periodDy = TaskUtil.getIdByNumAndModel(periodStr, modelId, "bcm_periodmembertree");
                    this.getModel().setValue(PERIOD, (Object)periodDy);
                }
                Long currencyDy = TaskUtil.getIdByNumAndModel(periodStr, modelId, "bcm_currencymembertree");
                this.getModel().setValue(CURRENCY, (Object)currencyDy);
            }
        } else {
            long taskcatalogid = (Long)this.getView().getFormShowParameter().getCustomParam("taskcatalogid");
            this.getModel().setValue(TASK_CATALOG, (Object)taskcatalogid);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (e.getSource() instanceof Save && issuccess) {
            long taskcatalogid = 0L;
            taskcatalogid = "copy".equals(this.getView().getFormShowParameter().getCustomParam(ACTION_NAME)) ? ((Long)this.getView().getFormShowParameter().getCustomParam("copycatalogid")).longValue() : ((Long)this.getView().getFormShowParameter().getCustomParam("taskcatalogid")).longValue();
            QFilter qf1 = new QFilter(TASK_CATALOG, "=", (Object)taskcatalogid);
            QFilter qf2 = new QFilter("tasktype", "=", (Object)TaskTypeEnum.PARAM.getValue());
            DynamicObjectCollection paramTab = QueryServiceHelper.query((String)"bcm_taskparam", (String)MyTaskServiceHelper.getTaskParamNameSelector(), (QFilter[])new QFilter[]{qf1});
            if (paramTab != null && paramTab.size() != 0) {
                String year = ((DynamicObject)paramTab.get(0)).getString("year.name");
                String period = ((DynamicObject)paramTab.get(0)).getString("period.name");
                String currency = ((DynamicObject)paramTab.get(0)).getString("currency.name");
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadKDString((String)"\u4efb\u52a1\u53c2\u6570\uff1a", (String)"TaskParamEdit_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(year).append('\uff0c').append(period).append('\uff0c').append(currency);
                DynamicObject dt = BusinessDataServiceHelper.loadSingle((String)"bcm_taskconfig", (String)"name,modifytime,modifier", (QFilter[])new QFilter[]{qf1, qf2});
                if (dt != null) {
                    dt.set("name", (Object)sb.toString());
                    dt.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
                    dt.set("modifier", (Object)RequestContext.get().getUserId());
                    Object[] dataEntities = new Object[]{dt};
                    BusinessDataServiceHelper.save((IDataEntityType)dt.getDataEntityType(), (Object[])dataEntities);
                }
            }
            if ("copy".equals(this.getView().getFormShowParameter().getCustomParam(ACTION_NAME))) {
                this.getView().returnDataToParent((Object)"copysuccess");
            } else {
                this.getView().returnDataToParent((Object)"savesuccess");
            }
            this.getView().close();
        }
    }

    private void alterF7Name() {
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelid != null) {
            ArrayList<String> listnumber = new ArrayList<String>();
            listnumber.add(DimTypesEnum.YEAR.getNumber());
            listnumber.add(DimTypesEnum.PERIOD.getNumber());
            listnumber.add(DimTypesEnum.CURRENCY.getNumber());
            DynamicObject[] namecol = QueryDimensionServiceHelper.getMoreMsgByNumber((long)Long.parseLong(modelid), listnumber);
            if (namecol != null) {
                BasedataEdit bdeyear = (BasedataEdit)this.getControl(YEAR);
                BasedataEdit bdeperiod = (BasedataEdit)this.getControl(PERIOD);
                BasedataEdit bdecurrency = (BasedataEdit)this.getControl(CURRENCY);
                bdeyear.setCaption(new LocaleString(namecol[0].getString("name")));
                bdeperiod.setCaption(new LocaleString(namecol[1].getString("name")));
                bdecurrency.setCaption(new LocaleString(namecol[2].getString("name")));
            }
        }
    }
}

