/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaskUtil {
    private static final String[] str = new String[]{"M_M01", "M_M02", "M_M03", "M_M04", "M_M05", "M_M06", "M_M07", "M_M08", "M_M09", "M_M10", "M_M11", "M_M12"};
    private static final String[] quarterStr = new String[]{"M_Q1", "M_Q2", "M_Q3", "M_Q4"};
    private static final String[] halfStr = new String[]{"M_HF1", "M_HF2"};

    public static int getMaxDSeq(long id, String entiryName, String className) {
        QFilter fdimenId = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)entiryName, (String)"kseq", (QFilter[])filters, (String)"kseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 0;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("kseq");
        }
        return 0;
    }

    public static String queryLongNum(long id, String entityName, String className) {
        String selectFields = "longnumber";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)entityName, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getString("longnumber");
        }
        return "";
    }

    public static Date queryEndTime(long id, String classNmae) {
        String selectFields = "endtime";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)classNmae, (String)"bcm_taskconfig", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getDate("endtime");
        }
        return null;
    }

    public static DynamicObjectCollection queryPreTask(long id, String classNmae) {
        String selectFields = "taskforpre";
        QFilter filter = new QFilter("taskconfig.id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)classNmae, (String)"bcm_taskforpre", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() > 0) {
            return dcs;
        }
        return null;
    }

    public static boolean isCirclePre(long id, long preId, String className) {
        DynamicObjectCollection preToPreIds = TaskUtil.queryPreTask(preId, className);
        if (preToPreIds != null) {
            for (DynamicObject preToPre : preToPreIds) {
                long preToPreId = preToPre.getLong("taskforpre");
                if (id == 0L) {
                    return false;
                }
                if (preToPreId == 0L) {
                    return false;
                }
                if (preToPreId == id) {
                    return true;
                }
                TaskUtil.isCirclePre(preId, preToPreId, className);
            }
        }
        return false;
    }

    public static Date getNeedTime(int hour, int minute, int second, int addDay, int ... args) {
        Calendar calendar = Calendar.getInstance();
        if (addDay != 0) {
            calendar.add(5, addDay);
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        if (args.length == 1) {
            calendar.set(14, args[0]);
        }
        return calendar.getTime();
    }

    public static int compareDate(Date date1, Date date2) {
        Calendar cal1 = TaskUtil.getCalendar(date1);
        Calendar cal2 = TaskUtil.getCalendar(date2);
        return cal1.compareTo(cal2);
    }

    public static Calendar getCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date getLastDayOfMonth(Integer year, Integer month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, -1);
        calendar.roll(5, 1);
        return calendar.getTime();
    }

    public static Object[] getTaskForPre(long id) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_taskforpre", (String)"taskforpre", (QFilter[])filters);
        if (dcs != null && dcs.size() > 0) {
            Object[] objs = new Object[dcs.size()];
            int i = 0;
            for (DynamicObject dy : dcs) {
                objs[i] = dy.getLong("taskforpre");
                ++i;
            }
            return objs;
        }
        return null;
    }

    public static Object[] getTaskTem(long id) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_tasktem", (String)"template", (QFilter[])filters);
        if (dcs != null && dcs.size() > 0) {
            Object[] objs = new Object[dcs.size()];
            int i = 0;
            for (DynamicObject dy : dcs) {
                objs[i] = dy.getLong("template");
                ++i;
            }
            return objs;
        }
        return null;
    }

    public static DynamicObjectCollection getTaskConfigByCatalog(long taskcatalogid, long id) {
        QFilter filter = new QFilter("taskcatalog", "=", (Object)taskcatalogid);
        QFilter filter2 = new QFilter("id", "!=", (Object)id);
        QFilter[] filters = new QFilter[]{filter, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id", (QFilter[])filters);
        return dcs;
    }

    public static List<Long> getTaskTemplate(long taskcatalogid, long id) {
        DynamicObjectCollection dcs = TaskUtil.getTaskConfigByCatalog(taskcatalogid, id);
        if (dcs != null && dcs.size() > 0) {
            ArrayList<Long> ls = new ArrayList<Long>();
            for (DynamicObject dy : dcs) {
                ls.add(dy.getLong("id"));
            }
            QFilter filter = new QFilter("taskconfig.id", "in", (Object)ls.toArray());
            QFilter[] filters = new QFilter[]{filter};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_tasktem", (String)"template", (QFilter[])filters);
            ls.clear();
            for (DynamicObject dy : dynamicObjects) {
                ls.add(dy.getLong("template"));
            }
            return ls;
        }
        return null;
    }

    public static String getNextPeriod(String currentPeriod) {
        int i;
        boolean flag = false;
        for (i = 0; i < halfStr.length; ++i) {
            flag = halfStr[i].equals(currentPeriod);
            if (!flag) continue;
            return TaskUtil.getNextString(i, halfStr);
        }
        for (i = 0; i < quarterStr.length; ++i) {
            flag = quarterStr[i].equals(currentPeriod);
            if (!flag) continue;
            return TaskUtil.getNextString(i, quarterStr);
        }
        for (i = 0; i < str.length; ++i) {
            flag = str[i].equals(currentPeriod);
            if (!flag) continue;
            return TaskUtil.getNextString(i, str);
        }
        return currentPeriod;
    }

    public static String getNextString(int index, String[] strs) {
        if (index == strs.length - 1) {
            return "year" + strs[0];
        }
        return strs[++index];
    }

    public static Long getIdByNumAndModel(String number, long modelid, String membermodel) {
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelid);
        DynamicObject dy = QueryServiceHelper.queryOne((String)membermodel, (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
        if (Objects.nonNull(dy)) {
            return dy.getLong("id");
        }
        return null;
    }

    public static String getParentLongNumber(String longNumber) {
        int index = longNumber.lastIndexOf(46);
        String parentLongNumber = longNumber.substring(0, index);
        return parentLongNumber;
    }

    public static void assembleSysField(DynamicObject dy) {
        dy.set("createtime", (Object)TimeServiceHelper.now());
        dy.set("creator", (Object)RequestContext.get().getUserId());
        dy.set("modifytime", (Object)TimeServiceHelper.now());
        dy.set("modifier", (Object)RequestContext.get().getUserId());
    }

    public static void saveSysTaskConfig(boolean issys, DynamicObject catalog, DynamicObject param) {
        String paramStr = TaskUtil.getParamTaskConfName(param);
        Object[] pks = TaskUtil.saveDefaultTaskConf(catalog, paramStr + catalog.getString("describe"), "root", 0, "root", 0, 1, catalog.getLong("id"), 0, false);
        DynamicObject roottask = (DynamicObject)pks[0];
        TaskUtil.saveDefaultTaskConf(catalog, paramStr, "rootparam", roottask.getLong("id"), "root.rootparam", 1, 2, catalog.getLong("id"), 1, true);
        if (issys) {
            TaskUtil.saveDefaultTaskConf(catalog, ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"TaskUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "rootdiscribe", roottask.getLong("id"), "root.rootdiscribe", 1, 1, catalog.getLong("id"), 2, true);
        }
    }

    public static String getParamTaskConfName(DynamicObject param) {
        return param.getString("year.name") + param.getString("period.name") + param.getString("scenario.name") + param.getString("currency.name");
    }

    public static Object[] saveDefaultTaskConf(DynamicObject catalog, String name, String number, Object parentid, String longnumber, int level, int seq, Object taskcatalogid, int tasktype, boolean isleaf) {
        DynamicObject taskconf = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskconfig");
        taskconf.set("name", (Object)new LocaleString(name));
        taskconf.set("number", (Object)number);
        taskconf.set("parent", parentid);
        taskconf.set("longnumber", (Object)longnumber);
        taskconf.set("level", (Object)level);
        taskconf.set("isleaf", (Object)isleaf);
        taskconf.set("kseq", (Object)seq);
        taskconf.set("taskcatalog", taskcatalogid);
        taskconf.set("tasktype", (Object)tasktype);
        taskconf.set("createtime", (Object)TimeServiceHelper.getCurrentSystemTime());
        taskconf.set("creator", (Object)RequestContext.get().getUserId());
        taskconf.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
        taskconf.set("modifier", (Object)RequestContext.get().getUserId());
        taskconf.set("model", catalog.getDynamicObject("model").getPkValue());
        return BusinessDataWriter.save((IDataEntityType)taskconf.getDataEntityType(), (Object[])new DynamicObject[]{taskconf});
    }

    public static String getSeriaNextNumber(long modelid) {
        StringBuilder sb = new StringBuilder();
        QFilter filter = new QFilter("model.id", "=", (Object)modelid);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_taskcatalog", (String)"number", (QFilter[])new QFilter[]{filter}, (String)"number desc", (int)1);
        if (CollectionUtils.isNotEmpty((Collection)dys)) {
            int i;
            sb.append("TL");
            sb.append(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            String number = ((DynamicObject)dys.get(0)).getString("number");
            int intNum = 1;
            String cs = number.substring(10, number.length());
            StringBuilder newSerNum = new StringBuilder();
            for (i = 0; i < 4; ++i) {
                if ("0".equals(cs.substring(i, i + 1))) continue;
                for (int j = i; j < 4; ++j) {
                    newSerNum.append(cs.substring(j, j + 1));
                }
                break;
            }
            intNum += Integer.parseInt(newSerNum.toString());
            for (i = 0; i < 4 - String.valueOf(intNum).length(); ++i) {
                sb.append("0");
            }
            sb.append(intNum);
        } else {
            sb.append("TL");
            sb.append(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            sb.append("0001");
        }
        return sb.toString();
    }
}

