/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.task;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class UserDistributeEditPlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener {
    private static final String BASE_USER = "baseuser";
    private static final String BASE_USER_GROUP = "baseusergroup";
    private String disEntryId = "userdisentry";

    @Override
    public void initialize() {
        super.initialize();
        this.addListener();
    }

    private void addListener() {
        this.addItemClickListeners("advcontoolbarap");
        BasedataEdit user = (BasedataEdit)this.getControl(BASE_USER);
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit usergroup = (BasedataEdit)this.getControl(BASE_USER_GROUP);
        usergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object catalogid = this.getView().getFormShowParameter().getCustomParam("catalogid");
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("model");
        this.getModel().setValue("taskcatalog", catalogid);
        this.getModel().setValue("model", (Object)modelid);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl(BASE_USER_GROUP);
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl(BASE_USER);
                user.click();
                break;
            }
            case "delentry": {
                this.deleteEntryRow(this.disEntryId);
                break;
            }
        }
    }

    private void deleteEntryRow(String entryId) {
        EntryGrid eg = (EntryGrid)this.getControl(entryId);
        int[] rows = eg.getSelectRows();
        if (rows.length > 0) {
            this.getModel().deleteEntryRows(entryId, rows);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"UserDistributeEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
        if (rows == null) {
            return;
        }
        ArrayList<Object> oids = this.getOldDisIds();
        switch (actionId = evt.getActionId()) {
            case "baseuser": {
                this.setData2Entry(rows, oids, "bos_user");
                break;
            }
            case "baseusergroup": {
                this.setData2Entry(rows, oids, "bos_usergroup");
            }
        }
    }

    private void setData2Entry(ListSelectedRowCollection rows, ArrayList<Object> oids, String baseType) {
        rows.forEach(p -> {
            if (!oids.contains(p.getPrimaryKeyValue())) {
                int rowIndex = this.getModel().createNewEntryRow(this.disEntryId);
                this.getModel().setValue("etype", (Object)baseType, rowIndex);
                this.getModel().setValue("eusers", p.getPrimaryKeyValue(), rowIndex);
            }
        });
    }

    private ArrayList<Object> getOldDisIds() {
        ArrayList<Object> ids = new ArrayList<Object>();
        this.getModel().getEntryEntity(this.disEntryId).forEach(p -> ids.add(p.getDynamicObject("eusers").getPkValue()));
        return ids;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        CloseCallBack aa = new CloseCallBack((IFormPlugin)this, evt.getProperty().getName());
        evt.getFormShowParameter().setCloseCallBack(aa);
        evt.getFormShowParameter().setHasRight(true);
        String name = evt.getProperty().getName();
        if (Objects.equals(BASE_USER, name) || Objects.equals(BASE_USER_GROUP, name)) {
            evt.getFormShowParameter().setCustomParam("ismergerows", (Object)Boolean.TRUE);
            evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)ConfigServiceHelper.getGlobalBoolParam((String)"P006"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("deleteentry".equals(e.getOperateKey())) {
            return;
        }
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (issuccess && e.getSource() instanceof Save) {
            this.getView().returnDataToParent((Object)new LocaleString(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6210\u3002", (String)"UserDistributeEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            this.getView().close();
            this.saveOpertionLog();
        }
    }

    private void saveOpertionLog() {
        DynamicObject taskcatalog = (DynamicObject)this.getModel().getValue("taskcatalog");
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        String log = String.format(ResManager.loadKDString((String)"\u201c%1$s\uff08%2$s\uff09\u201d\u5206\u914d\u6210\u529f\u3002", (String)"UserDistributeEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), model.get("shownumber"), taskcatalog.get("name"));
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u5206\u914d\u4efb\u52a1\u5217\u8868", (String)"UserDistributeEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)log, (Long)LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")), (String)"bcm_userdistribute");
    }
}

