/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabInfo;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabManager;

public interface TaskRecordCreateBase
extends BCMBaseFunction {
    public static final String CACHE_TASK_TPL_MODEL = "CACHE_TASK_TPL_MODEL";
    public static final String CACHE_TASK_ACTIVITY_MANAGER = "taskActivityTabManager";
    public static final String CUR_ACTIVITY_ID = "CUR_ACTIVITY_ID";

    default public TaskActivityTabManager getTaskActivityTabManagerFromCache(IPageCache pageCache) {
        String serial = pageCache.get(CACHE_TASK_ACTIVITY_MANAGER);
        if (!StringUtils.isEmpty((String)serial)) {
            return (TaskActivityTabManager)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return new TaskActivityTabManager();
    }

    default public void cacheTaskActivityTabManager(IPageCache pageCache, TaskActivityTabManager taskActivityTabManager) {
        if (taskActivityTabManager != null) {
            pageCache.put(CACHE_TASK_ACTIVITY_MANAGER, this.toByteSerialized(taskActivityTabManager));
        }
    }

    default public TaskActivityTabInfo getTaskActivityTabInfo(IPageCache pageCache) {
        String activityIdStr = this.getCurrentActivityId(pageCache);
        if (StringUtils.isEmpty((String)activityIdStr)) {
            return new TaskActivityTabInfo();
        }
        TaskActivityTabManager manager = this.getTaskActivityTabManagerFromCache(pageCache);
        TaskActivityTabInfo info = manager.searchTab(activityIdStr);
        if (null == info) {
            info = new TaskActivityTabInfo();
        }
        return info;
    }

    default public void setCurrentActivityId(IPageCache pageCache, String activityId) {
        pageCache.put(CUR_ACTIVITY_ID, activityId);
    }

    default public String getCurrentActivityId(IPageCache pageCache) {
        return pageCache.get(CUR_ACTIVITY_ID);
    }

    default public TaskTemplateModel getTaskTemplateModelFromCache(IPageCache pageCache) {
        String modelSerial = pageCache.get(CACHE_TASK_TPL_MODEL);
        if (!StringUtils.isEmpty((String)modelSerial)) {
            return (TaskTemplateModel)ObjectSerialUtil.deSerializedBytes((String)modelSerial);
        }
        return new TaskTemplateModel();
    }

    default public void modifyComboByCycle(boolean isCycletable) {
        ComboEdit viewCombo = (ComboEdit)this.getPlugin().getControl("viewcombo");
        String itemName = !isCycletable ? ResManager.loadKDString((String)"\u6309\u6a21\u677f\u5c55\u793a", (String)"TaskRecordCreateBase_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6309\u5957\u8868\u5c55\u793a", (String)"TaskRecordCreateBase_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        List items = ((ComboProp)viewCombo.getProperty()).getComboItems().stream().map(item -> new ComboItem(item.getName(), item.getValue(), item.getImageKey())).collect(Collectors.toList());
        ((ComboItem)items.get(0)).setCaption(new LocaleString(itemName));
        viewCombo.setComboItems(items);
    }
}

