/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.taskmanage.enums.TaskRecordStartModeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskSwitchStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskTemplateHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelActTplEntry;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelFilterMemEntry;
import kd.fi.bcm.business.taskmanage.model.TaskRecordTplModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActTplEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateDisdimEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateFilterdim;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskInfoModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.business.taskmanage.notice.TaskNoticeContentHelper;
import kd.fi.bcm.business.taskmanage.notice.TaskTplNoticeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabInfo;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabManager;
import kd.fi.bcm.formplugin.taskmanage.TaskRecordCreateBase;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskReportHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskScheduleHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskRecordCreatePlugin
extends AbstractBaseListPlugin
implements DynamicPage,
ClickListener,
TabSelectListener,
MainPage,
TaskRecordCreateBase {
    private static final String TAB_STEP1 = "tabpageap";
    private static final String TAB_STEP2 = "tabpageap1";
    private static final String TAB_STEP3 = "tabpageap2";
    private static final String TAB_STEP4 = "tabpageap3";
    private static final String TIP_INFO1 = "tipinfo";
    private static final String TIP_INFO2 = "tipinfo1";
    private static final String TIP_INFO3 = "tipinfo2";
    private static final String TIP_INFO4 = "tipinfo3";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String BTN_PRE = "btnprev";
    private static final String BTN_NEXT = "btnnext";
    private static final String BTN_ADD_TPL = "addtpl";
    private static final String BTN_DELETE_TPL = "deletetpl";
    private static final String TAB_VIEW = "guidecontent";
    private static final String NOTICECONTENT = "noticecontent";
    private static final String PARSEDIM = "parsedim";
    private static final String CACHE_TASK_TPL_ID = "CACHE_TASK_TPL_ID";
    private static final String TAB_FILTER_DIM = "filterflex";
    private static final String CACHE_TASK_TPL_FILTER_DIM_MAP = "filterDimMap";
    private static final String INIT_FILTER_FLAG = "INIT_FILTER_FLAG";
    private static final String INIT_ACTIVITY_FLAG = "INIT_ACTIVITY_FLAG";
    private static final String BILL_LIST_AP_ENTITY = "billlistapentity";
    private static final String COMBO_ACTIVITY = "activitylist";
    private static final String TAB_CHECKTPL = "checktpltab";
    private static final String CHECKTPL = "checktpl";
    private static final String EXCEPTIONTPL = "exceptiontpl";
    public static final String PANEL_EXCEPTIONTPL = "exceptiontplpanel";
    private TaskActivityTabManager taskActivityTabManager;
    private TaskRecordModel taskRecordModel;
    private static final String CACHE_TASK_RECORD_MODEL_KEY = "taskRecordModel";
    private TaskTemplateModel taskTemplateModel;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_PRE, BTN_NEXT, BTN_ADD_TPL, BTN_DELETE_TPL);
        Tab topTab = (Tab)this.getControl(TAB_VIEW);
        topTab.addTabSelectListener((TabSelectListener)this);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addListRowClickListener((ListRowClickListener)this);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId());
        this.addF7SelectListener(this.getFilterDimMapFromCache().keySet().toArray(new String[0]));
        Tab checkTplTab = (Tab)this.getControl(TAB_CHECKTPL);
        checkTplTab.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        this.loadTaskRecordModel();
        this.refreshTaskTplList();
        this.initNoticeDim(this.getModelId());
        this.refreshDisList(null);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"begintime", "endtime", "channel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_EXCEPTIONTPL});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (this.getFilterDimMapFromCache().containsKey(keyName)) {
            this.updateTaskRecordModelFilterDimMember(keyName);
            return;
        }
        TaskRecordModel recordModel = this.getTaskRecordModel();
        switch (keyName) {
            case "parsedim": {
                Object content = this.getValue(NOTICECONTENT);
                if (!(content instanceof Map)) break;
                LocaleString tem = LocaleString.fromMap((Map)((Map)content));
                tem.setLocaleValue(tem.getLocaleValue() + e.getChangeSet()[0].getNewValue());
                this.getModel().setValue(NOTICECONTENT, (Object)tem.getLocaleValue());
                break;
            }
            case "noticecontent": {
                recordModel.setNoticeContent(this.getModel().getValue(NOTICECONTENT));
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "noticeswitch": {
                boolean enable = (Boolean)this.getModel().getValue(keyName);
                recordModel.setNotice(enable ? TaskSwitchStatusEnum.ENABLE.getValue() : TaskSwitchStatusEnum.DISABLE.getValue());
                this.setEnable(enable, "channel");
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "channel": {
                recordModel.setMessageNoticeMode((String)this.getModel().getValue(keyName));
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "permclass": {
                DynamicObject value = (DynamicObject)this.getModel().getValue(keyName);
                recordModel.setPermClass(value == null ? null : Long.valueOf(value.getLong("id")));
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "startmode": {
                String startmode = (String)this.getModel().getValue(keyName);
                recordModel.setStartMode(startmode);
                this.setEnable(Objects.equals(TaskRecordStartModeEnum.SCHEDULE_PLAN.getValue(), startmode), "begintime");
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "forceclose": {
                boolean forceclose = (Boolean)this.getModel().getValue(keyName);
                recordModel.setForceClose(forceclose ? TaskSwitchStatusEnum.ENABLE.getValue() : TaskSwitchStatusEnum.DISABLE.getValue());
                this.setEnable(forceclose, "endtime");
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "begintime": {
                Date begintime = (Date)this.getModel().getValue(keyName);
                recordModel.setBeginTime(begintime);
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "endtime": {
                Date endtime = (Date)this.getModel().getValue(keyName);
                recordModel.setEndTime(endtime);
                this.cacheTaskRecordModel(recordModel);
                break;
            }
            case "activitylist": {
                this.setCurrentActivityId(this.getPageCache(), (String)e.getChangeSet()[0].getNewValue());
                this.refreshTemplateDistributionPage(true);
                this.refreshCheckTpl(((Tab)this.getView().getControl(TAB_CHECKTPL)).getCurrentTab());
                break;
            }
        }
    }

    private void setEnable(boolean enable, String keyName) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{keyName});
        if (!enable) {
            this.setValue(keyName, null);
        }
    }

    private void updateTaskRecordModelFilterDimMember(String key) {
        LinkedHashMap<String, Pair<Long, String>> filterDimMap = this.getFilterDimMapFromCache();
        Pair<Long, String> dimPair = filterDimMap.get(key);
        List taskRecordModelFilterMemEntry = this.getTaskRecordModel().getTaskRecordModelFilterMemEntry();
        for (TaskRecordModelFilterMemEntry entry : taskRecordModelFilterMemEntry) {
            if (!Objects.equals(entry.getDimensionId(), dimPair.p1)) continue;
            DynamicObject value = (DynamicObject)this.getValue(key);
            entry.setMemberId(Long.valueOf(value == null ? 0L : value.getLong("id")));
        }
        this.cacheTaskRecordModel(this.getTaskRecordModel());
        this.getPageCache().remove(INIT_ACTIVITY_FLAG);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String currentTabKey = this.getCurrentTabKey();
        switch (key) {
            case "btnnext": {
                this.nextCheck();
                if (!TAB_STEP4.equals(currentTabKey)) break;
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String eKey;
        super.beforeClick(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "btnnext": {
                if (!TAB_STEP4.equals(this.getCurrentTabKey()) || this.checkStep4_2()) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    private TaskRecordModelActTplEntry createRecordModelActTplEntry(Long activityId, Long templateId, boolean isCycleTable) {
        TaskRecordModelActTplEntry subEntry = new TaskRecordModelActTplEntry(null);
        subEntry.setActivityId(activityId);
        subEntry.setTemplateId(templateId);
        subEntry.setCycleTable(isCycleTable);
        return subEntry;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("exitGuideCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.saveTaskRecord();
            this.getView().close();
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)evt.getSource();
        String key = billList.getKey();
        if (BILL_LIST_AP.equals(key)) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getPageCache().remove(CACHE_TASK_TPL_ID);
            } else {
                Object taskTemplateId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                this.getPageCache().put(CACHE_TASK_TPL_ID, taskTemplateId.toString());
            }
        }
    }

    private void confirmTaskTemplate() {
        Long taskTemplateId = this.getTaskTemplateId();
        if (!LongUtil.isvalidLong((Object)taskTemplateId)) {
            return;
        }
        TaskTemplateModel oldTaskTplModel = this.getTaskTemplateModel();
        if (Objects.equals(taskTemplateId, oldTaskTplModel.getComeFrom())) {
            return;
        }
        this.taskTemplateModel = TaskTemplateHelper.copyTaskTemplate((Long)LongUtil.toLong((Object)taskTemplateId));
        this.getPageCache().put("CACHE_TASK_TPL_MODEL", ObjectSerialUtil.toByteSerialized((Object)this.taskTemplateModel));
        this.getPageCache().remove(INIT_FILTER_FLAG);
        this.getPageCache().remove(INIT_ACTIVITY_FLAG);
    }

    private void nextCheck() {
        String currentTabKey;
        switch (currentTabKey = this.getCurrentTabKey()) {
            case "tabpageap": {
                this.checkStep1();
                break;
            }
            case "tabpageap1": {
                this.checkStep2();
                break;
            }
            case "tabpageap2": {
                this.checkStep3();
                break;
            }
            case "tabpageap3": {
                this.checkStep4();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Tab sourceTab = (Tab)tabSelectEvent.getSource();
        String sourceTabKey = sourceTab.getKey();
        String currentTab = tabSelectEvent.getTabKey();
        if (TAB_CHECKTPL.equals(sourceTabKey)) {
            this.refreshCheckTpl(currentTab);
        } else {
            this.checkStep1();
            switch (currentTab) {
                case "tabpageap": {
                    break;
                }
                case "tabpageap1": {
                    this.confirmTaskTemplate();
                    this.buildFilterPanel();
                    break;
                }
                case "tabpageap2": {
                    this.buildActivityPanel();
                    break;
                }
            }
            HashMap<String, LocaleString> captionInfo = new HashMap<String, LocaleString>(16);
            if (TAB_STEP4.equals(currentTab)) {
                captionInfo.put("text", new LocaleString(ResManager.loadKDString((String)"\u5b8c\u6210", (String)"TaskRecordCreatePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            } else {
                captionInfo.put("text", new LocaleString(ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65", (String)"TaskRecordCreatePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
            this.getView().updateControlMetadata(BTN_NEXT, captionInfo);
        }
    }

    private void checkStep1() {
        Long taskTplId = this.getTaskTemplateId();
        if (!LongUtil.isvalidLong((Object)taskTplId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u6a21\u677f\u3002", (String)"TaskRecordCreatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            Tab tab = (Tab)this.getControl(TAB_VIEW);
            tab.activeTab(TAB_STEP1);
        }
    }

    private void checkStep2() {
        LinkedHashMap<String, Pair<Long, String>> filterDimMap = this.getFilterDimMapFromCache();
        boolean allInput = true;
        if (filterDimMap.size() > 0) {
            for (Map.Entry entry : filterDimMap.entrySet()) {
                if (this.getValue((String)entry.getKey()) != null) continue;
                allInput = false;
                break;
            }
        }
        if (!allInput) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u7ef4\u5ea6\u9700\u8981\u5168\u90e8\u586b\u5199\u3002", (String)"TaskRecordCreatePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            ((Tab)this.getControl(TAB_VIEW)).activeTab(TAB_STEP2);
            return;
        }
        if (this.getTaskTemplateModel().getType() == TaskTemplateModel.TypeEnum.MERGE) {
            HashMap dimMap = new HashMap(4);
            Map<Long, Long> dimMemberMap = this.getTaskRecordModel().getTaskRecordModelFilterMemEntry().stream().collect(Collectors.toMap(e -> e.getDimensionId(), e -> e.getMemberId()));
            filterDimMap.entrySet().forEach(e -> {
                Long cfr_ignored_0 = (Long)dimMap.put(((Pair)e.getValue()).p2, dimMemberMap.get(((Pair)e.getValue()).p1));
            });
            boolean isExist = TaskRecordServiceHelper.existDimByMergeTask((Long)this.getModelId(), dimMap);
            if (isExist) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u4e0b\u5df2\u5b58\u5728\u5408\u5e76\u4efb\u52a1\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskRecordCreatePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                ((Tab)this.getControl(TAB_VIEW)).activeTab(TAB_STEP2);
                return;
            }
        }
    }

    private void checkStep3() {
    }

    private void checkStep4() {
    }

    private boolean checkStep4_2() {
        boolean flag = this.validateTime("begintime") && this.validateTime("endtime");
        TaskRecordModel recordModel = this.getTaskRecordModel();
        if (TaskSwitchStatusEnum.ENABLE == recordModel.getNotice() && StringUtils.isEmpty((String)recordModel.getMessageNoticeMode())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6d88\u606f\u6e20\u9053\u201d\u3002", (String)"TaskRecordCreatePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        if (TaskSwitchStatusEnum.ENABLE == recordModel.getNotice() && (null == recordModel.getNoticeContent() || StringUtils.isEmpty((String)((OrmLocaleValue)recordModel.getNoticeContent()).getLocaleValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u901a\u77e5\u5185\u5bb9\u201d\u3002", (String)"TaskRecordCreatePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        return flag;
    }

    private String getCurrentTabKey() {
        Tab tab = (Tab)this.getView().getControl(TAB_VIEW);
        return tab.getCurrentTab();
    }

    private Long getCurrentActivityId() {
        String seria = this.getCurrentActivityId(this.getPageCache());
        return StringUtils.isNotEmpty((String)seria) ? Long.parseLong(seria) : 0L;
    }

    private void buildFilterPanel() {
        if (null != this.getPageCache().get(INIT_FILTER_FLAG)) {
            return;
        }
        TaskRecordModel taskRecordModel = this.getTaskRecordModel();
        List taskRecordModelFilterMemEntry = taskRecordModel.getTaskRecordModelFilterMemEntry();
        if (this.isNew()) {
            taskRecordModelFilterMemEntry.clear();
            TaskTemplateModel taskTemplateModel = this.getTaskTemplateModel();
            List templateFilterDim = taskTemplateModel.getTaskTemplateFilterdim();
            for (TaskTemplateFilterdim taskTemplateFilterdim : templateFilterDim) {
                Long dimensionId = taskTemplateFilterdim.getBasedataid();
                TaskRecordModelFilterMemEntry subEntry = new TaskRecordModelFilterMemEntry(null);
                subEntry.setDimensionId(dimensionId);
                subEntry.setMemberId(Long.valueOf(0L));
                subEntry.setId(taskRecordModel.getId());
                taskRecordModelFilterMemEntry.add(subEntry);
            }
            this.cacheTaskRecordModel(taskRecordModel);
            for (String string : this.getFilterDimMapFromCache().keySet()) {
                if (null == this.getControl(string)) continue;
                this.setValue(string, null);
            }
            this.getView().updateView(TAB_FILTER_DIM);
        }
        Area area = new Area(TAB_FILTER_DIM);
        Style style = this.getF7Style();
        LinkedHashMap<String, Pair<Long, String>> dimIgnoreCaseMap = new LinkedHashMap<String, Pair<Long, String>>(16);
        for (TaskRecordModelFilterMemEntry filterDim : taskRecordModelFilterMemEntry) {
            Long dimensionId = filterDim.getDimensionId();
            DynamicObject dimDyn = MemberReader.getDimensionDynById((long)dimensionId);
            if (dimDyn == null) continue;
            String dimNumber = dimDyn.getString("number");
            dimIgnoreCaseMap.put(dimNumber.toLowerCase(Locale.ENGLISH), Pair.onePair((Object)dimensionId, (Object)dimNumber));
            String dimEntityNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber);
            BaseEditElement f7 = new BaseEditElement(dimDyn.getString("name"), dimNumber.toLowerCase(Locale.ENGLISH), dimEntityNumber);
            f7.setLabelDirection("v");
            f7.setLabelWidth(new LocaleString("150px"));
            f7.setFieldTextAlign("left");
            f7.setHeight(new LocaleString("50px"));
            f7.setTextAlign("left");
            f7.setStyle(style);
            f7.setMustInput(true);
            area.addElement((Element)f7);
        }
        Page page = new Page();
        page.setChangeable(true);
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.getPageCache().put(CACHE_TASK_TPL_FILTER_DIM_MAP, ObjectSerialUtil.toByteSerialized(dimIgnoreCaseMap));
        this.registerTreeF7(dimIgnoreCaseMap);
        this.getPageCache().put(INIT_FILTER_FLAG, "true");
    }

    private void buildActivityPanel() {
        if (null != this.getPageCache().get(INIT_ACTIVITY_FLAG)) {
            return;
        }
        TaskRecordModel taskRecordModel = this.getTaskRecordModel();
        if (this.isNew()) {
            taskRecordModel.getTaskRecordModelActTplEntry().clear();
        }
        TaskTemplateModel taskTemplateModel = this.getTaskTemplateModel();
        List taskTemplateAct = taskTemplateModel.getTaskTemplateAct();
        List<TaskTemplateActModel> reportActivity = taskTemplateAct.stream().filter(r -> r.isReport()).collect(Collectors.toList());
        Map<Long, Long> allSource2Right = this.filterTemplateByVersioned(reportActivity);
        Set<Long> allCycleIdsByScenario = this.filterCycleByScenario(reportActivity);
        this.taskActivityTabManager = new TaskActivityTabManager();
        for (TaskTemplateActModel actModel : reportActivity) {
            boolean isCycleTable;
            long actId = actModel.getId();
            String tabKey = actId + "";
            String actName = ((OrmLocaleValue)actModel.getActName()).getLocaleValue();
            List taskTemplateActTpl = actModel.getTaskTemplateActTpl();
            boolean bl = isCycleTable = CollectionUtils.isNotEmpty((Collection)taskTemplateActTpl) ? ((TaskTemplateActTplEntry)taskTemplateActTpl.get(0)).isCycletable() : false;
            if (!isCycleTable) {
                taskTemplateActTpl.removeIf(e -> !allSource2Right.containsKey(e.getTemplateid()));
                taskTemplateActTpl.forEach(e -> e.setTemplateid((Long)allSource2Right.get(e.getTemplateid())));
            } else {
                taskTemplateActTpl.removeIf(e -> !allCycleIdsByScenario.contains(e.getTemplateid()));
            }
            List<Long> reportTplIdList = taskTemplateActTpl.stream().map(r -> r.getTemplateid()).collect(Collectors.toList());
            List<String> reportTplNumberList = taskTemplateActTpl.stream().map(r -> r.getTemplatenumber()).collect(Collectors.toList());
            TaskActivityTabInfo info = this.taskActivityTabManager.addActivityTabInfo(tabKey, actName, actId, reportTplIdList, reportTplNumberList);
            info.setCycleTable(isCycleTable);
            if (!this.isNew()) continue;
            reportTplIdList.stream().forEach(e -> taskRecordModel.getTaskRecordModelActTplEntry().add(this.createRecordModelActTplEntry(actId, (Long)e, isCycleTable)));
        }
        this.cacheTaskActivityTabManager(this.taskActivityTabManager);
        this.cacheTaskRecordModel(taskRecordModel);
        this.getPageCache().put(INIT_ACTIVITY_FLAG, "true");
        if (CollectionUtils.isEmpty(reportActivity)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ADD_TPL, BTN_DELETE_TPL});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADD_TPL, BTN_DELETE_TPL});
        }
        TaskRecordServiceHelper.deleteDisList((String)this.gainGroupId());
        if (CollectionUtils.isNotEmpty(reportActivity)) {
            TaskRecordServiceHelper.createDisList((TaskTemplateModel)this.getTaskTemplateModel(), (String)this.gainGroupId());
        }
        this.buildComboActivity(reportActivity);
    }

    private Map<Long, Long> filterTemplateByVersioned(List<TaskTemplateActModel> reportActivity) {
        ArrayList pagememberSceneids = Lists.newArrayList((Object[])new Long[]{((DynamicObject)this.getValue("scenario")).getLong("id")});
        Long yearId = ((DynamicObject)this.getValue("year")).getLong("id");
        Long periodId = ((DynamicObject)this.getValue("period")).getLong("id");
        HashSet allTemplateIds = new HashSet(16);
        for (TaskTemplateActModel actModel : reportActivity) {
            List taskTemplateActTpl = actModel.getTaskTemplateActTpl();
            boolean isCycleTable = CollectionUtils.isNotEmpty((Collection)taskTemplateActTpl) ? ((TaskTemplateActTplEntry)taskTemplateActTpl.get(0)).isCycletable() : false;
            if (isCycleTable) continue;
            allTemplateIds.addAll(taskTemplateActTpl.stream().map(e -> e.getTemplateid()).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isEmpty(allTemplateIds)) {
            return Collections.emptyMap();
        }
        Map allSource2Right = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)yearId, (Long)periodId, allTemplateIds);
        Set templateIdsByScene = TaskRecordServiceHelper.filterTemplateByScenario((Long)this.getModelId(), (List)pagememberSceneids, allSource2Right.values());
        allSource2Right.entrySet().removeIf(e -> !templateIdsByScene.contains(e.getValue()));
        return allSource2Right;
    }

    private Set<Long> filterCycleByScenario(List<TaskTemplateActModel> reportActivity) {
        ArrayList pagememberSceneids = Lists.newArrayList((Object[])new Long[]{((DynamicObject)this.getValue("scenario")).getLong("id")});
        HashSet allCycleIds = new HashSet(16);
        for (TaskTemplateActModel actModel : reportActivity) {
            List taskTemplateActTpl = actModel.getTaskTemplateActTpl();
            boolean isCycleTable = CollectionUtils.isNotEmpty((Collection)taskTemplateActTpl) ? ((TaskTemplateActTplEntry)taskTemplateActTpl.get(0)).isCycletable() : false;
            if (!isCycleTable) continue;
            allCycleIds.addAll(taskTemplateActTpl.stream().map(e -> e.getTemplateid()).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isEmpty(allCycleIds)) {
            return Collections.emptySet();
        }
        DynamicObjectCollection dyns = TaskReportHelper.getCycleTableList(this.getModelId(), allCycleIds.stream().collect(Collectors.toList()), false, pagememberSceneids);
        return dyns.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    private void registerTreeF7(Map<String, Pair<Long, String>> f7KeyMap) {
        HashMap map = new HashMap(16);
        if (f7KeyMap != null) {
            this.asMapF7toType(new ArrayList<String>(f7KeyMap.keySet()), SingleF7TypeEnum.LEAF, map);
            this.initSingleMemberF7(map);
        }
    }

    private LinkedHashMap<String, Pair<Long, String>> getFilterDimMapFromCache() {
        String serialStr = this.getPageCache().get(CACHE_TASK_TPL_FILTER_DIM_MAP);
        if (StringUtils.isNotEmpty((String)serialStr)) {
            return (LinkedHashMap)ObjectSerialUtil.deSerializedBytes((String)serialStr);
        }
        return new LinkedHashMap<String, Pair<Long, String>>();
    }

    private void loadTaskRecordModel() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == operationStatus) {
            this.taskRecordModel = this.getTaskRecordModel();
            this.taskRecordModel.setStartMode(TaskRecordStartModeEnum.RIGHT_NOW.getValue());
        } else {
            long taskRecordModelId = (Long)this.getView().getFormShowParameter().getCustomParam("taskRecordId");
            this.taskRecordModel = TaskRecordModel.dynObjToTaskRecordModel((Long)taskRecordModelId);
        }
        this.taskRecordModel.setModelId(this.getModelId());
        this.cacheTaskRecordModel(this.taskRecordModel);
    }

    private TaskRecordModel getTaskRecordModel() {
        if (null != this.taskRecordModel) {
            return this.taskRecordModel;
        }
        String serial = this.getPageCache().get(CACHE_TASK_RECORD_MODEL_KEY);
        this.taskRecordModel = StringUtils.isNotEmpty((String)serial) ? (TaskRecordModel)this.deSerializedBytes(serial) : new TaskRecordModel();
        return this.taskRecordModel;
    }

    private void cacheTaskRecordModel(TaskRecordModel taskRecordModel) {
        this.getPageCache().put(CACHE_TASK_RECORD_MODEL_KEY, this.toByteSerialized(taskRecordModel));
    }

    private void saveTaskRecord() {
        List taskTemplateDisdim;
        TaskTemplateModel taskTemplateModel = this.getTaskTemplateModel();
        long taskTemplateId = taskTemplateModel.getId();
        DynamicObject taskTemplateDyna = taskTemplateModel.genDynamicObject();
        List actList = taskTemplateModel.genActDynamicObject();
        TaskRecordModel taskRecordModel = this.getTaskRecordModel();
        taskRecordModel.setTaskTemplateId(taskTemplateId);
        taskRecordModel.setTaskRecordStatus(TaskReocrdStatusEnum.SUSPEND.getValue());
        if (taskRecordModel.getStartMode() == TaskRecordStartModeEnum.RIGHT_NOW) {
            taskRecordModel.setBeginTime(TimeServiceHelper.now());
            taskRecordModel.setTaskRecordStatus(TaskReocrdStatusEnum.RUNNING.getValue());
        } else if (taskRecordModel.getStartMode() == TaskRecordStartModeEnum.MANUAL) {
            taskRecordModel.setBeginTime(null);
        }
        if (taskRecordModel.getForceClose() == TaskSwitchStatusEnum.DISABLE) {
            taskRecordModel.setEndTime(null);
        }
        long dimensionId = CollectionUtils.isNotEmpty((Collection)(taskTemplateDisdim = taskTemplateModel.getTaskTemplateDisdim())) ? ((TaskTemplateDisdimEntry)taskTemplateDisdim.get(0)).getDisdimensionid() : 0L;
        List orgIds = TaskRecordServiceHelper.getRangeOrgIdsByDisDim((TaskTemplateModel)taskTemplateModel);
        taskRecordModel.setTotalnum(orgIds.size());
        ArrayList<DynamicObject> allUserTask = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> allUserTaskInfo = new ArrayList<DynamicObject>(10);
        if (orgIds.size() > 0) {
            for (Long orgId : orgIds) {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId);
                UserTaskModel userTaskModel = new UserTaskModel();
                userTaskModel.setTaskrecord(taskRecordModel.getId());
                userTaskModel.setDimension(dimensionId);
                userTaskModel.setDimensiontype(DimensionUtil.getDimMembEntityNumByDimNum(MemberReader.getDimensionNumById((long)dimensionId)));
                userTaskModel.setMember(orgId.longValue());
                userTaskModel.setStatus(TaskStatusEnum.READY.getCode());
                List taskTemplateAct = taskTemplateModel.getTaskTemplateAct();
                int executeSeq = 1;
                for (TaskTemplateActModel templateActModel : taskTemplateAct) {
                    if ((!orgNode.isLeaf() || !templateActModel.isApplydetail()) && (orgNode.isLeaf() || !templateActModel.isApplymerge()) || templateActModel.getRelevantop() == TaskRelaOperEnum.MergePcSubmit) continue;
                    UserTaskInfoModel userTaskInfoModel = new UserTaskInfoModel();
                    userTaskInfoModel.setUsertask(userTaskModel.getId());
                    userTaskInfoModel.setActivity(templateActModel.getId());
                    userTaskInfoModel.setStatus(TaskStatusEnum.READY.getCode());
                    userTaskInfoModel.setExecuteseq(executeSeq);
                    if (executeSeq == 1) {
                        userTaskModel.setActivity(templateActModel.getId());
                        userTaskModel.setStatus(TaskStatusEnum.PROCESSING.getCode());
                        userTaskInfoModel.setStatus(TaskStatusEnum.PROCESSING.getCode());
                    }
                    ++executeSeq;
                    allUserTaskInfo.add(userTaskInfoModel.genDynamicObject());
                }
                userTaskModel.setTotalnum(executeSeq - 1);
                allUserTask.add(userTaskModel.genDynamicObject());
            }
        }
        ArrayList<DynamicObject> exceptiontplList = new ArrayList<DynamicObject>(8);
        List<TaskActivityTabInfo> tabInfos = this.getTaskActivityTabManagerFromCache().getTabs();
        Dimension dimension = TaskRecordServiceHelper.getDimensionByTaskTemplate((TaskTemplateModel)taskTemplateModel);
        if (null != dimension) {
            for (TaskActivityTabInfo info : tabInfos) {
                HashSet<String> uniqueSet = new HashSet<String>(16);
                for (TaskRecordTplModel item : info.getExceptiontpl()) {
                    Set orgIdsBuRange = TaskRecordServiceHelper.getRangeOrgIdsByDisDim((Long)this.getModelId(), (Dimension)dimension, (TaskRecordTplModel)item);
                    for (Long orgId : orgIdsBuRange) {
                        String uniqueKey = Joiner.on((String)"_").join((Object)item.getActivity(), (Object)orgId, new Object[]{item.getTemplate()});
                        if (!uniqueSet.add(uniqueKey)) continue;
                        TaskRecordTplModel tplModelSub = TaskRecordTplModel.clone((TaskRecordTplModel)item);
                        tplModelSub.setEntity(orgId.longValue());
                        exceptiontplList.add(tplModelSub.genDynamicObject());
                    }
                }
            }
        }
        Date beginTime = taskRecordModel.getStartMode() == TaskRecordStartModeEnum.SCHEDULE_PLAN ? taskRecordModel.getBeginTime() : null;
        String scheduleId = TaskScheduleHelper.createSchedule(taskRecordModel.getId(), beginTime, taskRecordModel.getEndTime());
        taskRecordModel.setScheduleId(scheduleId);
        DynamicObject taskRecordDyna = taskRecordModel.genDynamicObject();
        try (TXHandle tx = TX.requiresNew();){
            try {
                BusinessDataWriter.delete((IDataEntityType)taskTemplateDyna.getDataEntityType(), (Object[])new Object[]{taskTemplateDyna.getPkValue()});
                BusinessDataWriter.save((IDataEntityType)taskTemplateDyna.getDataEntityType(), (Object[])new Object[]{taskTemplateDyna});
                BusinessDataWriter.delete((String)"bcm_tasktplactivity", (QFilter[])new QFilter("tasktemplate", "=", taskTemplateDyna.getPkValue()).toArray());
                if (!actList.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)actList.get(0)).getDataEntityType(), (Object[])actList.toArray());
                }
                BusinessDataWriter.delete((IDataEntityType)taskRecordDyna.getDynamicObjectType(), (Object[])new Object[]{taskRecordDyna.getPkValue()});
                BusinessDataWriter.save((IDataEntityType)taskRecordDyna.getDynamicObjectType(), (Object[])new Object[]{taskRecordDyna});
                BusinessDataWriter.delete((String)"bcm_usertask", (QFilter[])new QFilter("taskrecord", "=", taskRecordDyna.getPkValue()).toArray());
                if (!allUserTask.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)allUserTask.get(0)).getDataEntityType(), (Object[])allUserTask.toArray());
                }
                if (!allUserTaskInfo.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)allUserTaskInfo.get(0)).getDataEntityType(), (Object[])allUserTaskInfo.toArray());
                }
                if (CollectionUtils.isNotEmpty(exceptiontplList)) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)exceptiontplList.get(0)).getDataEntityType(), (Object[])exceptiontplList.toArray());
                }
                if (StringUtils.isNotEmpty((String)((String)taskRecordDyna.get("permclass")))) {
                    PermClassEntityHelper.savePermClass((DynamicObject)taskRecordDyna, (Long)this.getModelId());
                }
                TaskTplNoticeService.sendMsgByTaskRecord((TaskRecordModel)taskRecordModel, (TaskTemplateModel)taskTemplateModel);
            }
            catch (Throwable e) {
                tx.markRollback();
                TaskScheduleHelper.deleteSchedule(scheduleId);
                throw new KDBizException(e, new ErrorCode("save taskRecord error", e.getMessage()), new Object[0]);
            }
        }
        TaskScheduleHelper.addSchedule(scheduleId);
    }

    private void refreshTaskTplList() {
        long modelId = this.getModelId();
        BillList taskTplBillList = (BillList)this.getControl(BILL_LIST_AP);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.getQFilters().add(new QFilter("model", "=", (Object)modelId).and("enable", "=", (Object)true).and("comefrom", "=", (Object)0L));
        taskTplBillList.setQueryFilterParameter(filterParameter);
        taskTplBillList.getRealCount();
        taskTplBillList.refresh();
    }

    private void addF7SelectListener(String ... f7Keys) {
        for (String f7Key : f7Keys) {
            BasedataEdit basedata = (BasedataEdit)this.getControl(f7Key);
            if (basedata == null) continue;
            basedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (Objects.equals("scenario", propName)) {
            Set scenarioIds = this.getTaskTemplateModel().getTaskTemplateScene().stream().map(e -> e.getBasedataid()).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", scenarioIds);
            ((BasedataEditSingleMemberF7)((Object)beforeF7SelectEvent.getSource())).setCustomFilter(filter);
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
    }

    private Long getTaskTemplateId() {
        String idStr = this.getPageCache().get(CACHE_TASK_TPL_ID);
        if (!StringUtils.isEmpty((String)idStr)) {
            return LongUtil.toLong((Object)idStr);
        }
        return 0L;
    }

    private TaskTemplateModel getTaskTemplateModel() {
        if (null != this.taskTemplateModel) {
            return this.taskTemplateModel;
        }
        this.taskTemplateModel = this.getTaskTemplateModelFromCache(this.getPageCache());
        return this.taskTemplateModel;
    }

    private TaskActivityTabManager getTaskActivityTabManagerFromCache() {
        if (null != this.taskActivityTabManager) {
            return this.taskActivityTabManager;
        }
        this.taskActivityTabManager = this.getTaskActivityTabManagerFromCache(this.getPageCache());
        return this.taskActivityTabManager;
    }

    private void cacheTaskActivityTabManager(TaskActivityTabManager taskActivityTabManager) {
        this.cacheTaskActivityTabManager(this.getPageCache(), taskActivityTabManager);
    }

    private boolean isNew() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return status == OperationStatus.ADDNEW;
    }

    private Style getF7Style() {
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setRight("14px");
        padding.setLeft("14px");
        padding.setTop("14px");
        margin.setLeft("10px");
        margin.setRight("1px");
        margin.setTop("1px");
        margin.setBottom("10px");
        style.setMargin(margin);
        style.setPadding(padding);
        return style;
    }

    private void initNoticeDim(Long modelId) {
        Pair noticeDim = TaskNoticeContentHelper.getNoticeDim((Long)modelId, (boolean)false);
        ComboEdit comboEdit = (ComboEdit)this.getControl(PARSEDIM);
        comboEdit.setComboItems((List)noticeDim.p1);
        comboEdit.addTips(new Tips("text", null, new LocaleString((String)noticeDim.p2), false, null));
    }

    private boolean validateTime(String keyName) {
        TaskRecordModel recordModel = this.getTaskRecordModel();
        boolean flag = true;
        if (Objects.equals("begintime", keyName)) {
            if (recordModel.getStartMode() != TaskRecordStartModeEnum.SCHEDULE_PLAN) {
                return true;
            }
            if (recordModel.getStartMode() == TaskRecordStartModeEnum.SCHEDULE_PLAN && null == recordModel.getBeginTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u8ba1\u5212\u542f\u52a8\u65f6\u95f4\u201d\u3002", (String)"TaskRecordCreatePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (recordModel.getBeginTime().getTime() <= System.currentTimeMillis()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u542f\u52a8\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u3002", (String)"TaskRecordCreatePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                flag = false;
            }
        } else {
            if (recordModel.getForceClose() != TaskSwitchStatusEnum.ENABLE || null == recordModel.getEndTime()) {
                return true;
            }
            if (recordModel.getEndTime().getTime() <= System.currentTimeMillis()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5173\u95ed\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u3002", (String)"TaskRecordCreatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                flag = false;
            } else if (null != recordModel.getBeginTime() && recordModel.getEndTime().getTime() <= recordModel.getBeginTime().getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5173\u95ed\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u201c\u8ba1\u5212\u542f\u52a8\u65f6\u95f4\u201d\u3002", (String)"TaskRecordCreatePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                flag = false;
            }
        }
        if (!flag) {
            this.setValue(keyName, null);
        }
        return flag;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        TaskRecordServiceHelper.deleteDisList((String)this.gainGroupId());
        super.beforeClosed(e);
    }

    private void buildComboActivity(List<TaskTemplateActModel> reportActivity) {
        ComboEdit edit = (ComboEdit)this.getControl(COMBO_ACTIVITY);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(reportActivity.size());
        if (CollectionUtils.isEmpty(reportActivity)) {
            edit.setComboItems(items);
            this.setValue(COMBO_ACTIVITY, null);
            return;
        }
        for (TaskTemplateActModel act : reportActivity) {
            items.add(new ComboItem(new LocaleString(act.getActNameString()), String.valueOf(act.getId())));
        }
        edit.setComboItems(items);
        this.setValue(COMBO_ACTIVITY, null);
        this.setValue(COMBO_ACTIVITY, reportActivity.get(0).getId());
    }

    private void refreshDisList(String groupId) {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP_ENTITY);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.getQFilters().clear();
        QFilter qFilter = StringUtils.isNotEmpty((String)groupId) ? new QFilter("groupid", "=", (Object)groupId) : new QFilter("1", "=", (Object)0);
        filterParameter.getQFilters().add(qFilter);
        billList.setQueryFilterParameter(filterParameter);
        billList.clearSelection();
        this.setColumnDimName();
        billList.refresh();
    }

    private void refreshCheckTpl(String currentTab) {
        if (CHECKTPL.equals(currentTab)) {
            this.refreshDisList(this.gainGroupId());
        } else {
            this.openTemplateDistributionPage();
        }
        this.getView().setVisible(Boolean.valueOf(CHECKTPL.equals(currentTab)), new String[]{BILL_LIST_AP_ENTITY});
        this.getView().setVisible(Boolean.valueOf(!CHECKTPL.equals(currentTab)), new String[]{PANEL_EXCEPTIONTPL});
    }

    private void openTemplateDistributionPage() {
        String pageIdCacheKey = "SUB_PAGEID_TPLDIS";
        String refreshFlag = this.getPageCache().get("SUB_PAGEID_TPLDIS_REFRESH_FLAG");
        if (StringUtils.isNotEmpty((String)refreshFlag) && !Boolean.parseBoolean(refreshFlag)) {
            return;
        }
        this.refreshTemplateDistributionPage(false);
        TaskActivityTabInfo info = this.getTaskActivityTabInfo(this.getPageCache());
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("KEY_MODEL_ID", this.getModelId());
        params.put("iscycletable", info.isCycleTable());
        params.put("tpks", info.getReportTplId());
        Set rows = !info.isCycleTable() ? info.getExceptiontpl().stream().map(e -> e.getTemplateNumber()).collect(Collectors.toSet()) : info.getExceptiontpl().stream().map(e -> String.valueOf(e.getTemplate())).collect(Collectors.toSet());
        params.put("rows", rows.stream().collect(Collectors.toList()));
        String formId = "bcm_taskcreate_tpldistrib";
        String oldPageId = this.getPageCache().get(pageIdCacheKey);
        if (StringUtils.isNotEmpty((String)oldPageId) && this.getView().getView(oldPageId) != null) {
            this.getView().getView(oldPageId).getFormShowParameter().getCustomParams().putAll(params);
            CommandParam com = new CommandParam("bcm_createtaskrecord_new", formId, "refresh", params);
            this.sendMsg(this.getView(), com);
            return;
        }
        String pageId = this.getPageIdAndCache(this.getPageCache(), formId);
        this.getPageCache().put(pageIdCacheKey, pageId);
        FormShowParameter formParameter = new FormShowParameter();
        formParameter.setFormId(formId);
        formParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formParameter.getOpenStyle().setTargetKey(PANEL_EXCEPTIONTPL);
        formParameter.setPageId(pageId);
        formParameter.setCustomParams(params);
        this.getView().showForm(formParameter);
    }

    private void refreshTemplateDistributionPage(boolean refresh) {
        this.getPageCache().put("SUB_PAGEID_TPLDIS_REFRESH_FLAG", String.valueOf(refresh));
    }

    private void setColumnDimName() {
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), "scene", "scenario");
        TaskCommonHelper.setColumnDimNumAndName(this.getView(), this.getModelId(), new String[]{"disnumber", "disname"}, "entity");
    }

    private boolean checkAllShareOrgExitConvert(IDNumberTreeNode orgNode) {
        IDNumberTreeNode parentNode = orgNode.getParent();
        if (null != parentNode && !orgNode.getCurrency().equals(parentNode.getCurrency())) {
            return true;
        }
        List shareNodes = orgNode.getShareNodes();
        for (IDNumberTreeNode shareNode : shareNodes) {
            IDNumberTreeNode shareParentNode = shareNode.getParent();
            if (null == shareParentNode || shareNode.getCurrency().equals(shareParentNode.getCurrency())) continue;
            return true;
        }
        return false;
    }
}

