/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.IPageCache;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordTplModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.template.TemplatePermCrossUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabInfo;
import kd.fi.bcm.formplugin.taskmanage.TaskRecordCreateBase;
import org.apache.commons.collections4.CollectionUtils;

public class TaskRecordCreateTplCheckPlugin
extends AbstractBaseListPlugin
implements TaskRecordCreateBase {
    private static final String BILLLISTAP_TPL = "billlistaptpl";
    private static final String BILLLISTAP_CYCLE = "billlistapcycle";
    private static final String IS_CYCLETABLE = "isCycletable";
    private Boolean isCycletable;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Long> ids = this.getTemplateIdsByActivityId();
        ids = this.filterExceptiontplIds(ids);
        this.refreshBillListTpl(ids);
        this.refreshBillListCycle(ids);
        this.getView().setVisible(Boolean.valueOf(!this.isCycletable()), new String[]{BILLLISTAP_TPL});
        this.getView().setVisible(Boolean.valueOf(this.isCycletable()), new String[]{BILLLISTAP_CYCLE});
    }

    @Override
    public long getModelId() {
        long modelId = super.getModelId();
        if (!LongUtil.isvalidLong((Object)modelId)) {
            String seria = this.getParentPageCache().get("KEY_MODEL_ID");
            modelId = StringUtils.isNotEmpty((String)seria) ? Long.parseLong(seria) : 0L;
        }
        return modelId;
    }

    private boolean isCycletable() {
        if (null == this.isCycletable) {
            String seria = this.getPageCache().get(IS_CYCLETABLE);
            this.isCycletable = StringUtils.isNotEmpty((String)seria) ? Boolean.parseBoolean(seria) : false;
        }
        return this.isCycletable;
    }

    private void setCycletable(boolean isCycletable) {
        this.isCycletable = isCycletable;
        this.getPageCache().put(IS_CYCLETABLE, String.valueOf(isCycletable));
    }

    private IPageCache getParentPageCache() {
        return this.getView().getParentView().getPageCache();
    }

    private List<Long> getTemplateIdsByActivityId() {
        TaskActivityTabInfo info = this.getTaskActivityTabInfo(this.getParentPageCache());
        this.setCycletable(info.isCycleTable());
        return this.filterExceptiontpl(info);
    }

    private void refreshBillListTpl(List<Long> templateIds) {
        BillList billList = (BillList)this.getControl(BILLLISTAP_TPL);
        billList.clearSelection();
        FilterParameter fp = new FilterParameter();
        if (!this.isCycletable()) {
            fp.getQFilters().add(new QFilter("id", "in", templateIds));
            fp.getQFilters().add(TemplatePermCrossUtil.getCommonTemplateQfilter((boolean)false, (Long)this.getModelId(), (boolean)false));
        } else {
            fp.getQFilters().add(new QFilter("1", "=", (Object)0));
        }
        billList.setQueryFilterParameter(fp);
        billList.refresh();
    }

    private void refreshBillListCycle(List<Long> templateIds) {
        BillList billList = (BillList)this.getControl(BILLLISTAP_CYCLE);
        billList.clearSelection();
        FilterParameter fp = new FilterParameter();
        if (this.isCycletable()) {
            fp.getQFilters().add(new QFilter("id", "in", templateIds));
        } else {
            fp.getQFilters().add(new QFilter("1", "=", (Object)0));
        }
        billList.setQueryFilterParameter(fp);
        billList.refresh();
    }

    private Long getOrgId() {
        String pkId = (String)this.getFormCustomParam("pkId");
        if (!LongUtil.isvalidLong((Object)pkId)) {
            return 0L;
        }
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkId), (String)"bcm_taskcreate_dis");
        Long orgId = dyn.getLong("member");
        return orgId;
    }

    private List<Long> filterExceptiontpl(TaskActivityTabInfo info) {
        Long curOrgId = this.getOrgId();
        Long modelId = this.getModelId();
        List<Long> reportTplId = info.getReportTplId();
        List<TaskRecordTplModel> list = info.getExceptiontpl();
        Dimension dimension = TaskRecordServiceHelper.getDimensionByTaskTemplate((TaskTemplateModel)this.getTaskTemplateModelFromCache(this.getParentPageCache()));
        if (null == dimension) {
            return info.getReportTplId();
        }
        for (TaskRecordTplModel item : list) {
            Set orgIds;
            if (!reportTplId.contains(item.getTemplate()) || !(orgIds = TaskRecordServiceHelper.getRangeOrgIdsByDisDim((Long)modelId, (Dimension)dimension, (TaskRecordTplModel)item)).contains(curOrgId)) continue;
            reportTplId.removeIf(e -> Objects.equals(e, item.getTemplate()));
        }
        return reportTplId;
    }

    private List<Long> filterExceptiontplIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return ids;
        }
        String formId = this.getParentPageCache().get("PAGE_FORMM_ID");
        Long entityId = this.getOrgId();
        if ("bcm_viewtaskrecord".equals(formId)) {
            String findSelectedIds = "select ftemplateid from t_bcm_taskrecord_tpl where factivityid = ? and fentityid = ?";
            Object[] params4Product = new SqlParameter[]{new SqlParameter(":factivityid", -5, (Object)this.getCurrentActivityId(this.getParentPageCache())), new SqlParameter(":fentityid", -5, (Object)entityId)};
            List exceptiontplIds = (List)DB.query((DBRoute)BCMConstant.DBROUTE, (String)findSelectedIds, (Object[])params4Product, rs -> {
                ArrayList<Long> templateIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    templateIds.add(rs.getLong("ftemplateid"));
                }
                return templateIds;
            });
            if (CollectionUtils.isNotEmpty((Collection)exceptiontplIds)) {
                HashSet exceptiontplIdSet = new HashSet(exceptiontplIds);
                ids.removeIf(exceptiontplIdSet::contains);
            }
        }
        return ids;
    }
}

