/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordTplModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabInfo;
import kd.fi.bcm.formplugin.taskmanage.TaskRecordCreateBase;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskReportHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskRecordCreateTplDistribDetailPlugin
extends AbstractBaseFormPlugin
implements TaskRecordCreateBase {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_1 = "1";
    private static final String ENTRYENTITY_CYCLE = "entryentity_cycle";
    private static final String ENTRYENTITY_PRE = "entry_";
    private static final String ENTRYENTITY_CYCLE_PRE = "entry_cycle_";
    protected static final String VIEW_COMBO = "viewcombo";
    private static final String IS_CYCLETABLE = "isCycletable";
    private static final String VIEW_COMBO_TEMP = "10";
    private Boolean isCycletable;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRYENTITY, "entryentity1", ENTRYENTITY_CYCLE, "entryentity_cycle1"});
        this.refreshEntryGrid();
        this.modifyComboByCycle(this.isCycletable());
        this.setColumnDimName();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewcombo": {
                String suffix = this.getSuffix();
                this.getView().setVisible(Boolean.valueOf(StringUtils.isEmpty((String)suffix)), new String[]{this.getEntryKey()});
                this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)suffix)), new String[]{this.getEntryKey() + ENTRY_1});
            }
        }
    }

    private boolean isCycletable() {
        if (null == this.isCycletable) {
            String seria = this.getPageCache().get(IS_CYCLETABLE);
            this.isCycletable = StringUtils.isNotEmpty((String)seria) ? Boolean.parseBoolean(seria) : false;
        }
        return this.isCycletable;
    }

    private void setCycletable(boolean isCycletable) {
        this.isCycletable = isCycletable;
        this.getPageCache().put(IS_CYCLETABLE, String.valueOf(isCycletable));
    }

    private String getEntryKey() {
        return !this.isCycletable() ? ENTRYENTITY : ENTRYENTITY_CYCLE;
    }

    private String getSuffix() {
        String value = (String)this.getValue(VIEW_COMBO);
        return VIEW_COMBO_TEMP.equals(value) ? "" : ENTRY_1;
    }

    private String getPrefix() {
        return !this.isCycletable() ? ENTRYENTITY_PRE : ENTRYENTITY_CYCLE_PRE;
    }

    private IPageCache getParentPageCache() {
        return this.getView().getParentView().getParentView().getPageCache();
    }

    private void refreshEntryGrid() {
        TaskActivityTabInfo info = this.getTaskActivityTabInfo(this.getParentPageCache());
        this.setCycletable(info.isCycleTable());
        List<TaskRecordTplModel> curlist = info.getExceptiontpl();
        List ids = (List)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("ids")), List.class);
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            curlist.removeIf(e -> !ids.contains(e.getTemplate() + "_" + e.getEntity()));
        }
        this.refreshEntryGrid(curlist);
    }

    private void refreshEntryGrid(List<TaskRecordTplModel> list) {
        this.getModel().deleteEntryData(this.getEntryKey());
        this.getModel().deleteEntryData(this.getEntryKey() + ENTRY_1);
        String suffix = this.getSuffix();
        this.getView().setVisible(Boolean.valueOf(StringUtils.isEmpty((String)suffix)), new String[]{this.getEntryKey()});
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)suffix)), new String[]{this.getEntryKey() + ENTRY_1});
        Dimension dimension = TaskRecordServiceHelper.getDimensionByTaskTemplate((TaskTemplateModel)this.getTaskTemplateModelFromCache(this.getParentPageCache()));
        if (null == dimension) {
            return;
        }
        Map<Long, DynamicObject> templateMap = this.getTemplateMap(list);
        Long modelId = this.getModelId();
        list.sort(Comparator.comparingLong(e -> e.getTemplate()));
        HashSet allOrgIds = new HashSet(16);
        HashMap<Long, Set> templateToOrgIds = new HashMap<Long, Set>(16);
        HashSet<String> templateAndOrgSet = new HashSet<String>(16);
        for (TaskRecordTplModel item : list) {
            Set orgIds = TaskRecordServiceHelper.getRangeOrgIdsByDisDim((Long)modelId, (Dimension)dimension, (TaskRecordTplModel)item);
            for (Long orgId : orgIds) {
                String uniqueKey = item.getTemplate() + "_" + orgId;
                if (!templateAndOrgSet.add(uniqueKey)) continue;
                this.setEntryData(this.getEntryKey(), "", modelId, orgId, templateMap.get(item.getTemplate()));
            }
            allOrgIds.addAll(orgIds);
            templateToOrgIds.computeIfAbsent(item.getTemplate(), e -> new HashSet(16)).addAll(orgIds);
        }
        for (Long orgId : allOrgIds) {
            for (Map.Entry e2 : templateToOrgIds.entrySet()) {
                if (!((Set)e2.getValue()).contains(orgId)) continue;
                this.setEntryData(this.getEntryKey() + ENTRY_1, ENTRY_1, modelId, orgId, templateMap.get(e2.getKey()));
            }
        }
    }

    private void setEntryData(String entryKey, String suffix, Long modelId, Long orgId, DynamicObject dyn) {
        if (!this.isCycletable()) {
            this.setEntryForTemplate(entryKey, suffix, modelId, orgId, dyn);
        } else {
            this.setEntryForCycle(entryKey, suffix, modelId, orgId, dyn);
        }
    }

    private void setEntryForTemplate(String entryKey, String suffix, Long modelId, Long orgId, DynamicObject templateDyn) {
        String orgName = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId).getName();
        int i = this.getModel().createNewEntryRow(entryKey);
        this.getModel().setValue("entry_number" + suffix, (Object)templateDyn.getString("number"), i);
        this.getModel().setValue("entry_name" + suffix, (Object)templateDyn.getString("name"), i);
        this.getModel().setValue("entry_textname" + suffix, (Object)orgName, i);
        this.getModel().setValue("entry_tempcatalog" + suffix, (Object)templateDyn.getString("templatecatalog.name"), i);
    }

    private void setEntryForCycle(String entryKey, String suffix, Long modelId, Long orgId, DynamicObject cycleDyn) {
        String orgName = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId).getName();
        int i = this.getModel().createNewEntryRow(entryKey);
        this.getModel().setValue("entry_cycle_number" + suffix, (Object)cycleDyn.getString("number"), i);
        this.getModel().setValue("entry_cycle_name" + suffix, (Object)cycleDyn.getString("name"), i);
        this.getModel().setValue("entry_cycle_textname" + suffix, (Object)orgName, i);
        this.getModel().setValue("entry_cycle_belongtask" + suffix, (Object)cycleDyn.getString("belongtask"), i);
    }

    private Map<Long, DynamicObject> getTemplateMap(List<TaskRecordTplModel> list) {
        Set<Long> ids = list.stream().map(e -> e.getTemplate()).collect(Collectors.toSet());
        DynamicObjectCollection dyns = !this.isCycletable() ? TaskReportHelper.queryTemplate(ids) : TaskReportHelper.getCycleTableList(this.getModelId(), ids.stream().collect(Collectors.toList()), false);
        Map<Long, DynamicObject> templateMap = dyns.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        return templateMap;
    }

    private void setColumnDimName() {
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), this.getPrefix() + "textname", "entity");
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), this.getPrefix() + "textname" + ENTRY_1, "entity");
    }
}

