/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordTplModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabInfo;
import kd.fi.bcm.formplugin.taskmanage.TaskActivityTabManager;
import kd.fi.bcm.formplugin.taskmanage.TaskRecordCreateBase;
import kd.fi.bcm.formplugin.taskmanage.TaskTplDistributionPlugin;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskReportHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskRecordCreateTplDistribPlugin
extends TaskTplDistributionPlugin
implements SubPage,
TaskRecordCreateBase {
    private static final String LABELAP = "labelap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_1 = "1";
    private static final String ENTRYENTITY_CYCLE = "entryentity_cycle";
    private static final String ENTRYENTITY_PRE = "entry_";
    private static final String ENTRYENTITY_CYCLE_PRE = "entry_cycle_";
    public static final String cycleTable_treeID = "cycletabletree";
    private static final String VIEW_COMBO_TEMP = "10";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshEntryGrid();
        this.updateViewByCycle();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewcombo": {
                this.refreshEntryGrid();
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "deletedistribution": {
                this.deleteDistribution();
                break;
            }
            case "details": {
                this.showDetailsView();
                break;
            }
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        if (Objects.equals(com.getOperation(), "refresh")) {
            TaskActivityTabInfo info = this.getTaskActivityTabInfo(this.getParentPageCache());
            this.setCycletable(info.isCycleTable());
            this.getModel().beginInit();
            this.setValue("viewcombo", VIEW_COMBO_TEMP);
            this.getModel().endInit();
            this.getView().updateView("viewcombo");
            this.setTempalteDate2View(this.getModelId(), true);
            this.refreshEntryGrid(info.getExceptiontpl());
            this.updateViewByCycle();
        }
    }

    @Override
    public void refreshBillList() {
        this.distribution();
    }

    @Override
    public String getTreeKey() {
        return !this.isCycletable() ? "temcatalogtree" : cycleTable_treeID;
    }

    @Override
    public boolean showCycleTree() {
        return this.isCycletable();
    }

    private String getEntryKey() {
        return !this.isCycletable() ? ENTRYENTITY : ENTRYENTITY_CYCLE;
    }

    private String getSuffix() {
        String value = (String)this.getValue("viewcombo");
        return VIEW_COMBO_TEMP.equals(value) ? "" : ENTRY_1;
    }

    private String getPrefix() {
        return !this.isCycletable() ? ENTRYENTITY_PRE : ENTRYENTITY_CYCLE_PRE;
    }

    private IPageCache getParentPageCache() {
        return this.getView().getParentView().getPageCache();
    }

    private void refreshEntryGrid() {
        TaskActivityTabInfo info = this.getTaskActivityTabInfo(this.getParentPageCache());
        this.refreshEntryGrid(info.getExceptiontpl());
    }

    private void refreshEntryGrid(List<TaskRecordTplModel> list) {
        this.setColumnDimName();
        String suffix = this.getSuffix();
        String prefix = this.getPrefix();
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().deleteEntryData("entryentity1");
        this.getModel().deleteEntryData(ENTRYENTITY_CYCLE);
        this.getModel().deleteEntryData("entryentity_cycle1");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRYENTITY, "entryentity1", ENTRYENTITY_CYCLE, "entryentity_cycle1"});
        this.getView().setVisible(Boolean.valueOf(StringUtils.isEmpty((String)suffix)), new String[]{this.getEntryKey()});
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)suffix)), new String[]{this.getEntryKey() + ENTRY_1});
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.getEntryKey() + suffix);
        this.getModel().batchCreateNewEntryRow(entryGrid.getEntryKey(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            TaskRecordTplModel item = list.get(i);
            this.getModel().setValue(prefix + "number" + suffix, (Object)item.getTemplateNumber(), i);
            this.getModel().setValue(prefix + "name" + suffix, (Object)item.getTemplateName(), i);
            this.getModel().setValue(prefix + "textname" + suffix, (Object)item.getTextname(), i);
            this.getModel().setValue(prefix + "range" + suffix, (Object)item.getRange(), i);
            this.getModel().setValue(prefix + "templateid" + suffix, (Object)item.getTemplate(), i);
            this.getModel().setValue(prefix + "entityid" + suffix, (Object)item.getEntity(), i);
        }
        this.getView().updateView(entryGrid.getEntryKey());
    }

    private void distribution() {
        Long modelId = this.getModelId();
        List<Long> templateIds = this.getTemSelectedAndResultList(this.getTreeKey());
        DynamicObjectCollection templateDyns = !this.isCycletable() ? this.queryTemplate(new QFilter("id", "in", templateIds)) : TaskReportHelper.getCycleTableList(modelId, templateIds, false);
        TaskTemplateModel taskTemplateModel = this.getTaskTemplateModelFromCache(this.getParentPageCache());
        List orgIds = TaskRecordServiceHelper.getRangeOrgIdsByDisDim((TaskTemplateModel)taskTemplateModel);
        if (!Objects.equals(SysDimensionEnum.Entity.getMemberTreemodel(), taskTemplateModel.getDisdimensionentity())) {
            return;
        }
        TaskActivityTabManager manager = this.getTaskActivityTabManagerFromCache(this.getParentPageCache());
        TaskActivityTabInfo info = manager.searchTab(this.getCurrentActivityId(this.getParentPageCache()));
        List<Object> curlist = null != info ? info.getExceptiontpl() : Lists.newArrayList();
        Set curTemplateIds = curlist.stream().map(e -> e.getTemplate()).collect(Collectors.toSet());
        Set delTemplateIds = curTemplateIds.stream().filter(e -> !templateIds.contains(e)).collect(Collectors.toSet());
        Set addTemplateIds = templateIds.stream().filter(e -> !curTemplateIds.contains(e)).collect(Collectors.toSet());
        curlist.removeIf(e -> delTemplateIds.contains(e.getTemplate()));
        for (DynamicObject dyn : templateDyns) {
            if (!addTemplateIds.contains(dyn.getLong("id"))) continue;
            for (Long orgId : orgIds) {
                TaskRecordTplModel tplModel = new TaskRecordTplModel();
                tplModel.setModelId(modelId.longValue());
                tplModel.setEntity(orgId.longValue());
                tplModel.setTemplate(dyn.getLong("id"));
                tplModel.setTemplateNumber(dyn.getString("number"));
                tplModel.setTemplateName(dyn.getString("name"));
                tplModel.setType(!this.isCycletable() ? "bcm_templateentity" : "bcm_cycletable");
                tplModel.setRange(String.valueOf(RangeEnum.VALUE_10.getValue()));
                tplModel.setPropertyvalue(Long.valueOf(0L));
                tplModel.setTextname(MemberReader.findEntityMemberById((Long)modelId, (Long)orgId).getName());
                tplModel.setActivity(null != info ? info.getActivityId() : 0L);
                curlist.add(tplModel);
            }
        }
        this.refreshEntryGrid(curlist);
        this.cacheTaskActivityTabManager(this.getParentPageCache(), manager);
    }

    private void deleteDistribution() {
        String suffix = this.getSuffix();
        String prefix = this.getPrefix();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.getEntryKey() + suffix);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TaskRecordCreatePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> delTemplateIds = new HashSet<Long>(rows.length);
        TaskActivityTabManager manager = this.getTaskActivityTabManagerFromCache(this.getParentPageCache());
        TaskActivityTabInfo info = manager.searchTab(this.getCurrentActivityId(this.getParentPageCache()));
        List<Object> curlist = null != info ? info.getExceptiontpl() : Lists.newArrayList();
        for (int row : rows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), row);
            if (rowEntity == null) continue;
            Long templateId = rowEntity.getLong(prefix + "templateid" + suffix);
            Long entityId = rowEntity.getLong(prefix + "entityid" + suffix);
            curlist.removeIf(e -> Objects.equals(templateId, e.getTemplate()) && Objects.equals(entityId, e.getEntity()));
            delTemplateIds.add(templateId);
        }
        this.getModel().deleteEntryRows(entryGrid.getEntryKey(), rows);
        ArrayList<String> uncheckTemplateIds = new ArrayList<String>(delTemplateIds.size());
        for (Long templateId : delTemplateIds) {
            TaskRecordTplModel tplModel = curlist.stream().filter(e -> Objects.equals(templateId, e.getTemplate())).findFirst().orElseGet(() -> null);
            if (null != tplModel) continue;
            uncheckTemplateIds.add(templateId.toString());
        }
        TreeView tree = (TreeView)this.getControl(this.getTreeKey());
        tree.uncheckNodes(uncheckTemplateIds);
        this.cacheTaskActivityTabManager(this.getParentPageCache(), manager);
        this.getView().updateView(entryGrid.getEntryKey());
    }

    private void showDetailsView() {
        String suffix = this.getSuffix();
        String prefix = this.getPrefix();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.getEntryKey() + suffix);
        int[] rows = entryGrid.getSelectRows();
        ArrayList<String> ids = new ArrayList<String>(rows.length);
        for (int row : rows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), row);
            Long templateId = rowEntity.getLong(prefix + "templateid" + suffix);
            Long entityId = rowEntity.getLong(prefix + "entityid" + suffix);
            ids.add(templateId + "_" + entityId);
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_taskcreate_tpldetail");
        if (!this.isCycletable()) {
            param.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u4f8b\u5916\u8be6\u60c5", (String)"TaskRecordCreateTplDistribPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            param.setCaption(ResManager.loadKDString((String)"\u5957\u8868\u5206\u914d\u4f8b\u5916\u8be6\u60c5", (String)"TaskRecordCreateTplDistribPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString(ids));
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void updateViewByCycle() {
        this.modifyComboByCycle(this.isCycletable());
        String labelName = !this.isCycletable() ? ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f", (String)"TaskCommonHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5957\u8868", (String)"TaskRecordCreateBase_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        ((Label)this.getControl(LABELAP)).setText(labelName);
        this.getView().setVisible(Boolean.valueOf(!this.isCycletable()), new String[]{"temcatalogtree"});
        this.getView().setVisible(Boolean.valueOf(this.isCycletable()), new String[]{cycleTable_treeID});
    }

    private void setColumnDimName() {
        TaskCommonHelper.setColumnDimName(this.getView(), this.getModelId(), this.getPrefix() + "textname" + this.getSuffix(), "entity");
    }
}

