/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.taskmanage;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.util.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class TaskRecordEndTimePlugin
extends AbstractBaseFormPlugin {
    private static final String CONFIRM = "confirm";
    private static final String ENDTIME = "endtime";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(CONFIRM);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String endTime = (String)this.getFormCustomParam(ENDTIME);
        if (StringUtils.isNotEmpty((String)endTime)) {
            this.setValue(ENDTIME, endTime);
        }
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "confirm": {
                if (!this.valicate()) break;
                HashMap<String, Object> result = new HashMap<String, Object>(1);
                result.put(ENDTIME, this.getValue(ENDTIME));
                this.getView().returnDataToParent(result);
                this.getView().close();
                break;
            }
        }
    }

    private boolean valicate() {
        Date plantime = (Date)this.getValue(ENDTIME);
        if (null == plantime) {
            return true;
        }
        if (plantime.getTime() <= System.currentTimeMillis()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5173\u95ed\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u3002", (String)"TaskRecordCreatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String maxBeginTimeStr = (String)this.getFormCustomParam("maxBeginTime");
        String taskRecordName = (String)this.getFormCustomParam("taskRecordName");
        if (StringUtils.isNotEmpty((String)maxBeginTimeStr)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date maxBeginTime = format.parse(maxBeginTimeStr);
                if (plantime.getTime() <= maxBeginTime.getTime()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5173\u95ed\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u8ba1\u5212\u542f\u52a8\u65f6\u95f4\u3002", (String)"TaskRecordEndTimePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), taskRecordName, maxBeginTimeStr));
                    return false;
                }
            }
            catch (ParseException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        return true;
    }
}

